.include "p33FJ128GP802.inc"

.section *,bss,dma,align(8)

_AN0_VAL:               .space 2      ; 1 word
_AN1_VAL:               .space 2      ; 1 word
_AN4_VAL:               .space 2      ; 1 word
_AN5_VAL:               .space 2      ; 1 word


.text

.global _init_DAC1
.global _init_UART1
.global _init_UART2
.global _init_LED
.global _init_ADC1

.global _AN0_VAL
.global _AN1_VAL
.global _AN4_VAL
.global _AN5_VAL

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
; LED

_init_LED:
  BCLR TRISA, #4
  BCLR LATA, #4
  RETURN

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
; DAC

_init_DAC1:

  CLR DAC1CON
  CLR DAC1STAT
	
; Disable nested interrupts
  BSET INTCON1, #NSTDIS

; W0 was supplied the prescale value via function call from C
  MOV #0x0100, W1          ; set format to Signed Int
  MOV #0x007F, W2          ; 
  AND W0, W2, W0           ; limit the prescale number to 127 max.
  IOR W0, W1, W1           ; put the prescale into the DAC1CON word
  MOV W1, DAC1CON

  MOV #0x0000, W0          ; move fix point zero
  MOV W0, DAC1DFLT         ; to DAC default register
;........................................................................................................
; RP12 and RP13 are the DAC Right channel outputs.  doesn't appear necessary in docs to deal with them.
  BCLR TRISB, #12          ;
  BCLR TRISB, #13          ;
  
  MOV #0x0780, W0          ;
  MOV W0, ACLKCON          ;
 
  BSET DAC1STAT, #ROEN     ; Right Chan DAC Output Emable
  BSET DAC1STAT, #LOEN     ; Left Chan DAC Output Enable

  BCLR DAC1STAT, #RITYPE   ; Right Channel Interrupt if FIFO is not Full 
  BCLR DAC1STAT, #LITYPE   ; Left Channel Interrupt if FIFO is not Full

  BCLR DAC1CON, #AMPON     ; Amplifier Disabled During Sleep and Idle Modes

  BCLR IFS4, #DAC1RIF      ; Clear Right Channel Interrupt Flag
  BCLR IFS4, #DAC1LIF      ; Clear Right Channel Interrupt Flag

  BSET IEC4, #DAC1RIE      ; Right Channel Interrupt Enabled
  BCLR IEC4, #DAC1LIE      ; Left Channel Interrupt Disabled

; SET INTERRUPT PRIORITY  IPC19, low 3 bits of high byte for DAC right channel
  MOV #0x0400, W0          ; set priority 4
  MOV W0, IPC19            ; for DAC right channel interrupt

; Turn DAC on
  BSET DAC1CON, #DACEN     ; DAC1 Module Enabled
  RETURN

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
; DIAG  (UART1) on RP8

_init_UART1:

  BCLR TRISB, #TRISB8      ; Set pin RB8 (RP8) as output

  MOV #0x0003, W0          ; 
  MOV W0, RPOR4            ; 

  MOV #0x0108, W0          ; 
  MOV W0, U1MODE           ; 

  MOV #0x40C0, W0          ; 
  MOV W0, U1STA            ; 

  MOV #85, W0              ; 115.2 kbaud at 40 MIPS
  MOV W0, U1BRG            ;

  BSET U1MODE, #UARTEN     ;
  BSET U1STA, #UTXEN       ;

  RETURN

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
; MIDI UART  (UART2)

_init_UART2:

  BSET TRISB, #TRISB9      ; set pin RB9 (RP9) to input

  MOV #0x1F09, W0          ;
  MOV W0, RPINR19          ;

  MOV #0x0108, W0          ; high speed
  MOV W0, U2MODE           ;

  MOV #0x40C0, W0          ;
  MOV W0, U2STA            ;

  MOV #319, W0             ; bit rate to set for 31.250 kbaud
  MOV W0, U2BRG            ;

  BSET U2MODE, #UARTEN     ;

  RETURN

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
; ADC1

_init_ADC1:

; Original file is from Ninja Harp (Harpie) voice engine which used 2 pins
; for analog input (AN9 and AN10).
;
; The Single dsPIC Synth board uses up to 4 pins (AN0, AN1, AN4 and AN5) for
; analog input.
;------------------------------------------------------------------------------
;
; ANALOG PINS:
;   ACTUAL PIN NUMBER    AN
;   2                    AN0      RA0
;   3                    AN1      RA1
;   6                    AN4      RB2
;   7                    AN5      RB3
;
;------------------------------------------------------------------------------

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;  
; set up ADC DMA on channel 0, one-shot mode
; In one-shot mode, CHEN must be set by software for each set of conversions.

;  MOV #0b0000000000000001, W0   ; set AMODE to register indirect with autoincrement mode, set one-shot
;  MOV W0, DMA0CON               ;

  CLR DMA0CON
  BSET DMA0CON, #0              ; one-shot, no ping-pong.

  BSET DMA0CON, #5              ; peripheral indirect addressing
  BCLR DMA0CON, #4              ; peripheral indirect addressing

  MOV #ADC1BUF0, W0             ; ADC output data register address to W0
  MOV W0, DMA0PAD               ; set the Peripheral Address register

  MOV #3, W0                    ; set the DMA count to (val stored in register is N-1)
  MOV W0, DMA0CNT               ;

  MOV #13, W0                   ; ADC1
  MOV W0, DMA0REQ               ; This is an interrupt request which will be handled by DMA hardware.

  MOV #dmaoffset(_AN0_VAL), W0   ; buffer A address
  MOV W0, DMA0STA               ;

  MOV #dmaoffset(_AN0_VAL), W0   ; buffer B address  (not used in scanning mode)
  MOV W0, DMA0STB               ;

  BCLR IFS0, #DMA0IF            ; clear any current interrupt

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;  
; Set ADC for 12 bit mode, lowest sample rate

  BSET TRISA, #TRISA0                       ; RA0 as input, used as AN0
  BSET TRISA, #TRISA1                       ; RA1 as input, used as AN1
  BSET TRISB, #TRISB2                       ; RB2 as input, used as AN4
  BSET TRISB, #TRISB3                       ; RB3 as input, used as AN5

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; AD1CON1 

/*
15 - 0 : module is off 
14 - 0 : n/a
13 - 0 : ADSIDL, continue module operation in idle mode
12 - 0 : n/a
11 - 0 : n/a
10 - 1 : AD12B, 12 bit mode
 9 - 1 : 00 = unsigned int
 8 - 1 : 00 = unsigned int
 7 - 1 : 111 = Automatic Trigger
 6 - 1 : 111 = Automatic Trigger
 5 - 1 : 111 = Automatic Trigger
 4 - 0 : n/a
 3 - 0 : SIMSAM (simultaneous sampling) off
 2 - 1 : ASAM ADC auto-sample start bit.  sampling begins immediately after last conversion, SAMP bit is auto-set
 1 - 0 : SAMP ADC sample enable bit.
 0 - 0 : DONE bit, indicates conversion is complete.
*/

  CLR AD1CON1                           ; Clear all bits of AD1CON1
  BSET AD1CON1, #ADDMABM                ; DMA Buffer Build Mode bit (0=scatter gather, 1=order of conversion)
  BSET AD1CON1, #AD12B                  ; 12 bit mode
  BCLR AD1CON1, #9                      ; FORM: unsigned int
  BCLR AD1CON1, #8                      ; FORM: unsigned int
  BSET AD1CON1, #7                      ; SSRC: automatic conversion trigger
  BSET AD1CON1, #6                      ; SSRC: automatic conversion trigger
  BSET AD1CON1, #5                      ; SSRC: automatic conversion trigger
  BCLR AD1CON1, #SIMSAM                 ; SIMSAM simultaneous sampling off (do sequential)
  BSET AD1CON1, #ASAM                   ; ADC auto-sample start bit.  sampling begins immediately after last conversion, SAMP bit is auto-set

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; AD1CON2

  CLR AD1CON2                           ; Avdd and Avss as ref voltages, interrupt every conversion

  BSET AD1CON2, #CSCNA                  ; Scan inputs for CH0+ during Sample A bit

  BCLR AD1CON2, #9                      ; CHPS  Convert CH0 only
  BCLR AD1CON2, #8                      ; CHPS  Convert CH0 only

; When channel scanning is used (and Alternate Input Selection mode is disabled), the SMPI<3:0>
; bits should be set to the number of inputs being scanned minus one (i.e., SMPI<3:0> = N - 1).

  BCLR AD1CON2, #5                      ; SMPI: 4 inputs will be scanned
  BCLR AD1CON2, #4                      ; SMPI: so these should be set to 3
  BSET AD1CON2, #3                      ; SMPI:
  BSET AD1CON2, #2                      ; SMPI:

  BCLR AD1CON2, #BUFM                   ; 0 = Always starts filling the buffer from the start address
  
  BCLR AD1CON2, #ALTS                   ; Alternate Input Selection Mode Select bit 0 = Always uses channel input selects for Sample A



;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; AD1CON3
;
; Select the analog conversion clock to match desired data rate with processor clock (AD1CON3<7:0>)
; set ADC clock
;
; MOV #0b0000111100000101, W0           ; clock derived from system clock, 15 Tad auto sample time, ADCS=5 (Tad = 6*Tcy)
; MOV #0b0000111100000010, W0           ; clock derived from system clock, 15 Tad auto sample time, ADCS=2 (Tad = 3*Tcy)
  MOV #0b0000011100000010, W0           ; clock derived from system clock, 7 Tad auto sample time, ADCS=2 (Tad = 3*Tcy)
; MOV #0b0000001100000010, W0           ; clock derived from system clock, 3 Tad auto sample time, ADCS=2 (Tad = 3*Tcy)
  MOV W0, AD1CON3                       ; 

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; AD1CON4

  MOV #0x0000, W0                       ;
  MOV W0, AD1CON4                       ; set for 1 words per pin

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; AD1CSSL
;
; Determine how sampling will occur (ADxCON1<3>, ADxCSSH<15:0> and ADxCSSL<15:0>)
; SIMSAM (AD1CON1) bit 3 is off, simultaneous sample mode OFF
  CLR AD1CSSL                           ; AD1CSSL is input scan select register low.
  BSET AD1CSSL, #CSS0                   ; scan AN0
  BSET AD1CSSL, #CSS1                   ; scan AN1
  BSET AD1CSSL, #CSS4                   ; scan AN4
  BSET AD1CSSL, #CSS5                   ; scan AN5

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; AD1PCFGL
;
  BCLR AD1PCFGL, #PCFG0                 ; AN0 is an ADC input  
  BCLR AD1PCFGL, #PCFG1                 ; AN1 is an ADC input
  BCLR AD1PCFGL, #PCFG4                 ; AN4 is an ADC input  
  BCLR AD1PCFGL, #PCFG5                 ; AN5 is an ADC input

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

  BCLR IFS0, #AD1IF                     ; Clear the AD1IF bit   (Interrupt Flag)
  BSET AD1CON1, #ADON                   ; turn the ADC module on
  
  RETURN
.end
