/*
   Ed Droog
   14-04-2021
*/

#include <Arduino.h>
#include <U8g2lib.h>
volatile uint8_t display_row = 0;
volatile uint8_t midinum = 0;
volatile bool keypress, rotate_right, switched, switch_up, Midi_extern, gate_in, gate_old;
volatile uint8_t ReceivedByte, bytenumber, pitch, old_pitch, instrument_old, instrument_new;
volatile uint8_t block; //high and low byte for frequency
volatile uint16_t frequency_word, real_frequency, real_frequency_1stop, real_frequency_2ndop, Frequency; //word for frequency
volatile uint8_t MidiNum, ChordNum, channel, instrument, rotate_instr, lcd_line, edit_position;
volatile int MidiNum_shift, keynumber;
volatile uint16_t Fnum[12] = {514, 544, 577, 612, 648, 687, 728, 771, 817, 866, 918, 972};  // correction for clock generated by BluePill
//volatile uint16_t Fnum[12]={517,547,580,615,651,690,731,774,820,869,921,975};             // org for 14.32 MHz
volatile uint8_t colom, key_on, cmnd, velocity, dumper, old_note;
volatile bool rotated, NOTE_ON, NOTE_released;
bool turned = false;
bool pushed = false;
bool left = false;
HardwareTimer pwmtimer(3);
#define SYSEX           0xF0
#define SYSCOMUNDEF     0xF1
#define SYSCOMSONGPOS   0xF2
#define SYSCOMSONGSEL   0xF3
#define SYSCOMUNDEF1    0xF4
#define SYSCOMUNDEF2    0xF5
#define SYSCOMTUNEREQ   0xF6
#define SYSEXEND        0xF7
#define SYSRTCLOCK      0xF8
#define SYSRTUNDEF      0xF9
#define SYSRTSTART      0xFA
#define SYSRTCONTINUE   0xFB
#define SYSRTSTOP       0xFC
#define SYSRTUNDEF1     0xFD
#define SYSRTACTIVESEN  0xFE
#define SYSRTRESET      0xFF
#define NOTEON          0x90
#define NOTEOFF         0x80
#define NOTEPRES        0xA0 //note pressure
#define MODULATION      0xB0 //channel pressure
#define CONTROL         0xD0 //control change
#define PITCHBEND       0xE0 //pitch wheel change
#define PATCH           0xC0 //patch change

void encoderISR()
{
  rotated = true;
}

void encoderButtonISR()
{
  switched = true;
}

/*
  void ext_triggerISR()
  {
  timer_tick=true;
  }
*/

const uint8_t instr[][24] =
  /* ----- from JungleVizion FAT4.op3-----*/
{
  /*
    register set:   #2xx  #4xx  #6xx  #8xx  #Exx  FB    #2xx  #4xx  #6xx  #8xx  #Exx  #2xx  #4xx  #6xx  #8xx  #Exx  FB    #2xx  #4xx  #6xx  #8xx  #Exx */
  { 0x01, 0x00, 0x31, 0x8F, 0xF1, 0xB2, 0x80, 0x38, 0x11, 0x83, 0xF1, 0xAF, 0x80, 0x31, 0x19, 0xF1, 0xB2, 0x80, 0x31, 0x31, 0x01, 0xC1, 0xD5, 0x80 }
  , { 0x01, 0x00, 0x11, 0x4C, 0xF1, 0xD2, 0x80, 0x3A, 0x11, 0x83, 0xF2, 0xE6, 0x80, 0x11, 0x15, 0xC1, 0xD5, 0x80, 0x31, 0x31, 0x00, 0xC2, 0xE6, 0x80 }
  , { 0x01, 0x00, 0x15, 0x5F, 0xF3, 0xD4, 0x80, 0x3E, 0x15, 0x61, 0xB1, 0xE4, 0x80, 0x11, 0x5C, 0xB1, 0xE4, 0x80, 0x30, 0x11, 0x00, 0xB1, 0xB5, 0x80 }
  , { 0x01, 0x00, 0x11, 0x89, 0xF1, 0xD4, 0x80, 0x3D, 0x02, 0x5F, 0xC3, 0xE4, 0x80, 0x00, 0x9B, 0xC1, 0x35, 0x80, 0x30, 0x11, 0x00, 0xC1, 0xD5, 0x80 }
  , { 0x01, 0x00, 0x1C, 0x6F, 0xF2, 0xE7, 0x80, 0x3C, 0x01, 0x80, 0xF2, 0xB8, 0x80, 0x11, 0x9C, 0xB1, 0xE5, 0x80, 0x31, 0x11, 0x80, 0xF2, 0xB8, 0x80 }
  , { 0x01, 0x00, 0x1C, 0x3A, 0xC2, 0xE7, 0x80, 0x30, 0x01, 0x80, 0xF3, 0xB8, 0x80, 0x11, 0x1B, 0xB1, 0xF5, 0x80, 0x31, 0x11, 0x80, 0xF2, 0xD8, 0x80 }
  , { 0x01, 0x00, 0x31, 0x90, 0xF0, 0x31, 0x80, 0x38, 0x34, 0x9F, 0xF2, 0x37, 0x80, 0x24, 0x1C, 0xF3, 0x51, 0x84, 0x30, 0x11, 0x00, 0xF2, 0x97, 0x84 }
  , { 0x01, 0x00, 0x10, 0x60, 0xF2, 0x50, 0x80, 0x34, 0x31, 0x5D, 0xE1, 0xF0, 0x80, 0x30, 0xA2, 0xB2, 0x40, 0x80, 0x30, 0x11, 0x80, 0xF1, 0xE9, 0x85 }
  , { 0x01, 0x00, 0x02, 0x25, 0xCE, 0xE6, 0x80, 0x30, 0x01, 0x00, 0xF4, 0xE6, 0x80, 0x07, 0xA1, 0xF5, 0xE6, 0x80, 0x31, 0x41, 0x00, 0xF3, 0xE5, 0x80 }
  , { 0x01, 0x00, 0x17, 0x54, 0xF2, 0xE3, 0x80, 0x3A, 0x11, 0x06, 0xC2, 0xE2, 0x80, 0x19, 0x2B, 0xF2, 0xC3, 0x80, 0x31, 0x91, 0x07, 0xF2, 0xD2, 0x80 }
  , { 0x01, 0x00, 0x17, 0x21, 0x56, 0x04, 0x80, 0x32, 0x01, 0x00, 0xF6, 0x04, 0x80, 0x1A, 0x27, 0xA6, 0x04, 0x80, 0x31, 0x00, 0x0A, 0xF6, 0x04, 0x80 }
  , { 0x01, 0x00, 0x25, 0x9A, 0x08, 0x79, 0x80, 0x3A, 0x85, 0x5B, 0xE3, 0xE6, 0x80, 0x15, 0x62, 0xF3, 0xE6, 0x80, 0x31, 0x81, 0x00, 0xF2, 0xE6, 0x80 }
  , { 0x01, 0x00, 0x1C, 0xA3, 0xF7, 0x55, 0x80, 0x36, 0x20, 0x0A, 0x85, 0xD8, 0x80, 0x18, 0x23, 0xF7, 0x55, 0x80, 0x31, 0x21, 0x00, 0xE5, 0xD8, 0x80 }
  , { 0x01, 0x00, 0x0A, 0x53, 0xF9, 0xD6, 0x80, 0x3A, 0x84, 0x80, 0xF7, 0xD6, 0x80, 0x15, 0x91, 0xF6, 0xA6, 0x80, 0x31, 0x01, 0x00, 0xF6, 0xE6, 0x80 }
  , { 0x01, 0x00, 0x41, 0x8A, 0xD4, 0xB3, 0x80, 0x34, 0x80, 0x13, 0xC2, 0xB4, 0x80, 0x45, 0x59, 0xD3, 0x82, 0x80, 0x31, 0x81, 0x80, 0xA3, 0xE3, 0x80 }
  , { 0x01, 0x00, 0x01, 0x84, 0xE7, 0xF7, 0x80, 0x3D, 0x03, 0x49, 0x74, 0x55, 0x81, 0x01, 0x80, 0xB3, 0x05, 0x80, 0x31, 0x01, 0x80, 0x76, 0xF7, 0x80 }
  , { 0x01, 0x00, 0xA0, 0x85, 0xA2, 0x2A, 0x80, 0x37, 0x22, 0x9E, 0xA5, 0x2A, 0x80, 0xA2, 0x83, 0xA5, 0x2A, 0x80, 0x31, 0x28, 0x95, 0xA1, 0x2A, 0x80 }
  , { 0x01, 0x00, 0xA0, 0x85, 0x91, 0x2A, 0x80, 0x37, 0x21, 0x0B, 0xC8, 0x3A, 0x80, 0x20, 0x81, 0xC6, 0x38, 0x80, 0x31, 0x21, 0x80, 0xF6, 0x57, 0x80 }
  , { 0x01, 0x00, 0xE3, 0x56, 0xA6, 0x2A, 0x81, 0x38, 0x61, 0x83, 0xAF, 0x0A, 0x80, 0xE1, 0x91, 0xAF, 0x0A, 0x80, 0x31, 0x62, 0x83, 0xAF, 0x0A, 0x80 }
  , { 0x01, 0x00, 0x25, 0x5F, 0xB0, 0x02, 0x80, 0x3C, 0x30, 0x40, 0x70, 0x05, 0x80, 0x31, 0x46, 0xC0, 0x02, 0x80, 0x31, 0x31, 0x80, 0x60, 0x05, 0x80 }
  , { 0x01, 0x00, 0x21, 0x93, 0xC8, 0x15, 0x80, 0x3C, 0x31, 0x00, 0x6F, 0x05, 0x80, 0x31, 0x16, 0xCF, 0x05, 0x80, 0x31, 0x32, 0x87, 0x7F, 0x05, 0x80 }
  , { 0x01, 0x00, 0x23, 0xAC, 0x72, 0x1A, 0x87, 0x30, 0x21, 0x83, 0x72, 0x2A, 0x80, 0x23, 0x22, 0x62, 0x1A, 0x84, 0x31, 0xA1, 0x00, 0x62, 0x2A, 0x80 }
  , { 0x01, 0x00, 0x25, 0xA1, 0xFF, 0x06, 0x80, 0x3A, 0x23, 0x2F, 0xFF, 0x05, 0x80, 0xA1, 0x1F, 0xFF, 0x05, 0x84, 0x30, 0x22, 0x80, 0x6F, 0x09, 0x80 }
  , { 0x01, 0x00, 0x23, 0x19, 0x62, 0x1A, 0x81, 0x3C, 0x21, 0x80, 0x72, 0x2A, 0x80, 0x23, 0x1E, 0x62, 0x1A, 0x84, 0x31, 0x22, 0x83, 0x72, 0x2A, 0x80 }
  , { 0x01, 0x00, 0x02, 0x9C, 0xF3, 0x74, 0x80, 0x3A, 0x41, 0x80, 0xF3, 0xB8, 0x80, 0x02, 0xA5, 0xD3, 0x74, 0x82, 0x31, 0x82, 0x40, 0xD3, 0xB8, 0x80 }
  , { 0x01, 0x00, 0x34, 0x5B, 0xF2, 0xF6, 0x82, 0x3C, 0x31, 0x9E, 0xF2, 0xF7, 0x80, 0x23, 0xAB, 0xF2, 0xF7, 0x80, 0x30, 0x11, 0x00, 0xF1, 0xE7, 0x80 }
  , { 0x01, 0x00, 0x22, 0x53, 0xF3, 0xFA, 0x80, 0x3A, 0x23, 0x66, 0xF2, 0xFA, 0x80, 0x21, 0xA7, 0xC2, 0xFA, 0x80, 0x30, 0x21, 0x00, 0xC2, 0xF7, 0x80 }
  , { 0x01, 0x00, 0x02, 0x4C, 0xFA, 0x22, 0x80, 0x38, 0x01, 0x97, 0xF3, 0xF3, 0x80, 0x04, 0x9D, 0xC2, 0xF3, 0x81, 0x30, 0x11, 0x00, 0xC1, 0xF7, 0x80 }
  , { 0x01, 0x00, 0x11, 0x87, 0xC7, 0xAF, 0x80, 0x38, 0x01, 0x00, 0xF5, 0xF8, 0x80, 0x01, 0x18, 0xC3, 0x98, 0x80, 0x31, 0x02, 0x00, 0xC3, 0xF8, 0x80 }
  , { 0x01, 0x00, 0x13, 0x0A, 0xB9, 0xF2, 0x84, 0x3A, 0x02, 0x1A, 0x91, 0x11, 0x80, 0x21, 0x99, 0x92, 0x4A, 0x81, 0x30, 0x22, 0x00, 0x91, 0x2A, 0x80 }
  , { 0x01, 0x00, 0x23, 0x96, 0xF8, 0x42, 0x82, 0x30, 0x22, 0x1A, 0x91, 0xFA, 0x82, 0x21, 0x99, 0x92, 0xBA, 0x80, 0x30, 0x22, 0x00, 0x91, 0x4A, 0x80 }
  , { 0x01, 0x00, 0x09, 0xA1, 0x20, 0x4F, 0x80, 0x38, 0x04, 0x80, 0xD1, 0xF8, 0x80, 0x02, 0x87, 0xF8, 0xF8, 0x82, 0x31, 0x02, 0x00, 0xF6, 0xF8, 0x80 }
  , { 0x01, 0x00, 0x01, 0x4D, 0xA7, 0x15, 0x80, 0x32, 0x01, 0x00, 0xA3, 0xC8, 0x80, 0x01, 0x93, 0x71, 0x31, 0x80, 0x31, 0x01, 0x00, 0x73, 0xC8, 0x80 }
  , { 0x01, 0x00, 0x11, 0xA8, 0xF1, 0xE5, 0x80, 0x34, 0x12, 0x57, 0xF3, 0xE5, 0x80, 0x11, 0x97, 0xE1, 0xE5, 0x80, 0x30, 0x11, 0x00, 0xE1, 0xE6, 0x80 }
  , { 0x01, 0x00, 0x01, 0xB3, 0xF0, 0xC7, 0x80, 0x36, 0x01, 0x16, 0xF1, 0x27, 0x80, 0x01, 0x16, 0xF1, 0x27, 0x80, 0x30, 0x01, 0x00, 0xF1, 0x28, 0x80 }
  , { 0x01, 0x00, 0x31, 0x5B, 0x51, 0x28, 0x80, 0x3C, 0x32, 0x00, 0x71, 0x48, 0x80, 0x31, 0x19, 0x71, 0x48, 0x80, 0x31, 0x31, 0x00, 0x71, 0x48, 0x80 }
  , { 0x01, 0x00, 0x01, 0x8B, 0xA1, 0x9A, 0x80, 0x38, 0x21, 0x40, 0xF2, 0xDF, 0x80, 0x04, 0x0B, 0xF9, 0xDA, 0x80, 0x31, 0x01, 0x80, 0xF7, 0xDF, 0x80 }
  , { 0x01, 0x00, 0x01, 0x89, 0xA1, 0x9A, 0x80, 0x36, 0x21, 0x40, 0xF2, 0xDF, 0x80, 0x04, 0x0B, 0xF9, 0xDA, 0x80, 0x31, 0x01, 0x80, 0xF7, 0xDF, 0x80 }
  , { 0x01, 0x00, 0x21, 0x1C, 0xF6, 0xC8, 0x80, 0x3A, 0x01, 0x1F, 0xF1, 0xC8, 0x80, 0x01, 0xD8, 0xF1, 0xC8, 0x80, 0x30, 0x01, 0x00, 0xF2, 0xC8, 0x80 }
  , { 0x01, 0x00, 0x21, 0x1C, 0xF6, 0xC8, 0x81, 0x3A, 0x01, 0x1F, 0xF1, 0xC8, 0x80, 0x01, 0x12, 0x54, 0x42, 0x80, 0x30, 0x01, 0x00, 0xF2, 0xC8, 0x80 }
  , { 0x01, 0x00, 0x31, 0x15, 0xDD, 0x13, 0x81, 0x38, 0x21, 0x00, 0x56, 0x26, 0x80, 0x12, 0x95, 0x8D, 0x03, 0x81, 0x31, 0x03, 0x8B, 0x65, 0x86, 0x80 }
  , { 0x01, 0x00, 0x31, 0x17, 0xDD, 0x13, 0x81, 0x38, 0x21, 0x00, 0x56, 0x26, 0x80, 0x12, 0x95, 0x8D, 0x03, 0x81, 0x31, 0x03, 0x8B, 0x65, 0x86, 0x80 }
  , { 0x01, 0x00, 0x31, 0x95, 0xDD, 0x13, 0x85, 0x38, 0x21, 0x00, 0x56, 0x26, 0x80, 0x13, 0x95, 0x8D, 0x03, 0x81, 0x31, 0x05, 0x8C, 0x66, 0x86, 0x80 }
  , { 0x01, 0x00, 0x70, 0x92, 0xCC, 0x43, 0x82, 0x3E, 0xA0, 0x03, 0x74, 0x17, 0x82, 0x21, 0x95, 0xBF, 0x07, 0x80, 0x31, 0x21, 0x00, 0x6F, 0x07, 0x81 }
  , { 0x01, 0x00, 0x61, 0x97, 0xC2, 0x15, 0x85, 0x36, 0xA1, 0x00, 0x6F, 0x05, 0x80, 0x63, 0x13, 0xB5, 0x8F, 0x80, 0x31, 0xA5, 0x94, 0xB5, 0x8F, 0x80 }
  , { 0x01, 0x00, 0x23, 0xA7, 0x85, 0x84, 0x80, 0x3E, 0x12, 0xA4, 0x82, 0x74, 0x80, 0x02, 0x27, 0x82, 0x74, 0x80, 0x30, 0x11, 0x00, 0x85, 0x35, 0x80 }
  , { 0x01, 0x00, 0x23, 0xA7, 0x85, 0x84, 0x80, 0x3E, 0x12, 0xA4, 0x82, 0x74, 0x80, 0x02, 0x27, 0x82, 0x74, 0x80, 0x30, 0x11, 0x00, 0x84, 0x33, 0x80 }
  , { 0x01, 0x00, 0x10, 0x41, 0xF5, 0x05, 0x81, 0x32, 0x11, 0x00, 0xF2, 0xC3, 0x80, 0x11, 0x01, 0xF5, 0x05, 0x80, 0x31, 0x12, 0x1E, 0xF2, 0xC3, 0x80 }
  , { 0x01, 0x00, 0x30, 0x98, 0x61, 0x03, 0x82, 0x3E, 0xA0, 0x03, 0x64, 0x17, 0x82, 0x61, 0x92, 0x65, 0x17, 0x81, 0x31, 0x21, 0x00, 0x65, 0x17, 0x80 }
  , { 0x01, 0x00, 0x30, 0x98, 0x41, 0x23, 0x82, 0x3E, 0x60, 0x01, 0x44, 0x17, 0x82, 0xA1, 0x98, 0x7F, 0x03, 0x81, 0x31, 0x21, 0x00, 0x3F, 0x07, 0x81 }
  , { 0x01, 0x00, 0x21, 0x1A, 0xC1, 0x12, 0x80, 0x3C, 0x61, 0x00, 0x4F, 0x05, 0x80, 0xA1, 0x93, 0xC1, 0x12, 0x80, 0x31, 0x21, 0x00, 0x4F, 0x05, 0x80 }
  , { 0x01, 0x00, 0x21, 0x18, 0xC1, 0x22, 0x80, 0x3C, 0x61, 0x00, 0x4F, 0x05, 0x80, 0x22, 0x0B, 0xC1, 0x22, 0x80, 0x31, 0x22, 0x1C, 0x4F, 0x05, 0x80 }
  , { 0x01, 0x00, 0x06, 0x03, 0xA0, 0xF5, 0x80, 0x3E, 0xE4, 0x23, 0xA3, 0x35, 0x80, 0xA1, 0x51, 0x7F, 0x07, 0x80, 0x31, 0x61, 0x00, 0x7F, 0x07, 0x80 }
  , { 0x01, 0x00, 0x02, 0x05, 0x84, 0x57, 0x80, 0x3E, 0xE4, 0x16, 0xA7, 0x74, 0x80, 0xA1, 0x90, 0x74, 0x39, 0x80, 0x31, 0x61, 0x00, 0x71, 0x67, 0x80 }
  , { 0x01, 0x00, 0x0A, 0x65, 0x99, 0x54, 0x80, 0x38, 0x07, 0x60, 0x97, 0x63, 0x80, 0xA1, 0x59, 0x5F, 0x04, 0x81, 0x30, 0x61, 0x00, 0x6F, 0x06, 0x80 }
  , { 0x01, 0x00, 0x00, 0x00, 0x65, 0x68, 0x82, 0x3B, 0x00, 0x00, 0xC5, 0x13, 0x86, 0x00, 0x00, 0xC8, 0x06, 0x86, 0x31, 0x00, 0x00, 0x74, 0x07, 0x83 }
  , { 0x01, 0x00, 0x21, 0x92, 0x85, 0x17, 0x80, 0x3C, 0x21, 0x01, 0x8F, 0x09, 0x80, 0x21, 0x15, 0x84, 0x17, 0x80, 0x31, 0x61, 0x0B, 0xAF, 0x08, 0x80 }
  , { 0x01, 0x00, 0x21, 0x94, 0x85, 0x17, 0x80, 0x3C, 0x21, 0x05, 0x7F, 0x09, 0x80, 0x21, 0x15, 0x84, 0x17, 0x80, 0x31, 0x61, 0x0A, 0xAF, 0x08, 0x80 }
  , { 0x01, 0x00, 0x20, 0x94, 0x76, 0x15, 0x80, 0x3C, 0x61, 0x00, 0x82, 0x37, 0x80, 0xB1, 0xD3, 0x61, 0x26, 0x80, 0x31, 0x71, 0x80, 0x61, 0x26, 0x80 }
  , { 0x01, 0x00, 0x31, 0x15, 0x71, 0x27, 0x81, 0x3C, 0x61, 0x83, 0x91, 0x49, 0x80, 0xB1, 0x10, 0x7D, 0x27, 0x80, 0x31, 0x21, 0x08, 0x7A, 0x29, 0x80 }
  , { 0x01, 0x00, 0x21, 0x9F, 0x63, 0x0A, 0x80, 0x3E, 0x21, 0x00, 0x7F, 0x0B, 0x80, 0xA1, 0xA2, 0x65, 0x0A, 0x80, 0x31, 0x61, 0x00, 0x7F, 0x0B, 0x80 }
  , { 0x01, 0x00, 0x21, 0x16, 0x72, 0x25, 0x80, 0x3C, 0x21, 0x05, 0x7F, 0x0A, 0x80, 0x21, 0x1D, 0x7A, 0x35, 0x80, 0x31, 0x21, 0x09, 0x7A, 0x3A, 0x80 }
  , { 0x01, 0x00, 0x21, 0x16, 0xC2, 0x35, 0x80, 0x3E, 0x61, 0x09, 0xCF, 0x0A, 0x80, 0xA1, 0x8A, 0x74, 0x45, 0x80, 0x31, 0x21, 0x00, 0x7F, 0x08, 0x80 }
  , { 0x01, 0x00, 0xA1, 0x97, 0x52, 0x1A, 0x80, 0x3C, 0x61, 0x00, 0x8F, 0x1B, 0x80, 0x21, 0xA1, 0x75, 0x1A, 0x80, 0x31, 0x21, 0x00, 0x8F, 0x1B, 0x80 }
  , { 0x01, 0x00, 0x31, 0x96, 0x93, 0x0F, 0x82, 0x38, 0xA1, 0x00, 0x72, 0x0F, 0x80, 0x21, 0x96, 0x85, 0x07, 0x80, 0x31, 0x31, 0x00, 0x84, 0x27, 0x81 }
  , { 0x01, 0x00, 0x31, 0x8E, 0x93, 0x03, 0x81, 0x38, 0xA1, 0x00, 0x72, 0x09, 0x80, 0x24, 0xA1, 0xC5, 0x06, 0x80, 0x31, 0x31, 0x00, 0x64, 0x27, 0x81 }
  , { 0x01, 0x00, 0xB1, 0x8E, 0x93, 0x06, 0x81, 0x3A, 0x71, 0x00, 0x72, 0x06, 0x80, 0x21, 0x5D, 0x85, 0x08, 0x80, 0x31, 0xB1, 0x00, 0x84, 0x28, 0x80 }
  , { 0x01, 0x00, 0x31, 0x93, 0x93, 0x0F, 0x81, 0x3C, 0x72, 0x00, 0x72, 0x0F, 0x80, 0x22, 0x61, 0x85, 0x06, 0x80, 0x31, 0xB1, 0x00, 0x84, 0x16, 0x80 }
  , { 0x01, 0x00, 0x61, 0xA3, 0xA9, 0x2A, 0x80, 0x38, 0x23, 0x52, 0xA8, 0x36, 0x80, 0xA1, 0x94, 0xAA, 0x16, 0x80, 0x30, 0x21, 0x80, 0x8F, 0x0A, 0x80 }
  , { 0x01, 0x00, 0x21, 0x21, 0x77, 0x29, 0x80, 0x32, 0x33, 0x55, 0x7A, 0x26, 0x81, 0xA1, 0x93, 0x7A, 0x16, 0x80, 0x30, 0x22, 0x00, 0x7A, 0x19, 0x80 }
  , { 0x01, 0x00, 0x21, 0x2B, 0x7B, 0x07, 0x81, 0x3A, 0x22, 0x57, 0x7F, 0x00, 0x80, 0x31, 0x51, 0x75, 0x19, 0x80, 0x30, 0x72, 0x00, 0x61, 0x19, 0x80 }
  , { 0x01, 0x00, 0x32, 0x90, 0x9B, 0x21, 0x80, 0x38, 0x21, 0x00, 0x72, 0x17, 0x80, 0x32, 0x90, 0x9B, 0x21, 0x80, 0x31, 0x21, 0x13, 0x72, 0x17, 0x80 }
  , { 0x01, 0x00, 0x25, 0x00, 0xDA, 0x11, 0x80, 0x3C, 0xE3, 0x2B, 0xA6, 0x68, 0x80, 0xE1, 0x1F, 0x85, 0x5F, 0x80, 0x31, 0xE1, 0x00, 0x65, 0x1A, 0x80 }
  , { 0x01, 0x00, 0x25, 0x00, 0xDA, 0x11, 0x80, 0x3C, 0xE3, 0x2B, 0xA6, 0x68, 0x80, 0xE1, 0x46, 0x88, 0x5F, 0x80, 0x31, 0xE1, 0x00, 0x65, 0x1A, 0x80 }
  , { 0x01, 0x00, 0xA4, 0xA2, 0xC9, 0x29, 0x80, 0x3C, 0x21, 0x80, 0x6F, 0x08, 0x80, 0xA2, 0xAA, 0xCA, 0x15, 0x80, 0x31, 0x21, 0x00, 0x6F, 0x08, 0x80 }
  , { 0x01, 0x00, 0x25, 0x00, 0xDA, 0x11, 0x80, 0x3C, 0x23, 0x1E, 0xA6, 0x68, 0x80, 0x21, 0x8C, 0x88, 0x58, 0x80, 0x31, 0x21, 0x00, 0x65, 0x1A, 0x80 }
  , { 0x01, 0x00, 0xA1, 0x0A, 0x76, 0xC6, 0x80, 0x3F, 0x26, 0x59, 0x87, 0x86, 0x80, 0x22, 0x56, 0x66, 0x56, 0x80, 0x30, 0xA1, 0x00, 0x65, 0x26, 0x80 }
  , { 0x01, 0x00, 0x26, 0x00, 0x9F, 0x01, 0x80, 0x3E, 0x64, 0x25, 0x76, 0x48, 0x80, 0x22, 0xCB, 0x56, 0x46, 0x80, 0x31, 0xA1, 0x00, 0x45, 0x36, 0x80 }
  , { 0x01, 0x00, 0xE1, 0x67, 0x67, 0x14, 0x81, 0x3C, 0x61, 0x00, 0x54, 0x17, 0x80, 0x21, 0x6D, 0x67, 0x14, 0x81, 0x31, 0x21, 0x00, 0x44, 0x16, 0x80 }
  , { 0x01, 0x00, 0x26, 0x00, 0xDF, 0x01, 0x80, 0x3C, 0xE4, 0x2B, 0x76, 0x38, 0x80, 0x22, 0xD8, 0x95, 0x36, 0x80, 0x31, 0xE1, 0x00, 0x76, 0x07, 0x80 }
  , { 0x01, 0x00, 0x21, 0x35, 0xFF, 0x0F, 0x80, 0x34, 0x21, 0xB7, 0xFF, 0x0F, 0x80, 0x21, 0xB9, 0xFF, 0x0F, 0x80, 0x30, 0x21, 0x80, 0xFF, 0x0F, 0x86 }
  , { 0x01, 0x00, 0x21, 0x36, 0xFF, 0x0F, 0x80, 0x3A, 0x21, 0x1B, 0xFF, 0x0F, 0x80, 0x21, 0x1D, 0xFF, 0x0F, 0x80, 0x30, 0x61, 0x00, 0xCF, 0x09, 0x84 }
  , { 0x01, 0x00, 0xA3, 0x00, 0xC4, 0x87, 0x80, 0x3E, 0x26, 0x57, 0xC6, 0x76, 0x80, 0x22, 0x46, 0x86, 0x55, 0x80, 0x31, 0x21, 0x80, 0x64, 0x18, 0x80 }
  , { 0x01, 0x00, 0x21, 0x48, 0xA3, 0x4A, 0x80, 0x38, 0x21, 0x00, 0x86, 0x0A, 0x80, 0x21, 0x45, 0x66, 0x12, 0x80, 0x31, 0x21, 0x00, 0x96, 0x0A, 0x80 }
  , { 0x01, 0x00, 0x12, 0x0A, 0xB9, 0xF2, 0x84, 0x3A, 0x01, 0x1A, 0x91, 0x11, 0x80, 0x21, 0x99, 0x92, 0x2A, 0x81, 0x30, 0x22, 0x00, 0x91, 0x2A, 0x80 }
  , { 0x01, 0x00, 0x61, 0x40, 0x7D, 0x15, 0x80, 0x3E, 0xB1, 0xA3, 0x72, 0x15, 0x80, 0xA2, 0x5D, 0xDF, 0x05, 0x80, 0x31, 0x61, 0x40, 0x7F, 0x07, 0x80 }
  , { 0x01, 0x00, 0x20, 0x36, 0xFF, 0x01, 0x80, 0x38, 0x61, 0x00, 0x8F, 0x06, 0x84, 0x21, 0x27, 0xFF, 0x0F, 0x80, 0x31, 0x61, 0x00, 0x8F, 0x07, 0x84 }
  , { 0x01, 0x00, 0x21, 0x8F, 0xF1, 0x29, 0x80, 0x3A, 0x21, 0x80, 0xF4, 0x09, 0x80, 0x21, 0x1D, 0xF1, 0x09, 0x81, 0x31, 0x21, 0x80, 0xF1, 0x09, 0x81 }
  , { 0x01, 0x00, 0x17, 0x1A, 0x53, 0x03, 0x81, 0x32, 0x08, 0x0A, 0xF6, 0x04, 0x80, 0xA1, 0x9D, 0x41, 0x32, 0x80, 0x31, 0x61, 0x00, 0x61, 0x15, 0x80 }
  , { 0x01, 0x00, 0x61, 0x1F, 0xA8, 0x11, 0x80, 0x3A, 0xB1, 0x80, 0x25, 0x03, 0x80, 0x81, 0xA1, 0xA1, 0x31, 0x80, 0x31, 0x71, 0x00, 0x25, 0x03, 0x80 }
  , { 0x01, 0x00, 0x61, 0x17, 0x11, 0x14, 0x80, 0x3C, 0x61, 0x00, 0x55, 0x16, 0x80, 0x61, 0x14, 0xC3, 0x45, 0x84, 0x31, 0x61, 0x00, 0xC3, 0x25, 0x80 }
  , { 0x01, 0x00, 0x2A, 0x80, 0x54, 0x21, 0x80, 0x3E, 0x27, 0xA6, 0x6A, 0x13, 0x80, 0x31, 0x5D, 0x54, 0x01, 0x80, 0x31, 0x72, 0x00, 0x6A, 0x03, 0x80 }
  , { 0x01, 0x00, 0x21, 0x97, 0x21, 0x33, 0x80, 0x38, 0x22, 0x03, 0x42, 0x45, 0x80, 0xA1, 0x99, 0x21, 0xD4, 0x80, 0x31, 0x21, 0x03, 0x42, 0xD5, 0x80 }
  , { 0x01, 0x00, 0x21, 0x8D, 0x61, 0x33, 0x80, 0x3A, 0x61, 0x03, 0x42, 0x35, 0x80, 0xA1, 0x1C, 0xA1, 0x77, 0x81, 0x31, 0x21, 0x00, 0x31, 0x47, 0x81 }
  , { 0x01, 0x00, 0x21, 0x89, 0x11, 0x33, 0x80, 0x3A, 0x61, 0x03, 0x42, 0x35, 0x80, 0x21, 0x8C, 0x21, 0xE4, 0x80, 0x31, 0x61, 0x03, 0x42, 0xD5, 0x80 }
  , { 0x01, 0x00, 0x21, 0x15, 0x11, 0x47, 0x81, 0x30, 0x21, 0x00, 0xCF, 0x07, 0x80, 0x21, 0x8C, 0x11, 0xE4, 0x80, 0x31, 0x61, 0x00, 0x52, 0xD5, 0x80 }
  , { 0x01, 0x00, 0x0F, 0x83, 0xFE, 0x8A, 0x85, 0x3C, 0x04, 0x85, 0xFB, 0x06, 0x80, 0x21, 0x99, 0xA8, 0x03, 0x80, 0x31, 0x22, 0x00, 0xA7, 0x04, 0x80 }
  , { 0x01, 0x00, 0x21, 0x8C, 0x21, 0x32, 0x82, 0x36, 0x20, 0x97, 0x32, 0x13, 0x80, 0x21, 0x0E, 0x11, 0x03, 0x81, 0x31, 0x21, 0x00, 0x31, 0x13, 0x80 }
  , { 0x01, 0x00, 0x01, 0x61, 0x75, 0x93, 0x80, 0x38, 0x02, 0x80, 0xC5, 0xB4, 0x80, 0x06, 0x5B, 0x74, 0x95, 0x80, 0x31, 0x01, 0x00, 0xA5, 0x72, 0x80 }
  , { 0x01, 0x00, 0x22, 0x92, 0xB2, 0x56, 0x80, 0x3C, 0x61, 0x8A, 0xF2, 0x56, 0x80, 0x21, 0x9D, 0x31, 0x34, 0x82, 0x31, 0xA1, 0x80, 0x32, 0x05, 0x80 }
  , { 0x01, 0x00, 0x24, 0x40, 0xA3, 0x88, 0x80, 0x3E, 0x22, 0x5B, 0xA3, 0x87, 0x80, 0x01, 0x13, 0xF1, 0x51, 0x81, 0x31, 0x41, 0x00, 0xF2, 0xF5, 0x80 }
  , { 0x01, 0x00, 0xA1, 0x10, 0x11, 0x42, 0x80, 0x3A, 0x61, 0x92, 0x11, 0x73, 0x80, 0x61, 0x98, 0x11, 0x21, 0x80, 0x31, 0xA1, 0x80, 0x1D, 0x03, 0x80 }
  , { 0x01, 0x00, 0x62, 0x57, 0x7D, 0x16, 0x80, 0x34, 0xA2, 0x80, 0x72, 0x16, 0x80, 0x61, 0x5B, 0x9F, 0x06, 0x80, 0x31, 0xA1, 0x00, 0x9F, 0x04, 0x80 }
  , { 0x01, 0x00, 0x38, 0x9F, 0xA2, 0x24, 0x80, 0x36, 0x31, 0x9C, 0xF2, 0x24, 0x80, 0x23, 0x9F, 0xF1, 0x14, 0x80, 0x30, 0x61, 0x00, 0x81, 0x23, 0x80 }
  , { 0x01, 0x00, 0x01, 0x46, 0xF3, 0x53, 0x80, 0x30, 0x01, 0x80, 0xF1, 0xF6, 0x81, 0x01, 0x43, 0xF2, 0x53, 0x80, 0x31, 0x08, 0x40, 0xF2, 0xF6, 0x80 }
  , { 0x01, 0x00, 0x11, 0x10, 0xA5, 0x35, 0x81, 0x30, 0x17, 0xA4, 0xA5, 0x33, 0x81, 0x11, 0x0A, 0xF6, 0x41, 0x81, 0x30, 0x11, 0x00, 0xF2, 0xE5, 0x82 }
  , { 0x01, 0x00, 0x55, 0x92, 0xF7, 0xF8, 0x80, 0x3E, 0x52, 0x9F, 0xF7, 0xE4, 0x81, 0x41, 0x13, 0xF3, 0xE4, 0x80, 0x30, 0x51, 0x00, 0xF3, 0xE5, 0x81 }
  , { 0x01, 0x00, 0x93, 0x91, 0xD4, 0x32, 0x80, 0x38, 0x11, 0x00, 0xEB, 0x11, 0x81, 0x53, 0x91, 0xD4, 0x32, 0x80, 0x31, 0x13, 0x0A, 0xEB, 0x12, 0x81 }
  , { 0x01, 0x00, 0x04, 0x4F, 0xFA, 0x56, 0x80, 0x3C, 0x01, 0x00, 0xC2, 0x05, 0x80, 0x20, 0x00, 0xF7, 0xE5, 0x83, 0x31, 0x21, 0x0C, 0xF5, 0xE5, 0x80 }
  , { 0x01, 0x00, 0x21, 0x49, 0x7C, 0x20, 0x80, 0x36, 0x22, 0x00, 0x6F, 0x0C, 0x81, 0x21, 0x09, 0x7C, 0x20, 0x80, 0x31, 0x22, 0x09, 0x6F, 0x0C, 0x81 }
  , { 0x01, 0x00, 0x31, 0x85, 0xDD, 0x33, 0x81, 0x3A, 0x21, 0x00, 0x56, 0x16, 0x80, 0x02, 0x83, 0xDD, 0x33, 0x81, 0x31, 0x01, 0x80, 0x66, 0x16, 0x80 }
  , { 0x01, 0x00, 0x61, 0x33, 0x89, 0x29, 0x80, 0x36, 0xA3, 0xA4, 0xD8, 0x06, 0x84, 0x21, 0x17, 0xDA, 0x05, 0x80, 0x30, 0x22, 0x80, 0x8F, 0x0B, 0x80 }
  , { 0x01, 0x00, 0x05, 0x6A, 0xF1, 0xE5, 0x80, 0x36, 0x03, 0x80, 0xC3, 0xE5, 0x80, 0x01, 0x71, 0xC6, 0x53, 0x80, 0x31, 0x83, 0x40, 0xF5, 0xD5, 0x80 }
  , { 0x01, 0x00, 0x08, 0x15, 0xEC, 0x26, 0x80, 0x3A, 0x04, 0x00, 0xF8, 0x16, 0x80, 0x07, 0x15, 0xEC, 0x26, 0x80, 0x31, 0x02, 0x00, 0xF8, 0x16, 0x80 }
  , { 0x01, 0x00, 0x2C, 0xAB, 0x68, 0x24, 0x80, 0x30, 0x01, 0x00, 0xDF, 0x35, 0x80, 0x05, 0x9D, 0x67, 0x35, 0x80, 0x31, 0x01, 0x00, 0xDF, 0x05, 0x80 }
  , { 0x01, 0x00, 0x15, 0x11, 0xFA, 0xFC, 0x84, 0x3A, 0x12, 0x80, 0xFA, 0xEC, 0x80, 0x18, 0x9D, 0xFA, 0xFC, 0x80, 0x31, 0x12, 0x00, 0xF8, 0xE5, 0x80 }
  , { 0x01, 0x00, 0x10, 0x86, 0xA8, 0x07, 0x80, 0x36, 0x00, 0x03, 0xFA, 0x03, 0x80, 0x01, 0x5C, 0xA8, 0x07, 0x80, 0x31, 0x00, 0x03, 0xF6, 0x83, 0x80 }
  , { 0x01, 0x00, 0x11, 0x8F, 0xF8, 0x58, 0x84, 0x3E, 0x10, 0x00, 0xF3, 0xE5, 0x80, 0x10, 0x92, 0xF6, 0x54, 0x81, 0x31, 0x10, 0x00, 0xF4, 0xE4, 0x80 }
  , { 0x01, 0x00, 0x11, 0x86, 0xF8, 0x55, 0x84, 0x3E, 0x10, 0x00, 0xF4, 0xE5, 0x80, 0x11, 0x9C, 0xF3, 0x55, 0x81, 0x31, 0x10, 0x00, 0xF4, 0xE5, 0x80 }
  , { 0x01, 0x00, 0x0F, 0x00, 0x1F, 0x00, 0x80, 0x3E, 0xC0, 0x00, 0x1F, 0xF0, 0x83, 0x0F, 0x3F, 0x1F, 0x00, 0x80, 0x31, 0xC0, 0x3F, 0x1F, 0xF1, 0x83 }
  , { 0x01, 0x00, 0x06, 0x80, 0xF8, 0x24, 0x80, 0x3E, 0x03, 0x88, 0x56, 0x84, 0x87, 0x03, 0x1E, 0xD8, 0x24, 0x80, 0x31, 0x04, 0x08, 0x66, 0x84, 0x87 }
  , { 0x01, 0x00, 0x06, 0x00, 0xFF, 0x01, 0x80, 0x3E, 0x14, 0x00, 0x34, 0x04, 0x83, 0x01, 0x3F, 0x00, 0xF1, 0x80, 0x31, 0x01, 0x3F, 0x00, 0xF1, 0x80 }
  , { 0x01, 0x00, 0x26, 0x00, 0xFF, 0x01, 0x80, 0x3E, 0x04, 0x00, 0x12, 0x84, 0x81, 0x01, 0x3F, 0x00, 0xF1, 0x80, 0x31, 0x01, 0x3F, 0x00, 0xF1, 0x80 }
  , { 0x01, 0x00, 0x48, 0x00, 0x68, 0xF8, 0x80, 0x35, 0x01, 0x3F, 0x00, 0xF1, 0x80, 0x47, 0x00, 0x67, 0xF8, 0x80, 0x31, 0x4C, 0x00, 0x46, 0xF8, 0x80 }
  , { 0x01, 0x00, 0x35, 0x1C, 0xB2, 0x61, 0x82, 0x3A, 0x14, 0x08, 0xF4, 0x15, 0x80, 0x11, 0x20, 0xFE, 0x15, 0x87, 0x31, 0x87, 0xC0, 0xF4, 0x19, 0x80 }
  , { 0x01, 0x00, 0xF0, 0x00, 0x2E, 0x11, 0x81, 0x38, 0xE2, 0xC0, 0x21, 0x16, 0x81, 0xF0, 0x00, 0x2E, 0x11, 0x87, 0x31, 0xE2, 0xC0, 0x21, 0x16, 0x81 }
  , { 0x01, 0x00, 0x26, 0x00, 0xFF, 0x01, 0x80, 0x3E, 0xE4, 0x00, 0x12, 0x16, 0x87, 0x01, 0x3F, 0x00, 0xF1, 0x80, 0x31, 0x01, 0x3F, 0x00, 0xF1, 0x80 }
  , { 0x01, 0x00, 0x00, 0x00, 0xF2, 0x59, 0x80, 0x3E, 0x01, 0x00, 0xF7, 0x00, 0x80, 0x01, 0x00, 0xF3, 0xF0, 0x80, 0x30, 0x01, 0x00, 0xF6, 0xC9, 0x86 }
  , { 0x00, 0x23, 0x10, 0x44, 0xF8, 0x77, 0x82, 0x38, 0x11, 0x00, 0xF3, 0x06, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00 }
  , { 0x01, 0x23, 0x01, 0x07, 0xFD, 0x0C, 0x80, 0x30, 0x00, 0x00, 0xD6, 0x3C, 0x80, 0x00, 0x00, 0xF6, 0x0C, 0x80, 0x31, 0x00, 0x00, 0xF6, 0x0C, 0x80 }
  , { 0x01, 0x2C, 0x12, 0x11, 0xF5, 0xFE, 0x80, 0x36, 0x12, 0xA2, 0xF6, 0xFF, 0x80, 0x01, 0x0F, 0xF9, 0xFF, 0x80, 0x30, 0x11, 0x00, 0xF8, 0xFF, 0x80 }
  , { 0x01, 0x30, 0x00, 0x00, 0xFC, 0x05, 0x82, 0x3E, 0x00, 0x00, 0xFA, 0x17, 0x80, 0x01, 0x03, 0xFC, 0x07, 0x80, 0x31, 0x02, 0x03, 0xF8, 0x38, 0x86 }
  , { 0x01, 0x3A, 0x82, 0x00, 0xFF, 0x04, 0x82, 0x3E, 0x10, 0x06, 0xFF, 0x15, 0x80, 0x00, 0x02, 0xFF, 0x07, 0x80, 0x31, 0x01, 0x00, 0xFF, 0x08, 0x80 }
  , { 0x01, 0x3C, 0x00, 0x00, 0xFC, 0x05, 0x82, 0x3E, 0x00, 0x00, 0xFA, 0x17, 0x80, 0x00, 0x03, 0xFC, 0x07, 0x80, 0x31, 0x01, 0x03, 0xF8, 0x38, 0x86 }
  , { 0x01, 0x30, 0x01, 0x07, 0xFD, 0x0C, 0x80, 0x30, 0x00, 0x00, 0xD6, 0x3C, 0x80, 0x00, 0x00, 0xF6, 0x0C, 0x80, 0x31, 0x00, 0x00, 0xF6, 0x06, 0x80 }
  , { 0x01, 0x2B, 0x0C, 0x00, 0xF6, 0x08, 0x80, 0x3A, 0x12, 0x00, 0xFB, 0x47, 0x82, 0x0C, 0x00, 0xF6, 0x08, 0x80, 0x31, 0x12, 0x00, 0xFB, 0x47, 0x82 }
  , { 0x01, 0x31, 0x01, 0x07, 0xFD, 0x0C, 0x80, 0x30, 0x00, 0x00, 0xD6, 0x3C, 0x80, 0x00, 0x00, 0xF6, 0x0C, 0x80, 0x31, 0x00, 0x00, 0xF6, 0x0C, 0x80 }
  , { 0x01, 0x2B, 0x0C, 0x00, 0xF6, 0x08, 0x80, 0x3A, 0x12, 0x00, 0x7B, 0x47, 0x82, 0x0C, 0x00, 0xF6, 0x08, 0x80, 0x31, 0x12, 0x00, 0x7B, 0x47, 0x82 }
  , { 0x01, 0x33, 0x01, 0x07, 0xFD, 0x0C, 0x80, 0x30, 0x00, 0x00, 0xD6, 0x3C, 0x80, 0x00, 0x00, 0xF6, 0x0C, 0x80, 0x31, 0x00, 0x00, 0xF6, 0x0C, 0x80 }
  , { 0x01, 0x2B, 0x0C, 0x00, 0xF6, 0x02, 0x80, 0x3A, 0x12, 0x00, 0xCB, 0x43, 0x82, 0x0C, 0x00, 0xF6, 0x02, 0x80, 0x31, 0x12, 0x15, 0xCB, 0x43, 0x82 }
  , { 0x01, 0x36, 0x01, 0x07, 0xFD, 0x0C, 0x80, 0x30, 0x00, 0x00, 0xD6, 0x3C, 0x80, 0x00, 0x00, 0xF6, 0x0C, 0x80, 0x31, 0x00, 0x00, 0xF6, 0x0C, 0x80 }
  , { 0x01, 0x39, 0x01, 0x07, 0xFD, 0x0C, 0x80, 0x30, 0x00, 0x00, 0xD6, 0x3C, 0x80, 0x00, 0x00, 0xF6, 0x0C, 0x80, 0x31, 0x00, 0x00, 0xF6, 0x0C, 0x80 }
  , { 0x01, 0x48, 0x01, 0x00, 0xF2, 0x55, 0x80, 0x3E, 0x41, 0x00, 0xF4, 0x00, 0x80, 0x01, 0x00, 0xF3, 0x00, 0x80, 0x30, 0x8F, 0x00, 0xF4, 0xA4, 0x80 }
  , { 0x01, 0x3C, 0x01, 0x07, 0xFD, 0x0C, 0x80, 0x30, 0x00, 0x00, 0xD6, 0x3C, 0x80, 0x00, 0x00, 0xF6, 0x0C, 0x80, 0x31, 0x00, 0x00, 0xF6, 0x0C, 0x80 }
  , { 0x01, 0x46, 0x0F, 0x00, 0xE4, 0xE4, 0x83, 0x36, 0x08, 0x0A, 0xF5, 0xE5, 0x81, 0x0F, 0x00, 0xF5, 0x66, 0x83, 0x31, 0x08, 0x19, 0xF5, 0xA5, 0x81 }
  , { 0x01, 0x3C, 0x81, 0x00, 0xF9, 0x65, 0x80, 0x3E, 0x41, 0x00, 0xF2, 0x30, 0x80, 0x46, 0x00, 0xFE, 0x00, 0x80, 0x30, 0x85, 0x00, 0xF5, 0x55, 0x80 }
  , { 0x01, 0x24, 0x0F, 0x00, 0xE4, 0xE4, 0x83, 0x36, 0x07, 0x11, 0xF5, 0xE5, 0x81, 0x0F, 0x00, 0xF5, 0x65, 0x83, 0x31, 0x06, 0x1E, 0xF5, 0xA5, 0x81 }
  , { 0x01, 0x41, 0x06, 0x00, 0x94, 0xC4, 0x80, 0x30, 0x04, 0x00, 0xF6, 0xF5, 0x82, 0x02, 0x00, 0xF9, 0x04, 0x80, 0x30, 0x05, 0x03, 0x97, 0xF7, 0x80 }
  , { 0x01, 0x54, 0x8F, 0x03, 0xF2, 0x56, 0x81, 0x3E, 0x46, 0x00, 0xF4, 0x00, 0x81, 0x8F, 0x00, 0xF3, 0x00, 0x80, 0x30, 0x42, 0x06, 0xF4, 0xA5, 0x80 }
  , { 0x01, 0x3B, 0x11, 0x45, 0xF8, 0x37, 0x82, 0x38, 0x10, 0x00, 0xF3, 0x05, 0x80, 0x11, 0x05, 0xF8, 0x37, 0x80, 0x31, 0x10, 0x08, 0xF3, 0x05, 0x80 }
  , { 0x01, 0x54, 0x81, 0x00, 0xF3, 0x55, 0x81, 0x3E, 0x41, 0x00, 0xF4, 0x00, 0x80, 0x41, 0x00, 0xF3, 0x00, 0x80, 0x30, 0x8F, 0x00, 0xF4, 0xA4, 0x80 }
  , { 0x01, 0x23, 0x80, 0x00, 0xFF, 0x03, 0x85, 0x3C, 0x10, 0x00, 0xFF, 0x14, 0x80, 0x80, 0x00, 0xFF, 0x03, 0x85, 0x31, 0x10, 0x0A, 0xFF, 0x14, 0x80 }
  , { 0x01, 0x2C, 0x0F, 0x00, 0xE4, 0xE5, 0x83, 0x36, 0x08, 0x0A, 0xF5, 0xE7, 0x81, 0x0F, 0x00, 0xF5, 0x66, 0x83, 0x31, 0x08, 0x19, 0xF6, 0xA8, 0x81 }
  , { 0x01, 0x43, 0x06, 0xC8, 0xF5, 0x0C, 0x80, 0x36, 0x02, 0x0B, 0xF5, 0x08, 0x80, 0x06, 0xC5, 0xF5, 0x0C, 0x80, 0x31, 0x01, 0x03, 0xF5, 0x07, 0x80 }
  , { 0x01, 0x42, 0x01, 0x8F, 0xFA, 0xBF, 0x80, 0x36, 0x02, 0x80, 0xC8, 0x96, 0x80, 0x01, 0xCF, 0xFA, 0xBF, 0x80, 0x31, 0x02, 0x0B, 0xC8, 0x96, 0x80 }
  , { 0x01, 0x3B, 0x01, 0x51, 0xFA, 0x87, 0x80, 0x36, 0x01, 0x00, 0xFA, 0xB7, 0x80, 0x01, 0x4F, 0xFA, 0x87, 0x80, 0x31, 0x01, 0x08, 0xFA, 0xB7, 0x80 }
  , { 0x01, 0x33, 0x01, 0x55, 0xFA, 0x8D, 0x80, 0x36, 0x02, 0x00, 0xF8, 0xB5, 0x80, 0x01, 0x55, 0xFA, 0x8D, 0x80, 0x31, 0x02, 0x12, 0xF8, 0xB5, 0x80 }
  , { 0x01, 0x2D, 0x01, 0x59, 0xFA, 0x8D, 0x80, 0x36, 0x02, 0x00, 0xF8, 0xB6, 0x80, 0x01, 0x59, 0xFA, 0x8D, 0x80, 0x31, 0x02, 0x12, 0xF8, 0xB6, 0x80 }
  , { 0x01, 0x47, 0x01, 0x00, 0xFA, 0x0A, 0x80, 0x3E, 0x00, 0x00, 0xF9, 0x06, 0x80, 0x01, 0x00, 0xFA, 0x0A, 0x80, 0x31, 0x00, 0x0A, 0xF9, 0x06, 0x80 }
  , { 0x01, 0x3C, 0x00, 0x80, 0xF9, 0x89, 0x83, 0x3E, 0x00, 0x00, 0xF6, 0x6C, 0x80, 0x00, 0x80, 0xF9, 0x89, 0x80, 0x31, 0x00, 0x08, 0xF6, 0x6C, 0x80 }
  , { 0x01, 0x3A, 0x03, 0x8D, 0xF8, 0x88, 0x83, 0x3E, 0x0C, 0x00, 0xF6, 0xB6, 0x80, 0x03, 0x88, 0xF8, 0x88, 0x80, 0x31, 0x0C, 0x12, 0xF8, 0xB8, 0x80 }
  , { 0x01, 0x35, 0x03, 0x88, 0xF8, 0x88, 0x83, 0x3E, 0x0C, 0x03, 0xF6, 0xB6, 0x80, 0x03, 0x88, 0xF8, 0x88, 0x83, 0x31, 0x0C, 0x0F, 0xF8, 0xB8, 0x80 }
  , { 0x01, 0x40, 0x0F, 0x40, 0x76, 0x4F, 0x80, 0x3E, 0x00, 0x08, 0x77, 0x18, 0x82, 0x0F, 0x00, 0x76, 0x4F, 0x80, 0x31, 0x00, 0x12, 0x77, 0x18, 0x82 }
  , { 0x01, 0x47, 0x0F, 0x40, 0xC8, 0x49, 0x82, 0x3E, 0x02, 0x80, 0x9B, 0x69, 0x82, 0x0F, 0xC0, 0xC8, 0x49, 0x82, 0x31, 0x0F, 0x19, 0x9B, 0x69, 0x82 }
  , { 0x01, 0x3D, 0x57, 0xDC, 0xAD, 0x05, 0x83, 0x3E, 0x87, 0x00, 0x8D, 0x05, 0x80, 0x47, 0xDC, 0xAD, 0x05, 0x83, 0x31, 0x87, 0x12, 0x8D, 0x05, 0x80 }
  , { 0x01, 0x3D, 0x57, 0xDC, 0xA8, 0x04, 0x83, 0x3E, 0x87, 0x00, 0x88, 0x04, 0x80, 0x57, 0xDC, 0xA8, 0x04, 0x83, 0x31, 0x87, 0x08, 0x88, 0x05, 0x80 }
  , { 0x01, 0x30, 0x80, 0x00, 0xF6, 0x06, 0x85, 0x3C, 0x10, 0x00, 0xF6, 0x16, 0x80, 0x00, 0x00, 0x6F, 0x0F, 0x85, 0x31, 0x00, 0x00, 0x6F, 0x0F, 0x85 }
  , { 0x01, 0x30, 0x80, 0x00, 0xF6, 0x06, 0x85, 0x3C, 0x10, 0x00, 0xF6, 0x16, 0x80, 0x00, 0x00, 0x4F, 0x0F, 0x85, 0x31, 0x00, 0x00, 0x4F, 0x0F, 0x85 }
  , { 0x01, 0x45, 0x06, 0x3F, 0x00, 0xF4, 0x83, 0x30, 0x15, 0x00, 0xF7, 0xF5, 0x80, 0x06, 0x3F, 0x00, 0xF4, 0x83, 0x31, 0x15, 0x08, 0xF7, 0xF5, 0x80 }
  , { 0x01, 0x44, 0x06, 0x3F, 0x00, 0xF4, 0x83, 0x30, 0x12, 0x00, 0xF7, 0xF5, 0x80, 0x06, 0x3F, 0x00, 0xF4, 0x83, 0x31, 0x12, 0x08, 0xF7, 0xF5, 0x80 }
  , { 0x01, 0x3F, 0x06, 0x3F, 0x00, 0xF4, 0x83, 0x30, 0x12, 0x00, 0xF7, 0xF5, 0x80, 0x06, 0x3F, 0x00, 0xF4, 0x83, 0x31, 0x12, 0x08, 0xF7, 0xF5, 0x80 }
  , { 0x01, 0x4A, 0x01, 0xCD, 0x67, 0x47, 0x87, 0x38, 0x03, 0x40, 0x67, 0x47, 0x80, 0x01, 0xC0, 0x67, 0x47, 0x80, 0x31, 0x01, 0x00, 0x65, 0x55, 0x80 }
  , { 0x01, 0x3C, 0x01, 0x17, 0x67, 0xA7, 0x80, 0x3A, 0x03, 0x1E, 0x65, 0x35, 0x80, 0x01, 0x9D, 0x77, 0x77, 0x80, 0x31, 0x01, 0x00, 0x75, 0x05, 0x80 }
  , { 0x01, 0x50, 0x0A, 0x40, 0xE0, 0xF0, 0x83, 0x38, 0x1F, 0x40, 0xFF, 0x05, 0x80, 0x0A, 0x40, 0xE0, 0xF0, 0x83, 0x31, 0x1F, 0x48, 0xFF, 0x05, 0x80 }
  , { 0x01, 0x40, 0x0A, 0x7C, 0xE0, 0xF0, 0x83, 0x38, 0x1F, 0x40, 0xFF, 0x02, 0x80, 0x0A, 0x7C, 0xF5, 0xE0, 0x83, 0x31, 0x1F, 0x40, 0xFF, 0x03, 0x80 }
  , { 0x01, 0x45, 0x0F, 0x40, 0x7F, 0x4F, 0x80, 0x3E, 0x00, 0x88, 0x7E, 0x1E, 0x82, 0x0F, 0x40, 0x7F, 0x4F, 0x80, 0x31, 0x00, 0x14, 0x7E, 0x1E, 0x82 }
  , { 0x01, 0x37, 0x05, 0x05, 0xF9, 0x32, 0x83, 0x3E, 0x04, 0x40, 0xD6, 0xA6, 0x80, 0x05, 0x05, 0xF8, 0x32, 0x83, 0x31, 0x04, 0x40, 0x74, 0xA6, 0x80 }
  , { 0x01, 0x4B, 0x03, 0x0A, 0xE4, 0xE5, 0x86, 0x3B, 0x07, 0x11, 0xF5, 0xE7, 0x87, 0x00, 0x1B, 0xF5, 0x66, 0x83, 0x30, 0x04, 0x15, 0xF6, 0xA8, 0x84 }
  , { 0x01, 0x44, 0x03, 0x3F, 0x00, 0xF4, 0x83, 0x38, 0x15, 0x00, 0xF7, 0xF5, 0x80, 0x03, 0x3F, 0x00, 0xF4, 0x83, 0x31, 0x15, 0x08, 0xF7, 0xF5, 0x80 }
  , { 0x01, 0x30, 0x01, 0x4F, 0xFA, 0x8D, 0x80, 0x36, 0x02, 0x00, 0xF8, 0xB5, 0x80, 0x01, 0x4F, 0xFA, 0x8D, 0x80, 0x31, 0x02, 0x12, 0xF8, 0xB5, 0x80 }
  , { 0x01, 0x35, 0x01, 0x4F, 0xFA, 0x84, 0x80, 0x36, 0x00, 0x00, 0xF8, 0xB4, 0x80, 0x01, 0x4F, 0xFA, 0x84, 0x80, 0x31, 0x00, 0x00, 0xF8, 0xB4, 0x80 }
};
char *instrumentname[] {
  "Acoustic Piano",
  "Bright Piano",
  "Electric Piano",
  "Honky-tonk",
  "El. Piano 1",
  "El. Piano 2",
  "Harpsichord",
  "Clavinet",
  "Celesta",
  "Glockenspiel",
  "Music Box",
  "Vibraphone",
  "Marimba",
  "Xylophone",
  "Tubular Bells",
  "Dulcimer",
  "Drawbar Organ",
  "Perc. Organ",
  "Rock Organ",
  "Church Organ",
  "Reed Organ",
  "Accordion",
  "Harmonica",
  "Accordion",
  "Guitar nylon",
  "Guitar steel",
  "Guitar jazz",
  "Guitar clean",
  "Guitar muted",
  "Overdr Guitar",
  "Dist. Guitar",
  "Guit harmonics",
  "Acoustic Bass",
  "Bass (finger)",
  "Bass (pick)",
  "Fretless Bass",
  "Slap Bass 1",
  "Slap Bass 2",
  "Synth Bass 1",
  "Synth Bass 2",
  "Violin",
  "Viola",
  "Cello",
  "Contrabass",
  "Tremolo",
  "Pizzicato",
  "Harp",
  "Timpani",
  "String Ens.1",
  "String Ens.2",
  "Synth Str.1",
  "Synth Str.2",
  "Choir Aahs",
  "Voice Oohs",
  "Synth Voice",
  "Orchestra Hit",
  "Trumpet",
  "Trombone",
  "Tuba",
  "Muted Trumpet",
  "French Horn",
  "Brass Section",
  "Synth Brass 1",
  "Synth Brass 2",
  "Soprano Sax",
  "Alto Sax",
  "Tenor Sax",
  "Baritone Sax",
  "Oboe",
  "English Horn",
  "Bassoon",
  "Clarinet",
  "Piccolo",
  "Flute",
  "Recorder",
  "Pan Flute",
  "Blown Bottle",
  "Shakuhachi",
  "Whistle",
  "Ocarina",
  "Lead(square)",
  "Lead(sawtooth)",
  "Lead(calliope)",
  "Lead(chiff)",
  "Lead(charang)",
  "Lead(voice)",
  "Lead(fifths)",
  "Lead(bass/lead)",
  "Pad new age",
  "Pad warm",
  "Pad polysynth",
  "Pad choir",
  "Pad bowed",
  "Pad metallic",
  "Pad halo",
  "Pad sweep",
  "FX rain",
  "FX soundtrack",
  "FX crystal",
  "FX atmos",
  "FX bright",
  "FX goblins",
  "FX echoes",
  "FX sci-fi",
  "Sitar",
  "Banjo",
  "Shamisen",
  "Koto",
  "Kalimba",
  "Bag pipe",
  "Fiddle",
  "Shanai",
  "Tinkle Bell",
  "Agogo",
  "Steel Drums",
  "Woodblock",
  "Taiko Drum",
  "Melodic Tom",
  "Synth Drum",
  "Reverse Cymbal",
  "Fret Noise",
  "Breath Noise",
  "Seashore",
  "Bird Tweet",
  "Telephone Ring",
  "Helicopter",
  "Applause",
  "Gunshot"
};

U8X8_SSD1306_128X64_VCOMH0_HW_I2C u8x8(/* reset=*/ U8X8_PIN_NONE, /* clock=*/ 42, /* data=*/ 43); // edit this for different Oled screen

volatile uint8_t channel_store[7][2] =
{
  {0xFF, 0} //stores the data for each channel
  , {0xFF, 0}
  , {0xFF, 0}
  , {0xFF, 0}
  , {0xFF, 0}
  , {0xFF, 0}
  , {0xFF, 0xFF} //last always 0xFF
};

volatile uint16_t regset[6][4] =
{
  {0xA0, 0xB0, 0xC0, 0xC3}, //regset[channel_to_write][a number]
  {0xA1, 0xB1, 0xC1, 0xC4},
  {0xA2, 0xB2, 0xC2, 0xC5},
  {0x1A0, 0x1B0, 0x1C0, 0x1C3},
  {0x1A1, 0x1B1, 0x1C1, 0x1C4},
  {0x1A2, 0x1B2, 0x1C2, 0x1C5}
};

void YMF262_send(uint16_t to_DataBus)
{
  GPIOA->regs->ODR = (to_DataBus & 0x03FF); //set data, cs goes low
  delayMicroseconds(5);          //wait
  GPIOA->regs->BSRR = 0x400;     //CS high
  delayMicroseconds(5);
}

void YMF262_adress_mode(uint16_t _register)
{
  if (_register > 0x100) {
    YMF262_send((_register & 0x00FF) | 0x200); //A1 and CS is high
  }
  else {
    YMF262_send(_register & 0x00FF);
  };               //A1, A0 are low and CS is high
}

void YMF262_data_mode (uint8_t _data)
{
  YMF262_send(_data | 0x100);
}

/*
  Direct write to FM synthesizer register.
    reg - register number (range 0x001-0x0F5 and 0x101-0x1F5). When high byte
    of reg is zero, data go to port FMport, otherwise to FMport+2
    data - register value to be written
*/
void FMwriteReg (uint16_t _reg, uint8_t _data)
{
  YMF262_adress_mode(_reg);
  YMF262_data_mode(_data);
}

/*
   Write to channel a single value. To be used for register bases of
   0xA0, 0xB0 and 0xC0.
*/
void FMwriteValue(uint16_t regbase, uint8_t _value)
{
  FMwriteReg(regbase, _value);
}

/*
   Write to an operator pair. To be used for regbase of 0x20, 0x40,
   0x60, 0x80 and 0xE0.
*/
void FMwriteChannel(uint16_t instrument_number, uint16_t channel_to_write)// instrument_number = 0 (Bright Piano), channel = 0 t/m 5
{
  uint16_t base [] = { 0x20, 0x40, 0x60, 0x80, 0xE0};//for n=0 to 5
  uint16_t slot[] =  { 0, 1, 2, 18, 19, 20};
  uint16_t rg[] =    {0x000, 0x001, 0x002, 0x003, 0x004, 0x005,
                      0x008, 0x009, 0x00A, 0x00B, 0x00C, 0x00D,
                      0x010, 0x011, 0x012, 0x013, 0x014, 0x015,
                      0x100, 0x101, 0x102, 0x103, 0x104, 0x105,
                      0x108, 0x109, 0x10A, 0x10B, 0x10C, 0x10D,
                      0x110, 0x111, 0x112, 0x113, 0x114, 0x115
                     };
  uint16_t regbase;
  uint16_t instrument_data;
  uint8_t i = 1;
  for (uint8_t n = 0; n < 5; n++)
  {
    i++;//i = 2,3,4,5,6
    instrument_data = (instr[instrument_number][i]); //data1 = AVKVM, KSSL, AttDec, Sus, Wave
    FMwriteReg((base[n] + rg[slot[channel_to_write]]), instrument_data);//FMwriteReg = 0x20, data2; 0x40, data3; 0x60, data4; 0x80, data5; 0xE0, data6;
  }
  i++;//i=7
  for (uint8_t n = 0; n < 5; n++)
  {
    i++;//i = 8,9,10,11,12
    instrument_data = (instr[instrument_number][i]); //data2 = AVKVM, KSSL, AttDec, Sus, Wave
    FMwriteReg((base[n] + rg[slot[channel_to_write]] + 3), instrument_data);//FMwriteReg = 0x23, data8; 0x, data9; 0x, data10; 0x, data11; 0x, data1;
  }
  for (uint8_t n = 0; n < 5; n++)
  {
    i++;//i = 13,14,15,16,17
    instrument_data = (instr[instrument_number][i]); //data1 = AVKVM, KSSL, AttDec, Sus, Wave
    FMwriteReg((base[n] + rg[slot[channel_to_write]] + 8), instrument_data);//FMwriteReg = 0x26, data1; 0x49, data1; 0x69, data1; 0x89, data1; 0xE9, data1;
  }
  i++;//i=18
  for (uint8_t n = 0; n < 5; n++)
  {
    i++;//i = 19,20,21,22,23,
    instrument_data = (instr[instrument_number][i]); //data2 = AVKVM, KSSL, AttDec, Sus, Wave
    FMwriteReg((base[n] + rg[slot[channel_to_write]] + 11), instrument_data);//FMwriteReg = 0x29, data2; 0x4C, data2; 0x6C, data2; 0x8C, data2; 0xEC, data2;
  }
  uint8_t FB = (instr[instrument_number][7]); //FB = FMConn1/2
  FMwriteValue(regset[channel_to_write][2], FB); //0xC0, #1, FMConn1/2
  FB = (instr[instrument_number][18]); //FB = FMConn3/4
  FMwriteValue((regset[channel_to_write][2]) + 3, FB); //0xC1, #1, FMConn3/4
}

void YMF262_initialise (void)
{
  for (uint16_t n = 1; n < 512; n++)
  {
    FMwriteReg (n, 0x00);
  }
  FMwriteReg(0x105, 0x01);// enable OPL3 mode
  FMwriteReg(0x104, 0x3F);// all 4 op mode
  //FMwriteReg(0xBD,0xC0);//deep vibrato and deep tremolo
  FMwriteChannel(0, 0);
}

void setup_welcome_screen (void)
{
  FMwriteChannel((instrument), channel);
  u8x8.setFont(u8x8_font_8x13B_1x2_r);
  u8x8.setCursor(0, 0);
  u8x8.print(instrument);
  u8x8.print("  ");
  u8x8.setCursor(0, 0);
  u8x8.print("oooooo");
  u8x8.setCursor(8, 0);
  u8x8.print(instrument + 1);
  u8x8.print("  ");
  u8x8.setCursor(12, 0);
  u8x8.print(MidiNum_shift);
  u8x8.print("  ");
  u8x8.drawString(0, 2, "                 "); //clear line
  u8x8.drawString(0, 2, instrumentname[instrument]);
  u8x8.drawString(0, 4, "  Instruments");
  u8x8.drawString(0, 6, "  Transpose");
  if (lcd_line == 4) {
    u8x8.drawString(0, 4, " ");
  }
  else {
    u8x8.drawString(0, 6, " ");
  };
  u8x8.drawString(0, lcd_line, "*");
  for (uint8_t chan_fil = 0; chan_fil < 6; chan_fil++) {
    FMwriteChannel((0), chan_fil);
  };
  FMwriteChannel((0), 0);
}

void setup(void) {
  pinMode(PA0, OUTPUT);//D0 YMF262
  pinMode(PA1, OUTPUT);//D1
  pinMode(PA2, OUTPUT);//D2
  pinMode(PA3, OUTPUT);//D3
  pinMode(PA4, OUTPUT);//D4
  pinMode(PA5, OUTPUT);//D5
  pinMode(PA6, OUTPUT);//D6
  pinMode(PA7, OUTPUT);//D7 YMF262
  pinMode(PA8, OUTPUT);//A0 YMF262
  pinMode(PA9, OUTPUT);//A1 YMF262
  pinMode(PA10, OUTPUT);//chip select YMF262
  pinMode(PB6, OUTPUT);//SCL1 Display
  pinMode(PB7, OUTPUT);//SDA1 Display
  pinMode(PB11, INPUT_PULLUP);//RX3 MIDI IN
  pinMode(PB13, INPUT_PULLUP);
  pinMode(PB14, INPUT_PULLUP);
  pinMode(PB15, INPUT_PULLUP);
  digitalWrite(PA10, 1);    //CS goes high
  u8x8.begin();
  Serial3.begin(31250); //TX-PB10/RX-PB11
  lcd_line = 4; //place cursor at 3rd line
  attachInterrupt(digitalPinToInterrupt(PB13),  encoderISR,       FALLING);  //call encoderISR()   every high->low change
  attachInterrupt(digitalPinToInterrupt(PB15), encoderButtonISR, FALLING); //call pushButtonISR() every high->low change
  instrument = 0x00;
  rotated = false;
  switched = false;
  channel = 0;
  MidiNum_shift = 0;
  bytenumber = 0;
  pitch = 0;
  pinMode(PB0, PWM);
  pwmtimer.pause();
  pwmtimer.setPrescaleFactor(1);
  pwmtimer.setOverflow(4);
  pwmtimer.setCompare(TIMER_CH3, 2);  // 50% duty cycle
  pwmtimer.refresh();
  pwmtimer.resume();//create the 14.3 MHz clock
}

void loop(void) {
  setup();
  YMF262_initialise();
  u8x8.clearDisplay();
  setup_welcome_screen();
  while (1) {
    if (Serial3.available()) // midi received
    {
      ReceivedByte = Serial3.read();
      if (ReceivedByte == NOTEON)
      {
        while (!(Serial3.available()));
        keynumber = Serial3.read();
        while (!(Serial3.available()));
        velocity = Serial3.read();
        if (velocity != 0)
        {
          keypress = true;
        }
        if (velocity == 0) //note off
        {
          NOTE_released = true;
        }
      }
      if (ReceivedByte == NOTEOFF)
      {
        while (!(Serial3.available()));
        keynumber = Serial3.read();
        NOTE_released = true;
        while (!(Serial3.available()));
        dumper = Serial3.read();
      } //end
    } //end of if(c < 0xf0)

    if (switched)
    {
      if (lcd_line == 4) {
        u8x8.drawString(0, 4, " ");
        lcd_line = 6;
      }
      else {
        u8x8.drawString(0, 6, " ");
        lcd_line = 4;
      };
      u8x8.drawString(0, lcd_line, "*");
      switched = false;
    }

    if (keypress)// note on
    {
      keypress = false;
      channel = 0;
      while (channel_store[channel][0] != 0xFF) //check for a free channel
      {
        channel++;
      }
      if (channel < 6) // an empty channel is found
      {
        channel_store[channel][0] = keynumber; // store a note
        channel_store[channel][1] = channel; // in a channel
        FMwriteValue(regset[channel][1], 0); //stop the note in use
        keynumber += (MidiNum_shift + 5);
        block = (keynumber / 12);
        MidiNum = (((keynumber) % 12) & 0x7F);
        frequency_word = Fnum[MidiNum];
        FMwriteValue(regset[channel][0], uint8_t(frequency_word));
        FMwriteValue(regset[channel][1], (0x20 | (frequency_word >> 8) | (block << 2))); //and play the note
        u8x8.setCursor(channel, 0);
        u8x8.print("x");
      }
    }

    if (NOTE_released)// note off
    { NOTE_released = false;
      channel = 0;
      while ((channel_store[channel][0] != keynumber) & (channel < 7)) //looking for the channel to turn off
      {
        channel++;
      }
      if (channel < 6) // found the channel
      {
        channel_store[channel][0] = 0xFF;
        keynumber += (MidiNum_shift + 5);
        block = (keynumber / 12);
        MidiNum = (((keynumber) % 12) & 0x7F);
        frequency_word = Fnum[MidiNum];
        FMwriteValue(regset[channel][0], uint8_t(frequency_word));
        FMwriteValue(regset[channel][1], (0xDF & (frequency_word >> 8) | (block << 2))); //and stop the note
        u8x8.setCursor(channel, 0);
        u8x8.print("o");
      }
    }

    if (rotated)
    {
      rotate_right = (GPIOB->regs->IDR & (1 << 14));
      switch (lcd_line)
      {
        case 4://change instruments
          if (rotate_right)// rotate left
          {
            instrument--;
            if (instrument > 127) {
              instrument = 127;
            }
          }
          else      //rotated right
          {
            instrument++;
            if (instrument > 127) {
              instrument = 0;
            }
          }
          for (uint8_t chan_fil = 0; chan_fil < 6; chan_fil++) {
            FMwriteChannel((instrument), chan_fil);
          };
          FMwriteChannel((instrument), channel);
          u8x8.drawString(0, 2, "                 "); //clear line
          u8x8.drawString(0, 2, instrumentname[instrument]);
          break;
        case 6://Transpose, each step 1 note up/down
          if (rotate_right) //rotate left?
          {
            MidiNum_shift--;
            if (MidiNum_shift < -32) {
              MidiNum_shift = -32;
            }
          }
          else
          {
            MidiNum_shift++;
            if (MidiNum_shift > 32) {
              MidiNum_shift = 32;
            }
          }
          break;
        default:
          break;
      }
      /*
        for (uint8_t s=0; s<6; s++){channel_store[s][0]=0xFF;};
        u8x8.setCursor(0, 0);
        u8x8.print("oooooo");
      */
      u8x8.setCursor(8, 0);
      u8x8.print(instrument + 1);
      u8x8.print("  ");
      u8x8.setCursor(12, 0);
      u8x8.print(MidiNum_shift);
      u8x8.print("  ");
      rotated = false;
    }
  }
}
