var xmlns="http://www.w3.org/2000/svg";
var type2colour = {Logic:"#f2f26d", Audio:"#f26d6d", Control:"#6d6df2"};
/*
zoomSlider.oninput = function(e) {
	var fac = e.target.value;
	var w = 1280 / fac;
	var h = 600 / fac;
	alldefs.parentElement.setAttribute("viewBox", "0 0 "+w+" "+h);
	h = wrap.scrollHeight;
	h = h * fac;
	wrap.style.height = h + "px";
}
*/
var shadowCheckBoxes = document.querySelectorAll("input.shadowChk");
Array.prototype.slice.call(shadowCheckBoxes,0).forEach( function (chk) {
	chk.onclick = function (e) {
	wrap.classList.toggle(chk.parentElement.textContent+"_shadow");
	alldefs.parentElement.currentScale += 0.00001;
	};
});

function svgNSGet(tag, attr) {
	var a, se = (typeof tag == "object")?tag:document.createElementNS(xmlns, tag);
	for (a in attr)
		if (a=="innerHTML"||a=="textContent")
			se[a] = attr[a];
		else
			se.setAttributeNS(null,a,attr[a]);
	return se;
}

function loadTestPatch(patchurl) {
	// get our template
	var oReq = new XMLHttpRequest();
	oReq.open("GET", patchurl, true);
	oReq.responseType = "arraybuffer";
	oReq.onload = function (oEvent) {
		var arrayBuffer = oReq.response;
		if (arrayBuffer)
			procpch2({target:{result:arrayBuffer}}, "testpatch.pch2");
	}
	oReq.send(null);
}

function makeSubElements(s,o)
{
	// add static visual elements to the module
	o.ve.forEach( function (n) {
		switch (n.type) {
		case "graph":
		case "graphenv":
			s.appendChild(svgNSGet("rect",{x:n.x, y:n.y, width:n.w, height:n.h, fill:"#088"}));
			if (n.type=="graph")
				s.appendChild(svgNSGet("line",{x1:n.x, y1:n.y+(n.h/2), x2:n.x+n.w, y2:n.y+(n.h/2), stroke:"#0DD"}));
			break;
		case "line":
			points = {"stroke":"#333", x1:n.x1, y1:n.y1, x2:n.x2, y2:n.y2};
			s.appendChild(svgNSGet("line", points));
			break;
		case "path":
			s.appendChild(svgNSGet("path", {stroke:"#333", fill:"none", d:n.d}));
			break;
		case "valueDisplay":
			s.appendChild(svgNSGet("rect",{x:n.x, y:n.y, width:n.w, height:14, fill:"#666", "data-id":n.ref}));
			break;
		case "led":
		case "ledArray":
			var max = n.cnt || 1;
			var spc = +n.xo || 0;
			var x = 2+n.x;
			for (var i=0; i<max; i++, x+=spc)
				s.appendChild(svgNSGet("rect",{fill:"#040", stroke:"#000", width:n.w, height:6.5, x:x, y:n.y}));
			break;
		case "bmp":
			var t = svgNSGet("svg", {x:n.x, y:n.y});
			var u = document.createElementNS(xmlns,"use");
			var classn = "Bitmap"+n.id;
			u.setAttributeNS("http://www.w3.org/1999/xlink","xlink:href","#"+classn);
			t.appendChild(u);
			s.appendChild(t);
			break;
		case "text":
			s.appendChild(svgNSGet("text",{fill:"black", x:n.x, y:n.y, textContent:n.t}));
			break;
		default:
			break;
		}
	});
	o.modes.forEach( function(n) {
		var w = n.w;
		if (w) {
			if (w>0) {
				var p1 = svgNSGet("rect",{stroke:"#222", fill:"#EEE", x:n.x, y:n.y, height:n.h, width:w});
				s.appendChild(p1);
			}
			w = Math.abs(w);
			var p2 = svgNSGet("rect",{stroke:"#222", fill:"#CCC", x:n.x+w, y:n.y, height:n.h, width:8});
			var p3 = svgNSGet("path",{stroke:"none", fill:"#000", d:"M"+(n.x+w+1.5)+","+(n.y+(n.h>>1)-1.5)+" l5,0 -2.5,3z"});
			s.appendChild(p2);
			s.appendChild(p3);
		}
	});
	var colourmap = {yellow:"#f2f26d", orange:"#f2f26d", red:"#f26d6d", blue:"#6d6df2", purple:"#6d6df2"};
	o.inputs.forEach( function (n) {
		var t = svgNSGet("svg",{"fill":colourmap[n.colour], x:n.x-6, y:n.y-5.5});
		var u = document.createElementNS(xmlns,"use");
		u.setAttributeNS("http://www.w3.org/1999/xlink","xlink:href","#input");
		t.appendChild(u);
		s.appendChild(t);
	});
	o.outputs.forEach( function (n) {
		var t = svgNSGet("svg",{"fill":colourmap[n.colour], x:n.x-6, y:n.y-5.5});
		var u = document.createElementNS(xmlns,"use");
		u.setAttributeNS("http://www.w3.org/1999/xlink","xlink:href","#output");
		t.appendChild(u);
		s.appendChild(t);
	});
	o.params.forEach( function (n) {
		if (n.n.substr(0,3)=="SwM") {
			s.appendChild(switchsv(n));
		} else {
			var t = svgNSGet("svg",{"class":n.n, x:n.x, y:n.y});
			var u = document.createElementNS(xmlns,"use");
			u.setAttributeNS("http://www.w3.org/1999/xlink","xlink:href","#"+n.n);
			t.appendChild(u);
			s.appendChild(t);
		}
	});
}
function switchsv(n) {
	// build static elements for switches
	var e;
	var p = parammap[n.type];
	var w = 18;
	var t = "B";
	if (!p.width)
		setupParam(p);

	if (p.width)
		w = p.width;

	var x = n.x;
	var y = n.y;
	var xo=0;
	var yo=0;
	var cnt = 1;
	var rows = p.rows||1;
	if (p.mode == "VR" || p.mode == "HR") {
	// vertical or horizontal row of radio buttons
		cnt = p.names.length;
		if (p.mode=="VR")
			yo=11;
		else
			xo=w;
	}
	e = svgNSGet("svg", {fill:"none", x:x, y:y});
	var rowmod = cnt/rows;
	var ro=0;
	for (var i=0; i< cnt; i++) {
		t = getSwName(p.names[i],n.name);
		if (n.w)
			w=n.w;
		var xi = i%rowmod;
		if (i&&(xi==0))
			ro+=11;
		var re0 = svgNSGet("rect",{x:xi*xo, y:i*yo+ro, fill:"#CCC", stroke:"#CCC", width:w, height:11});
		var re = svgNSGet("rect",{x:xi*xo, y:i*yo+ro, opacity:0.5, fill:"#none", stroke:"#333", width:w, height:11});
		e.appendChild(re0);
		e.appendChild(re);
	}
	return(e);
}

function getSwName(a,b) {
	// get name for radio button switch, needs reworking
	// to allow for switch labels from patch data
	if ((!a)||a.indexOf("#")<0)
		return a;
	var nmre = /\d+/;
	var m = nmre.exec(b);
	var rep = (m)?m[0]:"";
	return (m)?a.replace("#", rep):b;
}

function plen(s){
	// attempt to get actual width of text before it is in the DOM
	var charw = [4.578125, 2.296875, 3.4375, 5.15625, 5.15625, 8, 6.296875, 1.71875, 2.859375, 2.859375, 3.4375, 5.15625, 2.296875, 2.859375, 2.296875, 2.296875, 5.15625, 5.15625, 5.15625, 5.15625, 5.15625, 5.15625, 5.15625, 5.15625, 5.15625, 5.15625, 2.296875, 2.296875, 5.15625, 5.15625, 5.15625, 5.15625, 9.15625, 6.296875, 6.296875, 6.296875, 6.296875, 6.296875, 5.71875, 6.859375, 6.296875, 2.296875, 4.578125, 6.296875, 5.15625, 7.4375, 6.296875, 6.859375, 6.296875, 6.859375, 6.296875, 6.296875, 5.71875, 6.296875, 6.296875, 8.578125, 6.296875, 6.296875, 5.71875, 2.296875, 2.296875, 2.296875, 4, 5.15625, 2.859375, 5.15625, 5.15625, 4.578125, 5.15625, 5.15625, 2.296875, 5.15625, 5.15625, 1.71875, 1.71875, 4.578125, 1.71875, 7.4375, 5.15625, 5.15625, 5.15625, 5.15625, 2.859375, 4.578125, 2.296875, 5.15625, 4.578125, 6.296875, 4.578125, 4.578125];
	var pl = 0;
	for (var i=0; i<s.length; i++)
		pl += charw[s.charCodeAt(i)-32];
	return pl;
}
function setupParam(p){
	// generic code for augmenting raw parameter data
	if (p.names)
		return;
	if (p.high<17) {
		var nam = p.defin[0].split(",");
		var na = [];
		var maxlen = 0;
		nam.forEach( function (x) {
			var k = x.split("~");
			var trimmed = k[1].trim();
			na.push(trimmed);
			var pl = plen(trimmed);
			if (pl > maxlen)
				maxlen = pl;
		});
		p.width = Math.max(maxlen+2,14);
		p.names = na;
	}
}

function removeAll() {
	// remove everything ready for new patch
	var p = alldefs.parentNode;
	var m = alldefs.nextSibling;
	var del = [];
	while (m) {
		del.push(m);
		m = m.nextSibling;
	}
	del.forEach( function (mod) {
		alldefs.parentNode.removeChild(mod);
	});
}

function makeBasicPanel(s,id,h,type)
{
	var h0 = parseInt(h)-16;
	s.setAttributeNS(null, "id", type);
	s.appendChild(svgNSGet("rect", {width:"256",height:h}));
	s.appendChild(svgNSGet("rect", {width:"256",height:16,fill:"url(#g119)",transform:"translate(0,"+h0+")"}));
	s.appendChild(svgNSGet("rect", {width:"256",height:16,fill:"url(#g118)"}));
	s.appendChild(svgNSGet("path", {fill:"url(#g117)",stroke:"none",d:"M256,0 l0,"+(h-1)+" -4,-4 0,"+(-(h-7))+"z"}));
	s.appendChild(svgNSGet("path", {fill:"url(#g116)",stroke:"none",d:"M0,0 l0,"+(h-1)+" 4,-4 0,"+(-(h-7))+"z"}));
}
function addModuleTemplate(id, xpos, ypos, colourix, uname, lv, modes)
{
	modcolours = {0:"#c0c0c0",
		6:"#e5777a",13:"#ba7d81",14:"#ca8d8d",1:"#ccbaba",
		9:"#e7d14b",11:"#dec77d",15:"#ded1a5",4:"#d0cbaa",
		10:"#93d162",8:"#82b980",16:"#94cf9c",2:"#baccba",
		17:"#69d6c7",7:"#7bc1bd",18:"#a0d2c8",19:"#bed2d2",
		5:"#74a0d4",20:"#808cc0",12:"#8f9ac2",3:"#b0bacc",
		21:"#d673c7",22:"#be82be",23:"#cda0d2",24:"#d2bed2"};
	// get module description and build a template
	var o = modules.getById(id);
	var defs = alldefs;
	
	var h = (o.height * 16);

	// need to check if we have done this one already
	var s = document.getElementById(o.shortnm);
	if (!s) {
		s = document.createElementNS(xmlns,"svg");
		makeBasicPanel(s,id,h,o.shortnm, uname);
		makeSubElements(s,o);
		
		defs.appendChild(s);
	}
	var g = svgNSGet("g",{"class":"module",transform:"translate("+xpos+","+ypos+")"});
	var u = document.createElementNS(xmlns,"use");
	u.setAttributeNS("http://www.w3.org/1999/xlink","xlink:href","#"+s.id);
	u.setAttributeNS(null,"fill",modcolours[colourix]);
	u.onclick = undefined;
	g.appendChild(u);
	var textop = {x:10,a:"start"};
	if (id==0x7e)
		textop = {x:128,a:"middle"};
	g.appendChild(svgNSGet("text", {fill:"#000",x:textop.x,y:10,"text-anchor":textop.a,textContent:uname}));
	g.lv = lv;
	g.modes = modes;
	g.modid = id;
	defs.parentNode.appendChild(g);
	return h;
}
function mclick(e) {
	// handler for buttons
	var rect = e.target;
	var container = rect.parentNode;
	var control = container.parentElement.controls.filter(function (c) { return c.sv === container })[0];
	var siblings = Array.prototype.slice.call(container.children).filter( function (x) {return x.localName=="rect"});
	
	if (siblings.length>1) {
		// radio buttons
		var v = 0;
		siblings.forEach( function (x, ix) {
			var fill = "#CCC";
			if (x===rect) {
				fill = "#6df2f2";
				v = ix;
			}
			x.setAttributeNS(null,"fill", fill);
		});
		if (control.isgraph && control.l != v) {
			control.l = v;
		}
	} else if (control.n == "levelshift") {
		control.l = ((control.l+1)%(control.p.high+1));
		levelshiftset(container,control.l);
	} else {
		// multi-state button
		if (control.p.names.length==1) {
			// toggle cyan color
			var fill = "#CCC";
			if (control.l ^= 1)
				fill = "#6df2f2";
			rect.previousSibling.setAttributeNS(null,"fill", fill);
		} else {
			// cycle text or translate bmp
			control.l = ((control.l+1)%(control.p.high+1));
			if (control.p.bmp) {
				var u = control.sv.childNodes[2].childNodes[0];
				u.setAttributeNS(null, "transform", "translate(0,"+-control.l*10+")");
			} else
				rect.textContent = control.p.names[control.l];
		}
	}
	if (control.p.f)
		control.tw.textContent = window[control.p.f](0,container.parentElement.controls,control.tw);
	if (container.parentNode.graph&&container.parentNode.graph.f)
		window[container.parentNode.graph.f](container.parentNode.graph,container.parentNode.controls,container.parentNode.modes);
}
function mdown(e) {
	// get control element for this control
	var ss = e.target.nextSibling;
	var control = ss.parentElement.controls.filter(function (c) { return c.sv === ss })[0];
	window.globTarget = control;
	window.globMod = ss.parentElement;
	control.mdx = e.screenX;
	document.addEventListener("mousemove", mmove, false);
	document.addEventListener("mouseup", mup, false);
}
function mmove(e) {
	var deltax = (e.screenX - window.globTarget.mdx)/8;
	var newl = window.globTarget.l + deltax;
	newl = Math.max(0, Math.min(127, newl));
	var newx = newl/128*270-135;
	window.globTarget.a = newx;
	window.globTarget.l = newl;
	var dial = window.globTarget.sv;
	var oldt = dial.getAttribute("transform");
	var newt = oldt.replace(/rotate\([\d|\.|-]* /, "rotate(" + newx + " ");
	if (newt != oldt)
	{
		dial.setAttribute("transform", newt);
		if (globTarget.tw) {
			var f = window[globTarget.p.f];
			var i = globTarget.l;
			var t = " "+i;
			if (f)
				t = f(i,globMod.controls,globTarget.tw);
			globTarget.tw.textContent = t;
		}
		if (globTarget.isgraph && globMod.graph && globMod.graph.f)
			window[globMod.graph.f](globMod.graph, globMod.controls, globMod.modes);
	}
}
function mwheel(e) { // mousewheel
	var ss = e.target.nextSibling;
	e.preventDefault();
	var control = ss.parentElement.controls.filter(function (c) { return c.sv === ss })[0];
	var newl = control.l;
	newl = (e.deltaY>0)?newl-1:newl+1;
	newl = Math.max(0, Math.min(127, newl));
	var newx = newl/128*270-135;
	control.a = newx;
	control.l = newl;
	var dial = control.sv;
	var oldt = dial.getAttribute("transform");
	var newt = oldt.replace(/rotate\([\d|\.|-]* /, "rotate(" + newx + " ");
	if (newt != oldt)
	{
		dial.setAttribute("transform", newt);
		if (control.tw) {
			var f = window[control.p.f];
			var i = control.l;
			var t = " "+i;
			if (f)
				t = f(i,ss.parentElement.controls,control.tw);
			control.tw.textContent = t;
		}
		if (control.isgraph && ss.parentElement.graph && ss.parentElement.graph.f)
			window[ss.parentElement.graph.f](ss.parentElement.graph, ss.parentElement.controls, ss.parentElement.modes);
	}
}
function mup(e) {
	document.removeEventListener("mousemove", mmove, false);
	document.removeEventListener("mouseup", mup, false);
}
// is this too hackey? using eval(e.attributes["transform"].value) to parse the x,y locations?
function translate(x,y){return {x:x,y:y}};
function buildPatchPanel(modules, cables) {
	var maxheight = 0;
	// first remove all the old modules if any
	removeAll();
	modules.forEach(function (m) {
		var v = m.vert*16;
		v += addModuleTemplate(m.type, m.horiz*256, v, m.colour, m.uname, m.lv, m.modes );
		if (v>maxheight)
			maxheight=v;
	});
	moduleSetup();
	wrap.style.height = maxheight + "px";
	if (cables)
		makePatchCables(modules, cables);
}
function makePatchCables(modules, cables) {
	var cableColours = {0:"red",1:"#009",2:"#990",3:"orange",4:"#090",5:"#909",6:"#999"};
	cables.forEach( function (x) {
		// get coords for cable ends
		var smod = modules.filter( function (m) {return x.smod==m.index})[0];
		var dmod = modules.filter( function (m) {return x.dmod==m.index})[0];
		var scon = smod[x.dir==1?"outputs":"inputs"][x.scon];
		var dcon = dmod.inputs[x.dcon];
		var sx = (scon.x)+(smod.horiz*256);
		var sy = (scon.y)+(smod.vert*16);
		var dx = (dcon.x)+(dmod.horiz*256);
		var dy = (dcon.y)+(dmod.vert*16);
		// make random control points mostly along vector
		// adapated from Blue Hell pascal source 
		var pc = new Patchcord(sx,sy,dx,dy);
		var d = pc.getCurvePath();
		var p = svgNSGet("path", {stroke:cableColours[x.colour], fill:"none", d:d, "class":"svgcable nomouse"});
		var i = svgNSGet("path", {stroke:cableColours[x.colour], fill:"none", d:d, "class":"innersvgcable nomouse"});
		alldefs.parentNode.appendChild(p);
		alldefs.parentNode.appendChild(i);
	});
}

function levelshiftset(svg, l){
// the level shifter is quite complex for a little button
	var rr = [3,3,1,1,2,2];
	var xx = [2,3,4,5,0,1];
	var ang = xx[l];
	// one or two green rectangles
	var posfill = (rr[ang]&1)?"#0f0":"none";
	var negfill = (rr[ang]&2)?"#0f0":"none";
	svg.childNodes[1].setAttributeNS(null,"fill",posfill);
	svg.childNodes[2].setAttributeNS(null,"fill",negfill);
	svg.childNodes[3].setAttributeNS(null,"transform","translate(0,"+(ang*-11)+")");
}

function moduleSetup() {
	globModules = document.getElementsByTagName("g");
	//globIO = [];
	var modulecount = globModules.length;
	Array.prototype.slice.call(globModules, 0).forEach(function (e,moduleIndex) {
		//statusdisplay.value = modulecount--;
		if (e.className.baseVal!="module")
			return;
		var mod = modules.getById(e.modid);
		var controls = [];
		var tmpl8 = document.getElementById(e.firstChild.href.baseVal.slice(1));
		// new code for new structure, now that full parameter details are available,
		// make the elements based on that info

		/*// input/output
		var tmp = e.attributes["transform"].value.replace(" ",",");
		var mofs = eval(tmp);
		var io = tmpl8.querySelectorAll("use[*|href$='put']");
		Array.prototype.slice.call(io, 0).forEach(function (i,ix) {
			var cx = 6+i.parentElement.x.baseVal.value+mofs.x;
			var cy = 5+i.parentElement.y.baseVal.value+mofs.y;
			globIO.push({x:cx,y:cy,f:0,t:i.href.baseVal.charAt(1),mi:moduleIndex,si:ix});
		});*/
		var vn = variationselect.v*mod.params.length; // offset into level data for selected variation
		// make a text element for each value display, and graph
		var vds = [];
		var graph; // change to array maybe
		mod.ve.forEach( function (ve) {
			if (ve.type=="valueDisplay") {
				var text = svgNSGet("text",{x:(3+ve.x), y:(9.5+ve.y), fill:"#FFF"});
				var ii = ve.ref;
				if (ii instanceof Array)
					ii = ii[0];
				var p = parammap[mod.params[ii].type];
				var val = p.def;
				if (e.lv)
					val = e.lv[(ve.ref>>0)+vn];
				if (p.f)
					val = window[p.f](val);
				text.textContent = val;
				vds.push({el:text, id:ve.ref});
				e.appendChild(text);
			}
			if (ve.type=="graph"||ve.type=="graphenv") {
				// graphs get a path element and clipping svg element
				var p = svgNSGet("path", {stroke:"#AFA", fill:(ve.type=="graph")?"none":"#00A4A4"});
				var s = svgNSGet("svg", {x:ve.x+0.5, y:ve.y, width:ve.w, height:ve.h, "class":"clipper"});
				s.appendChild(p);
				e.appendChild(s);
				graph = Object.create(ve);
				graph.svg = s;
			}
		});
		// make element for each knob/control in template
		mod.params.forEach(function (knob,knobIndex) {
			var n = knob.n;
			var dial;
			var area;
			var x = knob.x;
			var y = knob.y;
			var ang;
			var sv;
			var p = parammap[knob.type];
			var l = (e.lv)?e.lv[knobIndex+vn]:p.def;
			switch (n) {
				case "KnobBig":
				case "KnobMedium":
				case "KnobSmall":
				case "KnobReset":
				// rotary knob needs clickable circle and pointer elements
					var kd = document.getElementById(n);
					var r = {KnobBig:11,KnobMedium:10,KnobSmall:9,KnobReset:10}[n];
					var top = (n=="KnobReset")?6:0;
					ang = l/128*270-135;
					area = svgNSGet("circle",{r:r, cx:x+r, cy:y+top+r, class:"knob", fill:"rgba(44,0,0,0.025)"});
					area.onmousedown = mdown;
					area.onwheel = mwheel;
					dial = svgNSGet("line",{x1:x + r, y1:y+r/1.2+top, x2:x + r, y2:y + top, stroke:"black"});
					dial.setAttribute("transform", "rotate(" + (ang) + " " + (x + r) + " " + (y + r+top) + ")");
					break;
				case "KnobSlider":
				case "KnobSeqSlider":
				// slider needs click-able rectangle and rectangle pointer elements
					ang = l*0.3125;
					area = svgNSGet("rect",{x:x, y:y, width:12, height:62, fill:"rgba(44,0,0,0.01)"});
					dial = svgNSGet("rect",{x:x, y:y, width:10, height:6, fill:"url(#g121)", stroke:"none", transform:"translate(0," + (ang) + ")"});
					break;
				case "KnobSpin":
				case "KnobSpinH":
				// spinner/horizontal spinner
					break;
				case "levelshift":
					area = svgNSGet("svg", {x:x, y:y, width:18, "class":"clipper", height:11 });
					var clickrect = svgNSGet("rect",{width:18, height:11, fill:"rgba(44,0,0,0.01)"});
					clickrect.onclick = mclick;
					area.appendChild(clickrect);
					area.appendChild( svgNSGet("path", {fill:"none", stroke:"none", d:"M2.5,0l9,0 0,5 -9,0z", "class":"nomouse"}));
					area.appendChild( svgNSGet("path", {fill:"none", stroke:"none", d:"M2.5,6l9,0 0,5 -9,0z", "class":"nomouse"}));
					var u = svgNSGet("use",{transform:"translate(0,0)", "class":"nomouse"});
					u.setAttributeNS("http://www.w3.org/1999/xlink","xlink:href","#BitmapOutputMode");
					area.appendChild(u);
					levelshiftset(area,l);
					break;
				default:
				 /* switch,
				 * types:
					OnOff, type==ActiveMonitor|OffOn
					radioButton, Mode==HR|VR)
				*/
					var w = 18;
					var t = "B";
					if (p.width)
						w = p.width;
					var x = knob.x;
					var y = knob.y;
					if (knob.type=="ActiveMonitor"){ // remove if we correct offset
						x-=1; y-=1.5;
					}
					var xo=0;
					var yo=0;
					var cnt = 1;
					if (p.mode == "VR" || p.mode == "HR") {
					// vertical or horizontal row of radio buttons
						cnt = p.names.length;
						if (p.mode=="VR")
							yo=11;
						else
							xo=w;
					}
					area = svgNSGet("svg", {x:x, y:y});
					var active = p.def;
					var fillt = ["#6df2f2","#CCC"];
					active = l;
					var rows = p.rows||1;
					var rowmod = cnt/rows;
					var ro = 0;
					for (var i=0; i< cnt; i++) {
						var nix = (cnt==1)?active:i;
						t = (p.names)?getSwName(p.names[nix]||p.names[0],knob.name):"";
						if (knob.w)
							w=knob.w;
						var fill = fillt[((i==active)>>0)^((cnt>1)>>0)];
						if (p.names&&p.names.length>1&&cnt==1)
							fill = fillt[1];
						var ix = i%rowmod;
						if (i&&(ix==0))
							ro+=11;
						if (t==""&&cnt==1)
							t="\xA0\xA0";
						var tx = svgNSGet("text",{x:w/2+ix*xo, y:9+i*yo+ro, fill:"#000", textContent:t, "text-anchor":"middle"});
						var re = svgNSGet("rect",{x:ix*xo, y:i*yo+ro, opacity:0.5, fill:fill, stroke:"#333", width:w, height:11});
						area.appendChild(re);
						area.appendChild(tx);
						area.onclick = mclick;
					}
					var bmp = knob.bmp||p.bmp;
					if (bmp) {
						var u = svgNSGet("use",{"class":"nomouse"});
						u.setAttributeNS("http://www.w3.org/1999/xlink","xlink:href","#Bitmap"+bmp);
						if (p.maskh) {
							var i=0;
							if (e.lv)
								i = e.lv[knobIndex+vn];
							u.setAttribute("transform", "translate(0,"+(-i*10)+")");
							var clp = svgNSGet("svg", {"class":"clipper", width:w, height:p.maskh});
							clp.appendChild(u);
							area.appendChild(clp);
						}
						else
							area.appendChild(u);
					}
					
					break;
			}
			if (area)
				e.appendChild(area);
			if (dial) {
				dial.setAttribute("class","nomouse");
				sv = e.appendChild(dial);
			}
			var tc = { sv: sv||area, a: ang, l:l, mdx:0, n:n, x:x, y:y, /*f:p.f*/p:p };
			if (knob.isgraph)
				tc.isgraph = knob.isgraph;
			controls.push(tc);
		});
		mod.modes.forEach(function (sw,mIndex) {
			// these are typically drop down lists, no variations data in pch2.modes array
			if (sw.w) {
				var p = parammap[sw.type];
				var vo = p.h||-18;
				var svg = svgNSGet("svg", {x:sw.x, y:sw.y, width:sw.w, "class":"clipper", height:sw.h });
				var ofs = (e.modes)?e.modes[mIndex]*vo:0;
				var u = svgNSGet("use",{transform:"translate(0,"+ofs+")"});
				u.setAttributeNS("http://www.w3.org/1999/xlink","xlink:href","#"+p.img);
				svg.appendChild(u);
				e.appendChild(svg);
			}
		});
		// valuedisplay text objects, xref to controls
		vds.forEach( function(vvd){
			if (vvd.id instanceof Array) {
				vvd.el.ca = vvd.id;
				vvd.id.forEach(function (id) {controls[id].tw = vvd.el});
				var t = window[controls[vvd.id[0]].p.f](0,controls,controls[vvd.id[0]].tw); // call update function for initial value
				vvd.el.textContent = t;
			} else
				controls[vvd.id].tw = vvd.el;
		});
		e.controls = controls;
		if (graph&&graph.f) {
			e.graph = graph;
			window[graph.f](graph, controls, e.modes);
		}
		e.ve = tmpl8.ve;
	});
}


// set controls etc to reflect current variation
function moduleSetVariation() {
	globModules = document.getElementsByTagName("g");
	var modulecount = globModules.length;
	Array.prototype.slice.call(globModules, 0).forEach(function (e,moduleIndex) {
		if (e.className.baseVal!="module")
			return;
		var mod = modules.getById(e.modid);
		var tmpl8 = document.getElementById(e.firstChild.href.baseVal.slice(1));
		var con = e.controls;
		var vn = variationselect.v*mod.params.length; // offset into level data for selected variation

		var vds = [];
		var graph; // change to array maybe
		mod.ve.forEach( function (ve) {
			if (ve.type=="valueDisplay") {
				// update text for value displays
				var text;
				var val = ve.ref;
				var p = parammap[mod.params[ve.ref].type];
				if (e.lv)
					val = e.lv[(ve.ref>>0)+vn];
				if (p.f)
					val = window[p.f](val);
				text = val;
			}
			if (ve.type=="graph"||ve.type=="graphenv") {
				// call function to update graph
			}
		});
		mod.params.forEach(function (knob,knobIndex) {
			var n = knob.n;
			var area;
			var ang;
			var sv;
			var x = knob.x;
			var y = knob.y;
			var p = parammap[knob.type];
			var l = (e.lv)?e.lv[knobIndex+vn]:p.def;
			var control = con[knobIndex];
			switch (n) {
				case "KnobBig":
				case "KnobMedium":
				case "KnobSmall":
				case "KnobReset":
				// rotary knob
					var r = {KnobBig:11,KnobMedium:10,KnobSmall:9,KnobReset:10}[n];
					var top = (n=="KnobReset")?6:0;
					ang = l/128*270-135;
					dial = con[knobIndex].sv;
					dial.setAttribute("transform", "rotate(" + (ang) + " " + (x + r) + " " + (y + r+top) + ")");
					if (control.tw) {
						var f = window[control.p.f];
						var i = control.l=l;
						var t = " "+i;
						if (f)
							t = f(i);
						control.tw.textContent = t;
					}
					break;
				case "KnobSlider":
				case "KnobSeqSlider":
				// slider
					ang = l*0.3125;
					dial = con[knobIndex].sv;
					dial.setAttribute("transform", "translate(0," + (ang) + ")");
					break;
				case "KnobSpin":
				case "KnobSpinH":
				// spinner/horizontal spinner
					break;
				case "levelshift":
					area = con[knobIndex].sv;
					levelshiftset(area,l);
					break;
				default:
				 // switch,
					var xo=0;
					var yo=0;
					var cnt = 1;
					if (p.mode == "VR" || p.mode == "HR") {
					// vertical or horizontal row of radio buttons
						cnt = p.names.length;
					}
					area = con[knobIndex].sv;
					var active = p.def;
					var fillt = ["#6df2f2","#CCC"];
					active = l;
					var rect = area.getElementsByTagName("rect");
					for (var i=0; i< cnt; i++) {
						var nix = (cnt==1)?active:i;
						var t = (p.names)?getSwName(p.names[nix]||p.names[0],knob.name):"";
						var fill = fillt[((i==active)>>0)^((cnt>1)>>0)];
						if (p.names&&p.names.length>1&&cnt==1)
							fill = fillt[1];
						if (t==""&&cnt==1)
							t="\xA0\xA0";
						rect[i].setAttribute("fill",fill);
					}
					var bmp = knob.bmp||p.bmp;
					if (bmp) {
						if (p.maskh) {
							var i=0;
							if (e.lv)
								i = e.lv[knobIndex+vn];
							/*
							u.setAttribute("transform", "translate(0,"+(-i*10)+")");
							var clp = svgNSGet("svg", {"class":"clipper", width:w, height:p.maskh});
							clp.appendChild(u);
							area.appendChild(clp);*/
						}
					}
					break;
			}
		});
	});
}

var Patchcord = function(sx,sy,dx,dy) {
	this.points = [4];
	this.points[3] = new FastVector(sx,sy);
	this.points[0] = new FastVector(dx,dy);
}
Patchcord.prototype = {
	shake: function() {
		var angle1 = (Math.random()-0.5)*2;
		var strength1 = Math.random()*0.38;
		var angle2 = (Math.random()-0.5)*2;
		var strength2 = Math.random()*0.38;
		var dir1 = this.points[0].subtract(this.points[3]).rotate(angle1);
		var dir2 = this.points[0].subtract(this.points[3]).rotate(angle2);
		this.points[1] = this.points[0].subtract(dir1.multiply(strength1));
		this.points[2] = this.points[3].add(dir2.multiply(strength2));
	},
	getCurvePath: function() {
		this.shake();
		return this.points[0].toString("M")+this.points[1].toString("C")+this.points[2].toString(",")+this.points[3].toString(",");
		//return this.points[0].toString("M")+this.points[1].toString("L")+this.points[2].toString("M")+this.points[3].toString("L");
	},
	getStraitPath: function() {
	}
}

var FastVector = function(x,y,x2){
	this.x = x;
	this.y = y;
	this.x2 = x2;
};

FastVector.prototype = {
	
	add: function (B,internal) {
		var nx, ny;
		if (typeof(B)=='number'){
			nx = this.x+B;
			ny = this.y+B;
		}else{
			nx = this.x+B.x;
			ny = this.y+B.y;
		}
		return new FastVector(nx,ny);
	},
	rotate: function(angle) {
		var nx,ny;
		var a = angle;//angle * (Math.PI / 180);
		var sa = Math.sin(a);
		var ca = Math.cos(a);
		nx = (ca * this.x) - (sa * this.y);
		ny = (sa * this.x) + (ca * this.y);
		return new FastVector(nx, ny);
	},
	dot: function(B) {
		return ((this.x*B.x)+(this.y*B.y));
	},
	length: function() {
		return Math.sqrt((this.x*this.x)+(this.y*this.y));
	},
	longway: function(B) {
		var nx, ny; // if the shortest distance is a straight line, calculate the other distance
		if (typeof(B) == 'number'){
			nx = this.x-B; ny = this.y-B;
		}else{
			nx = Math.abs(this.x-B.x); ny = Math.abs(this.y-B.y);
		}
		return nx+ny;
	},
	multiply: function(B) {
		var nx, ny;
		if (typeof(B)=='number'){
			nx = this.x*B; ny = this.y*B;
		}else{ 
			nx = this.x*B.x; ny = this.y*B.y;
		}
		return new FastVector(nx,ny);
	},
	divide: function(B) {
		var nx, ny;
		if (typeof(B)=='number'){
			nx = this.x/B; ny = this.y/B;
		}else{ 
			nx = this.x/B.x; ny = this.y/B.y;
		}
		return new FastVector(nx,ny);
	},
	squaredLength: function(args) {
		return (this.x*this.x)+(this.y*this.y);
	},
	sum: function(){
		return this.x+this.y;
	},
	subtract: function(B) {
		var nx, ny;
		if (typeof(B) == 'number'){
			nx = this.x-B; ny = this.y-B;
		}else{
			nx = this.x-B.x; ny = this.y-B.y;
		}
		return new FastVector(nx,ny);
	},
	toString: function(pre) {
		pre = pre||"";
		return pre+this.x+" "+this.y;
	},
	getstr: function (p, xs, ys, yo) {
		return p+(this.x*xs)+","+(this.y*ys+yo);
	}
};

function getstr2(p, xs, ys, yo, shp) {
	var tx = this.x;
	var delta = this.x2 - tx;
	tx = tx + (delta*(shp*(1/128)));
	return p+Math.round(tx*xs,5)+","+(this.y*ys+yo);
};

function fvf(x,y, x2, ns) {
	var nefv = new FastVector(x,y,x2);
	if (ns)
		nefv.getstr = ns;
	return nefv;
}
	// lfo graph code
	function lfoBgraph(g,con) {
		var dp = [
			[fvf(0,0), fvf(0.14,-0.2), fvf(0.3,-0.5), fvf(0.5,-0.5), fvf(0.7,-0.5), fvf(0.86,-0.2),
			fvf(1,0), fvf(1.14,0.2), fvf(1.3,0.5), fvf(1.5,0.5), fvf(1.7,0.5), fvf(1.86,0.2), fvf(2,0)],
			[fvf(0,0), fvf(0.5,-0.5), fvf(1.5,0.5), fvf(2,0)],
			[fvf(0,0.5), fvf(0,-0.5), fvf(2,0.5)],
			[fvf(0,0.5), fvf(0,-0.5), fvf(1,-0.5), fvf(1,0.5), fvf(2,0.5)]
		];
		var phase = 0;
		var wave = 0;
		// offset and scale factors for levelshift modes
		var xf = [{yo:7,ys:12.5},{yo:7,ys:-12.5},{yo:21,ys:12.5},{yo:21,ys:-12.5},{yo:14,ys:26.5},{yo:14,ys:-26.5}]// 4,5,0,1,2,3
		var xl = xf[4];
		if (con) {
			phase = (con[6].l*-2.8125)*(g.w/360);
			wave = con[4].l;
			xl = xf[con[8].l];
		}
		var kl = dp[wave]; // wave points array, one cycle
		var kt = (wave==0)?"C":"L"; // path type, curve or line
		// add more points to make two cycles
		var k = kl.concat(kl.slice(1).map(function(x){return x.add({x:2,y:0})}));
		// calculate actual path with scaling and offset
		var d = k[0].getstr("M", 26, xl.ys, xl.yo)+k[1].getstr(kt, 26, xl.ys, xl.yo);
		k.slice(2).forEach( function (x) {d+=x.getstr(" ", 26, xl.ys, xl.yo)});
		
		var path = g.svg.firstChild;
		path.setAttributeNS(null,"d", d);
		path.setAttributeNS(null,"transform", "translate("+phase+",0)");
	}

	function lfoShpgraph(g,con) {
		var dp = [
			[fvf(0,0.5), fvf(0.025,-0.5,1.975, getstr2), fvf(2,0.5)],

			[fvf(0,0.5), fvf(0.975,0.5,0.0001,getstr2), fvf(1,-0.5), fvf(1.025,0.5,2,getstr2), fvf(2,0.5)],

			[fvf(0,0.5), fvf(0.975,0.5,0.0001,getstr2), fvf(1,-0.5), fvf(1.025,0.5,2,getstr2), fvf(2,0.5)],

			[fvf(0,0.5), fvf(0.025,-0.5,1.975, getstr2), fvf(2,0.5)],

			[fvf(0,0), fvf(0.5,-0.5,0.0001,getstr2), fvf(0.5,-0.5,1,getstr2), fvf(1.5,0.5,1,getstr2), fvf(1.5,0.5,2,getstr2), fvf(2,0)],

			[fvf(0,0.5), fvf(0,-0.5), fvf(0.01,-0.5,1.99,getstr2), fvf(0.01,0.5,1.99,getstr2), fvf(2,0.5)]
		];
		var phase = 0;
		var wave = 0;
		var shp = 64;
		// offset and scale factors for levelshift modes
		var xf = [{yo:7,ys:12.5},{yo:7,ys:-12.5},{yo:21,ys:12.5},{yo:21,ys:-12.5},{yo:14,ys:26.5},{yo:14,ys:-26.5}]// 4,5,0,1,2,3
		var xl = xf[4];
		if (con) {
			phase = (con[7].l*-2.8125)*(g.w/360);
			shp = con[5].l;
			wave = con[11].l;
			xl = xf[con[10].l];
		}
		var kl = dp[wave]; // wave points array, one cycle
		var kt = "L"; // path type, curve or line
		if (wave<2) {
			kt = "C";
			// add control points for sine like curves
			var newk = [];
			var lastx = kl[0].x;
			var lasty = kl[0].y;
			var lastd = 0;
			var delta;
			kl.forEach( function (x,i){
				if (i==0)
					newk.push(x);
				else {
					var tx = x.x;
					if (x.x2) {
						delta = x.x2 - tx;
						tx = tx + (delta*(shp*(1/128)));
					}
					// make two new points for control points
					var tx1 = tx2 = (tx - lastx)/2;
					newk.push(new FastVector(lastx+tx1,lasty));
					newk.push(new FastVector(tx-tx2,x.y));
					newk.push(new FastVector(tx,x.y));
					lasty = x.y;
					lastx = tx;
					lastd = delta;
				}
			});
			kl = newk;
		}
		// add more points to make two cycles
		var k = kl.concat(kl.slice(1).map(function(x){
			var nex = x.add({x:2,y:0});
			if (x.x2) {
				nex.x2 = x.x2+2;
				nex.getstr = x.getstr;
			}
			return nex}
		));
		// calculate actual path with scaling and offset
		var d = k[0].getstr("M", 26, xl.ys, xl.yo, shp)+k[1].getstr(kt, 26, xl.ys, xl.yo, shp);
		k.slice(2).forEach( function (x) {d+=x.getstr(" ", 26, xl.ys, xl.yo, shp)});
		
		var path = g.svg.firstChild;
		path.setAttributeNS(null,"d", d);
		path.setAttributeNS(null,"transform", "translate("+phase+",0)");
	}

	function interpol(a,b,shp) {
		var r = [];
		var d = [2];
		r.push(fvf(0,0));
		a.forEach( function (a,i) {
			d[i%2] = a-((a - b[i])*shp);
			if (i%2)
				r.push(fvf(d[0],d[1]-0.5));
		});
		return r;
	}

	function oscShpgraph(g,con) {
		var dp = [
			[fvf(0,0.5), fvf(1,-0.5,0.001, getstr2), fvf(2,0.5)],

			//[fvf(0,0), fvf(0.5,-0.5,0.95, getstr2), fvf(1,0,1.9, getstr2), fvf(1.5,0.5,1.95, getstr2), fvf(2,0)],
			//[fvf(0,0), fvf(1,-0.5,1.99,getstr2), fvf(1,0.5,1.99,getstr2), fvf(2,0)],
			[[0,.50, .2643,0, .50,0, .7357,0, 1.00,.50, 1.00,.50, 1.00,.50, 1.264,1.00, 1.50,1.00, 1.736,1.00, 2.00,.50, 2.00,.50],
			[0,.5, .15,0, .8999,0, 1.65,0, 1.80,.50, 1.80,.50, 1.80,.50, 1.80,1.00, 1.90,1.00, 2.00,1.00, 2.00,.50, 2.00,.50]],

			[[0,.50, .2643,0, .50,0, .7357,0, 1.00,.50, 1.00,.50, 1.00,.50, 1.264,1.00, 1.50,1.00, 1.736,1.00, 2.00,.50, 2.00,.50],
			[.3294,.4234, .6492,.3103, .95,.001531, .9667,.1815, .9833,.3615, 1.00,.5415, 1.017,.6948, 1.033,.8482, 1.05,1.002, 1.382,.6305, 1.692,.5297, 2.00,.50]],
			
			[[0,.50, .2643,0, .50,0, .7357,0, 1.00,.50, 1.00,.50, 1.00,.50, 1.264,1.00, 1.50,1.00, 1.736,1.00, 2.00,.50, 2.00,.50],
			[.05,-.05072, -.05,-.10, .50,.15, 1.05,-.10, .95,-.05072, 1.00,.4993, 1.05,1.05, .95,1.10, 1.50,.8485, 2.05,1.10, 1.95,1.05, 2.00,.4993]],

			[fvf(0,0), fvf(0.5,-0.5,0.0001, getstr2), fvf(1.5,0.5,2, getstr2), fvf(2,0)],

			[fvf(0,0), fvf(0,-0.5), fvf(1,-0.5,0.0001,getstr2), fvf(1,0.5,0.0001,getstr2), fvf(2,0.5,0.0001,getstr2), fvf(2,0,0.0001,getstr2), fvf(2,0)]
		];
		var wave = 0;
		var shp = 64;
		if (con) {
			shp = con[7].l;
			wave = con[9].l;
		}
		var kl = dp[wave]; // wave points array, one cycle
		var kt = "L"; // path type, curve or line
		if (kl[0] instanceof Array) {
			kl = interpol(kl[0],kl[1],shp*(1/128));
			kt = "C";
		}
		else if (wave<2) {
			kt = "C";
			// add control points for sine like curves
			var newk = [];
			var lastx = kl[0].x;
			var lasty = kl[0].y;
			var lastd = 0;
			var delta;
			kl.forEach( function (x,i){
				if (i==0)
					newk.push(x);
				else {
					var tx = x.x;
					if (x.x2) {
						delta = x.x2 - tx;
						tx = tx + (delta*(shp*(1/128)));
					}
					// make two new points for control points
					var tx1 = tx2 = (tx - lastx)/2;
					newk.push(new FastVector(lastx+tx1,lasty));
					newk.push(new FastVector(tx-tx2,x.y));
					newk.push(new FastVector(tx,x.y));
					lasty = x.y;
					lastx = tx;
					lastd = delta;
				}
			});
			kl = newk;
		}
		
		var k = kl;
		// calculate actual path with scaling and offset
		var d = k[0].getstr("M", 19, 21.5, 11, shp)+k[1].getstr(kt, 19, 21.5, 11, shp);
		k.slice(2).forEach( function (x) {d+=x.getstr(" ", 19, 21.5, 11, shp)});
		
		var path = g.svg.firstChild;
		path.setAttributeNS(null,"d", d);
	}

	function oscShpBgraph(g,con,mode) {
		var dp = [
			[fvf(0,0.5), fvf(1,-0.5,0.001, getstr2), fvf(2,0.5)],

			//[fvf(0,0), fvf(0.5,-0.5,0.95, getstr2), fvf(1,0,1.9, getstr2), fvf(1.5,0.5,1.95, getstr2), fvf(2,0)],
			//[fvf(0,0), fvf(1,-0.5,1.99,getstr2), fvf(1,0.5,1.99,getstr2), fvf(2,0)],
			[[ 0,.50, .2643,0, .50,0, .7357,0, 1.00,.50, 1.00,.50, 1.00,.50, 1.264,1.00, 1.50,1.00, 1.736,1.00, 2.00,.50, 2.00,.50],
			[0,.5, .15,0, .8999,0, 1.65,0, 1.80,.50, 1.80,.50, 1.80,.50, 1.80,1.00, 1.90,1.00, 2.00,1.00, 2.00,.50, 2.00,.50]],

			[[0,.50, .2643,0, .50,0, .7357,0, 1.00,.50, 1.00,.50, 1.00,.50, 1.264,1.00, 1.50,1.00, 1.736,1.00, 2.00,.50, 2.00,.50],
			[.3294,.4234, .6492,.3103, .95,.001531, .9667,.1815, .9833,.3615, 1.00,.5415, 1.017,.6948, 1.033,.8482, 1.05,1.002, 1.382,.6305, 1.692,.5297, 2.00,.50]],
			
			[[0,.50, .2643,0, .50,0, .7357,0, 1.00,.50, 1.00,.50, 1.00,.50, 1.264,1.00, 1.50,1.00, 1.736,1.00, 2.00,.50, 2.00,.50],
			[.05,-.05072, -.05,-.10, .50,.15, 1.05,-.10, .95,-.05072, 1.00,.4993, 1.05,1.05, .95,1.10, 1.50,.8485, 2.05,1.10, 1.95,1.05, 2.00,.4993]],

			[fvf(0,0), fvf(0.5,-0.5,0.0001, getstr2), fvf(1.5,0.5,2, getstr2), fvf(2,0)],

			[[0,.9965, 0,.2965, 0.000306,.2938, 0.000306,.05479, 2.00,.9965],[0,10, 0,.30, 1,1, 1,.30, 2.00,1.00]],
			
			[fvf(0,0.5), fvf(0,-0.5), fvf(1,-0.5,1.9,getstr2), fvf(1,0.5,1.9,getstr2), fvf(1.9,0.5)],
			
			[fvf(0,0), fvf(0,-0.5), fvf(1,-0.5,0.0001,getstr2), fvf(1,0.5,0.0001,getstr2), fvf(2,0.5,0.0001,getstr2), fvf(2,0,0.0001,getstr2), fvf(2,0)]
		];
		var wave = 0;
		var shp = 64;
		if (con)
			shp = con[6].l;
		if (mode)
			wave = mode[0];
		var kl = dp[wave]; // wave points array, one cycle
		var kt = "L"; // path type, curve or line
		if (kl[0] instanceof Array) {
			kl = interpol(kl[0],kl[1],shp*(1/128));
			kt = (wave>3)?"L":"C";
		}
		else if (wave<2) {
			kt = "C";
			// add control points for sine like curves
			var newk = [];
			var lastx = kl[0].x;
			var lasty = kl[0].y;
			var lastd = 0;
			var delta;
			kl.forEach( function (x,i){
				if (i==0)
					newk.push(x);
				else {
					var tx = x.x;
					if (x.x2) {
						delta = x.x2 - tx;
						tx = tx + (delta*(shp*(1/128)));
					}
					// make two new points for control points
					var tx1 = tx2 = (tx - lastx)/2;
					newk.push(new FastVector(lastx+tx1,lasty));
					newk.push(new FastVector(tx-tx2,x.y));
					newk.push(new FastVector(tx,x.y));
					lasty = x.y;
					lastx = tx;
					lastd = delta;
				}
			});
			kl = newk;
		}
		
		var k = kl;
		// calculate actual path with scaling and offset
		var d = k[0].getstr("M", 19, 21.5, 11, shp)+k[1].getstr(kt, 19, 21.5, 11, shp);
		k.slice(2).forEach( function (x) {d+=x.getstr(" ", 19, 21.5, 11, shp)});
		
		var path = g.svg.firstChild;
		path.setAttributeNS(null,"d", d);
	}

	// envelope graph code
	var envsegment = function (t,l) {
		this.l = l*(1/128);
		this.t = t*(1/128);
	}
	envsegment.prototype = {
		lin:function (i,en) {
			var emt = en.tacc+=this.t;
			return "L"+emt*en.thi.xs+","+(this.l*en.thi.ys+en.thi.yo);
		},
		exp:function (i,en) {
			var emt1 = en.tacc+(this.t*.16);
			var emt2 = en.tacc+=this.t;
			var y = (this.l*en.thi.ys+en.thi.yo);
			return "Q"+emt1*en.thi.xs+","+y+" "+emt2*en.thi.xs+","+y;
		},
		log:function (i,en) {
			var pli = (en[(i||en.length)-1].l*en.thi.ys+en.thi.yo);
			var emt1 = en.tacc+(this.t*.8);
			var emt2 = en.tacc+=this.t;
			var y = (this.l*en.thi.ys+en.thi.yo);
			return "Q"+emt1*en.thi.xs+","+pli+" "+emt2*en.thi.xs+","+y;
		},
		sseg:function (i,en) {
			var emt = en.tacc+=en.thi.sustime;
			return "L"+emt*en.thi.xs+","+(this.l*en.thi.ys+en.thi.yo);
		},
		initial:function(l,en) {
			l = en[en.length-1].l;
			return "M0,"+(l*en.thi.ys+en.thi.yo);
		}
	};

	function envGetd(en,segs) {
		en.tacc = 0;
		var d = en[0].initial(1,en);
		en.forEach(function (seg,i) {
			d += seg[segs[i]](i,en);
			if (seg.sustain)
				d += seg["sseg"](i,en);
		});
		return d;
	}
	
	function adrGraph(g, con) {
		var en = [new envsegment(con[1].l,0),new envsegment(con[3].l,127)];
		if (con[7].l)
			en[0].sustain = true;
		en.thi = (con[5].l&1)?{ys:-22,xs:15,yo:22}:{ys:22,xs:15,yo:0};
		var sm = [
		["exp","exp"],
		["lin","exp"],
		["log","exp"],
		["lin","lin"]
		][con[0].l];
		en.thi.sustime = 2 - en.reduce(function(a,b){b.en=en; return (b.sustain)?a:a+b.t},0);
		var d = envGetd(en,sm);//en[0].initial(1,en);
		var path = g.svg.firstChild;
		path.setAttributeNS(null,"d", d);
	}
	function adsrGraph(g, con) {
		var en = [new envsegment(con[1].l,0),new envsegment(con[2].l,127-con[3].l),new envsegment(con[4].l,127)];
		en[1].sustain = true;
		en.thi = (con[5].l&1)?{ys:-28,xs:15,yo:28}:{ys:28,xs:15,yo:0};
		var sm = [
		["exp","exp","exp"],
		["lin","exp","exp"],
		["log","exp","exp"],
		["lin","lin","lin"]
		][con[0].l];
		en.thi.sustime = 3 - en.reduce(function(a,b){b.en=en; return (b.sustain)?a:a+b.t},0);
		var d = envGetd(en,sm);//en[0].initial(1,en);
		var path = g.svg.firstChild;
		path.setAttributeNS(null,"d", d);
	}
	function addsrGraph(g, con) {
		var en = [new envsegment(con[2].l,0),new envsegment(con[3].l,127-con[4].l),
		new envsegment(con[5].l,127-con[6].l),new envsegment(con[7].l,127)];
		en[con[8].l&&2||1].sustain = true;
		en.thi = (con[9].l&1)?{ys:-28,xs:15,yo:28}:{ys:28,xs:15,yo:0};
		var sm = [
		["exp","exp","exp","exp"],
		["lin","exp","exp","exp"],
		["log","exp","exp","exp"],
		["lin","lin","lin","lin"]
		][con[1].l];
		en.thi.sustime = 4 - en.reduce(function(a,b){b.en=en; return (b.sustain)?a:a+b.t},0);
		var d = envGetd(en,sm);
		var path = g.svg.firstChild;
		path.setAttributeNS(null,"d", d);
	}
	function multiEnvGraph(g, con) {
		var en = [
			new envsegment(con[4].l,127-con[0].l),new envsegment(con[5].l,127-con[1].l),
			new envsegment(con[6].l,127-con[2].l),new envsegment(con[7].l,127-con[3].l)
		];
		if (con[9].l<3)
			en[con[9].l].sustain = true;
		en.thi = (con[10].l&1)?{ys:-28,xs:15,yo:28}:{ys:28,xs:15,yo:0};
		var sm = [
		["exp","exp","exp","exp"],
		["lin","exp","exp","exp"],
		["log","exp","exp","exp"],
		["lin","lin","lin","lin"]
		][con[12].l];
		en.thi.sustime = 4.5 - en.reduce(function(a,b){b.en=en; return (b.sustain)?a:a+b.t},0);
		var d = envGetd(en,sm);
		var path = g.svg.firstChild;
		path.setAttributeNS(null,"d", d);
	}
	function adsrMGraph(g, con) {
		var en = [new envsegment(con[0].l,0),new envsegment(con[1].l,127-con[2].l),new envsegment(con[3].l,127)];
		en[1].sustain = true;
		en.thi = (con[8].l&1)?{ys:-28,xs:15,yo:28}:{ys:28,xs:15,yo:0};
		var sm = ["exp","exp","exp"];
		en.thi.sustime = 3 - en.reduce(function(a,b){b.en=en; return (b.sustain)?a:a+b.t},0);
		var d = envGetd(en,sm);
		var path = g.svg.firstChild;
		path.setAttributeNS(null,"d", d);
	}
	function denvGraph(g, con) {
		var en = [new envsegment(0,0),new envsegment(con[0].l,127)];
		en.thi = (con[1].l&1)?{ys:-22,xs:31,yo:22}:{ys:22,xs:31,yo:0};
		var sm = ["lin","exp"];
		en.reduce(function(a,b){b.en=en; return (b.sustain)?a:a+b.t},0);
		var d = envGetd(en,sm);
		var path = g.svg.firstChild;
		path.setAttributeNS(null,"d", d);
	}
	function henvGraph(g, con) {
		var en = [new envsegment(0,0),new envsegment(con[0].l,0),new envsegment(0,127),new envsegment(200,127)];
		en.thi = (con[1].l&1)?{ys:-22,xs:31,yo:22}:{ys:22,xs:31,yo:0};
		var sm = ["lin","lin","lin","lin"];
		en.reduce(function(a,b){b.en=en; return (b.sustain)?a:a+b.t},0);
		var d = envGetd(en,sm);
		var path = g.svg.firstChild;
		path.setAttributeNS(null,"d", d);
	}
	function ahdGraph(g, con) {
		var en = [new envsegment(con[1].l,0),new envsegment(con[2].l,0),new envsegment(con[4].l,127)];
		en.thi = (con[5].l&1)?{ys:-28,xs:20,yo:28}:{ys:28,xs:20,yo:0};
		en.tacc = 0;
		var sm = [
		["exp","lin","exp"],
		["lin","lin","exp"],
		["log","lin","exp"],
		["lin","lin","lin"]
		][con[0].l];
		en.reduce(function(a,b){b.en=en; return (b.sustain)?a:a+b.t},0);
		var d = envGetd(en,sm);
		var path = g.svg.firstChild;
		path.setAttributeNS(null,"d", d);
	}
	function ahdMGraph(g, con) {
		var en = [new envsegment(con[0].l,0),new envsegment(con[1].l,0),new envsegment(con[2].l,127)];
		en.thi = (con[6].l&1)?{ys:-28,xs:20,yo:28}:{ys:28,xs:20,yo:0};
		en.tacc = 0;
		var sm = ["exp","lin","exp"];
		en.reduce(function(a,b){b.en=en; return (b.sustain)?a:a+b.t},0);
		var d = envGetd(en,sm);
		var path = g.svg.firstChild;
		path.setAttributeNS(null,"d", d);
	}
	// filter graph code
	
	if (window.location.search) {
		filepickerfieldset.className = "nope";
		modulegroupfieldset.className = "nope";
		loadTestPatch(window.location.search.substr(5));
	}
	function dxrouterGraph(g, con) {
		var ala = [];
		var alb = [];
		ala[ 0] = [{x:46,y:51},{x:46,y:35},{x:78,y:51},{x:78,y:35},{x:78,y:19},{x:78,y:3}];
		alb[ 0] = {i:0, d:"m 54.8,46 0,19.01 33,0 0,-64.3184 12,0 0,15.7984 -12,0"};
		alb[ 1] = {i:0, d:"m 55,48.51 11.51,0 0,-16.02 -11.61,0 -0.1,32.52 33,0 0,-51.01"};
		ala[ 1] = [{x:46,y:51},{x:46,y:35},{x:46,y:19},{x:78,y:51},{x:78,y:35},{x:78,y:19}];
		alb[ 2] = {i:1, d:"m 54.8,30 0,34.91 33,0 0,-48.32 11.08,0 0,15.8 -11.08,0"};
		alb[ 3] = {i:1, d:"m 54.8,30 0,34.91 33,0 0,-48.32 11.08,0 0,46.9 -11.08,-0.12"};
		ala[ 2] = [{x:28,y:51},{x:28,y:35},{x:60,y:51},{x:60,y:35},{x:92,y:51},{x:92,y:35}];
		alb[ 4] = {i:2, d:"m 36.41,45.93 0,19.01 64.99,0 0,-32.32 11.5,0 0,15.8 -11.5,0 M 68.74,46 l 0,19"};
		alb[ 5] = {i:2, d:"m 36.41,45.93 0,19.01 64.99,0 0,-32.32 11.4,0 0,31.16 -11.4,0 M 68.68,46 l 0,19"};
		ala[ 3] = [{x:28,y:51},{x:28,y:35},{x:60,y:51},{x:60,y:35},{x:92,y:35},{x:92,y:19}];
		alb[ 6] = {i:3, d:"M 77.56,50.66 92.43,46.1 m -56.02,-0.17 0,19.01 32.63,0 0,-18.94 M 101,35 l 0.2,-18.59 11.4,0 0,16.18 -11.4,-0.1"};
		alb[ 7] = {i:3, d:"m 77.52,50.72 14.9,-4.56 m -56.01,-0.17 0,18.97 32.61,0 0,-32.71 -12.23,0.19 0,16.04 12.23,0.1 M 100.9,35.06 101,29.54"};
		alb[ 8] = {i:3, d:"m 77.45,50.69 14.9,-4.56 m -56.15,2.35 -12.36,0 0,-16.4 12.68,0 -0.18,32.89 32.61,0 0,-18.94 m 32.15,-11 0,-5.04"};
		ala[ 4] = [{x:83,y:51},{x:83,y:35},{x:83,y:19},{x:55,y:51},{x:55,y:35},{x:26,y:35}];
		alb[ 9] = {i:4, d:"m 43.2,46.1 11.15,4.68 m 8.87,-4.78 0,18.94 28.52,0 0,-48.32 11.06,0 0,15.8 -11.06,0"};
		alb[10] = {i:4, d:"m 43.2,46.1 11.15,4.68 m 8.99,-2.31 11.63,0.1 -0.12,-16.47 -11.63,0 0,32.91 28.52,0 0,-35.01"};
		ala[ 5] = [{x:99,y:51},{x:99,y:35},{x:44,y:51},{x:17,y:35},{x:44,y:35},{x:72,y:35}];
		alb[11] = {i:5, d:"M 71.99,46.1 61.8,50.78 M 34.16,46.1 44.35,50.78 m 63.35,-2.31 11.6,0.1 -0.1,-16.47 -11.6,0 0,2.79 m -54.38,11.15 0,18.97 54.48,0 0,-19.07"};
		alb[12] = {i:5, d:"M 71.99,46.1 61.8,50.78 M 34.16,46.1 44.35,50.78 m 36.07,-4.71 0,2.44 11.55,0 -0.1,-16.47 -11.6,0 0,2.79 m -27.1,11.15 0,18.97 54.53,0 0,-19.07"};
		ala[ 6] = [{x:43,y:51},{x:43,y:35},{x:72,y:51},{x:72,y:35},{x:43,y:19},{x:72,y:19}];
		alb[13] = {i:6, d:"m 59.7,30.28 11.87,4.55 m -20.24,11.09 0,19 29,0 0,-34.92 m 0.16,2.41 11.6,0.1 -0.1,-16.47 -11.6,0 0,2.79"};
		alb[14] = {i:6, d:"m 59.7,30.28 11.87,4.55 m -20.24,11.09 0,19 29,0 0,-34.92 m -28.82,18.53 -11.6,0.1 0.1,-15.99 11.6,0 0,2.79"};
		ala[ 7] = [{x:54,y:51},{x:26,y:35},{x:55,y:35},{x:55,y:19},{x:83,y:35},{x:83,y:19}];
		alb[15] = {i:7, d:"M 82.83,46.1 71.68,50.78 M 43.2,46.1 54.35,50.78 m 37.35,-18.31 11.6,0.1 -0.1,-16.47 -11.62,0 0,2.6 m -28.24,11.68 0,34.63 m 28.4,-18.82 0,-16.19"};
		alb[16] = {i:7, d:"M 82.83,46.1 71.68,50.78 M 43.2,46.1 54.35,50.78 m 37.39,-4.66 0,-16.19 m -28.4,0.38 0,34.63 m -16.88,-17.59 -0.1,-15.27 -11.62,0 0,2.6"};
		ala[ 8] = [{x:54,y:51},{x:26,y:35},{x:55,y:35},{x:83,y:35},{x:83,y:19},{x:83,y:3}];
		alb[17] = {i:8, d:"m 63.34,34.87 0,30.07 M 82.83,46.1 71.68,50.78 M 43.2,46.1 54.35,50.78 m 0.1,0 17.21,0 0,11.3 -17.21,0 z m 37.3,-15.87 0,-20.75 m -28.43,34.5 8.01,0 3.69,-1.84 -0.1,-14.71 -11.62,0 0,2.6"};
		ala[ 9] = [{x:28,y:51},{x:28,y:35},{x:28,y:19},{x:60,y:51},{x:93,y:51},{x:60,y:35}];
		alb[18] = {i:9, d:"m 69.11,34.57 0,-3.13 12.64,0 0,15.99 m -4.43,-1.39 15.16,4.74 m -56.07,-21.97 0,36.13 64.99,0 0,-3.67 M 68.68,46 l 0,19"};
		ala[10] = [{x:11,y:51},{x:44,y:51},{x:11,y:35},{x:108,y:51},{x:108,y:35},{x:76,y:35}];
		alb[19] = {i:10, d:"m 93.4,46.04 14.9,4.74 m -87.91,-16.21 0,-3.13 12.64,0 0,15.99 M 28.6,46.04 43.76,50.78 M 20.41,46 l 0,18.94 96.69,0 0,-18.94 m -64.42,14 0,5"};
		ala[11] = [{x:11,y:51},{x:44,y:51},{x:11,y:35},{x:76,y:51},{x:108,y:51},{x:76,y:35}];
		alb[20] = {i:11, d:"M 93.4,46.04 108.3,50.78 M 28.6,46.04 43.76,50.78 M 20.39,34.57 20.39,31.44 33.03,31.44 33.03,47.43 M 20.41,46 20.41,64.94 117.1,64.94 117.1,62 M 52.68,62 52.68,65 M 84.75,46 84.75,65"};
		ala[12] = [{x:11,y:51},{x:11,y:35},{x:44,y:51},{x:76,y:51},{x:108,y:51},{x:76,y:35}];
		alb[21] = {i:12, d:"M 75.74,46.04 60.84,50.78 M 93.4,46.04 108.3,50.78 M 84.25,34.38 84.25,31.25 96.95,31.25 96.95,47.24 M 43.67,50.81 60.89,50.81 60.89,62.09 43.67,62.09 z M 20.41,46 20.41,64.94 117.1,64.94 117.1,62 M 52.68,62 52.68,65 M 84.75,46 84.75,65"};
		ala[13] = [{x:11,y:51},{x:44,y:51},{x:44,y:35},{x:76,y:51},{x:108,y:51},{x:76,y:35}];
		alb[22] = {i:13, d:"M 93.4,46.04 108.3,50.78 M 84.25,34.38 84.25,31.25 96.95,31.25 96.95,47.24 M 20.41,61.95 20.41,64.94 117.1,64.94 117.1,62 M 52.68,46 52.68,64.87 M 84.75,46 84.75,65"};
		ala[14] = [{x:1,y:51},{x:31,y:51},{x:61,y:51},{x:90,y:51},{x:120,y:51},{x:90,y:35}];
		alb[23] = {i:14, d:"M 39.04,62 39.04,65 M 90.5,46.04 77.83,50.78 M 107.9,46.04 120.3,50.78 M 99.01,34.95 99.01,31.82 111.8,31.82 111.8,47.56 M 9.542,61.67 9.542,64.94 129.1,64.94 129.1,62 M 69.04,62 69.04,65 M 98.75,46 98.75,65"};
		alb[24] = {i:14, d:"M 39.04,62 39.04,65 M 107.9,46.04 120.3,50.78 M 99.01,34.95 99.01,31.82 111.8,31.82 111.8,47.56 M 9.542,61.67 9.542,64.94 129.1,64.94 129.1,62 M 69.04,62 69.04,65 M 98.75,46 98.75,65"};
		ala[15] = [{x:11,y:51},{x:44,y:51},{x:44,y:35},{x:108,y:51},{x:76,y:35},{x:108,y:35}];
		alb[25] = {i:15, d:"M 93.4,46.04 108.3,50.78 M 117.1,34.38 117.1,31.56 129.6,31.56 129.6,48.22 117.1,48.22 M 20.41,61.95 20.41,64.94 117.1,64.94 117.1,45.86 M 52.68,46 52.68,64.87"};
		alb[26] = {i:15, d:"M 93.4,46.04 108.3,50.78 M 52.69,34.38 52.69,31.56 65.19,31.56 65.19,48.22 52.69,48.22 M 20.41,61.95 20.41,64.94 117.1,64.94 117.1,45.86 M 52.68,46 52.68,64.87"};
		ala[16] = [{x:28,y:51},{x:28,y:35},{x:60,y:51},{x:60,y:35},{x:60,y:19},{x:92,y:51}];
		alb[27] = {i:16, d:"M 69.11,18.57 69.11,15.44 81.75,15.44 81.75,32.47 68.62,32.47 M 36.41,45.96 36.41,64.94 101.4,64.94 101.4,61.27 M 68.68,29.52 68.68,65"};
		ala[17] = [{x:11,y:51},{x:44,y:51},{x:76,y:51},{x:76,y:35},{x:108,y:51},{x:108,y:35}];
		alb[28] = {i:17, d:"M 117.1,34.38 117.1,31.25 129.9,31.25 129.9,48.13 117.1,48.13 M 20.41,61.95 20.41,64.94 117.1,64.94 117.1,45.72 M 52.68,62.18 52.68,64.87 M 84.75,46 84.75,65"};
		ala[18] = [{x:11,y:51},{x:44,y:51},{x:76,y:51},{x:76,y:35},{x:76,y:19},{x:108,y:51}];
		alb[29] = {i:18, d:"M 84.75,18.38 84.75,15.25 97.55,15.25 97.55,32.13 84.75,32.13 M 20.41,61.95 20.41,64.94 117.1,64.94 117.1,61.82 M 52.68,62.18 52.68,64.87 M 84.75,29.9 84.75,65"};
		ala[19] = [{x:1,y:51},{x:31,y:51},{x:61,y:51},{x:90,y:51},{x:120,y:51},{x:120,y:35}];
		alb[30] = {i:19, d:"M 39.04,62 39.04,65 M 129.4,34.92 129.4,31.79 116.6,31.79 116.6,48.32 129.1,48.32 M 9.542,61.67 9.542,64.94 129.1,64.94 129.1,45.67 M 69.04,62 69.04,65 M 98.75,61.54 98.75,65"};
		ala[20] = [{x:1,y:51},{x:25,y:51},{x:49,y:51},{x:73,y:51},{x:97,y:51},{x:121,y:51}];
		alb[31] = {i:20, d:"M 33.06,62 33.06,65 M 129.4,50.92 129.4,47.79 116.9,47.79 116.9,63.67 129.1,63.67 M 80.82,61.54 80.82,65 M 57.08,62 57.08,65 M 9.542,61.67 9.542,64.94 129.1,64.94 129.1,61.82 M 105.5,62 105.5,65"};

		var al = alb[con[0].l||0];
		if (! al)
			return;
		g.svg.appendChild(svgNSGet("path",{fill:"none", stroke:"white", d:al.d}));
		ala[al.i].forEach( function (i,ix) {
			var s = svgNSGet("svg", {x:i.x, y:i.y});
			var r = svgNSGet("rect", {height:11, width:18, fill:"white"});
			var t = svgNSGet("text", {x:6.5, y:9, fill:"#088", textContent:(ix+1)});
			s.appendChild(r);
			s.appendChild(t);
			g.svg.appendChild(s);
		});
	}
