
modules = [
/// start of In/Out
{
	id: 1,
	height: 2,
	longnm: "Keyboard",
	shortnm: "Keyboard",
	page: {
		name: "In/Out",
		ord: 5
	},
	inputs: [],
	outputs: [
		{	 name: "Pitch",	 colour: "blue",	 x: 34,	 y: 19
		},
		{	 name: "Gate",	 colour: "yellow",	 x: 124,	 y: 19
		},
		{	 name: "Lin",	 colour: "blue",	 x: 162,	 y: 19
		},
		{	 name: "Release",	 colour: "blue",	 x: 246,	 y: 19
		},
		{	 name: "Note",	 colour: "blue",	 x: 80,	 y: 19
		},
		{	 name: "Exp",	 colour: "blue",	 x: 197,	 y: 19
		}
	],
	params: [],
	modes: [],
	ve: [
		{	 type: "line",	 "x1": 189,	 "y1": 7,	 "x2": 251,	 "y2": 7
		},
		{	 type: "line",	 "x1": 141,	 "y1": 7,	 "x2": 151,	 "y2": 7
		},
		{	 type: "text",	 x: 3,	 y: 23,	 t: "Pitch"
		},
		{	 type: "text",	 x: 95,	 y: 23,	 t: "Gate"
		},
		{	 type: "text",	 x: 140,	 y: 23,	 t: "Lin"
		},
		{	 type: "text",	 x: 205,	 y: 23,	 t: "Release"
		},
		{	 type: "text",	 x: 51,	 y: 23,	 t: "Note"
		},
		{	 type: "text",	 x: 172,	 y: 23,	 t: "Exp"
		},
		{	 type: "text",	 x: 151,	 y: 11,	 t: "Velocity"
		}
	]
},{
	id: 3,
	height: 2,
	longnm: "4 outputs",
	shortnm: "4-Out",
	page: {
		name: "In/Out",
		ord: 1
	},
	inputs: [
		{	 name: "In1",	 colour: "red",	 x: 168,	 y: 18
		},
		{	 name: "In2",	 colour: "red",	 x: 194,	 y: 18
		},
		{	 name: "In3",	 colour: "red",	 x: 220,	 y: 18
		},
		{	 name: "In4",	 colour: "red",	 x: 246,	 y: 18
		}
	],
	outputs: [],
	params: [
		{	 name: "Destination",	 type: "Dst_2",	 n: "SwM3251911c",	 x: 78.5,	 y: 8.5
		},
		{	 name: "Active",	 type: "ActiveMonitor",	 n: "SwM4d",	 x: 140.25,	 y: 14.5
		},
		{	 name: "Pad",	 type: "Pad_1",	 n: "SwM7121db69",	 x: 23.5,	 y: 14.5
		}
	],
	modes: [],
	ve: [
		{	 type: "text",	 x: 165,	 y: 10,	 t: "1"
		},
		{	 type: "text",	 x: 191,	 y: 10,	 t: "2"
		},
		{	 type: "text",	 x: 217,	 y: 10,	 t: "3"
		},
		{	 type: "text",	 x: 242,	 y: 10,	 t: "4"
		},
		{	 type: "text",	 x: 4,	 y: 23,	 t: "Pad"
		}
	]
},{
	id: 4,
	height: 2,
	longnm: "2 outputs",
	shortnm: "2-Out",
	page: {
		name: "In/Out",
		ord: 0
	},
	inputs: [
		{	 name: "InL",	 colour: "red",	 x: 220,	 y: 18
		},
		{	 name: "InR",	 colour: "red",	 x: 246,	 y: 18
		}
	],
	outputs: [],
	params: [
		{	 name: "Destination",	 type: "Dst_1",	 n: "SwM1b5f3ad8",	 x: 78.5,	 y: 12.5
		},
		{	 name: "Active",	 type: "ActiveMonitor",	 n: "SwM4d",	 x: 192.25,	 y: 14.5
		},
		{	 name: "Pad",	 type: "Pad_1",	 n: "SwM7121db69",	 x: 23.5,	 y: 14.5
		}
	],
	modes: [],
	ve: [
		{	 type: "text",	 x: 216,	 y: 10,	 t: "L"
		},
		{	 type: "text",	 x: 242,	 y: 10,	 t: "R"
		},
		{	 type: "text",	 x: 123,	 y: 9,	 t: "Fx"
		},
		{	 type: "text",	 x: 154,	 y: 9,	 t: "Bus"
		},
		{	 type: "text",	 x: 87,	 y: 9,	 t: "Out"
		},
		{	 type: "text",	 x: 4,	 y: 23,	 t: "Pad"
		}
	]
},{
	id: 30,
	height: 3,
	longnm: "Device",
	shortnm: "Device",
	page: {
		name: "In/Out",
		ord: 7
	},
	inputs: [],
	outputs: [
		{	 name: "Wheel",	 colour: "blue",	 x: 18,	 y: 35
		},
		{	 name: "AftTouch",	 colour: "blue",	 x: 58,	 y: 35
		},
		{	 name: "ControlPedal",	 colour: "blue",	 x: 98,	 y: 35
		},
		{	 name: "SustainPedal",	 colour: "yellow",	 x: 138,	 y: 35
		},
		{	 name: "PitchStick",	 colour: "blue",	 x: 178,	 y: 35
		},
		{	 name: "GlobalWheel1",	 colour: "blue",	 x: 216,	 y: 35
		},
		{	 name: "GlobalWheel2",	 colour: "blue",	 x: 246,	 y: 35
		}
	],
	params: [],
	modes: [],
	ve: [
		{	 type: "text",	 x: 166,	 y: 26,	 t: "Stick"
		},
		{	 type: "text",	 x: 125,	 y: 26,	 t: "Pedal"
		},
		{	 type: "text",	 x: 3,	 y: 26,	 t: "Wheel"
		},
		{	 type: "text",	 x: 36,	 y: 26,	 t: "AftTouch"
		},
		{	 type: "text",	 x: 86,	 y: 26,	 t: "Pedal"
		},
		{	 type: "text",	 x: 82,	 y: 16,	 t: "Control"
		},
		{	 type: "text",	 x: 121,	 y: 16,	 t: "Sustain"
		},
		{	 type: "text",	 x: 166,	 y: 16,	 t: "Pitch"
		},
		{	 type: "text",	 x: 217,	 y: 16,	 t: "Global"
		},
		{	 type: "text",	 x: 204,	 y: 39,	 t: "1"
		},
		{	 type: "text",	 x: 233,	 y: 39,	 t: "2"
		},
		{	 type: "text",	 x: 214,	 y: 26,	 t: "Wheels"
		}
	]
},{
	id: 127,
	height: 2,
	longnm: "Fx Input",
	shortnm: "Fx-In",
	page: {
		name: "In/Out",
		ord: 4
	},
	inputs: [],
	outputs: [
		{	 name: "OutL",	 colour: "red",	 x: 220,	 y: 20
		},
		{	 name: "OutR",	 colour: "red",	 x: 246,	 y: 20
		}
	],
	params: [
		{	 name: "Source",	 type: "Source_1",	 n: "SwM731a7980",	 x: 78.5,	 y: 12.5
		},
		{	 name: "Active",	 type: "ActiveMonitor",	 n: "SwM4d",	 x: 192.25,	 y: 14.5
		},
		{	 name: "Pad",	 type: "Pad_4",	 n: "SwMdc07958",	 x: 23.5,	 y: 14.5
		}
	],
	modes: [],
	ve: [
		{	 type: "text",	 x: 216,	 y: 10,	 t: "L"
		},
		{	 type: "text",	 x: 242,	 y: 10,	 t: "R"
		},
		{	 type: "text",	 x: 90,	 y: 9,	 t: "Fx"
		},
		{	 type: "text",	 x: 4,	 y: 23,	 t: "Pad"
		}
	]
},{
	id: 156,
	height: 2,
	longnm: "Note Detector",
	shortnm: "NoteDet",
	page: {
		name: "In/Out",
		ord: 9
	},
	inputs: [],
	outputs: [
		{	 name: "Gate",	 colour: "yellow",	 x: 178,	 y: 20
		},
		{	 name: "Vel",	 colour: "blue",	 x: 208,	 y: 20
		},
		{	 name: "RelVel",	 colour: "blue", x: 238, 	y: 20
		}
	],
	params: [
		{	 name: "Note",	 type: "FreqCoarse",	 n: "KnobMedium",	 x: 120.5,	 y: 5.5
		}
	],
	modes: [],
	ve: [
		{	 type: "valueDisplay",	 x: 85,	 y: 12,	 w: 32,	 ref: 0
		},
		{	 type: "led",	 x: 186,	 y: 15,	 w: 6.5
		},
		{	 type: "text",	 x: 89,	 y: 9,	 t: "Note"
		},
		{	 type: "text",	 x: 200,	 y: 10,	 t: "Vel"
		},
		{	 type: "text",	 x: 166,	 y: 10,	 t: "Gate"
		},
		{	 type: "text",	 x: 224,	 y: 10,	 t: "RelVel"
		}
	]
},{
	id: 170,
	height: 2,
	longnm: "2 inputs",
	shortnm: "2-In",
	page: {
		name: "In/Out",
		ord: 2
	},
	inputs: [],
	outputs: [
		{	 name: "OutL",	 colour: "red",	 x: 220,	 y: 20
		},
		{	 name: "OutR",	 colour: "red",	 x: 246,	 y: 20
		}
	],
	params: [
		{	 name: "Source",	 type: "Source_2",	 n: "SwM7e68d6ac",	 x: 78.5,	 y: 12.5
		},
		{	 name: "Active",	 type: "ActiveMonitor",	 n: "SwM4d",	 x: 192.25,	 y: 14.5
		},
		{	 name: "Pad",	 type: "Pad_4",	 n: "SwMdc07958",	 x: 23.5,	 y: 14.5
		}
	],
	modes: [],
	ve: [
		{	 type: "text",	 x: 91,	 y: 9,	 t: "In"
		},
		{	 type: "text",	 x: 120,	 y: 9,	 t: "Bus"
		},
		{	 type: "text",	 x: 216,	 y: 10,	 t: "L"
		},
		{	 type: "text",	 x: 242,	 y: 10,	 t: "R"
		},
		{	 type: "text",	 x: 4,	 y: 23,	 t: "Pad"
		}
	]
},{
	id: 171,
	height: 2,
	longnm: "4 inputs",
	shortnm: "4-In",
	page: {
		name: "In/Out",
		ord: 3
	},
	inputs: [],
	outputs: [
		{	 name: "Out1",	 colour: "red",	 x: 168,	 y: 20
		},
		{	 name: "Out2",	 colour: "red",	 x: 194,	 y: 20
		},
		{	 name: "Out3",	 colour: "red",	 x: 220,	 y: 20
		},
		{	 name: "Out4",	 colour: "red",	 x: 246,	 y: 20
		}
	],
	params: [
		{	 name: "Source",	 type: "Source_3",	 n: "SwM7d4b1a87",	 x: 78.5,	 y: 8.5
		},
		{	 name: "Active",	 type: "ActiveMonitor",	 n: "SwM4d",	 x: 140.25,	 y: 14.5
		},
		{	 name: "Pad",	 type: "Pad_4",	 n: "SwMdc07958",	 x: 23.5,	 y: 14.5
		}
	],
	modes: [],
	ve: [
		{	 type: "text",	 x: 242,	 y: 10,	 t: "4"
		},
		{	 type: "text",	 x: 216,	 y: 10,	 t: "3"
		},
		{	 type: "text",	 x: 191,	 y: 10,	 t: "2"
		},
		{	 type: "text",	 x: 165,	 y: 10,	 t: "1"
		},
		{	 type: "text",	 x: 4,	 y: 23,	 t: "Pad"
		}
	]
},{
	id: 197,
	height: 2,
	longnm: "Status",
	shortnm: "Status",
	page: {
		name: "In/Out",
		ord: 8
	},
	inputs: [],
	outputs: [
		{	 name: "PatchActive",	 colour: "yellow",	 x: 113,	 y: 18
		},
		{	 name: "VarActive",	 colour: "yellow",	 x: 172,	 y: 18
		},
		{	 name: "VoiceNo",	 colour: "blue",	 x: 231,	 y: 18
		}
	],
	params: [],
	modes: [],
	ve: [
		{	 type: "text",	 x: 147,	 y: 10,	 t: "Var. Active"
		},
		{	 type: "text",	 x: 82,	 y: 10,	 t: "Patch Active"
		},
		{	 type: "text",	 x: 211,	 y: 10,	 t: "Voice No."
		}
	]
},{
	id: 199,
	height: 2,
	longnm: "Monophonic Keyboard",
	shortnm: "MonoKey",
	page: {
		name: "In/Out",
		ord: 6
	},
	inputs: [],
	outputs: [
		{	 name: "Pitch",	 colour: "blue",	 x: 186,	 y: 18
		},
		{	 name: "Gate",	 colour: "yellow",	 x: 216,	 y: 18
		},
		{	 name: "Vel",	 colour: "blue",	 x: 246,	 y: 18
		}
	],
	params: [
		{	 name: "Mode",	 type: "MonoKeyMode",	 n: "SwM5a5300ac",	 x: 88.5,	 y: 8.5
		}
	],
	modes: [],
	ve: [
		{	 type: "text",	 x: 205,	 y: 10,	 t: "Gate"
		},
		{	 type: "text",	 x: 174,	 y: 10,	 t: "Pitch"
		},
		{	 type: "text",	 x: 238,	 y: 10,	 t: "Vel"
		}
	]
},{
	id: 0x7e,
	height: 1,
	longnm: "Name bar",
	shortnm: "Name",
	page: {
		name: "In/Out",
		ord: 11
	},
	inputs: [],
	outputs: [],
	params: [],
	modes: [],
	ve: []
},///end In/Out
/// start of Note
{
	id: 22,
	height: 2,
	longnm: "Partial Quantizer",
	shortnm: "PartQuant",
	page: {
		name: "Note",
		ord: 2
	},
	inputs: [
		{	 name: "In",	 colour: "blue",	 x: 216,	 y: 16
		}
	],
	outputs: [
		{	 name: "Out",	 colour: "blue",	 x: 246,	 y: 16
		}
	],
	params: [
		{	 name: "Range",	 type: "PartialRange",	 n: "KnobMedium",	 x: 148.5,	 y: 5.5
		}
	],
	modes: [],
	ve: [
		{	 type: "valueDisplay",	 x: 105,	 y: 12,	 w: 40,	 ref: 0
		},
		{	 type: "bmp",	 x: 220.5,	 y: 9.5,	 id: "box"
		},
		{	 type: "text",	 x: 111,	 y: 9,	 t: "Range"
		}
	]
},{
	id: 72,
	height: 2,
	longnm: "Note Scaler",
	shortnm: "NoteScaler",
	page: {
		name: "Note",
		ord: 3
	},
	inputs: [
		{	 name: "In",	 colour: "blue",	 x: 216,	 y: 16
		}
	],
	outputs: [
		{	 name: "Out",	 colour: "blue",	 x: 246,	 y: 16
		}
	],
	params: [
		{	 name: "Range",	 type: "NoteRange",	 n: "KnobMedium",	 x: 148.5,	 y: 5.5
		}
	],
	modes: [],
	ve: [
		{	 type: "valueDisplay",	 x: 90,	 y: 12,	 w: 55,	 ref: 0
		},
		{	 type: "bmp",	 x: 220.5,	 y: 9.5,	 id: "box"
		},
		{	 type: "text",	 x: 103,	 y: 9,	 t: "Range"
		}
	]
},{
	id: 115,
	height: 3,
	longnm: "Level Scaler",
	shortnm: "LevScaler",
	page: {
		name: "Note",
		ord: 7
	},
	inputs: [
		{	 name: "Note",	 colour: "blue",	 x: 10,	 y: 35
		},
		{	 name: "In",	 colour: "purple",	 x: 246,	 y: 9
		}
	],
	outputs: [
		{	 name: "Level",	 colour: "blue",	 x: 216,	 y: 35
		},
		{	 name: "Out",	 colour: "purple",	 x: 246,	 y: 35
		}
	],
	params: [
		{	 name: "L",	 type: "LevScaledB",	 n: "KnobMedium",	 x: 90.5,	 y: 20.5
		},
		{	 name: "BP", type: "FreqCoarse",	 n: "KnobSpin",		 x: 130.5,	 y: 20.5
		},
		{	 name: "R",	 type: "LevScaledB",	 n: "KnobMedium",	 x: 154.5,	 y: 20.5
		},
		{	 name: "Kbt",type: "Kbt_1",			 n: "SwM7364bc84",	 x: 30.5,	 y: 29.5
		}
	],
	modes: [],
	ve: [
		{	 type: "graph",	 x: 180,	 y: 4,	 w: 56,	 h: 24
		},
		{	 type: "valueDisplay",	 x: 116,	 y: 4,	 w: 25,	 ref: 1
		},
		{	 type: "valueDisplay",	 x: 79,	 y: 4,	 w: 35,	 ref: 0
		},
		{	 type: "valueDisplay",	 x: 143,	 y: 4,	 w: 35,	 ref: 2
		},
		{	 type: "text",	 x: 3,	 y: 27,	 t: "Note"
		},
		{	 type: "text",	 x: 116,	 y: 27,	 t: "BP"
		},
		{	 type: "text",	 x: 82,	 y: 27,	 t: "L"
		},
		{	 type: "text",	 x: 146,	 y: 27,	 t: "R"
		},
		{	 type: "bmp",	 x: 240,	 y: 11.5,	 id: "VVCA"
		},
		{	 type: "text",	 x: 32,	 y: 27,	 t: "KBT"
		},
		{	 type: "text",	 x: 184,	 y: 39,	 t: "Level"
		}
	]
},{
	id: 75,
	height: 2,
	longnm: "Note Quantizer",
	shortnm: "NoteQuant",
	page: {
		name: "Note",
		ord: 0
	},
	inputs: [
		{
			name: "In",
			colour: "blue",
			x: 216,
			y: 16
		}
	],
	outputs: [
		{
			name: "Out",
			colour: "blue",
			x: 246,
			y: 16
		}
	],
	params: [
		{
			name: "Range",
			type: "NoteRange",
			n: "KnobMedium",
			x: 114.5,
			y: 5.5
		},
		{
			name: "Notes",
			type: "NoteQuantNotes",
			n: "KnobSpin",
			x: 171.5,
			y: 5.5
		}
	],
	modes: [],
	ve: [
		{
			type: "valueDisplay",x: 79,	y: 12,	w: 32,	ref: 0
		},
		{	 type: "bmp",	 x: 220.5,	 y: 9.5,	 id: "box"
		},
		{
			type: "text",
			x: 81,
			y: 9,
			t: "Range"
		},
		{
			type: "valueDisplay",	x: 145,	y: 12,	w: 23,	ref: 1
		},
		{
			type: "text",	x: 143,	y: 9,	t: "Notes"
		}
	]
},{
	id: 152,
	height: 2,
	longnm: "Key Quantizer",
	shortnm: "KeyQuant",
	page: {
		name: "Note",
		ord: 1
	},
	inputs: [
		{	 name: "In",	 colour: "blue",	 x: 216,	 y: 16
		}
	],
	outputs: [
		{	 name: "Out",	 colour: "blue",	 x: 246,	 y: 16
		}
	],
	params: [
		{	 name: "Range",	 type: "NoteRange",	 n: "KnobMedium",	 x: 114.5,	 y: 5.5
		},
		{	 name: "Capture",	 type: "KeyQuantCapture",	 n: "SwM692bace6",	 x: 40.5,	 y: 14.5
		},
		{	 name: "", w:10,	 type: "OffOn",	 n: "SwM45",	 x: 157.5,	 y: 14.5
		},
		{	 name: "", w:10,	 type: "OffOn",	 n: "SwM46",	 x: 167.5,	 y: 14.5
		},
		{	 name: "", w:10, type: "OffOn",	 n: "SwM89d",	 x: 172.5,	 y: 2.5, bmp:"sharp"
		},
		{	 name: "", w:10,	 type: "OffOn",	 n: "SwM47",	 x: 177.5,	 y: 14.5
		},
		{	 name: "", w:10, type: "OffOn",	 n: "SwM8bc",	 x: 182.5,	 y: 2.5, bmp:"sharp"
		},
		{	 name: "", w:10,	 type: "OffOn",	 n: "SwM41",	 x: 187.5,	 y: 14.5
		},
		{	 name: "", w:10, type: "OffOn",	 n: "SwM860",	 x: 192.5,	 y: 2.5, bmp:"sharp"
		},
		{	 name: "", w:10,	 type: "OffOn",	 n: "SwM42",	 x: 197.5,	 y: 14.5
		},
		{	 name: "", w:10,	 type: "OffOn",	 n: "SwM43",	 x: 137.5,	 y: 14.5
		},
		{	 name: "", w:10, type: "OffOn",	 n: "SwM840",	 x: 142.5,	 y: 2.5, bmp:"sharp"
		},
		{	 name: "", w:10,	 type: "OffOn",	 n: "SwM44",	 x: 147.5,	 y: 14.5
		},
		{	 name: "", w:10, type: "OffOn",	 n: "SwM85f",	 x: 152.5,	 y: 2.5, bmp:"sharp"
		}
	],
	modes: [],
	ve: [
		{	 type: "valueDisplay",	 x: 79,	 y: 12,	 w: 32,	 ref: 0
		},
		{	 type: "bmp",	 x: 220.5,	 y: 9.5,	 id: "box"
		},
		{	 type: "text",	 x: 81,	 y: 9,	 t: "Range"
		},
		{	 type: "text",	 x: 3,	 y: 23,	 t: "Capture"
		}
	]
},{
	id: 158,
	height: 2,
	longnm: "Glide",
	shortnm: "Glide",
	page: {
		name: "Note",
		ord: 4
	},
	inputs: [
		{	 name: "In",	 colour: "purple",	 x: 216,	 y: 16
		},
		{	 name: "On",	 colour: "orange",	 x: 10,	 y: 20
		}
	],
	outputs: [
		{	 name: "Out",	 colour: "purple",	 x: 246,	 y: 16
		}
	],
	params: [
		{	 name: "Time",	 type: "GlideTime",	 n: "KnobMedium",	 x: 155.5,	 y: 5.5
		},
		{	 name: "On",	 type: "OffOn",	 n: "SwM7364bc84",	 x: 80.5,	 y: 14.5
		},
		{	 name: "Shape",	 type: "LogLin",	 n: "SwM778423e9",	 x: 181.5,	 y: 14.5
		}
	],
	modes: [],
	ve: [
		{	 type: "valueDisplay",	 x: 104,	 y: 12,	 w: 48,	 ref: 0
		},
		{	 type: "bmp",	 x: 220.5,	 y: 9.5,	 id: "box"
		},
		{	 type: "text",	 x: 115,	 y: 9,	 t: "Time"
		},
		{	 type: "text",	 x: 180,	 y: 11,	 t: "Shape"
		},
		{	 type: "text",	 x: 79,	 y: 11,	 t: "Glide"
		},
		{	 type: "text",	 x: 16,	 y: 24,	 t: "Glide on"
		}
	]
},{
	id: 160,
	height: 2,
	longnm: "Zero Crossing Counter",
	shortnm: "ZeroCnt",
	page: {
		name: "Note",
		ord: 6
	},
	inputs: [
		{	 name: "In",	 colour: "purple",	 x: 216,	 y: 18
		}
	],
	outputs: [
		{	 name: "Out",	 colour: "blue",	 x: 246,	 y: 18
		}
	],
	params: [],
	modes: [],
	ve: [
		{	 type: "text",	 x: 211,	 y: 10,	 t: "In"
		},
		{	 type: "bmp",	 x: 220.5,	 y: 11.5,	 id: "box"
		},
		{	 type: "text",	 x: 229,	 y: 10,	 t: "Pitch"
		}
	]
},{
	id: 198,
	height: 2,
	longnm: "Pitch Tracker",
	shortnm: "PitchTrack",
	page: {
		name: "Note",
		ord: 5
	},
	inputs: [
		{	 name: "In",	 colour: "purple",	 x: 10,	 y: 20
		}
	],
	outputs: [
		{	 name: "Period",	 colour: "orange",	 x: 179,	 y: 18
		},
		{	 name: "Gate",	 colour: "orange",	 x: 205,	 y: 18
		},
		{	 name: "Pitch",	 colour: "blue",	 x: 246,	 y: 18
		}
	],
	params: [
		{	 name: "Threshold",	 type: "Threshold_127",	 n: "KnobMedium",	 x: 133.5,	 y: 5.5
		}
	],
	modes: [],
	ve: [
		{	 type: "text",	 x: 16,	 y: 23,	 t: "Input"
		},
		{	 type: "text",	 x: 229,	 y: 10,	 t: "Pitch"
		},
		{	 type: "text",	 x: 164,	 y: 10,	 t: "Period"
		},
		{	 type: "text",	 x: 199,	 y: 10,	 t: "Gate"
		},
		{	 type: "led",	 x: 212,	 y: 15,	 w: 6.5
		},
		{	 type: "text",	 x: 87,	 y: 9,	 t: "Threshold"
		},
		{	 type: "valueDisplay",	 x: 88,	 y: 12,	 w: 42,	 ref: 0
		}
	]
}, ///end of Note
/// start of Logic
{
	id: 5,
	height: 2,
	longnm: "Logic Inverter",
	shortnm: "Invert",
	page: {
		name: "Logic",
		ord: 1
	},
	inputs: [
		{	 name: "In1",	 colour: "orange",	 x: 106,	 y: 14
		},
		{	 name: "In2",	 colour: "orange",	 x: 199,	 y: 14
		}
	],
	outputs: [
		{	 name: "Out1",	 colour: "orange",	 x: 153,	 y: 14
		},
		{	 name: "Out2",	 colour: "orange",	 x: 246,	 y: 14
		}
	],
	params: [],
	modes: [],
	ve: [
		{	 type: "path",	 d: "M152,14 L134,14 M106,14 L120,14 M227,14 L245,14 M199,14 L213,14"
		},
		{	 type: "led",	 x: 137,	 y: 11,	 w: 6.5
		},
		{	 type: "bmp",	 x: 117,	 y: 7,	 id: "INV"
		},
		{	 type: "led",	 x: 230,	 y: 11,	 w: 6.5
		},
		{	 type: "bmp",	 x: 210,	 y: 7,	 id: "INV"
		}
	]
},{
	id: 38,
	height: 2,
	longnm: "Pulse",
	shortnm: "Pulse",
	page: {
		name: "Logic",
		ord: 4
	},
	inputs: [
		{	 name: "In",	 colour: "orange",	 x: 198,	 y: 9
		},
		{	 name: "Time",	 colour: "blue",	 x: 70,	 y: 19
		}
	],
	outputs: [
		{	 name: "Out",	 colour: "orange",	 x: 246,	 y: 20
		}
	],
	params: [
		{	 name: "Time",	 type: "LogicTime",	 n: "KnobMedium",	 x: 167.5,	 y: 5.5
		},
		{	 name: "TimeMod",	 type: "Level_100",	 n: "KnobSmall",	 x: 78.5,	 y: 7.5
		},
		{	 name: "Range",	 type: "LogicRange",	 n: "SwM1bb3873e",	 x: 101.5,	 y: 9.5
		}
	],
	modes: [
		{	 name: "Mode",	 type: "PulseMode", x:208, y:4.5, h:21, w:20
		}
	],
	ve: [
		{	 type: "path",	 d: "M69,19 L91,19 M199,9 L219,9 M227,20 L247,20"
		},
		{	 type: "valueDisplay",	 x: 126,	 y: 8,	 w: 38,	 ref: 0
		},
		{	 type: "led",	 x: 242,	 y: 4,	 w: 6.5
		}
	]
},{
	id: 42,
	height: 2,
	longnm: "Logic Delay",
	shortnm: "Delay",
	page: {
		name: "Logic",
		ord: 5
	},
	inputs: [
		{	 name: "In",	 colour: "orange",	 x: 198,	 y: 9
		},
		{	 name: "TimeMod",	 colour: "purple",	 x: 70,	 y: 19
		}
	],
	outputs: [
		{	 name: "Out",	 colour: "orange",	 x: 246,	 y: 20
		}
	],
	params: [
		{	 name: "Time",	 type: "LogicTime",	 n: "KnobMedium",	 x: 167.5,	 y: 5.5
		},
		{	 name: "TimeMod",	 type: "Level_100",	 n: "KnobSmall",	 x: 78.5,	 y: 7.5
		},
		{	 name: "Range",	 type: "LogicRange",	 n: "SwM1bb3873e",	 x: 101.5,	 y: 9.5
		}
	],
	modes: [
		{	 name: "Mode",	 type: "LogicDelayMode", x:208, y:4.5, h:21, w:20
		}
	],
	ve: [
		{	 type: "path",	 d: "M69,19 L91,19 M199,9 L219,9 M227,20 L247,20"
		},
		{	 type: "valueDisplay",	 x: 126,	 y: 8,	 w: 38,	 ref: 0
		},
		{	 type: "led",	 x: 242,	 y: 4,	 w: 6.5
		}
	]
},{
	id: 64,
	height: 2,
	longnm: "Gate",
	shortnm: "Gate",
	page: {
		name: "Logic",
		ord: 0
	},
	inputs: [
		{	 name: "In1_1",	 colour: "orange",	 x: 86,	 y: 9
		},
		{	 name: "In1_2",	 colour: "orange",	 x: 76,	 y: 20
		},
		{	 name: "In2_1",	 colour: "orange",	 x: 179,	 y: 9
		},
		{	 name: "In2_2",	 colour: "orange",	 x: 169,	 y: 20
		}
	],
	outputs: [
		{	 name: "Out1",	 colour: "orange",	 x: 153,	 y: 14
		},
		{	 name: "Out2",	 colour: "orange",	 x: 246,	 y: 14
		}
	],
	params: [],
	modes: [
		{	 name: "GateMode1",	 type: "GateMode", x:97.5, y:5, h:21, w:31
		},
		{	 name: "GateMode2",	 type: "GateMode", x:189.5, y:5, h:21, w:31
		}
	],
	ve: [
		{	 type: "path",	 d: "M165,20 L195,20 M183,9 L194,9 M71,20 L101,20 M90,9 L102,9 M133,14 L151,14 M226,14 L244,14"
		},
		{	 type: "led",	 x: 230,	 y: 11,	 w: 6.5
		},
		{	 type: "led",	 x: 137,	 y: 11,	 w: 6.5
		}
	]
},{
	id: 69,
	height: 2,
	longnm: "Clock Divider",
	shortnm: "ClkDiv",
	page: {
		name: "Logic",
		ord: 3
	},
	inputs: [
		{	 name: "Clk",	 colour: "orange",	 x: 84,	 y: 16
		},
		{	 name: "Rst",	 colour: "orange",	 x: 122,	 y: 16
		}
	],
	outputs: [
		{	 name: "Out",	 colour: "orange",	 x: 246,	 y: 16
		}
	],
	params: [
		{	 name: "Divider",	 type: "Range_128",	 n: "KnobSpin",	 x: 186.5,	 y: 5.5
		}
	],
	modes: [
		{	 name: "DivMode",	 type: "ClkDivMode"
		}
	],
	ve: [
		{	 type: "text",	 x: 96,	 y: 20,	 t: "Clk"
		},
		{	 type: "text",	 x: 134,	 y: 20,	 t: "Rst"
		},
		{	 type: "valueDisplay",	 x: 162,	 y: 12,	 w: 21,	 ref: 0
		},
		{	 type: "text",	 x: 154,	 y: 10,	 t: "Divider"
		}
	]
},{
	id: 86,
	height: 2,
	longnm: "8 Counter",
	shortnm: "8Counter",
	page: {
		name: "Logic",
		ord: 6
	},
	inputs: [
		{	 name: "Clk",	 colour: "orange",	 x: 10,	 y: 20
		},
		{	 name: "Rst",	 colour: "orange",	 x: 50,	 y: 20
		}
	],
	outputs: [
		{	 name: "Out1",	 colour: "orange",	 x: 85,	 y: 18
		},
		{	 name: "Out2",	 colour: "orange",	 x: 108,	 y: 18
		},
		{	 name: "Out3",	 colour: "orange",	 x: 131,	 y: 18
		},
		{	 name: "Out4",	 colour: "orange",	 x: 154,	 y: 18
		},
		{	 name: "Out5",	 colour: "orange",	 x: 177,	 y: 18
		},
		{	 name: "Out6",	 colour: "orange",	 x: 200,	 y: 18
		},
		{	 name: "Out7",	 colour: "orange",	 x: 223,	 y: 18
		},
		{	 name: "Out8",	 colour: "orange",	 x: 246,	 y: 18
		}
	],
	params: [],
	modes: [],
	ve: [
		{	 type: "text",	 x: 76,	 y: 10,	 t: "1"
		},
		{	 type: "text",	 x: 98,	 y: 10,	 t: "2"
		},
		{	 type: "text",	 x: 121,	 y: 10,	 t: "3"
		},
		{	 type: "text",	 x: 144,	 y: 10,	 t: "4"
		},
		{	 type: "text",	 x: 167,	 y: 10,	 t: "5"
		},
		{	 type: "text",	 x: 190,	 y: 10,	 t: "6"
		},
		{	 type: "text",	 x: 213,	 y: 10,	 t: "7"
		},
		{	 type: "text",	 x: 236,	 y: 10,	 t: "8"
		},
		{	 type: "ledArray",	 x: 81,	 y: 3,	 w: 6.5,	 xo: 23,	 cnt: 8
		},
		{	 type: "text",	 x: 21,	 y: 24,	 t: "↑ Clk"
		},
		{	 type: "text",	 x: 57,	 y: 24,	 t: "Rst"
		}
	]
},{
	id: 91,
	height: 2,
	longnm: "Flip Flop",
	shortnm: "FlipFlop",
	page: {
		name: "Logic",
		ord: 2
	},
	inputs: [
		{	 name: "Clk",	 colour: "orange",	 x: 122,	 y: 20
		},
		{	 name: "In",	 colour: "orange",	 x: 149,	 y: 10
		},
		{	 name: "Rst",	 colour: "orange",	 x: 86,	 y: 20
		}
	],
	outputs: [
		{	 name: "NotQ",	 colour: "orange",	 x: 220,	 y: 20
		},
		{	 name: "Q",	 colour: "orange",	 x: 246,	 y: 10
		}
	],
	params: [],
	modes: [
		{	 name: "OperationMode",	 type: "FlipFlopMode", x:158, y:4.5, w:36, h:20	
		}
	],
	ve: [
		{	 type: "path",	 d: "M123,20 L165,20 M153,10 L164,10 M200,20 L218,20 M189,10 L247,10"
		},
		{	 type: "led",	 x: 204,	 y: 17,	 w: 6.5
		},
		{	 type: "led",	 x: 230,	 y: 7,	 w: 6.5
		},
		{	 type: "text",	 x: 62,	 y: 24,	 t: "Rst"
		},
		{	 type: "text",	 x: 96,	 y: 24,	 t: "Clk ↑"
		}
	]
},{
	id: 130,
	height: 2,
	longnm: "Binary Counter",
	shortnm: "BinCounter",
	page: {
		name: "Logic",
		ord: 7
	},
	inputs: [
		{	 name: "Clk",	 colour: "orange",	 x: 10,	 y: 20
		},
		{	 name: "Rst",	 colour: "orange",	 x: 50,	 y: 20
		}
	],
	outputs: [
		{	 name: "Out001",	 colour: "orange",	 x: 85,	 y: 18
		},
		{	 name: "Out002",	 colour: "orange",	 x: 108,	 y: 18
		},
		{	 name: "Out004",	 colour: "orange",	 x: 131,	 y: 18
		},
		{	 name: "Out008",	 colour: "orange",	 x: 154,	 y: 18
		},
		{	 name: "Out016",	 colour: "orange",	 x: 177,	 y: 18
		},
		{	 name: "Out032",	 colour: "orange",	 x: 200,	 y: 18
		},
		{	 name: "Out064",	 colour: "orange",	 x: 223,	 y: 18
		},
		{	 name: "Out128",	 colour: "orange",	 x: 246,	 y: 18
		}
	],
	params: [],
	modes: [],
	ve: [
		{	 type: "text",	 x: 76,	 y: 10,	 t: "1"
		},
		{	 type: "text",	 x: 97,	 y: 10,	 t: "2"
		},
		{	 type: "text",	 x: 121,	 y: 10,	 t: "4"
		},
		{	 type: "text",	 x: 144,	 y: 10,	 t: "8"
		},
		{	 type: "text",	 x: 164,	 y: 10,	 t: "16"
		},
		{	 type: "text",	 x: 185,	 y: 10,	 t: "32"
		},
		{	 type: "text",	 x: 207,	 y: 10,	 t: "64"
		},
		{	 type: "text",	 x: 228,	 y: 10,	 t: "128"
		},
		{	 type: "ledArray",	 x: 81,	 y: 3,	 w: 6.5,	 xo: 23,	 cnt: 8
		},
		{	 type: "text",	 x: 21,	 y: 24,	 t: "↑ Clk"
		},
		{	 type: "text",	 x: 57,	 y: 24,	 t: "Rst"
		}
	]
},{
	id: 131,
	height: 2,
	longnm: "A/D Converter",
	shortnm: "ADConv",
	page: {
		name: "Logic",
		ord: 8
	},
	inputs: [
		{	 name: "In",	 colour: "purple",	 x: 10,	 y: 20
		}
	],
	outputs: [
		{	 name: "D0",	 colour: "orange",	 x: 85,	 y: 18
		},
		{	 name: "D1",	 colour: "orange",	 x: 108,	 y: 18
		},
		{	 name: "D2",	 colour: "orange",	 x: 131,	 y: 18
		},
		{	 name: "D3",	 colour: "orange",	 x: 154,	 y: 18
		},
		{	 name: "D4",	 colour: "orange",	 x: 177,	 y: 18
		},
		{	 name: "D5",	 colour: "orange",	 x: 200,	 y: 18
		},
		{	 name: "D6",	 colour: "orange",	 x: 223,	 y: 18
		},
		{	 name: "D7",	 colour: "orange",	 x: 246,	 y: 18
		}
	],
	params: [],
	modes: [],
	ve: [
		{	 type: "text",	 x: 67,	 y: 22,	 t: "D0"
		},
		{	 type: "text",	 x: 92,	 y: 22,	 t: "D1"
		},
		{	 type: "text",	 x: 113,	 y: 22,	 t: "D2"
		},
		{	 type: "text",	 x: 136,	 y: 22,	 t: "D3"
		},
		{	 type: "text",	 x: 159,	 y: 22,	 t: "D4"
		},
		{	 type: "text",	 x: 182,	 y: 22,	 t: "D5"
		},
		{	 type: "text",	 x: 205,	 y: 22,	 t: "D6"
		},
		{	 type: "text",	 x: 228,	 y: 22,	 t: "D7"
		},
		{	 type: "ledArray",	 x: 81,	 y: 3,	 w: 6.5,	 xo: 23,	 cnt: 8
		},
		{	 type: "text",	 x: 17,	 y: 24,	 t: "Input"
		}
	]
},{
	id: 132,
	height: 2,
	longnm: "D/A Converter",
	shortnm: "DAConv",
	page: {
		name: "Logic",
		ord: 9
	},
	inputs: [
		{	 name: "D0",	 colour: "orange",	 x: 86,	 y: 18
		},
		{	 name: "D1",	 colour: "orange",	 x: 106,	 y: 18
		},
		{	 name: "D2",	 colour: "orange",	 x: 126,	 y: 18
		},
		{	 name: "D3",	 colour: "orange",	 x: 146,	 y: 18
		},
		{	 name: "D4",	 colour: "orange",	 x: 166,	 y: 18
		},
		{	 name: "D5",	 colour: "orange",	 x: 186,	 y: 18
		},
		{	 name: "D6",	 colour: "orange",	 x: 206,	 y: 18
		},
		{	 name: "D7",	 colour: "orange",	 x: 226,	 y: 18
		}
	],
	outputs: [
		{	 name: "Out",	 colour: "purple",	 x: 246,	 y: 18
		}
	],
	params: [],
	modes: [],
	ve: [
		{	 type: "text",	 x: 79,	 y: 10,	 t: "D0"
		},
		{	 type: "text",	 x: 99,	 y: 10,	 t: "D1"
		},
		{	 type: "text",	 x: 119,	 y: 10,	 t: "D2"
		},
		{	 type: "text",	 x: 139,	 y: 10,	 t: "D3"
		},
		{	 type: "text",	 x: 159,	 y: 10,	 t: "D4"
		},
		{	 type: "text",	 x: 179,	 y: 10,	 t: "D5"
		},
		{	 type: "text",	 x: 199,	 y: 10,	 t: "D6"
		},
		{	 type: "text",	 x: 219,	 y: 10,	 t: "D7"
		}
	]
}, ///end of Logic
/// start of Shaper
{
	id: 28,
	height: 2,
	longnm: "Saturate",
	shortnm: "Saturate",
	page: {
		name: "Shaper",
		ord: 2
	},
	inputs: [
		{	 name: "In",	 colour: "purple",	 x: 216,	 y: 16
		},
		{	 name: "Mod",	 colour: "purple",	 x: 114,	 y: 19
		}
	],
	outputs: [
		{	 name: "Out",	 colour: "purple",	 x: 246,	 y: 16
		}
	],
	params: [
		{	 name: "Amount",	 type: "Level_100",	 n: "KnobMedium",	 x: 149.5,	 y: 5.5
		},
		{	 name: "AmountMod",	 type: "Level_100",	 n: "KnobSmall",	 x: 122.5,	 y: 7.5
		},
		{	 name: "Active",	 type: "ActiveMonitor",	 n: "SwM42",	 x: 226.25,	 y: 10.5
		},
		{	 name: "Curve",	 type: "SaturateCurve",	 n: "SwM6dfbef46",	 x: 43.5,	 y: 13.5
		}
	],
	modes: [],
	ve: [
		{	 type: "path",	 d: "M111,19 L133,19 M215,16 L249,16"
		},
		{	 type: "graph",	 x: 173,	 y: 4,	 w: 34,	 h: 22
		},
		{	 type: "text",	 x: 14,	 y: 23,	 t: "Curve"
		}
	]
},{
	id: 34,
	height: 2,
	longnm: "Shape Exp",
	shortnm: "ShpExp",
	page: {
		name: "Shaper",
		ord: 3
	},
	inputs: [
		{	 name: "In",	 colour: "purple",	 x: 216,	 y: 16
		},
		{	 name: "Mod",	 colour: "purple",	 x: 114,	 y: 19
		}
	],
	outputs: [
		{	 name: "Out",	 colour: "purple",	 x: 246,	 y: 16
		}
	],
	params: [
		{	 name: "Amount",	 type: "Level_100",	 n: "KnobMedium",	 x: 149.5,	 y: 5.5
		},
		{	 name: "AmountMod",	 type: "Level_100",	 n: "KnobSmall",	 x: 122.5,	 y: 7.5
		},
		{	 name: "Active",	 type: "ActiveMonitor",	 n: "SwM42",	 x: 226.25,	 y: 10.5
		},
		{	 name: "Curve",	 type: "ShpExpCurve",	 n: "SwM757d9bd2",	 x: 43.5,	 y: 13.5
		}
	],
	modes: [],
	ve: [
		{	 type: "path",	 d: "M111,19 L133,19 M215,16 L249,16"
		},
		{	 type: "graph",	 x: 173,	 y: 4,	 w: 34,	 h: 22
		},
		{	 type: "text",	 x: 14,	 y: 23,	 t: "Curve"
		}
	]
},{
	id: 61,
	height: 2,
	longnm: "Clip",
	shortnm: "Clip",
	page: {
		name: "Shaper",
		ord: 0
	},
	inputs: [
		{	 name: "In",	 colour: "purple",	 x: 216,	 y: 16
		},
		{	 name: "Mod",	 colour: "purple",	 x: 84,	 y: 19
		}
	],
	outputs: [
		{	 name: "Out",	 colour: "purple",	 x: 246,	 y: 16
		}
	],
	params: [
		{	 name: "ClipLevMod",	 type: "Level_100",	 n: "KnobSmall",	 x: 92.5,	 y: 7.5
		},
		{	 name: "ClipLev",	 type: "Level_100",	 n: "KnobMedium",	 x: 150.5,	 y: 5.5
		},
		{	 name: "Shape",	 type: "ClipShape",	 n: "SwM7d7511f",	 x: 32.5,	 y: 14.5
		},
		{	 name: "Active",	 type: "ActiveMonitor",	 n: "SwM42",	 x: 226.25,	 y: 10.5
		}
	],
	modes: [],
	ve: [
		{	 type: "path",	 d: "M83,19 L105,19 M215,16 L249,16"
		},
		{	 type: "graph",	 x: 174,	 y: 4,	 w: 34,	 h: 22
		},
		{	 type: "valueDisplay",	 x: 121,	 y: 12,	 w: 26,	 ref: 1
		},
		{	 type: "text",	 x: 112,	 y: 9,	 t: "Clip Lev"
		},
		{	 type: "text",	 x: 3,	 y: 23,	 t: "Shape"
		}
	]
},{
	id: 62,
	height: 2,
	longnm: "Overdrive",
	shortnm: "Overdrive",
	page: {
		name: "Shaper",
		ord: 1
	},
	inputs: [
		{	 name: "In",	 colour: "purple",	 x: 216,	 y: 16
		},
		{	 name: "Mod",	 colour: "purple",	 x: 114,	 y: 19
		}
	],
	outputs: [
		{	 name: "Out",	 colour: "purple",	 x: 246,	 y: 16
		}
	],
	params: [
		{	 name: "AmountMod",	 type: "Level_100",	 n: "KnobSmall",	 x: 122.5,	 y: 7.5
		},
		{	 name: "Amount",	 type: "Level_100",	 n: "KnobMedium",	 x: 149.5,	 y: 5.5
		},
		{	 name: "Active",	 type: "ActiveMonitor",	 n: "SwM42",	 x: 226.25,	 y: 10.5
		},
		{	 name: "Type",	 type: "OverdriveType",	 n: "SwM5ca98275",	 x: 68.5,	 y: 14.5
		},
		{	 name: "Shape",	 type: "ClipShape",	 n: "SwM7d7511f",	 x: 32.5,	 y: 14.5
		}
	],
	modes: [],
	ve: [
		{	 type: "graph",	 x: 173,	 y: 4,	 w: 34,	 h: 22
		},
		{	 type: "path",	 d: "M111,19 L133,19 M215,16 L249,16"
		},
		{	 type: "text",	 x: 76,	 y: 11,	 t: "Type"
		},
		{	 type: "text",	 x: 3,	 y: 23,	 t: "Shape"
		}
	]
},{
	id: 74,
	height: 2,
	longnm: "Wave Wrapper",
	shortnm: "WaveWrap",
	page: {
		name: "Shaper",
		ord: 4
	},
	inputs: [
		{	 name: "In",	 colour: "purple",	 x: 216,	 y: 16
		},
		{	 name: "Mod",	 colour: "purple",	 x: 114,	 y: 19
		}
	],
	outputs: [
		{	 name: "Out",	 colour: "purple",	 x: 246,	 y: 16
		}
	],
	params: [
		{	 name: "AmountMod",	 type: "Level_100",	 n: "KnobSmall",	 x: 122.5,	 y: 7.5
		},
		{	 name: "Amount",	 type: "Level_100",	 n: "KnobMedium",	 x: 149.5,	 y: 5.5
		},
		{	 name: "Active",	 type: "ActiveMonitor",	 n: "SwM42",	 x: 226.25,	 y: 10.5
		}
	],
	modes: [],
	ve: [
		{	 type: "path",	 d: "M111,19 L133,19 M215,16 L249,16"
		},
		{	 type: "graph",	 x: 173,	 y: 4,	 w: 34,	 h: 22
		}
	]
},{
	id: 82,
	height: 2,
	longnm: "Rectifier",
	shortnm: "Rect",
	page: {
		name: "Shaper",
		ord: 6
	},
	inputs: [
		{	 name: "In",	 colour: "purple",	 x: 216,	 y: 16
		}
	],
	outputs: [
		{	 name: "Out",	 colour: "purple",	 x: 246,	 y: 16
		}
	],
	params: [
		{	 name: "Mode",	 type: "RectMode",	 n: "SwM0",	 x: 96.5,	 y: 8.5
		},
		{	 name: "Active",	 type: "ActiveMonitor",	 n: "SwM42",	 x: 226.25,	 y: 10.5
		}
	],
	modes: [],
	ve: [
		{	 type: "path",	 d: "M215,16 L249,16"
		}
	]
},{
	id: 83,
	height: 2,
	longnm: "Shape Static",
	shortnm: "ShpStatic",
	page: {
		name: "Shaper",
		ord: 5
	},
	inputs: [
		{	 name: "In",	 colour: "purple",	 x: 216,	 y: 16
		}
	],
	outputs: [
		{	 name: "Out",	 colour: "purple",	 x: 246,	 y: 16
		}
	],
	params: [
		{	 name: "Mode",	 type: "ShpStaticMode",	 n: "SwM0",	 x: 96.5,	 y: 8.5
		},
		{	 name: "Active",	 type: "ActiveMonitor",	 n: "SwM42",	 x: 226.25,	 y: 11.5
		}
	],
	modes: [],
	ve: [
		{	 type: "path",	 d: "M215,16 L249,16"
		}
	]
}, ///end of Shaper
/// start of Filter
{
	id: 32,
	height: 3,
	longnm: "Eq 2 Band",
	shortnm: "Eq2Band",
	page: {
		name: "Filter",
		ord: 12
	},
	inputs: [
		{	 name: "In",	 colour: "red",	 x: 246,	 y: 8
		}
	],
	outputs: [
		{	 name: "Out",	 colour: "red",	 x: 246,	 y: 35
		}
	],
	params: [
		{	 name: "LoSlope",	 type: "EqdB",	 n: "KnobMedium",	 x: 99.5,	 y: 20.5
		},
		{	 name: "HiSlope",	 type: "EqdB",	 n: "KnobMedium",	 x: 148.5,	 y: 20.5
		},
		{	 name: "Level",	 type: "Level_100",	 n: "KnobMedium",	 x: 24.5,	 y: 20.5
		},
		{	 name: "Active",	 type: "ActiveMonitor",	 n: "SwM42",	 x: 241.25,	 y: 16.5
		},
		{	 name: "LoFreq",	 type: "EqLoFreq",	 n: "SwM71fec5a5",	 x: 77.5,	 y: 29.5
		},
		{	 name: "HiFreq",	 type: "EqHiFreq",	 n: "SwM2ea74f08",	 x: 126.5,	 y: 29.5
		}
	],
	modes: [],
	ve: [
		{	 type: "graph",	 x: 173,	 y: 4,	 w: 52,	 h: 28
		},
		{	 type: "path",	 d: "M245,8 L245,39"
		},
		{	 type: "valueDisplay",	 x: 80,	 y: 4,	 w: 40,	 ref: 0
		},
		{	 type: "valueDisplay",	 x: 129,	 y: 4,	 w: 40,	 ref: 1
		},
		{	 type: "text",	 x: 81,	 y: 27,	 t: "Lo"
		},
		{	 type: "text",	 x: 130,	 y: 27,	 t: "Hi"
		},
		{	 type: "text",	 x: 5,	 y: 33,	 t: "Lev"
		}
	]
},{
	id: 33,
	height: 4,
	longnm: "Eq 3 Band",
	shortnm: "Eq3Band",
	page: {
		name: "Filter",
		ord: 13
	},
	inputs: [
		{	 name: "In",	 colour: "red",	 x: 246,	 y: 9
		}
	],
	outputs: [
		{	 name: "Out",	 colour: "red",	 x: 246,	 y: 50
		}
	],
	params: [
		{	 name: "LoSlope",	 type: "EqdB",	 n: "KnobMedium",	 x: 25.5,	 y: 35.5
		},
		{	 name: "MidGain",	 type: "EqdB",	 n: "KnobMedium",	 x: 68.5,	 y: 35.5
		},
		{	 name: "MidFreq",	 type: "EqMidFreq",	 n: "KnobMedium",	 x: 113.5,	 y: 35.5
		},
		{	 name: "HiSlope",	 type: "EqdB",	 n: "KnobMedium",	 x: 158.5,	 y: 35.5
		},
		{	 name: "Level",	 type: "Level_100",	 n: "KnobMedium",	 x: 202.5,	 y: 35.5
		},
		{	 name: "Active",	 type: "ActiveMonitor",	 n: "SwM42",	 x: 241.25,	 y: 24.5
		},
		{	 name: "LoFreq",	 type: "EqLoFreq",	 n: "SwM71fec5a5",	 x: 4.5,	 y: 44.5
		},
		{	 name: "HiFreq",	 type: "EqHiFreq",	 n: "SwM2ea74f08",	 x: 137.5,	 y: 44.5
		}
	],
	modes: [],
	ve: [
		{	 type: "graph",	 x: 182,	 y: 4,	 w: 52,	 h: 28
		},
		{	 type: "path",	 d: "M246,10 L246,52 M51,14 L133,14"
		},
		{	 type: "valueDisplay",	 x: 4,	 y: 17,	 w: 40,	 ref: 0
		},
		{	 type: "valueDisplay",	 x: 50,	 y: 17,	 w: 40,	 ref: 1
		},
		{	 type: "valueDisplay",	 x: 139,	 y: 17,	 w: 40,	 ref: 3
		},
		{	 type: "text",	 x: 7,	 y: 41,	 t: "Lo"
		},
		{	 type: "text",	 x: 49,	 y: 41,	 t: "Gain"
		},
		{	 type: "text",	 x: 141,	 y: 41,	 t: "Hi"
		},
		{	 type: "text",	 x: 183,	 y: 48,	 t: "Lev"
		},
		{	 type: "valueDisplay",	 x: 92,	 y: 17,	 w: 40,	 ref: 2
		},
		{	 type: "text",	 x: 91,	 y: 41,	 t: "Freq"
		},
		{	 type: "text",	 x: 82,	 y: 12,	 t: "Mid"
		}
	]
},{
	id: 45,
	height: 4,
	longnm: "Filter Voice",
	shortnm: "FltVoice",
	page: {
		name: "Filter",
		ord: 9
	},
	inputs: [
		{	 name: "In",	 colour: "red",	 x: 246,	 y: 9
		},
		{	 name: "VowelMod",	 colour: "blue",	 x: 130,	 y: 49
		},
		{	 name: "FreqMod",	 colour: "red",	 x: 10,	 y: 49
		}
	],
	outputs: [
		{	 name: "Out",	 colour: "red",	 x: 246,	 y: 50
		}
	],
	params: [
		{	 name: "Vowel1",	 type: "Vowel",	 n: "KnobSpin",	 x: 120.5,	 y: 12.5
		},
		{	 name: "Vowel2",	 type: "Vowel",	 n: "KnobSpin",	 x: 157.5,	 y: 12.5
		},
		{	 name: "Vowel3",	 type: "Vowel",	 n: "KnobSpin",	 x: 194.5,	 y: 12.5
		},
		{	 name: "Level",	 type: "Level_100",	 n: "KnobSmall",	 x: 215.5,	 y: 14.5
		},
		{	 name: "Vowel",	 type: "Level_100",	 n: "KnobBig",	 x: 164.5,	 y: 33.5
		},
		{	 name: "VowelMod",	 type: "Bipolar_127",	 n: "KnobSmall",	 x: 138.5,	 y: 37.5
		},
		{	 name: "Freq",	 type: "Level_100",	 n: "KnobReset",	 x: 42.5,	 y: 29.5
		},
		{	 name: "FreqMod",	 type: "Bipolar_127",	 n: "KnobSmall",	 x: 18.5,	 y: 37.5
		},
		{	 name: "Res",	 type: "Bipolar_127",	 n: "KnobReset",	 x: 70.5,	 y: 29.5
		},
		{	 name: "Active",	 type: "ActiveMonitor",	 n: "SwM42",	 x: 241.25,	 y: 24.5
		}
	],
	modes: [],
	ve: [
		{	 type: "path",	 d: "M246,11 L246,55 M9,49 L31,49 M129,49 L151,49 M98,5 L98,55 M210,5 L210,55"
		},
		{	 type: "valueDisplay",	 x: 139,	 y: 15,	 w: 17,	 ref: 1
		},
		{	 type: "valueDisplay",	 x: 176,	 y: 15,	 w: 17,	 ref: 2
		},
		{	 type: "valueDisplay",	 x: 102,	 y: 15,	 w: 17,	 ref: 0
		},
		{	 type: "text",	 x: 41,	 y: 26,	 t: "Freq"
		},
		{	 type: "text",	 x: 72,	 y: 26,	 t: "Res"
		},
		{	 type: "text",	 x: 212,	 y: 11,	 t: "Level"
		},
		{	 type: "text",	 x: 121,	 y: 10,	 t: "Vowel navigator"
		}
	]
},{
	id: 49,
	height: 4,
	longnm: "Filter Multi-mode",
	shortnm: "FltMulti",
	page: {
		name: "Filter",
		ord: 4
	},
	inputs: [
		{	 name: "In",	 colour: "red",	 x: 246,	 y: 9
		},
		{	 name: "PitchVar",	 colour: "purple",	 x: 10,	 y: 49
		},
		{	 name: "Pitch",	 colour: "purple",	 x: 10,	 y: 33
		}
	],
	outputs: [
		{	 name: "LP",	 colour: "red",	 x: 246,	 y: 50
		},
		{	 name: "BP",	 colour: "red",	 x: 246,	 y: 36
		},
		{	 name: "HP",	 colour: "red",	 x: 246,	 y: 22
		}
	],
	params: [
		{	 name: "Freq",	 type: "FltFreq",	 n: "KnobBig",	 x: 97.5,	 y: 33.5
		},
		{	 name: "PitchMod",	 type: "Level_200",	 n: "KnobReset",	 x: 18.5,	 y: 32.5
		},
		{	 name: "Kbt",	 type: "Kbt_4",	 n: "SwM43a19dbe",	 x: 49.5,	 y: 42.5
		},
		{	 name: "GC",	 type: "OffOn",	 n: "SwM8dc",	 x: 128.5,	 y: 40.5
		},
		{	 name: "Res",	 type: "Res_1",	 n: "KnobMedium",	 x: 150.5,	 y: 35.5
		},
		{	 name: "Slope",	 type: "FltSlope_1",	 n: "SwM193757",	 x: 186.5,	 y: 16.5
		},
		{	 name: "Active",	 type: "ActiveMonitor",	 n: "SwM42",	 x: 210.25,	 y: 44.5
		}
	],
	modes: [],
	ve: [
		{	 type: "path",	 d: "M9,49 L31,49 M246,13 L246,47"
		},
		{	 type: "text",	 x: 16,	 y: 30,	 t: "Pitch"
		},
		{	 type: "text",	 x: 53,	 y: 39,	 t: "KBT"
		},
		{	 type: "valueDisplay",	 x: 86,	 y: 16,	 w: 44,	 ref: 0
		},
		{	 type: "text",	 x: 97,	 y: 13,	 t: "Freq"
		},
		{	 type: "valueDisplay",	 x: 148,	 y: 16,	 w: 26,	 ref: 4
		},
		{	 type: "text",	 x: 187,	 y: 13,	 t: "dB/Oct"
		},
		{	 type: "text",	 x: 226,	 y: 26,	 t: "HP"
		},
		{	 type: "text",	 x: 226,	 y: 40,	 t: "BP"
		},
		{	 type: "text",	 x: 226,	 y: 54,	 t: "LP"
		},
		{	 type: "text",	 x: 152,	 y: 13,	 t: "Res"
		}
	]
},{
	id: 51,
	height: 5,
	longnm: "Filter Nord",
	shortnm: "FltNord",
	page: {
		name: "Filter",
		ord: 2
	},
	inputs: [
		{	 name: "In",	 colour: "red",	 x: 246,	 y: 9
		},
		{	 name: "PitchVar",	 colour: "purple",	 x: 10,	 y: 64
		},
		{	 name: "Pitch",	 colour: "purple",	 x: 10,	 y: 48
		},
		{	 name: "FMLin",	 colour: "purple",	 x: 51,	 y: 64
		},
		{	 name: "Res",	 colour: "purple",	 x: 130,	 y: 64
		}
	],
	outputs: [
		{	 name: "Out",	 colour: "red",	 x: 246,	 y: 65
		}
	],
	params: [
		{	 name: "Freq",	 type: "FltFreq",	 n: "KnobBig",	 x: 79.5,	 y: 14.5
		},
		{	 name: "PitchMod",	 type: "Level_200",	 n: "KnobReset",	 x: 18.5,	 y: 47.5
		},
		{	 name: "Kbt",	 type: "Kbt_4",	 n: "SwM43a19dbe",	 x: 83.5,	 y: 57.5
		},
		{	 name: "GC",	 type: "OffOn",	 n: "SwM8dc",	 x: 112.5,	 y: 34.5
		},
		{	 name: "Res",	 type: "Res_1",	 n: "KnobMedium",	 x: 137.5,	 y: 15.5
		},
		{	 name: "Slope",	 type: "FltSlope_2",	 n: "SwM2c9e5ad",	 x: 192.5,	 y: 50.5
		},
		{	 name: "Active",	 type: "ActiveMonitor",	 n: "SwM42",	 x: 241.25,	 y: 31.5
		},
		{	 name: "FM_Lin",	 type: "Level_100",	 n: "KnobSmall",	 x: 59.5,	 y: 52.5
		},
		{	 name: "FilterType",	 type: "LpBpHpBr",	 n: "SwM2c62dfda",	 x: 161.5,	 y: 4.5
		},
		{	 name: "ResMod",	 type: "Level_100",	 n: "KnobSmall",	 x: 138.5,	 y: 52.5
		}
	],
	modes: [],
	ve: [
		{	 type: "path",	 d: "M9,64 L31,64 M51,64 L73,64 M246,9 L246,65 M129,64 L151,64"
		},
		{	 type: "graph",	 x: 182,	 y: 4,	 w: 52,	 h: 28
		},
		{	 type: "text",	 x: 16,	 y: 45,	 t: "Pitch"
		},
		{	 type: "text",	 x: 45,	 y: 49,	 t: "FM Lin"
		},
		{	 type: "valueDisplay",	 x: 32,	 y: 18,	 w: 44,	 ref: 0
		},
		{	 type: "text",	 x: 86,	 y: 54,	 t: "KBT"
		},
		{	 type: "text",	 x: 80,	 y: 11,	 t: "Freq"
		},
		{	 type: "valueDisplay",	 x: 108,	 y: 18,	 w: 26,	 ref: 4
		},
		{	 type: "text",	 x: 138,	 y: 12,	 t: "Res"
		},
		{	 type: "text",	 x: 193,	 y: 47,	 t: "dB/Oct"
		},
		{	 type: "text",	 x: 119,	 y: 56,	 t: "Res"
		}
	]
},{
	id: 54,
	height: 3,
	longnm: "Filter Static",
	shortnm: "FltStatic",
	page: {
		name: "Filter",
		ord: 5
	},
	inputs: [
		{	 name: "In",	 colour: "red",	 x: 246,	 y: 8
		}
	],
	outputs: [
		{	 name: "Out",	 colour: "red",	 x: 246,	 y: 35
		}
	],
	params: [
		{	 name: "Freq",	 type: "FltFreq",	 n: "KnobBig",	 x: 53.5,	 y: 18.5
		},
		{	 name: "Res",	 type: "Res_1",	 n: "KnobMedium",	 x: 110.5,	 y: 20.5
		},
		{	 name: "FilterType",	 type: "LpBpHp",	 n: "SwM5257d302",	 x: 127.5,	 y: 4.5
		},
		{	 name: "Active",	 type: "ActiveMonitor",	 n: "SwM42",	 x: 241.25,	 y: 16.5
		},
		{	 name: "GC",	 type: "OffOn",	 n: "SwM8dc",	 x: 136.5,	 y: 29.5
		}
	],
	modes: [],
	ve: [
		{	 type: "graph",	 x: 182,	 y: 4,	 w: 52,	 h: 28
		},
		{	 type: "path",	 d: "M246,11 L246,36"
		},
		{	 type: "valueDisplay",	 x: 6,	 y: 27,	 w: 44,	 ref: 0
		},
		{	 type: "text",	 x: 18,	 y: 24,	 t: "Freq"
		},
		{	 type: "valueDisplay",	 x: 81,	 y: 27,	 w: 26,	 ref: 1
		},
		{	 type: "text",	 x: 85,	 y: 24,	 t: "Res"
		}
	]
},{
	id: 87,
	height: 2,
	longnm: "Filter Lowpass",
	shortnm: "FltLP",
	page: {
		name: "Filter",
		ord: 0
	},
	inputs: [
		{	 name: "In",	 colour: "red",	 x: 216,	 y: 16
		},
		{	 name: "Pitch",	 colour: "purple",	 x: 69,	 y: 19
		}
	],
	outputs: [
		{	 name: "Out",	 colour: "red",	 x: 246,	 y: 16
		}
	],
	params: [
		{	 name: "Freq",	 type: "FltFreq",	 n: "KnobMedium",	 x: 145.5,	 y: 5.5
		},
		{	 name: "FreqMod",	 type: "Level_100",	 n: "KnobSmall",	 x: 77.5,	 y: 7.5
		},
		{	 name: "Kbt",	 type: "Kbt_4",	 n: "SwM43a19dbe",	 x: 24.5,	 y: 14.5
		},
		{	 name: "Active",	 type: "ActiveMonitor",	 n: "SwM42",	 x: 226.25,	 y: 10.5
		}
	],
	modes: [
		{	 name: "SlopeMode",	 type: "HpLpSlopeMode"
		}
	],
	ve: [
		{	 type: "path",	 d: "M68,19 L90,19 M216,16 L248,16"
		},
		{	 type: "graph",	 x: 168,	 y: 4,	 w: 32,	 h: 22
		},
		{	 type: "valueDisplay",	 x: 99,	 y: 8,	 w: 44,	 ref: 0
		},
		{	 type: "text",	 x: 3,	 y: 24,	 t: "KBT"
		}
	]
},{
	id: 92,
	height: 4,
	longnm: "Filter Classic",
	shortnm: "FltClassic",
	page: {
		name: "Filter",
		ord: 3
	},
	inputs: [
		{	 name: "In",	 colour: "red",	 x: 246,	 y: 9
		},
		{	 name: "PitchVar",	 colour: "purple",	 x: 10,	 y: 49
		},
		{	 name: "Pitch",	 colour: "purple",	 x: 10,	 y: 33
		}
	],
	outputs: [
		{	 name: "Out",	 colour: "red",	 x: 246,	 y: 50
		}
	],
	params: [
		{	 name: "Freq",	 type: "FltFreq",	 n: "KnobBig",	 x: 97.5,	 y: 33.5
		},
		{	 name: "PitchMod",	 type: "Level_200",	 n: "KnobReset",	 x: 18.5,	 y: 32.5
		},
		{	 name: "Kbt",	 type: "Kbt_4",	 n: "SwM43a19dbe",	 x: 49.5,	 y: 42.5
		},
		{	 name: "Res",	 type: "Level_100",	 n: "KnobMedium",	 x: 150.5,	 y: 35.5
		},
		{	 name: "Slope",	 type: "ClassicSlope",	 n: "SwM7b0cfb64",	 x: 182.5,	 y: 42.5
		},
		{	 name: "Active",	 type: "ActiveMonitor",	 n: "SwM42",	 x: 241.25,	 y: 24.5
		}
	],
	modes: [],
	ve: [
		{	 type: "path",	 d: "M9,49 L31,49 M246,12 L246,49"
		},
		{	 type: "graph",	 x: 182,	 y: 4,	 w: 52,	 h: 28
		},
		{	 type: "text",	 x: 16,	 y: 30,	 t: "Pitch"
		},
		{	 type: "valueDisplay",	 x: 86,	 y: 16,	 w: 44,	 ref: 0
		},
		{	 type: "text",	 x: 53,	 y: 39,	 t: "KBT"
		},
		{	 type: "text",	 x: 97,	 y: 13,	 t: "Freq"
		},
		{	 type: "text",	 x: 152,	 y: 13,	 t: "Res"
		},
		{	 type: "valueDisplay",	 x: 148,	 y: 16,	 w: 26,	 ref: 3
		},
		{	 type: "text",	 x: 193,	 y: 40,	 t: "dB/Oct"
		}
	]
},{
	id: 102,
	height: 5,
	longnm: "Filter Phase",
	shortnm: "FltPhase",
	page: {
		name: "Filter",
		ord: 6
	},
	inputs: [
		{	 name: "In",	 colour: "red",	 x: 246,	 y: 9
		},
		{	 name: "PitchVar",	 colour: "purple",	 x: 10,	 y: 64
		},
		{	 name: "Spr",	 colour: "blue",	 x: 87,	 y: 64
		},
		{	 name: "FB",	 colour: "blue",	 x: 128,	 y: 64
		},
		{	 name: "Pitch",	 colour: "purple",	 x: 10,	 y: 48
		}
	],
	outputs: [
		{	 name: "Out",	 colour: "red",	 x: 246,	 y: 65
		}
	],
	params: [
		{	 name: "PitchMod",	 type: "Level_100",	 n: "KnobSmall",	 x: 18.5,	 y: 52.5
		},
		{	 name: "Freq",	 type: "Freq_2",	 n: "KnobBig",	 x: 48.5,	 y: 41.5
		},
		{	 name: "SpreadMod",	 type: "Level_100",	 n: "KnobSmall",	 x: 95.5,	 y: 52.5
		},
		{	 name: "FB",	 type: "Bipolar_127",	 n: "KnobReset",	 x: 125.5,	 y: 15.5
		},
		{	 name: "NotchCount",	 type: "FltPhaseNotchCount",	 n: "KnobSpin",	 x: 184.5,	 y: 50.5
		},
		{	 name: "Spread",	 type: "Level_100",	 n: "KnobMedium",	 x: 91.5,	 y: 21.5
		},
		{	 name: "Active",	 type: "ActiveMonitor",	 n: "SwM42",	 x: 241.25,	 y: 31.5
		},
		{	 name: "Level",	 type: "Level_100",	 n: "KnobSmall",	 x: 203.5,	 y: 52.5
		},
		{	 name: "FBMod",	 type: "Level_100",	 n: "KnobSmall",	 x: 136.5,	 y: 52.5
		},
		{	 name: "Type",	 type: "FltPhaseType",	 n: "SwM13c860bb",	 x: 149.5,	 y: 20.5
		},
		{	 name: "Kbt",	 type: "Kbt_4",	 n: "SwM43a19dbe",	 x: 4.5,	 y: 25.5
		}
	],
	modes: [],
	ve: [
		{	 type: "graph",	 x: 182,	 y: 4,	 w: 52,	 h: 28
		},
		{	 type: "path",	 d: "M246,12 L246,66 M87,64 L109,64 M10,62 L32,64 M125,64 L147,64"
		},
		{	 type: "text",	 x: 86,	 y: 18,	 t: "Spread"
		},
		{	 type: "valueDisplay",	 x: 37,	 y: 24,	 w: 44,	 ref: 1
		},
		{	 type: "text",	 x: 49,	 y: 21,	 t: "Freq"
		},
		{	 type: "valueDisplay",	 x: 164,	 y: 57,	 w: 17,	 ref: 4
		},
		{	 type: "text",	 x: 156,	 y: 54,	 t: "Notch"
		},
		{	 type: "text",	 x: 129,	 y: 13,	 t: "FB"
		},
		{	 type: "text",	 x: 152,	 y: 17,	 t: "Type"
		},
		{	 type: "text",	 x: 16,	 y: 50,	 t: "Pitch"
		},
		{	 type: "text",	 x: 8,	 y: 22,	 t: "KBT"
		},
		{	 type: "text",	 x: 199,	 y: 49,	 t: "Level"
		},
		{	 type: "text",	 x: 79,	 y: 56,	 t: "Spr"
		},
		{	 type: "text",	 x: 120,	 y: 56,	 t: "FB"
		}
	]
},{
	id: 103,
	height: 4,
	longnm: "Eq Peak",
	shortnm: "EqPeak",
	page: {
		name: "Filter",
		ord: 11
	},
	inputs: [
		{	 name: "In",	 colour: "red",	 x: 246,	 y: 9
		}
	],
	outputs: [
		{	 name: "Out",	 colour: "red",	 x: 246,	 y: 50
		}
	],
	params: [
		{	 name: "Freq",	 type: "Freq_3",	 n: "KnobMedium",	 x: 49.5,	 y: 35.5
		},
		{	 name: "Gain",	 type: "EqdB",	 n: "KnobMedium",	 x: 96.5,	 y: 35.5
		},
		{	 name: "Bandwidth",	 type: "EqPeakBandwidth",	 n: "KnobMedium",	 x: 143.5,	 y: 35.5
		},
		{	 name: "Active",	 type: "ActiveMonitor",	 n: "SwM42",	 x: 241.25,	 y: 24.5
		},
		{	 name: "Level",	 type: "Level_100",	 n: "KnobMedium",	 x: 203.5,	 y: 35.5
		}
	],
	modes: [],
	ve: [
		{	 type: "graph",	 x: 182,	 y: 4,	 w: 52,	 h: 28
		},
		{	 type: "path",	 d: "M246,10 L246,50"
		},
		{	 type: "valueDisplay",	 x: 27,	 y: 18,	 w: 44,	 ref: 0
		},
		{	 type: "valueDisplay",	 x: 76,	 y: 18,	 w: 44,	 ref: 1
		},
		{	 type: "valueDisplay",	 x: 125,	 y: 18,	 w: 44,	 ref: 2
		},
		{	 type: "text",	 x: 27,	 y: 42,	 t: "Freq"
		},
		{	 type: "text",	 x: 76,	 y: 42,	 t: "Gain"
		},
		{	 type: "text",	 x: 125,	 y: 42,	 t: "BW"
		},
		{	 type: "text",	 x: 183,	 y: 48,	 t: "Lev"
		}
	]
},{
	id: 108,
	height: 8,
	longnm: "Vocoder",
	shortnm: "Vocoder",
	page: {
		name: "Filter",
		ord: 10
	},
	inputs: [
		{	 name: "Ctrl",	 colour: "red",	 x: 12,	 y: 30
		},
		{	 name: "In",	 colour: "red",	 x: 216,	 y: 107
		}
	],
	outputs: [
		{	 name: "Out",	 colour: "red",	 x: 246,	 y: 107
		}
	],
	params: [
		{	 name: "Band1",	 type: "VocoderBand",	 n: "KnobSpin",	 x: 37.5,	 y: 75.5
		},
		{	 name: "Band2",	 type: "VocoderBand",	 n: "KnobSpin",	 x: 49.5,	 y: 75.5
		},
		{	 name: "Band3",	 type: "VocoderBand",	 n: "KnobSpin",	 x: 61.5,	 y: 75.5
		},
		{	 name: "Band4",	 type: "VocoderBand",	 n: "KnobSpin",	 x: 73.5,	 y: 75.5
		},
		{	 name: "Band5",	 type: "VocoderBand",	 n: "KnobSpin",	 x: 85.5,	 y: 75.5
		},
		{	 name: "Band6",	 type: "VocoderBand",	 n: "KnobSpin",	 x: 97.5,	 y: 75.5
		},
		{	 name: "Band7",	 type: "VocoderBand",	 n: "KnobSpin",	 x: 109.5,	 y: 75.5
		},
		{	 name: "Band8",	 type: "VocoderBand",	 n: "KnobSpin",	 x: 121.5,	 y: 75.5
		},
		{	 name: "Band9",	 type: "VocoderBand",	 n: "KnobSpin",	 x: 133.5,	 y: 75.5
		},
		{	 name: "Band10",	 type: "VocoderBand",	 n: "KnobSpin",	 x: 145.5,	 y: 75.5
		},
		{	 name: "Band11",	 type: "VocoderBand",	 n: "KnobSpin",	 x: 157.5,	 y: 75.5
		},
		{	 name: "Band12",	 type: "VocoderBand",	 n: "KnobSpin",	 x: 169.5,	 y: 75.5
		},
		{	 name: "Band13",	 type: "VocoderBand",	 n: "KnobSpin",	 x: 181.5,	 y: 75.5
		},
		{	 name: "Band14",	 type: "VocoderBand",	 n: "KnobSpin",	 x: 193.5,	 y: 75.5
		},
		{	 name: "Band15",	 type: "VocoderBand",	 n: "KnobSpin",	 x: 205.5,	 y: 75.5
		},
		{	 name: "Band16",	 type: "VocoderBand",	 n: "KnobSpin",	 x: 217.5,	 y: 75.5
		},
		{	 name: "Emphasis",	 type: "OffOn2",	 n: "SwM7364bc84",	 x: 7.5,	 y: 103.5
		},
		{	 name: "Monitor",	 type: "ActiveMonitor",	 n: "SwM12eec",	 x: 6.5,	 y: 40.5
		}
	],
	modes: [],
	ve: [
		{	 type: "graph",	 x: 35,	 y: 28,	 w: 194,	 h: 47
		},
		{	 type: "path",	 d: "M43,24 L43,100 M55,24 L55,100 M67,24 L67,100 M79,24 L79,100 M91,24 L91,100 M103,24 L103,100 M115,24 L115,100 M127,24 L127,100 M139,24 L139,100 M151,24 L151,100 M163,24 L163,100 M175,24 L175,100 M187,24 L187,100 M199,24 L199,100 M211,24 L211,100 M223,24 L223,100 M27,24 L27,32 M16,31 L27,31 M27,24 L224,24 M43,99 L231,99 M230,99 L230,102"
		},
		{	 type: "graph",	 x: 31,	 y: 103,	 w: 154,	 h: 12
		},
		{	 type: "text",	 x: 40,	 y: 22,	 t: "1"
		},
		{	 type: "text",	 x: 51,	 y: 22,	 t: "2"
		},
		{	 type: "text",	 x: 63,	 y: 22,	 t: "3"
		},
		{	 type: "text",	 x: 75,	 y: 22,	 t: "4"
		},
		{	 type: "text",	 x: 87,	 y: 22,	 t: "5"
		},
		{	 type: "text",	 x: 99,	 y: 22,	 t: "6"
		},
		{	 type: "text",	 x: 111,	 y: 22,	 t: "7"
		},
		{	 type: "text",	 x: 123,	 y: 22,	 t: "8"
		},
		{	 type: "text",	 x: 135,	 y: 22,	 t: "9"
		},
		{	 type: "text",	 x: 146,	 y: 22,	 t: "10"
		},
		{	 type: "text",	 x: 159,	 y: 22,	 t: "11"
		},
		{	 type: "text",	 x: 170,	 y: 22,	 t: "12"
		},
		{	 type: "text",	 x: 182,	 y: 22,	 t: "13"
		},
		{	 type: "text",	 x: 193,	 y: 22,	 t: "14"
		},
		{	 type: "text",	 x: 205,	 y: 22,	 t: "15"
		},
		{	 type: "text",	 x: 217,	 y: 22,	 t: "16"
		},
		{	 type: "text",	 x: 5,	 y: 22,	 t: "Ctrl"
		},
		{	 type: "text",	 x: 101,	 y: 10,	 t: "Analysis"
		},
		{	 type: "bmp",	 x: 220.5,	 y: 101,	 id: "box"
		},
		{	 type: "text",	 x: 7,	 y: 100,	 t: "Emp"
		}
	]
},{
	id: 125,
	height: 2,
	longnm: "Wah-Wah",
	shortnm: "WahWah",
	page: {
		name: "Filter",
		ord: 8
	},
	inputs: [
		{	 name: "In",	 colour: "red",	 x: 216,	 y: 16
		},
		{	 name: "Sweep",	 colour: "blue",	 x: 103,	 y: 19
		}
	],
	outputs: [
		{	 name: "Out",	 colour: "red",	 x: 246,	 y: 16
		}
	],
	params: [
		{	 name: "SweepMod",	 type: "Level_100",	 n: "KnobSmall",	 x: 111.5,	 y: 7.5
		},
		{	 name: "Sweep",	 type: "Level_100",	 n: "KnobMedium",	 x: 139.5,	 y: 5.5
		},
		{	 name: "Active",	 type: "ActiveMonitor",	 n: "SwM42",	 x: 226.25,	 y: 10.5
		}
	],
	modes: [],
	ve: [
		{	 type: "path",	 d: "M219,16 L244,16 M100,19 L122,19"
		},
		{	 type: "text",	 x: 162,	 y: 12,	 t: "Sweep"
		}
	]
},{
	id: 134,
	height: 2,
	longnm: "Filter Highpass",
	shortnm: "FltHP",
	page: {
		name: "Filter",
		ord: 1
	},
	inputs: [
		{	 name: "In",	 colour: "red",	 x: 216,	 y: 16
		},
		{	 name: "Pitch",	 colour: "blue",	 x: 69,	 y: 19
		}
	],
	outputs: [
		{	 name: "Out",	 colour: "red",	 x: 246,	 y: 16
		}
	],
	params: [
		{	 name: "Freq",	 type: "FltFreq",	 n: "KnobMedium",	 x: 145.5,	 y: 5.5
		},
		{	 name: "FreqMod",	 type: "Level_100",	 n: "KnobSmall",	 x: 77.5,	 y: 7.5
		},
		{	 name: "Kbt",	 type: "Kbt_4",	 n: "SwM43a19dbe",	 x: 24.5,	 y: 14.5
		},
		{	 name: "Active",	 type: "ActiveMonitor",	 n: "SwM42",	 x: 226.25,	 y: 10.5
		}
	],
	modes: [
		{	 name: "SlopeMode",	 type: "HpLpSlopeMode"
		}
	],
	ve: [
		{	 type: "path",	 d: "M68,19 L90,19 M216,16 L248,16"
		},
		{	 type: "graph",	 x: 168,	 y: 4,	 w: 32,	 h: 22
		},
		{	 type: "valueDisplay",	 x: 99,	 y: 8,	 w: 44,	 ref: 0
		},
		{	 type: "text",	 x: 3,	 y: 24,	 t: "KBT"
		}
	]
},{
	id: 162,
	height: 4,
	longnm: "Filter Comb",
	shortnm: "FltComb",
	page: {
		name: "Filter",
		ord: 7
	},
	inputs: [
		{	 name: "In",	 colour: "red",	 x: 246,	 y: 9
		},
		{	 name: "Pitch",	 colour: "purple",	 x: 10,	 y: 33
		},
		{	 name: "PitchVar",	 colour: "purple",	 x: 10,	 y: 49
		},
		{	 name: "FB",	 colour: "blue",	 x: 128,	 y: 49
		}
	],
	outputs: [
		{	 name: "Out",	 colour: "red",	 x: 246,	 y: 50
		}
	],
	params: [
		{	 name: "Freq",	 type: "Freq_1",	 n: "KnobMedium",	 x: 81.5,	 y: 35.5
		},
		{	 name: "PitchMod",	 type: "Level_100",	 n: "KnobSmall",	 x: 18.5,	 y: 37.5
		},
		{	 name: "Kbt",	 type: "Kbt_4",	 n: "SwM43a19dbe",	 x: 42.5,	 y: 44.5
		},
		{	 name: "FB",	 type: "Bipolar_127",	 n: "KnobReset",	 x: 125.5,	 y: 5.5
		},
		{	 name: "FBMod",	 type: "Level_100",	 n: "KnobSmall",	 x: 136.5,	 y: 37.5
		},
		{	 name: "Type",	 type: "CombType",	 n: "SwM13c860bb",	 x: 149.5,	 y: 20.5
		},
		{	 name: "Lev",	 type: "Level_100",	 n: "KnobSmall",	 x: 204.5,	 y: 37.5
		},
		{	 name: "Active",	 type: "ActiveMonitor",	 n: "SwM42",	 x: 241.25,	 y: 24.5
		}
	],
	modes: [],
	ve: [
		{	 type: "path",	 d: "M246,7 L246,51 M10,49 L32,49 M125,49 L147,49"
		},
		{	 type: "graph",	 x: 182,	 y: 4,	 w: 52,	 h: 28
		},
		{	 type: "valueDisplay",	 x: 66,	 y: 18,	 w: 50,	 ref: 0
		},
		{	 type: "text",	 x: 81,	 y: 15,	 t: "Freq"
		},
		{	 type: "text",	 x: 113,	 y: 12,	 t: "FB"
		},
		{	 type: "text",	 x: 16,	 y: 35,	 t: "Pitch"
		},
		{	 type: "text",	 x: 46,	 y: 41,	 t: "KBT"
		},
		{	 type: "text",	 x: 152,	 y: 17,	 t: "Type"
		},
		{	 type: "text",	 x: 184,	 y: 49,	 t: "Lev"
		},
		{	 type: "text",	 x: 121,	 y: 42,	 t: "FB"
		}
	]
}, ///end of Filter
/// start of LFO
{
	id: 24,
	height: 2,
	longnm: "LFO C",
	shortnm: "LfoC",
	page: {
		name: "LFO",
		ord: 2
	},
	inputs: [
		{	 name: "Rate",	 colour: "blue",	 x: 10,	 y: 20
		}
	],
	outputs: [
		{	 name: "Out",	 colour: "blue",	 x: 245,	 y: 20
		}
	],
	params: [
		{	 name: "Rate",	 type: "LfoRate_3",	 n: "KnobMedium",	 x: 165.5,	 y: 5.5
		},
		{	 name: "PolyMono",	 type: "PolyMono",	 n: "SwM7dcebf3d",	 x: 42.5,	 y: 14.5
		},
		{	 name: "OutputType",	 type: "OutTypeLfo",	 n: "levelshift",	 x: 222.5,	 y: 14.5
		},
		{	 name: "Range",	 type: "LfoRange_3",	 n: "SwM49cfa41",	 x: 77.5,	 y: 9.5
		},
		{	 name: "Active",	 type: "ActiveMonitor",	 n: "SwM4d",	 x: 240.25,	 y: 3.5
		}
	],
	modes: [
		{	 name: "Waveform",	 type: "LfoWaveform_1", x:189, y:7.5, w:22, h:18
		}
	],
	ve: [
		{	 type: "text",	 x: 17,	 y: 24,	 t: "Rate"
		},
		{	 type: "valueDisplay",	 x: 122,	 y: 8,	 w: 40,	 ref: [0,3]
		},
		{	 type: "led",	 x: 226,	 y: 4,	 w: 6.5
		}
	]
},{
	id: 25,
	height: 5,
	longnm: "LFO Shape A",
	shortnm: "LfoShpA",
	page: {
		name: "LFO",
		ord: 3
	},
	inputs: [
		{	 name: "Rate",	 colour: "blue",	 x: 29,	 y: 64
		},
		{	 name: "RateVar",	 colour: "blue",	 x: 46,	 y: 64
		},
		{	 name: "Rst",	 colour: "blue",	 x: 10,	 y: 31
		},
		{	 name: "ShapeMod",	 colour: "blue",	 x: 131,	 y: 64
		},
		{	 name: "PhaseMod",	 colour: "blue",	 x: 169,	 y: 64
		},
		{	 name: "Dir",	 colour: "blue",	 x: 31,	 y: 31
		}
	],
	outputs: [
		{	 name: "Out",	 colour: "blue",	 x: 246,	 y: 65
		},
		{	 name: "Snc",	 colour: "blue",	 x: 10,	 y: 65
		}
	],
	params: [
		{	 name: "Rate",	 type: "LfoRate_4",	 n: "KnobMedium",	 x: 84.5,	 y: 50.5
		},
		{	 name: "Range",	 type: "LfoRange_4",	 n: "SwM1d0ee86b",	 x: 74.5,	 y: 19.5
		},
		{	 name: "Kbt",	 type: "Kbt_4",	 n: "SwM43a19dbe",	 x: 44.5,	 y: 22.5
		},
		{	 name: "RateMod",	 type: "Level_100",	 n: "KnobSmall",	 x: 54.5,	 y: 52.5
		},
		{	 name: "Active",	 type: "ActiveMonitor",	 n: "SwM4d",	 x: 226.25,	 y: 59.5
		},
		{	 name: "Shape",	 type: "LfoShpAPW",	 n: "KnobMedium",	 x: 121.5,	 y: 28.5, isgraph:1
		},
		{	 name: "PhaseMod",	 type: "Level_100",	 n: "KnobSmall",	 x: 177.5,	 y: 52.5
		},
		{	 name: "Phase",	 type: "Phase",	 n: "KnobMedium",	 x: 176.5,	 y: 28.5, isgraph:1
		},
		{	 name: "ShapeMod",	 type: "Level_100",	 n: "KnobSmall",	 x: 139.5,	 y: 52.5
		},
		{	 name: "PolyMono",	 type: "PolyMono",	 n: "SwM7dcebf3d",	 x: 41.5,	 y: 36.5
		},
		{	 name: "OutputType",	 type: "OutTypeLfo",	 n: "levelshift",	 x: 206.5,	 y: 59.5, isgraph:1
		},
		{	 name: "Waveform",	 type: "LfoShpA__Waveform",	 n: "SwM2142c4b1",	 x: 92.5,	 y: 4.5, isgraph:1
		}
	],
	modes: [],
	ve: [
		{	 type: "path",	 d: "M44,64 L66,64 M168,64 L190,64 M130,64 L152,64"
		},
		{	 type: "graph",	 x: 199,	 y: 4,	 w: 52,	 h: 28, f:"lfoShpgraph"
		},
		{	 type: "text",	 x: 118,	 y: 26,	 t: "Shape"
		},
		{	 type: "text",	 x: 27,	 y: 57,	 t: "Rate"
		},
		{	 type: "text",	 x: 25,	 y: 24,	 t: "Dir"
		},
		{	 type: "led",	 x: 242,	 y: 51,	 w: 6.5
		},
		{	 type: "text",	 x: 155,	 y: 26,	 t: "Phase"
		},
		{	 type: "text",	 x: 47,	 y: 21,	 t: "KBT"
		},
		{	 type: "text",	 x: 3,	 y: 24,	 t: "Rst"
		},
		{	 type: "valueDisplay",	 x: 75,	 y: 33,	 w: 40,	 ref: [0,1]
		},
		{	 type: "valueDisplay",	 x: 146,	 y: 32,	 w: 27,	 ref: 7
		},
		{	 type: "text",	 x: 3,	 y: 58,	 t: "Snc"
		}
	]
},{
	id: 26,
	height: 3,
	longnm: "LFO A",
	shortnm: "LfoA",
	page: {
		name: "LFO",
		ord: 0
	},
	inputs: [
		{	 name: "Rate",	 colour: "blue",	 x: 10,	 y: 19
		},
		{	 name: "RateVar",	 colour: "blue",	 x: 10,	 y: 34
		}
	],
	outputs: [
		{	 name: "Out",	 colour: "blue",	 x: 246,	 y: 35
		}
	],
	params: [
		{	 name: "Rate",	 type: "LfoRate_3",	 n: "KnobMedium",	 x: 121.5,	 y: 20.5
		},
		{	 name: "PolyMono",	 type: "PolyMono",	 n: "SwM7dcebf3d",	 x: 43.5,	 y: 24.5
		},
		{	 name: "Kbt",	 type: "Kbt_4",	 n: "SwM43a19dbe",	 x: 166.5,	 y: 29.5
		},
		{	 name: "RateMod",	 type: "Level_100",	 n: "KnobSmall",	 x: 18.5,	 y: 22.5
		},
		{	 name: "Waveform",	 type: "LfoA_Waveform",	 n: "SwM0",	 x: 148.5,	 y: 4.5
		},
		{	 name: "Active",	 type: "ActiveMonitor",	 n: "SwM4d",	 x: 226.25,	 y: 29.5
		},
		{	 name: "OutputType",	 type: "OutTypeLfo",	 n: "levelshift",	 x: 206.5,	 y: 29.5
		},
		{	 name: "Range",	 type: "LfoRange_3",	 n: "SwM1d0ee86b",	 x: 77.5,	 y: 9.5
		}
	],
	modes: [],
	ve: [
		{	 type:"bmp", id:"LfoAWave", x: 148.5,	 y: 4.5
		},
		{	 type: "path",	 d: "M9,34 L31,34"
		},
		{	 type: "valueDisplay",	 x: 78,	 y: 23,	 w: 40,	 ref: [0,7]
		},
		{	 type: "text",	 x: 17,	 y: 21,	 t: "Rate"
		},
		{	 type: "led",	 x: 242,	 y: 21,	 w: 6.5
		},
		{	 type: "text",	 x: 146,	 y: 38,	 t: "KBT"
		}
	]
},{
	id: 68,
	height: 4,
	longnm: "Clock Generator",
	shortnm: "ClkGen",
	page: {
		name: "LFO",
		ord: 4
	},
	inputs: [
		{	 name: "Rst",	 colour: "yellow",	 x: 10,	 y: 21
		}
	],
	outputs: [
		{	 name: "1/96",	 colour: "yellow",	 x: 246,	 y: 22
		},
		{	 name: "1/16",	 colour: "yellow",	 x: 246,	 y: 36
		},
		{	 name: "ClkActive",	 colour: "yellow",	 x: 246,	 y: 8
		},
		{	 name: "Sync",	 colour: "yellow",	 x: 246,	 y: 50
		}
	],
	params: [
		{	 name: "Rate",	 type: "RateBpm",	 n: "KnobBig",	 x: 150.5,	 y: 6.5
		},
		{	 name: "Active",	 type: "ActiveMonitor",	 n: "SwM9ff",	 x: 176.5,	 y: 17.5
		},
		{	 name: "Source",	 type: "InternalMaster",	 n: "SwM4fd567cf",	 x: 4.5,	 y: 44.5
		},
		{	 name: "BeatSync",	 type: "ClkGenBeatSync",	 n: "KnobSpin",	 x: 165.5,	 y: 35.5
		},
		{	 name: "Swing",	 type: "ClkGenSwing",	 n: "KnobMedium",	 x: 57.5,	 y: 35.5
		}
	],
	modes: [],
	ve: [
		{	 type: "valueDisplay",	 x: 86,	 y: 15,	 w: 58,	 ref: 0
		},
		{	 type: "text",	 x: 219,	 y: 26,	 t: "1/96"
		},
		{	 type: "text",	 x: 221,	 y: 40,	 t: "1/16"
		},
		{	 type: "text",	 x: 191,	 y: 12,	 t: "Clk Active"
		},
		{	 type: "text",	 x: 99,	 y: 12,	 t: "Tempo"
		},
		{	 type: "text",	 x: 215,	 y: 54,	 t: "Sync"
		},
		{	 type: "text",	 x: 87,	 y: 48,	 t: "Sync every"
		},
		{	 type: "valueDisplay",	 x: 140,	 y: 39,	 w: 22,	 ref: 3
		},
		{	 type: "text",	 x: 178,	 y: 49,	 t: "beats"
		},
		{	 type: "text",	 x: 10,	 y: 42,	 t: "Source"
		},
		{	 type: "text",	 x: 21,	 y: 26,	 t: "Reset"
		},
		{	 type: "text",	 x: 54,	 y: 32,	 t: "Swing"
		}
	]
},{
	id: 190,
	height: 4,
	longnm: "LFO B",
	shortnm: "LfoB",
	page: {
		name: "LFO",
		ord: 1
	},
	inputs: [
		{	 name: "Rate",	 colour: "blue",	 x: 34,	 y: 49
		},
		{	 name: "RateVar",	 colour: "blue",	 x: 51,	 y: 49
		},
		{	 name: "Rst",	 colour: "blue",	 x: 10,	 y: 21
		},
		{	 name: "Phase",	 colour: "blue",	 x: 146,	 y: 49
		}
	],
	outputs: [
		{	 name: "Out",	 colour: "blue",	 x: 246,	 y: 50
		},
		{	 name: "Sync",	 colour: "blue",	 x: 10,	 y: 50
		}
	],
	params: [
		{	 name: "Rate",	 type: "LfoRate_4",	 n: "KnobMedium",	 x: 87.5,	 y: 35.5
		},
		{	 name: "RateMod",	 type: "Level_100",	 n: "KnobSmall",	 x: 59.5,	 y: 37.5
		},
		{	 name: "Range",	 type: "LfoRange_4",	 n: "SwM1d0ee86b",	 x: 77.5,	 y: 4.5
		},
		{	 name: "Kbt",	 type: "Kbt_4",	 n: "SwM43a19dbe",	 x: 112.5,	 y: 44.5
		},
		{	 name: "Waveform",	 type: "LfoB_Waveform",	 n: "SwM2142c4b1",	 x: 126.5,	 y: 4.5, isgraph:1
		},
		{	 name: "PolyMono",	 type: "PolyMono",	 n: "SwM7dcebf3d",	 x: 43.5,	 y: 19.5
		},
		{	 name: "Phase",	 type: "Phase",	 n: "KnobMedium",	 x: 176.5,	 y: 35.5, isgraph:1
		},
		{	 name: "Active",	 type: "ActiveMonitor",	 n: "SwM4d",	 x: 226.25,	 y: 44.5
		},
		{	 name: "OutputType",	 type: "OutTypeLfo",	 n: "levelshift",	 x: 206.5,	 y: 44.5, isgraph:1
		},
		{	 name: "PhaseMod",	 type: "Level_100",	 n: "KnobSmall",	 x: 154.5,	 y: 37.5
		}
	],
	modes: [],
	ve: [
		{	 type: "line",	 "x1": 49,	 "y1": 49,	 "x2": 71,	 "y2": 49
		},
		{	 type: "graph",	 x: 199,	 y: 4,	 w: 52,	 h: 28, f:"lfoBgraph"
		},
		{	 type: "line",	 "x1": 145,	 "y1": 49,	 "x2": 167,	 "y2": 49
		},
		{	 type: "valueDisplay",	 x: 78,	 y: 18,	 w: 40,	 ref: [0,2]
		},
		{	 type: "text",	 x: 142,	 y: 30,	 t: "Phase"
		},
		{	 type: "led",	 x: 242,	 y: 36,	 w: 6.5
		},
		{	 type: "text",	 x: 115,	 y: 42,	 t: "KBT"
		},
		{	 type: "text",	 x: 21,	 y: 25,	 t: "Rst"
		},
		{	 type: "valueDisplay",	 x: 170,	 y: 20,	 w: 25,	 ref: 6
		},
		{	 type: "text",	 x: 32,	 y: 42,	 t: "Rate"
		},
		{	 type: "text",	 x: 3,	 y: 43,	 t: "Snc"
		}
	]
}, ///end of LFO
/// start of Osc
{
	id: 7,
	height: 5,
	longnm: "Osc B",
	shortnm: "OscB",
	page: {
		name: "Osc",
		ord: 1
	},
	inputs: [
		{	 name: "Pitch",	 colour: "purple",	 x: 10,	 y: 48
		},
		{	 name: "PitchVar",	 colour: "purple",	 x: 10,	 y: 64
		},
		{	 name: "Sync",	 colour: "red",	 x: 10,	 y: 22
		},
		{	 name: "FmMod",	 colour: "red",	 x: 121,	 y: 64
		},
		{	 name: "ShapeMod",	 colour: "red",	 x: 186,	 y: 64
		}
	],
	outputs: [
		{	 name: "Out",	 colour: "red",	 x: 246,	 y: 65
		}
	],
	params: [
		{	 name: "FreqCoarse",	 type: "FreqCoarse",	 n: "KnobBig",	 x: 50.5,	 y: 48.5
		},
		{	 name: "FreqFine",	 type: "FreqFine",	 n: "KnobReset",	 x: 78.5,	 y: 44.5
		},
		{	 name: "Kbt",	 type: "Kbt_1",	 n: "SwM7364bc84",	 x: 126.5,	 y: 15.5
		},
		{	 name: "PitchMod",	 type: "Level_100",	 n: "KnobSmall",	 x: 18.5,	 y: 52.5
		},
		{	 name: "FreqMode",	 type: "FreqMode_3",	 n: "SwM1831ef4d",	 x: 47.5,	 y: 34.5
		},
		{	 name: "FmAmount",	 type: "Level_100",	 n: "KnobSmall",	 x: 129.5,	 y: 52.5
		},
		{	 name: "Shape",	 type: "PW",	 n: "KnobMedium",	 x: 188.5,	 y: 26.5
		},
		{	 name: "ShapeMod",	 type: "Level_100",	 n: "KnobSmall",	 x: 194.5,	 y: 52.5
		},
		{	 name: "Waveform",	 type: "OscBWaveform",	 n: "SwM0",	 x: 165.5,	 y: 4.5
		},
		{	 name: "Active",	 type: "ActiveMonitor",	 n: "SwM4d",	 x: 226.25,	 y: 59.5
		},
		{	 name: "FmMode",	 type: "FmLinTrk",	 n: "SwM4f346cb8",	 x: 114.5,	 y: 38.5
		}
	],
	modes: [],
	ve: [
		{	 type: "path",	 d: "M9,64 L31,64 M119,64 L141,64 M184,64 L206,64 M248,23 L222,23 222,38 211,38"
		},
		{	 type: "valueDisplay",	 x: 48,	 y: 15,	 w: 50,	 ref: [0,1,4]
		},
		{	 type: "text",	 x: 16,	 y: 50,	 t: "Pitch"
		},
		{	 type: "text",	 x: 21,	 y: 26,	 t: "Sync"
		},
		{	 type: "text",	 x: 159,	 y: 30,	 t: "Shape"
		},
		{	 type: "valueDisplay",	 x: 159,	 y: 33,	 w: 26,	 ref: 6
		},
		{	 type: "text",	 x: 78,	 y: 43,	 t: "Cent"
		},
		{	 type: "text",	 x: 106,	 y: 24,	 t: "KBT"
		}
	]
},{
	id: 8,
	height: 4,
	longnm: "Osc Shape B",
	shortnm: "OscShpB",
	page: {
		name: "Osc",
		ord: 6
	},
	inputs: [
		{	 name: "Pitch",	 colour: "purple",	 x: 10,	 y: 33
		},
		{	 name: "PitchVar",	 colour: "purple",	 x: 10,	 y: 49
		},
		{	 name: "Sync",	 colour: "red",	 x: 10,	 y: 19
		},
		{	 name: "FmMod",	 colour: "red",	 x: 143,	 y: 49
		},
		{	 name: "ShapeMod",	 colour: "red",	 x: 193,	 y: 49
		}
	],
	outputs: [
		{	 name: "Out",	 colour: "red",	 x: 246,	 y: 50
		}
	],
	params: [
		{	 name: "FreqCoarse",	 type: "FreqCoarse",	 n: "KnobBig",	 x: 80.5,	 y: 33.5
		},
		{	 name: "FreqFine",	 type: "FreqFine",	 n: "KnobReset",	 x: 108.5,	 y: 29.5
		},
		{	 name: "Kbt",	 type: "Kbt_1",	 n: "SwM7364bc84",	 x: 48.5,	 y: 32.5
		},
		{	 name: "PitchMod",	 type: "Level_100",	 n: "KnobSmall",	 x: 18.5,	 y: 37.5
		},
		{	 name: "FreqMode",	 type: "FreqMode_3",	 n: "SwM1831ef4d",	 x: 77.5,	 y: 19.5
		},
		{	 name: "FmAmount",	 type: "Level_100",	 n: "KnobSmall",	 x: 151.5,	 y: 37.5
		},
		{	 name: "Shape",	 type: "PW",	 n: "KnobMedium",	 x: 185.5,	 y: 4.5, isgraph:1
		},
		{	 name: "ShapeMod",	 type: "Level_100",	 n: "KnobSmall",	 x: 201.5,	 y: 37.5
		},
		{	 name: "Active",	 type: "ActiveMonitor",	 n: "SwM4d",	 x: 226.25,	 y: 44.5
		},
		{	 name: "FmMode",	 type: "FmLinTrk",	 n: "SwM4f346cb8",	 x: 136.5,	 y: 23.5
		}
	],
	modes: [
		{	 name: "Waveform",	 type: "OscWaveform_3", x:220, y:4.5, w:-24, h:22
		}
	],
	ve: [
		{	 type: "path",	 d: "M9,49 L31,49 M141,49 L163,49 M191,49 L213,49"
		},
		{	 type: "graph",	 x: 208,	 y: 4,	 w: 35,	 h: 22, f:"oscShpBgraph"
		},
		{	 type: "valueDisplay",	 x: 157,	 y: 7,	 w: 26,	 ref: 6
		},
		{	 type: "text",	 x: 130,	 y: 16,	 t: "Shape"
		},
		{	 type: "text",	 x: 16,	 y: 35,	 t: "Pitch"
		},
		{	 type: "text",	 x: 21,	 y: 23,	 t: "Sync"
		},
		{	 type: "valueDisplay",	 x: 79,	 y: 4,	 w: 50,	 ref: [0,1,4]
		},
		{	 type: "text",	 x: 108,	 y: 28,	 t: "Cent"
		},
		{	 type: "text",	 x: 49,	 y: 30,	 t: "KBT"
		},
		{	 type: "text",	 x: 173,	 y: 41,	 t: "Shape"
		}
	]
},{
	id: 9,
	height: 3,
	longnm: "Osc C",
	shortnm: "OscC",
	page: {
		name: "Osc",
		ord: 2
	},
	inputs: [
		{	 name: "PitchVar",	 colour: "purple",	 x: 10,	 y: 34
		},
		{	 name: "Sync",	 colour: "red",	 x: 164,	 y: 34
		},
		{	 name: "FmMod",	 colour: "red",	 x: 188,	 y: 34
		},
		{	 name: "Pitch",	 colour: "purple",	 x: 10,	 y: 18
		}
	],
	outputs: [
		{	 name: "Out",	 colour: "red",	 x: 246,	 y: 35
		}
	],
	params: [
		{	 name: "FreqCoarse",	 type: "FreqCoarse",	 n: "KnobBig",	 x: 102.5,	 y: 18.5
		},
		{	 name: "FreqFine",	 type: "FreqFine",	 n: "KnobReset",	 x: 129.5,	 y: 14.5
		},
		{	 name: "Kbt",	 type: "Kbt_1",	 n: "SwM7364bc84",	 x: 74.5,	 y: 29.5
		},
		{	 name: "FreqMode",	 type: "FreqMode_3",	 n: "SwM1831ef4d",	 x: 98.5,	 y: 4.5
		},
		{	 name: "FmAmount",	 type: "Level_100",	 n: "KnobSmall",	 x: 196.5,	 y: 22.5
		},
		{	 name: "Active",	 type: "ActiveMonitor",	 n: "SwM4d",	 x: 226.25,	 y: 29.5
		},
		{	 name: "FmMode",	 type: "FmLinTrk",	 n: "SwM4f346cb8",	 x: 181.5,	 y: 5.5
		},
		{	 name: "PitchMod",	 type: "Level_100",	 n: "KnobSmall",	 x: 18.5,	 y: 22.5
		}
	],
	modes: [
		{	 name: "Waveform",	 type: "OscWaveform_2", x:220, y:5, w:22, h:18
		}
	],
	ve: [
		{	 type: "path",	 d: "M185,34 L207,34 M9,34 L31,34"
		},
		{	 type: "valueDisplay",	 x: 46,	 y: 14,	 w: 50,	 ref: [0,1,3]
		},
		{	 type: "text",	 x: 16,	 y: 20,	 t: "Pitch"
		},
		{	 type: "text",	 x: 129,	 y: 13,	 t: "Cent"
		},
		{	 type: "text",	 x: 154,	 y: 24,	 t: "Sync"
		},
		{	 type: "text",	 x: 54,	 y: 38,	 t: "KBT"
		}
	]
},{
	id: 13,
	height: 3,
	longnm: "Osc String",
	shortnm: "OscString",
	page: {
		name: "Osc",
		ord: 13
	},
	inputs: [
		{	 name: "In",	 colour: "red",	 x: 246,	 y: 9
		},
		{	 name: "Pitch",	 colour: "blue",	 x: 10,	 y: 18
		},
		{	 name: "PitchVar",	 colour: "blue",	 x: 10,	 y: 34
		}
	],
	outputs: [
		{	 name: "Out",	 colour: "red",	 x: 246,	 y: 35
		}
	],
	params: [
		{	 name: "FreqCoarse",	 type: "FreqCoarse",	 n: "KnobBig",	 x: 102.5,	 y: 18.5
		},
		{	 name: "FreqFine",	 type: "FreqFine",	 n: "KnobReset",	 x: 130.5,	 y: 14.5
		},
		{	 name: "Kbt",	 type: "Kbt_1",	 n: "SwM7364bc84",	 x: 74.5,	 y: 29.5
		},
		{	 name: "PitchMod",	 type: "Level_100",	 n: "KnobSmall",	 x: 18.5,	 y: 22.5
		},
		{	 name: "FreqMode",	 type: "FreqMode_3",	 n: "SwM1831ef4d",	 x: 98.5,	 y: 4.5
		},
		{	 name: "Decay",	 type: "Level_100",	 n: "KnobMedium",	 x: 164.5,	 y: 20.5
		},
		{	 name: "Moisture",	 type: "Level_100",	 n: "KnobMedium",	 x: 195.5,	 y: 20.5
		},
		{	 name: "Active",	 type: "ActiveMonitor",	 n: "SwM4d",	 x: 226.25,	 y: 29.5
		}
	],
	modes: [],
	ve: [
		{	 type: "path",	 d: "M9,34 L31,34 M246,27 L246,37 M241,17 L252,17 252,28 241,28z M246,8 L246,18"
		},
		{	 type: "text",	 x: 16,	 y: 20,	 t: "Pitch"
		},
		{	 type: "valueDisplay",	 x: 46,	 y: 14,	 w: 50,	 ref: [0,1,4]
		},
		{	 type: "text",	 x: 130,	 y: 13,	 t: "Cent"
		},
		{	 type: "text",	 x: 160,	 y: 16,	 t: "Decay"
		},
		{	 type: "text",	 x: 194,	 y: 16,	 t: "Damp"
		},
		{	 type: "text",	 x: 54,	 y: 38,	 t: "KBT"
		}
	]
},{
	id: 27,
	height: 3,
	longnm: "Osc Master",
	shortnm: "OscMaster",
	page: {
		name: "Osc",
		ord: 16
	},
	inputs: [
		{	 name: "Pitch",	 colour: "purple",	 x: 10,	 y: 18
		},
		{	 name: "PitchVar",	 colour: "purple",	 x: 10,	 y: 34
		}
	],
	outputs: [
		{	 name: "Out",	 colour: "purple",	 x: 246,	 y: 35
		}
	],
	params: [
		{	 name: "FreqCoarse",	 type: "FreqCoarse",	 n: "KnobBig",	 x: 102.5,	 y: 18.5
		},
		{	 name: "FreqFine",	 type: "FreqFine",	 n: "KnobReset",	 x: 130.5,	 y: 14.5
		},
		{	 name: "Kbt",	 type: "Kbt_1",	 n: "SwM7364bc84",	 x: 74.5,	 y: 29.5
		},
		{	 name: "FreqMode",	 type: "FreqMode_2",	 n: "SwM19938232",	 x: 98.5,	 y: 4.5
		},
		{	 name: "PitchMod",	 type: "Level_100",	 n: "KnobSmall",	 x: 18.5,	 y: 22.5
		}
	],
	modes: [],
	ve: [
		{	 type: "path",	 d: "M8,35 L30,35"
		},
		{	 type: "valueDisplay",	 x: 46,	 y: 14,	 w: 50,	 ref: [0,1,3]
		},
		{	 type: "text",	 x: 16,	 y: 20,	 t: "Pitch"
		},
		{	 type: "text",	 x: 130,	 y: 13,	 t: "Cent"
		},
		{	 type: "text",	 x: 54,	 y: 38,	 t: "KBT"
		},
		{	 type: "text",	 x: 229,	 y: 27,	 t: "Pitch"
		}
	]
},{
	id: 29,
	height: 2,
	longnm: "Metallic Noise Oscillator",
	shortnm: "MetNoise",
	page: {
		name: "Osc",
		ord: 10
	},
	inputs: [
		{	 name: "FreqMod",	 colour: "purple",	 x: 72,	 y: 19
		},
		{	 name: "ColorMod",	 colour: "purple",	 x: 156,	 y: 19
		}
	],
	outputs: [
		{	 name: "Out",	 colour: "red",	 x: 246,	 y: 20
		}
	],
	params: [
		{	 name: "Color",	 type: "Level_100",	 n: "KnobMedium",	 x: 187.5,	 y: 5.5
		},
		{	 name: "Freq",	 type: "Level_100",	 n: "KnobMedium",	 x: 103.5,	 y: 5.5
		},
		{	 name: "Active",	 type: "ActiveMonitor",	 n: "SwM0",	 x: 239.5,	 y: 2.5
		},
		{	 name: "FreqMod",	 type: "Level_100",	 n: "KnobSmall",	 x: 80.5,	 y: 7.5
		},
		{	 name: "ColorMod",	 type: "Level_100",	 n: "KnobSmall",	 x: 164.5,	 y: 7.5
		}
	],
	modes: [],
	ve: [
		{	 type: "path",	 d: "M73,19 L95,19 M156,19 L178,19"
		},
		{	 type: "text",	 x: 208,	 y: 11,	 t: "Color"
		},
		{	 type: "text",	 x: 124,	 y: 11,	 t: "Freq"
		}
	]
},{
	id: 31,
	height: 2,
	longnm: "Noise",
	shortnm: "Noise",
	page: {
		name: "Osc",
		ord: 9
	},
	inputs: [],
	outputs: [
		{	 name: "Out",	 colour: "red",	 x: 246,	 y: 20
		}
	],
	params: [
		{	 name: "Color",	 type: "NoiseColor",	 n: "KnobMedium",	 x: 129.5,	 y: 5.5
		},
		{	 name: "Active",	 type: "ActiveMonitor",	 n: "SwM4d",	 x: 241.25,	 y: 2.5
		}
	],
	modes: [],
	ve: [
		{	 type: "text",	 x: 100,	 y: 25,	 t: "White"
		},
		{	 type: "text",	 x: 152,	 y: 25,	 t: "Colored"
		}
	]
},{
	id: 58,
	height: 8,
	longnm: "Drum Synthesizer",
	shortnm: "DrumSynth",
	page: {
		name: "Osc",
		ord: 12
	},
	inputs: [
		{	 name: "Trig",	 colour: "yellow",	 x: 10,	 y: 31
		},
		{	 name: "Vel",	 colour: "blue",	 x: 10,	 y: 110
		},
		{	 name: "Pitch",	 colour: "blue",	 x: 10,	 y: 72
		}
	],
	outputs: [
		{	 name: "Out",	 colour: "red",	 x: 246,	 y: 110
		}
	],
	params: [
		{	 name: "Masterfreq",	 type: "DrumSynthFreq",	 n: "KnobMedium",	 x: 34.5,	 y: 43.5
		},
		{	 name: "SlaveRatio",	 type: "DrumSynthRatio",	 n: "KnobMedium",	 x: 34.5,	 y: 95.5
		},
		{	 name: "MasterDecay",	 type: "EnvTime",	 n: "KnobMedium",	 x: 63.5,	 y: 43.5
		},
		{	 name: "SlaveDecay",	 type: "EnvTime",	 n: "KnobMedium",	 x: 63.5,	 y: 95.5
		},
		{	 name: "MasterLevel",	 type: "Level_100",	 n: "KnobMedium",	 x: 92.5,	 y: 43.5
		},
		{	 name: "SlaveLevel",	 type: "Level_100",	 n: "KnobMedium",	 x: 92.5,	 y: 95.5
		},
		{	 name: "NoiseFltFreq",	 type: "DrumSynthNoiseFlt",	 n: "KnobMedium",	 x: 126.5,	 y: 48.5
		},
		{	 name: "NoiseFltRes",	 type: "Level_100",	 n: "KnobMedium",	 x: 153.5,	 y: 48.5
		},
		{	 name: "NoiseFltSweep",	 type: "Level_100",	 n: "KnobMedium",	 x: 180.5,	 y: 48.5
		},
		{	 name: "NoiseFltDecay",	 type: "EnvTime",	 n: "KnobMedium",	 x: 207.5,	 y: 48.5
		},
		{	 name: "NoiseFltMode",	 type: "LpBpHp2",	 n: "SwMe2379fe",	 x: 231.5,	 y: 30.5
		},
		{	 name: "BendAmount",	 type: "Level_100",	 n: "KnobMedium",	 x: 126.5,	 y: 95.5
		},
		{	 name: "BendDecay",	 type: "EnvTime",	 n: "KnobMedium",	 x: 153.5,	 y: 95.5
		},
		{	 name: "Click",	 type: "Level_100",	 n: "KnobMedium",	 x: 184.5,	 y: 95.5
		},
		{	 name: "Noise",	 type: "Level_100",	 n: "KnobMedium",	 x: 211.5,	 y: 95.5
		},
		{	 name: "Active",	 type: "ActiveMonitor",	 n: "SwM9ff",	 x: 239.5,	 y: 90.5
		}
	],
	modes: [],
	ve: [
		{	 type: "graph",	 x: 157,	 y: 4,	 w: 64,	 h: 21
		},
		{	 type: "path",	 d: "M210,26 L250,26 250,27 210,27z"
		},
		{	 type: "valueDisplay",	 x: 25,	 y: 27,	 w: 40,	 ref: 0
		},
		{	 type: "valueDisplay",	 x: 25,	 y: 80,	 w: 40,	 ref: 1
		},
		{	 type: "led",	 x: 6,	 y: 39,	 w: 6.5
		},
		{	 type: "text",	 x: 65,	 y: 40,	 t: "Dcy"
		},
		{	 type: "text",	 x: 93,	 y: 40,	 t: "Lev"
		},
		{	 type: "text",	 x: 126,	 y: 45,	 t: "Freq"
		},
		{	 type: "text",	 x: 154,	 y: 45,	 t: "Res"
		},
		{	 type: "text",	 x: 181,	 y: 45,	 t: "Swp"
		},
		{	 type: "text",	 x: 207,	 y: 45,	 t: "Dcy"
		},
		{	 type: "text",	 x: 125,	 y: 17,	 t: "Preset"
		},
		{	 type: "text",	 x: 126,	 y: 92,	 t: "Amt"
		},
		{	 type: "text",	 x: 154,	 y: 92,	 t: "Dcy"
		},
		{	 type: "text",	 x: 183,	 y: 92,	 t: "Click"
		},
		{	 type: "text",	 x: 209,	 y: 92,	 t: "Noise"
		},
		{	 type: "text",	 x: 3,	 y: 24,	 t: "Trig"
		},
		{	 type: "text",	 x: 3,	 y: 103,	 t: "Vel"
		},
		{	 type: "text",	 x: 3,	 y: 65,	 t: "Pitch"
		},
		{	 type: "text",	 x: 93,	 y: 92,	 t: "Lev"
		},
		{	 type: "text",	 x: 65,	 y: 92,	 t: "Dcy"
		},
		{	 type: "bmp",	 x: 24,	 y: 14,	 id: 35
		},
		{	 type: "bmp",	 x: 24,	 y: 67,	 id: 43
		},
		{	 type: "bmp",	 x: 123,	 y: 26,	 id: 33
		},
		{	 type: "bmp",	 x: 125,	 y: 72,	 id: 46
		}
	]
},{
	id: 96,
	height: 2,
	longnm: "Osc D",
	shortnm: "OscD",
	page: {
		name: "Osc",
		ord: 3
	},
	inputs: [
		{	 name: "Pitch",	 colour: "purple",	 x: 10,	 y: 20
		}
	],
	outputs: [
		{	 name: "Out",	 colour: "red",	 x: 246,	 y: 20
		}
	],
	params: [
		{	 name: "FreqCoarse",	 type: "FreqCoarse",	 n: "KnobMedium",	 x: 161.5,	 y: 5.5
		},
		{	 name: "FreqFine",	 type: "FreqFine",	 n: "KnobReset",	 x: 185.5,	 y: 3.5
		},
		{	 name: "Kbt",	 type: "Kbt_1",	 n: "SwM7364bc84",	 x: 61.5,	 y: 14.5
		},
		{	 name: "FreqMode",	 type: "FreqMode_3",	 n: "SwM1831ef4d",	 x: 134.5,	 y: 9.5
		},
		{	 name: "Active",	 type: "ActiveMonitor",	 n: "SwM4d",	 x: 241.25,	 y: 2.5
		}
	],
	modes: [
		{	 name: "Waveform",	 type: "OscWaveform_2", x:208, y:5, w:22, h:18
		}
	],
	ve: [
		{	 type: "text",	 x: 16,	 y: 23,	 t: "Pitch"
		},
		{	 type: "valueDisplay",	 x: 83,	 y: 8,	 w: 50,	 ref: [0,1,3]
		},
		{	 type: "text",	 x: 181,	 y: 10,	 t: "F"
		},
		{	 type: "text",	 x: 42,	 y: 23,	 t: "KBT"
		}
	]
},{
	id: 97,
	height: 3,
	longnm: "Osc A",
	shortnm: "OscA",
	page: {
		name: "Osc",
		ord: 0
	},
	inputs: [
		{	 name: "Pitch",	 colour: "purple",	 x: 10,	 y: 18
		},
		{	 name: "PitchVar",	 colour: "purple",	 x: 10,	 y: 34
		}
	],
	outputs: [
		{	 name: "Out",	 colour: "red",	 x: 246,	 y: 35
		}
	],
	params: [
		{	 name: "FreqCoarse",	 type: "FreqCoarse",	 n: "KnobBig",	 x: 98.5,	 y: 18.5
		},
		{	 name: "FreqFine",	 type: "FreqFine",	 n: "KnobReset",	 x: 126.5,	 y: 14.5
		},
		{	 name: "Kbt",	 type: "Kbt_1",	 n: "SwM7364bc84",	 x: 70.5,	 y: 29.5
		},
		{	 name: "PitchMod",	 type: "Level_100",	 n: "KnobSmall",	 x: 18.5,	 y: 22.5
		},
		{	 name: "Waveform",	 type: "OscA_Waveform",	 n: "SwM0",	 x: 148.5,	 y: 4.5
		},
		{	 name: "Active",	 type: "ActiveMonitor",	 n: "SwM4d",	 x: 226.25,	 y: 29.5
		},
		{	 name: "FreqMode",	 type: "FreqMode_3",	 n: "SwM1831ef4d",	 x: 94.5,	 y: 4.5
		}
	],
	modes: [],
	ve: [
		{	 type: "path",	 d: "M8,34 L30,34"
		},
		{	 type: "valueDisplay",	 x: 42,	 y: 14,	 w: 50,	 ref: [0,1,6]
		},
		{	 type: "text",	 x: 16,	 y: 20,	 t: "Pitch"
		},
		{	 type: "text",	 x: 126,	 y: 13,	 t: "Cent"
		},
		{	 type: "text",	 x: 50,	 y: 38,	 t: "KBT"
		}
	]
},{
	id: 106,
	height: 3,
	longnm: "Oscillator Noise",
	shortnm: "OscNoise",
	page: {
		name: "Osc",
		ord: 8
	},
	inputs: [
		{	 name: "Pitch",	 colour: "purple",	 x: 10,	 y: 18
		},
		{	 name: "PitchVar",	 colour: "purple",	 x: 10,	 y: 34
		},
		{	 name: "Width",	 colour: "purple",	 x: 165,	 y: 34
		}
	],
	outputs: [
		{	 name: "Out",	 colour: "red",	 x: 246,	 y: 35
		}
	],
	params: [
		{	 name: "FreqCoarse",	 type: "FreqCoarse",	 n: "KnobBig",	 x: 102.5,	 y: 18.5
		},
		{	 name: "FreqFine",	 type: "FreqFine",	 n: "KnobReset",	 x: 130.5,	 y: 14.5
		},
		{	 name: "Kbt",	 type: "Kbt_1",	 n: "SwM7364bc84",	 x: 74.5,	 y: 29.5
		},
		{	 name: "PitchMod",	 type: "Level_100",	 n: "KnobSmall",	 x: 18.5,	 y: 22.5
		},
		{	 name: "FreqMode",	 type: "FreqMode_3",	 n: "SwM1831ef4d",	 x: 98.5,	 y: 4.5
		},
		{	 name: "Width",	 type: "Level_100",	 n: "KnobBig",	 x: 195.5,	 y: 18.5
		},
		{	 name: "WidthMod",	 type: "Level_100",	 n: "KnobSmall",	 x: 173.5,	 y: 22.5
		},
		{	 name: "Active",	 type: "ActiveMonitor",	 n: "SwM4d",	 x: 226.25,	 y: 29.5
		}
	],
	modes: [],
	ve: [
		{	 type: "path",	 d: "M163,34 L185,34 M8,34 L30,34"
		},
		{	 type: "graph",	 x: 220,	 y: 4,	 w: 31,	 h: 22
		},
		{	 type: "text",	 x: 179,	 y: 15,	 t: "Width"
		},
		{	 type: "valueDisplay",	 x: 46,	 y: 14,	 w: 50,	 ref: [0,1,4]
		},
		{	 type: "text",	 x: 16,	 y: 20,	 t: "Pitch"
		},
		{	 type: "text",	 x: 130,	 y: 13,	 t: "Cent"
		},
		{	 type: "text",	 x: 54,	 y: 38,	 t: "KBT"
		}
	]
},{
	id: 163,
	height: 5,
	longnm: "Osc Shape A",
	shortnm: "OscShpA",
	page: {
		name: "Osc",
		ord: 5
	},
	inputs: [
		{	 name: "Pitch",	 colour: "purple",	 x: 10,	 y: 48
		},
		{	 name: "PitchVar",	 colour: "purple",	 x: 10,	 y: 64
		},
		{	 name: "Sync",	 colour: "red",	 x: 10,	 y: 22
		},
		{	 name: "FmMod",	 colour: "red",	 x: 121,	 y: 64
		},
		{	 name: "ShapeMod",	 colour: "red",	 x: 186,	 y: 64
		}
	],
	outputs: [
		{	 name: "Out",	 colour: "red",	 x: 246,	 y: 65
		}
	],
	params: [
		{	 name: "FreqCoarse",	 type: "FreqCoarse",	 n: "KnobBig",	 x: 50.5,	 y: 48.5
		},
		{	 name: "FreqFine",	 type: "FreqFine",	 n: "KnobReset",	 x: 78.5,	 y: 44.5
		},
		{	 name: "Kbt",	 type: "Kbt_1",	 n: "SwM7364bc84",	 x: 123.5,	 y: 17.5
		},
		{	 name: "PitchMod",	 type: "Level_100",	 n: "KnobSmall",	 x: 18.5,	 y: 52.5
		},
		{	 name: "FreqMode",	 type: "FreqMode_3",	 n: "SwM1831ef4d",	 x: 47.5,	 y: 34.5
		},
		{	 name: "FmAmount",	 type: "Level_100",	 n: "KnobSmall",	 x: 129.5,	 y: 52.5
		},
		{	 name: "FmMode",	 type: "FmLinTrk",	 n: "SwM4f346cb8",	 x: 114.5,	 y: 38.5
		},
		{	 name: "Shape",	 type: "PW",	 n: "KnobMedium",	 x: 188.5,	 y: 25.5, isgraph:1
		},
		{	 name: "ShapeMod",	 type: "Level_100",	 n: "KnobSmall",	 x: 194.5,	 y: 52.5
		},
		{	 name: "Waveform",	 type: "OscShpA_Waveform",	 n: "SwM0",	 x: 148.5,	 y: 4.5, isgraph:1
		},
		{	 name: "Active",	 type: "ActiveMonitor",	 n: "SwM4d",	 x: 226.25,	 y: 59.5
		}
	],
	modes: [],
	ve: [
		{	 type: "path",	 d: "M9,64 L31,64 M122,64 L144,64 M184,64 L206,64"
		},
		{	 type: "graph",	 x: 213,	 y: 24,	 w: 38,	 h: 22, f:"oscShpgraph"
		},
		{	 type: "valueDisplay",	 x: 48,	 y: 17,	 w: 50,	 ref: [0,1,4]
		},
		{	 type: "text",	 x: 16,	 y: 50,	 t: "Pitch"
		},
		{	 type: "text",	 x: 21,	 y: 26,	 t: "Sync"
		},
		{	 type: "text",	 x: 158,	 y: 28,	 t: "Shape"
		},
		{	 type: "valueDisplay",	 x: 159,	 y: 31,	 w: 26,	 ref: 7
		},
		{	 type: "text",	 x: 78,	 y: 43,	 t: "Cent"
		},
		{	 type: "text",	 x: 103,	 y: 26,	 t: "KBT"
		}
	]
},{
	id: 164,
	height: 5,
	longnm: "Osc Dual",
	shortnm: "OscDual",
	page: {
		name: "Osc",
		ord: 7
	},
	inputs: [
		{	 name: "Pitch",	 colour: "purple",	 x: 10,	 y: 48
		},
		{	 name: "PitchVar",	 colour: "purple",	 x: 10,	 y: 64
		},
		{	 name: "Sync",	 colour: "red",	 x: 10,	 y: 22
		},
		{	 name: "PW",	 colour: "red",	 x: 130,	 y: 27
		},
		{	 name: "Phase",	 colour: "red",	 x: 130,	 y: 64
		}
	],
	outputs: [
		{	 name: "Out",	 colour: "red",	 x: 246,	 y: 65
		}
	],
	params: [
		{	 name: "FreqCoarse",	 type: "FreqCoarse",	 n: "KnobBig",	 x: 50.5,	 y: 48.5
		},
		{	 name: "FreqFine",	 type: "FreqFine",	 n: "KnobReset",	 x: 78.5,	 y: 44.5
		},
		{	 name: "Kbt",	 type: "Kbt_1",	 n: "SwM7364bc84",	 x: 101.5,	 y: 42.5
		},
		{	 name: "PitchMod",	 type: "Level_100",	 n: "KnobSmall",	 x: 18.5,	 y: 52.5
		},
		{	 name: "FreqMode",	 type: "FreqMode_3",	 n: "SwM1831ef4d",	 x: 48.5,	 y: 34.5
		},
		{	 name: "SqrLevel",	 type: "Level_100",	 n: "KnobMedium",	 x: 189.5,	 y: 13.5
		},
		{	 name: "PWMod",	 type: "Level_100",	 n: "KnobSmall",	 x: 138.5,	 y: 15.5
		},
		{	 name: "SawLevel",	 type: "Level_100",	 n: "KnobMedium",	 x: 189.5,	 y: 50.5
		},
		{	 name: "SawPhase",	 type: "Phase",	 n: "KnobMedium",	 x: 161.5,	 y: 50.5
		},
		{	 name: "SubOctLevel",	 type: "Level_100",	 n: "KnobMedium",	 x: 225.5,	 y: 13.5
		},
		{	 name: "Active",	 type: "ActiveMonitor",	 n: "SwM4d",	 x: 226.25,	 y: 59.5
		},
		{	 name: "SqrPW",	 type: "PW",	 n: "KnobMedium",	 x: 161.5,	 y: 13.5
		},
		{	 name: "PhaseMod",	 type: "Level_100",	 n: "KnobSmall",	 x: 138.5,	 y: 52.5
		},
		{	 name: "Soft",	 type: "OffOn",	 n: "SwM7364bc84",	 x: 226.5,	 y: 45.5
		}
	],
	modes: [],
	ve: [
		{	 type: "path",	 d: "M9,64 L31,64 M128,27 L150,27 M124,38 L217,38 M217,18 L217,58 M127,64 L149,64"
		},
		{	 type: "valueDisplay",	 x: 48,	 y: 17,	 w: 50,	 ref: [0,1,4]
		},
		{	 type: "text",	 x: 78,	 y: 43,	 t: "Cent"
		},
		{	 type: "text",	 x: 16,	 y: 50,	 t: "Pitch"
		},
		{	 type: "text",	 x: 21,	 y: 26,	 t: "Sync"
		},
		{	 type: "text",	 x: 162,	 y: 11,	 t: "PW"
		},
		{	 type: "text",	 x: 221,	 y: 11,	 t: "Sub"
		},
		{	 type: "text",	 x: 157,	 y: 48,	 t: "Phase"
		},
		{	 type: "bmp",	 x: 201,	 y: 39,	 id: "WSAW"
		},
		{	 type: "bmp",	 x: 201,	 y: 2,	 id: "WSQR1"
		},
		{	 type: "bmp",	 x: 237,	 y: 2,	 id: "WSQR2"
		},
		{	 type: "text",	 x: 186,	 y: 11,	 t: "Lvl"
		},
		{	 type: "text",	 x: 186,	 y: 48,	 t: "Lvl"
		},
		{	 type: "text",	 x: 102,	 y: 40,	 t: "KBT"
		},
		{	 type: "text",	 x: 226,	 y: 43,	 t: "Soft"
		}
	]
},{
	id: 165,
	height: 6,
	longnm: "DX Style Router",
	shortnm: "DXRouter",
	page: {
		name: "Osc",
		ord: 15
	},
	inputs: [
		{	 name: "In1",	 colour: "red",	 x: 13,	 y: 80
		},
		{	 name: "In2",	 colour: "red",	 x: 50,	 y: 80
		},
		{	 name: "In3",	 colour: "red",	 x: 87,	 y: 80
		},
		{	 name: "In4",	 colour: "red",	 x: 124,	 y: 80
		},
		{	 name: "In5",	 colour: "red",	 x: 161,	 y: 80
		},
		{	 name: "In6",	 colour: "red",	 x: 198,	 y: 80
		}
	],
	outputs: [
		{	 name: "Out1",	 colour: "red",	 x: 27,	 y: 80
		},
		{	 name: "Out2",	 colour: "red",	 x: 64,	 y: 80
		},
		{	 name: "Out3",	 colour: "red",	 x: 101,	 y: 80
		},
		{	 name: "Out4",	 colour: "red",	 x: 138,	 y: 80
		},
		{	 name: "Out5",	 colour: "red",	 x: 175,	 y: 80
		},
		{	 name: "Out6",	 colour: "red",	 x: 212,	 y: 80
		},
		{	 name: "Main",	 colour: "red",	 x: 246,	 y: 80
		}
	],
	params: [
		{	 name: "Algorithm",	 type: "DxAlgorithm",	 n: "KnobSpin",	 x: 83.5,	 y: 37.5, isgraph:1
		},
		{	 name: "Feedback",	 type: "DxFeedback",	 n: "KnobSpin",	 x: 33.5,	 y: 37.5
		}
	],
	modes: [],
	ve: [
		{	 type: "graphenv",	 x: 112,	 y: 4,	 w: 139,	 h: 67, f:"dxrouterGraph"
		},
		{	 type: "valueDisplay",	 x: 60,	 y: 40,	 w: 20,	 ref: 0
		},
		{	 type: "valueDisplay",	 x: 10,	 y: 40,	 w: 20,	 ref: 1
		},
		{	 type: "text",	 x: 56,	 y: 35,	 t: "Algorithm"
		},
		{	 type: "text",	 x: 5,	 y: 35,	 t: "Feedback"
		},
		{	 type: "text",	 x: 3,	 y: 84,	 t: "1"
		},
		{	 type: "text",	 x: 38,	 y: 84,	 t: "2"
		},
		{	 type: "text",	 x: 75,	 y: 84,	 t: "3"
		},
		{	 type: "text",	 x: 111,	 y: 84,	 t: "4"
		},
		{	 type: "text",	 x: 149,	 y: 84,	 t: "5"
		},
		{	 type: "text",	 x: 186,	 y: 84,	 t: "6"
		},
		{	 type: "text",	 x: 219,	 y: 84,	 t: "Main"
		}
	]
},{
	id: 180,
	height: 12,
	longnm: "FM Operator",
	shortnm: "Operator",
	page: {
		name: "Osc",
		ord: 14
	},
	inputs: [
		{	 name: "Freq",	 colour: "blue",	 x: 10,	 y: 54
		},
		{	 name: "FM",	 colour: "red",	 x: 246,	 y: 24
		},
		{	 name: "Gate",	 colour: "yellow",	 x: 10,	 y: 80
		},
		{	 name: "Note",	 colour: "blue",	 x: 10,	 y: 105
		},
		{	 name: "AMod",	 colour: "blue",	 x: 10,	 y: 147
		},
		{	 name: "Vel",	 colour: "blue",	 x: 10,	 y: 170
		},
		{	 name: "Pitch",	 colour: "blue",	 x: 10,	 y: 28
		}
	],
	outputs: [
		{	 name: "Out",	 colour: "red",	 x: 246,	 y: 170
		}
	],
	params: [
		{	 name: "Kbt",	 type: "Kbt_1",	 n: "SwM7364bc84",	 x: 32.5,	 y: 24.5
		},
		{	 name: "Sync",	 type: "OffOn",	 n: "SwM278ebb",	 x: 60.5,	 y: 20.5
		},
		{	 name: "RatioFixed",	 type: "RatioFixed",	 n: "SwM4a67b653",	 x: 97.5,	 y: 4.5
		},
		{	 name: "FreqCoarse",	 type: "OpFreqCoarse",	 n: "KnobMedium",	 x: 146.5,	 y: 15.5
		},
		{	 name: "FreqFine",	 type: "OpFreqFine",	 n: "KnobMedium",	 x: 176.5,	 y: 15.5
		},
		{	 name: "FreqDetune",	 type: "OpFreqDetune",	 n: "KnobSpin",	 x: 221.5,	 y: 16.5
		},
		{	 name: "Vel",	 type: "OpVel",	 n: "KnobSpin",	 x: 198.5,	 y: 51.5
		},
		{	 name: "RateScale",	 type: "OpRateScale",	 n: "KnobSpin",	 x: 234.5,	 y: 51.5
		},
		{	 name: "R1",	 type: "OpTime",	 n: "KnobMedium",	 x: 38.5,	 y: 99.5
		},
		{	 name: "L1",	 type: "OpLevel",	 n: "KnobMedium",	 x: 64.5,	 y: 99.5
		},
		{	 name: "R2",	 type: "OpTime",	 n: "KnobMedium",	 x: 93.5,	 y: 99.5
		},
		{	 name: "L2",	 type: "OpLevel",	 n: "KnobMedium",	 x: 119.5,	 y: 99.5
		},
		{	 name: "R3",	 type: "OpTime",	 n: "KnobMedium",	 x: 148.5,	 y: 99.5
		},
		{	 name: "L3",	 type: "OpLevel",	 n: "KnobMedium",	 x: 174.5,	 y: 99.5
		},
		{	 name: "R4",	 type: "OpTime",	 n: "KnobMedium",	 x: 203.5,	 y: 99.5
		},
		{	 name: "L4",	 type: "OpLevel",	 n: "KnobMedium",	 x: 229.5,	 y: 99.5
		},
		{	 name: "AMod",	 type: "OpAmod",	 n: "KnobSpin",	 x: 18.5,	 y: 123.5
		},
		{	 name: "BrPoint",	 type: "OpBrPpoint",	 n: "KnobSpin",	 x: 57.5,	 y: 155.5
		},
		{	 name: "LDepthMode",	 type: "OpDepthMode",	 n: "SwM244d5d6c",	 x: 74.5,	 y: 164.5
		},
		{	 name: "LDepth",	 type: "OpDepth",	 n: "KnobSpin",	 x: 125.5,	 y: 155.5
		},
		{	 name: "RDepthMode",	 type: "OpDepthMode",	 n: "SwM244d5d6c",	 x: 142.5,	 y: 164.5
		},
		{	 name: "RDepth",	 type: "OpDepth",	 n: "KnobSpin",	 x: 193.5,	 y: 155.5
		},
		{	 name: "OutLevel",	 type: "OpLevel",	 n: "KnobMedium",	 x: 211.5,	 y: 155.5
		},
		{	 name: "Active",	 type: "ActiveMonitor",	 n: "SwM4d",	 x: 241.25,	 y: 150.5
		},
		{	 name: "EnvKB",	 type: "OffOn",	 n: "SwM957",	 x: 36.5,	 y: 55.5
		}
	],
	modes: [],
	ve: [
		{	 type: "graph",	 x: 87,	 y: 43,	 w: 85,	 h: 28
		},
		{	 type: "graph",	 x: 103,	 y: 127,	 w: 63,	 h: 24
		},
		{	 type: "valueDisplay",	 x: 37,	 y: 83,	 w: 22,	 ref: 8
		},
		{	 type: "valueDisplay",	 x: 63,	 y: 83,	 w: 22,	 ref: 9
		},
		{	 type: "valueDisplay",	 x: 92,	 y: 83,	 w: 22,	 ref: 10
		},
		{	 type: "valueDisplay",	 x: 118,	 y: 83,	 w: 22,	 ref: 11
		},
		{	 type: "valueDisplay",	 x: 147,	 y: 83,	 w: 22,	 ref: 12
		},
		{	 type: "valueDisplay",	 x: 173,	 y: 83,	 w: 22,	 ref: 13
		},
		{	 type: "valueDisplay",	 x: 202,	 y: 83,	 w: 22,	 ref: 14
		},
		{	 type: "valueDisplay",	 x: 228,	 y: 83,	 w: 22,	 ref: 15
		},
		{	 type: "text",	 x: 68,	 y: 81,	 t: "L1"
		},
		{	 type: "text",	 x: 43,	 y: 81,	 t: "R1"
		},
		{	 type: "text",	 x: 97,	 y: 81,	 t: "R2"
		},
		{	 type: "text",	 x: 123,	 y: 81,	 t: "L2"
		},
		{	 type: "text",	 x: 178,	 y: 81,	 t: "L3"
		},
		{	 type: "text",	 x: 232,	 y: 81,	 t: "L4"
		},
		{	 type: "text",	 x: 152,	 y: 81,	 t: "R3"
		},
		{	 type: "text",	 x: 206,	 y: 81,	 t: "R4"
		},
		{	 type: "text",	 x: 3,	 y: 22,	 t: "Pitch"
		},
		{	 type: "valueDisplay",	 x: 89,	 y: 20,	 w: 50,	 ref: 4
		},
		{	 type: "text",	 x: 141,	 y: 13,	 t: "Coarse"
		},
		{	 type: "text",	 x: 177,	 y: 13,	 t: "Fine"
		},
		{	 type: "valueDisplay",	 x: 204,	 y: 19,	 w: 15,	 ref: 5
		},
		{	 type: "text",	 x: 236,	 y: 18,	 t: "FM"
		},
		{	 type: "text",	 x: 201,	 y: 13,	 t: "Detune"
		},
		{	 type: "valueDisplay",	 x: 181,	 y: 54,	 w: 15,	 ref: 6
		},
		{	 type: "valueDisplay",	 x: 217,	 y: 54,	 w: 15,	 ref: 7
		},
		{	 type: "text",	 x: 181,	 y: 50,	 t: "Vel"
		},
		{	 type: "text",	 x: 207,	 y: 50,	 t: "RateScale"
		},
		{	 type: "text",	 x: 3,	 y: 73,	 t: "Gate"
		},
		{	 type: "led",	 x: 17,	 y: 77,	 w: 6.5
		},
		{	 type: "valueDisplay",	 x: 5,	 y: 126,	 w: 11,	 ref: 16
		},
		{	 type: "text",	 x: 3,	 y: 122,	 t: "AMod"
		},
		{	 type: "valueDisplay",	 x: 210,	 y: 139,	 w: 22,	 ref: 22
		},
		{	 type: "text",	 x: 204,	 y: 136,	 t: "OutLev"
		},
		{	 type: "valueDisplay",	 x: 170,	 y: 162,	 w: 20,	 ref: 21
		},
		{	 type: "text",	 x: 150,	 y: 159,	 t: "R-Depth"
		},
		{	 type: "valueDisplay",	 x: 102,	 y: 162,	 w: 20,	 ref: 19
		},
		{	 type: "text",	 x: 82,	 y: 159,	 t: "L-Depth"
		},
		{	 type: "valueDisplay",	 x: 30,	 y: 158,	 w: 24,	 ref: 17
		},
		{	 type: "text",	 x: 34,	 y: 151,	 t: "BrPoint"
		},
		{	 type: "text",	 x: 3,	 y: 163,	 t: "Vel"
		},
		{	 type: "text",	 x: 3,	 y: 98,	 t: "Note"
		},
		{	 type: "text",	 x: 3,	 y: 48,	 t: "Freq"
		},
		{	 type: "bmp",	 x: 34,	 y: 39,	 id: 82
		},
		{	 type: "bmp",	 x: 35,	 y: 123,	 id: 25
		},
		{	 type: "text",	 x: 33,	 y: 22,	 t: "KBT"
		}
	]
},{
	id: 183,
	height: 3,
	longnm: "Osc Phase Mod",
	shortnm: "OscPM",
	page: {
		name: "Osc",
		ord: 4
	},
	inputs: [
		{	 name: "PitchVar",	 colour: "purple",	 x: 10,	 y: 34
		},
		{	 name: "Sync",	 colour: "red",	 x: 164,	 y: 34
		},
		{	 name: "PhaseMod",	 colour: "red",	 x: 188,	 y: 34
		},
		{	 name: "Pitch",	 colour: "purple",	 x: 10,	 y: 18
		}
	],
	outputs: [
		{	 name: "Out",	 colour: "red",	 x: 246,	 y: 35
		}
	],
	params: [
		{	 name: "FreqCoarse",	 type: "FreqCoarse",	 n: "KnobBig",	 x: 102.5,	 y: 18.5
		},
		{	 name: "FreqFine",	 type: "FreqFine",	 n: "KnobReset",	 x: 130.5,	 y: 14.5
		},
		{	 name: "Kbt",	 type: "Kbt_1",	 n: "SwM7364bc84",	 x: 74.5,	 y: 29.5
		},
		{	 name: "FreqMode",	 type: "FreqMode_3",	 n: "SwM1831ef4d",	 x: 98.5,	 y: 4.5
		},
		{	 name: "PhaseMod",	 type: "Level_100",	 n: "KnobSmall",	 x: 196.5,	 y: 22.5
		},
		{	 name: "Active",	 type: "ActiveMonitor",	 n: "SwM4d",	 x: 226.25,	 y: 29.5
		},
		{	 name: "PitchVar",	 type: "Level_100",	 n: "KnobSmall",	 x: 18.5,	 y: 22.5
		}
	],
	modes: [
		{	 name: "Waveform",	 type: "OscWaveform_2"/* change back to 1 when editor*/, x:220, y:5, w:22, h:18
		}
	],
	ve: [
		{	 type: "path",	 d: "M187,34 L209,34 M9,34 L31,34"
		},
		{	 type: "valueDisplay",	 x: 46,	 y: 14,	 w: 50,	 ref: [0,1,3]
		},
		{	 type: "text",	 x: 185,	 y: 11,	 t: "Phase"
		},
		{	 type: "text",	 x: 130,	 y: 13,	 t: "Cent"
		},
		{	 type: "text",	 x: 154,	 y: 24,	 t: "Sync"
		},
		{	 type: "text",	 x: 189,	 y: 20,	 t: "Mod"
		},
		{	 type: "text",	 x: 16,	 y: 20,	 t: "Pitch"
		},
		{	 type: "text",	 x: 54,	 y: 38,	 t: "KBT"
		}
	]
},{
	id: 196,
	height: 3,
	longnm: "Osc Percussion",
	shortnm: "OscPerc",
	page: {
		name: "Osc",
		ord: 11
	},
	inputs: [
		{	 name: "Pitch",	 colour: "purple",	 x: 10,	 y: 18
		},
		{	 name: "PitchVar",	 colour: "purple",	 x: 10,	 y: 34
		},
		{	 name: "Trig",	 colour: "red",	 x: 50,	 y: 34
		}
	],
	outputs: [
		{	 name: "Out",	 colour: "red",	 x: 246,	 y: 35
		}
	],
	params: [
		{	 name: "FreqCoarse",	 type: "FreqCoarse",	 n: "KnobBig",	 x: 121.5,	 y: 18.5
		},
		{	 name: "FreqFine",	 type: "FreqFine",	 n: "KnobReset",	 x: 149.5,	 y: 14.5
		},
		{	 name: "FreqMode",	 type: "FreqMode_3",	 n: "SwM1831ef4d",	 x: 117.5,	 y: 4.5
		},
		{	 name: "Kbt",	 type: "Kbt_1",	 n: "SwM7364bc84",	 x: 94.5,	 y: 29.5
		},
		{	 name: "PitchMod",	 type: "Level_100",	 n: "KnobSmall",	 x: 18.5,	 y: 22.5
		},
		{	 name: "Decay",	 type: "Level_100",	 n: "KnobMedium",	 x: 173.5,	 y: 20.5
		},
		{	 name: "Click",	 type: "Level_100",	 n: "KnobMedium",	 x: 197.5,	 y: 20.5
		},
		{	 name: "Punch",	 type: "OffOn2",	 n: "SwM7364bc84",	 x: 228.5,	 y: 13.5
		},
		{	 name: "Active",	 type: "ActiveMonitor",	 n: "SwM4d",	 x: 226.25,	 y: 29.5
		}
	],
	modes: [],
	ve: [
		{	 type: "path",	 d: "M9,34 L31,34"
		},
		{	 type: "text",	 x: 174,	 y: 17,	 t: "Dcy"
		},
		{	 type: "text",	 x: 44,	 y: 27,	 t: "Trig"
		},
		{	 type: "valueDisplay",	 x: 66,	 y: 14,	 w: 50,	 ref: [0,1,2]
		},
		{	 type: "text",	 x: 16,	 y: 20,	 t: "Pitch"
		},
		{	 type: "text",	 x: 196,	 y: 17,	 t: "Click"
		},
		{	 type: "text",	 x: 148,	 y: 13,	 t: "Cent"
		},
		{	 type: "text",	 x: 224,	 y: 11,	 t: "Punch"
		},
		{	 type: "text",	 x: 74,	 y: 38,	 t: "KBT"
		}
	]
}, ///end of Osc
/// start of FX
{
	id: 12,
	height: 3,
	longnm: "reverb",
	shortnm: "Reverb",
	page: {
		name: "FX",
		ord: 7
	},
	inputs: [
		{	 name: "InL",	 colour: "red",	 x: 226,	 y: 9
		},
		{	 name: "InR",	 colour: "red",	 x: 246,	 y: 9
		}
	],
	outputs: [
		{	 name: "OutL",	 colour: "red",	 x: 226,	 y: 35
		},
		{	 name: "OutR",	 colour: "red",	 x: 246,	 y: 35
		}
	],
	params: [
		{	 name: "Time",	 type: "ReverbTime",	 n: "KnobMedium",	 x: 94.5,	 y: 20.5
		},
		{	 name: "Brightness",	 type: "Level_100",	 n: "KnobMedium",	 x: 149.5,	 y: 20.5
		},
		{	 name: "DryWet",	 type: "Level_100",	 n: "KnobMedium",	 x: 180.5,	 y: 20.5
		},
		{	 name: "Active",	 type: "ActiveMonitor",	 n: "SwM42",	 x: 206.25,	 y: 29.5
		}
	],
	modes: [
		{	 name: "RoomType",	 type: "RoomType"
		}
	],
	ve: [
		{	 type: "path",	 d: "M226,11 L226,31 M246,12 L246,32 M197,34 L213,34"
		},
		{	 type: "text",	 x: 79,	 y: 17,	 t: "Time"
		},
		{	 type: "valueDisplay",	 x: 56,	 y: 27,	 w: 35,	 ref: 0
		},
		{	 type: "text",	 x: 119,	 y: 17,	 t: "Brightness"
		},
		{	 type: "valueDisplay",	 x: 120,	 y: 27,	 w: 26,	 ref: 1
		},
		{	 type: "text",	 x: 3,	 y: 24,	 t: "Type"
		},
		{	 type: "text",	 x: 233,	 y: 13,	 t: "R"
		},
		{	 type: "text",	 x: 213,	 y: 13,	 t: "L"
		},
		{	 type: "text",	 x: 170,	 y: 17,	 t: "Dry/Wet"
		}
	]
},{
	id: 63,
	height: 3,
	longnm: "Scratch",
	shortnm: "Scratch",
	page: {
		name: "FX",
		ord: 6
	},
	inputs: [
		{	 name: "In",	 colour: "red",	 x: 246,	 y: 9
		},
		{	 name: "Mod",	 colour: "blue",	 x: 17,	 y: 34
		}
	],
	outputs: [
		{	 name: "Out",	 colour: "red",	 x: 246,	 y: 35
		}
	],
	params: [
		{	 name: "Ratio",	 type: "ScratchRatio",	 n: "KnobReset",	 x: 139.5,	 y: 14.5
		},
		{	 name: "RatioMod",	 type: "Level_100",	 n: "KnobSmall",	 x: 25.5,	 y: 22.5
		},
		{	 name: "Delay",	 type: "ScratchDelay",	 n: "SwM55ef4dc1",	 x: 195.5,	 y: 20.5
		},
		{	 name: "Active",	 type: "ActiveMonitor",	 n: "SwM4d",	 x: 241.25,	 y: 17.5
		}
	],
	modes: [],
	ve: [
		{	 type: "path",	 d: "M17,34 L39,34 M246,10 L246,35"
		},
		{	 type: "text",	 x: 87,	 y: 24,	 t: "Pitch Ratio"
		},
		{	 type: "text",	 x: 200,	 y: 17,	 t: "Delay"
		},
		{	 type: "valueDisplay",	 x: 87,	 y: 27,	 w: 49,	 ref: 0
		},
		{	 type: "text",	 x: 3,	 y: 26,	 t: "Ratio"
		}
	]
},{
	id: 89,
	height: 3,
	longnm: "Flanger",
	shortnm: "Flanger",
	page: {
		name: "FX",
		ord: 2
	},
	inputs: [
		{	 name: "In",	 colour: "red",	 x: 246,	 y: 9
		}
	],
	outputs: [
		{	 name: "Out",	 colour: "red",	 x: 246,	 y: 35
		}
	],
	params: [
		{	 name: "Rate",	 type: "FlangerRate",	 n: "KnobMedium",	 x: 106.5,	 y: 20.5
		},
		{	 name: "Range",	 type: "Level_100",	 n: "KnobMedium",	 x: 152.5,	 y: 20.5
		},
		{	 name: "FeedBack",	 type: "Level_100",	 n: "KnobMedium",	 x: 199.5,	 y: 20.5
		},
		{	 name: "Active",	 type: "ActiveMonitor",	 n: "SwM42",	 x: 241.25,	 y: 17.5
		}
	],
	modes: [],
	ve: [
		{	 type: "path",	 d: "M246,11 L246,32"
		},
		{	 type: "text",	 x: 105,	 y: 17,	 t: "Rate"
		},
		{	 type: "text",	 x: 149,	 y: 17,	 t: "Range"
		},
		{	 type: "text",	 x: 188,	 y: 17,	 t: "Feedback"
		},
		{	 type: "valueDisplay",	 x: 62,	 y: 23,	 w: 40,	 ref: 0
		}
	]
},{
	id: 94,
	height: 3,
	longnm: "Stereo Chorus",
	shortnm: "StChorus",
	page: {
		name: "FX",
		ord: 0
	},
	inputs: [
		{	 name: "In",	 colour: "red",	 x: 234,	 y: 9
		}
	],
	outputs: [
		{	 name: "OutL",	 colour: "red",	 x: 222,	 y: 35
		},
		{	 name: "OutR",	 colour: "red",	 x: 246,	 y: 35
		}
	],
	params: [
		{	 name: "Detune",	 type: "Level_100",	 n: "KnobMedium",	 x: 90.5,	 y: 20.5
		},
		{	 name: "Amount",	 type: "Level_100",	 n: "KnobMedium",	 x: 138.5,	 y: 20.5
		},
		{	 name: "Active",	 type: "ActiveMonitor",	 n: "SwM42",	 x: 229.25,	 y: 17.5
		}
	],
	modes: [],
	ve: [
		{	 type: "path",	 d: "M222,36 L222,23 247,23 247,36 M234,9 L234,24"
		},
		{	 type: "text",	 x: 232,	 y: 39,	 t: "R"
		},
		{	 type: "text",	 x: 209,	 y: 39,	 t: "L"
		},
		{	 type: "text",	 x: 85,	 y: 17,	 t: "Detune"
		},
		{	 type: "text",	 x: 130,	 y: 17,	 t: "Amount"
		}
	]
},{
	id: 98,
	height: 3,
	longnm: "Frequency Shifter",
	shortnm: "FreqShift",
	page: {
		name: "FX",
		ord: 4
	},
	inputs: [
		{	 name: "In",	 colour: "red",	 x: 234,	 y: 9
		},
		{	 name: "Shift",	 colour: "blue",	 x: 17,	 y: 34
		}
	],
	outputs: [
		{	 name: "Dn",	 colour: "red",	 x: 222,	 y: 35
		},
		{	 name: "Up",	 colour: "red",	 x: 246,	 y: 35
		}
	],
	params: [
		{	 name: "FreqShift",	 type: "FreqShiftFreq",	 n: "KnobMedium",	 x: 166.5,	 y: 20.5
		},
		{	 name: "ShiftMod",	 type: "Level_100",	 n: "KnobSmall",	 x: 25.5,	 y: 22.5
		},
		{	 name: "Range",	 type: "FreqShiftRange",	 n: "SwM1bb3873e",	 x: 86.5,	 y: 28.5
		},
		{	 name: "Active",	 type: "ActiveMonitor",	 n: "SwM42",	 x: 229.25,	 y: 17.5
		}
	],
	modes: [],
	ve: [
		{	 type: "path",	 d: "M16,34 L38,34 M222,36 L222,23 247,23 247,36 M234,9 L234,24"
		},
		{	 type: "text",	 x: 3,	 y: 26,	 t: "Shift"
		},
		{	 type: "text",	 x: 228,	 y: 39,	 t: "Up"
		},
		{	 type: "text",	 x: 204,	 y: 39,	 t: "Dn"
		},
		{	 type: "valueDisplay",	 x: 117,	 y: 27,	 w: 46,	 ref: 0
		},
		{	 type: "text",	 x: 83,	 y: 25,	 t: "Range"
		},
		{	 type: "text",	 x: 117,	 y: 24,	 t: "Freq Shift"
		}
	]
},{
	id: 118,
	height: 3,
	longnm: "Digitizer",
	shortnm: "Digitizer",
	page: {
		name: "FX",
		ord: 3
	},
	inputs: [
		{	 name: "In",	 colour: "purple",	 x: 246,	 y: 9
		},
		{	 name: "Rate",	 colour: "purple",	 x: 17,	 y: 34
		}
	],
	outputs: [
		{	 name: "Out",	 colour: "purple",	 x: 246,	 y: 35
		}
	],
	params: [
		{	 name: "Bits",	 type: "DigitizerBits",	 n: "KnobSpin",	 x: 206.5,	 y: 20.5
		},
		{	 name: "Rate",	 type: "DigitizerRate",	 n: "KnobMedium",	 x: 131.5,	 y: 20.5
		},
		{	 name: "RateMod",	 type: "Level_100",	 n: "KnobSmall",	 x: 25.5,	 y: 22.5
		},
		{	 name: "Active",	 type: "ActiveMonitor",	 n: "SwM42",	 x: 241.25,	 y: 17.5
		}
	],
	modes: [],
	ve: [
		{	 type: "path",	 d: "M246,11 L246,32 M16,34 L38,34"
		},
		{	 type: "valueDisplay",	 x: 180,	 y: 27,	 w: 23,	 ref: 0
		},
		{	 type: "text",	 x: 161,	 y: 36,	 t: "Bits"
		},
		{	 type: "text",	 x: 160,	 y: 17,	 t: "Quantization"
		},
		{	 type: "text",	 x: 84,	 y: 17,	 t: "Sample Rate"
		},
		{	 type: "valueDisplay",	 x: 84,	 y: 27,	 w: 44,	 ref: 1
		},
		{	 type: "text",	 x: 3,	 y: 26,	 t: "Rate"
		}
	]
},{
	id: 150,
	height: 5,
	longnm: "Compressor",
	shortnm: "Compressor",
	page: {
		name: "FX",
		ord: 8
	},
	inputs: [
		{	 name: "InL",	 colour: "red",	 x: 231,	 y: 31
		},
		{	 name: "InR",	 colour: "red",	 x: 246,	 y: 31
		},
		{	 name: "SideChain",	 colour: "red",	 x: 85,	 y: 9
		}
	],
	outputs: [
		{	 name: "OutR",	 colour: "red",	 x: 246,	 y: 65
		},
		{	 name: "OutL",	 colour: "red",	 x: 231,	 y: 65
		}
	],
	params: [
		{	 name: "Threshold",	 type: "Threshold_42",	 n: "KnobMedium",	 x: 10.5,	 y: 50.5
		},
		{	 name: "Ratio",	 type: "CompressorRatio",	 n: "KnobMedium",	 x: 43.5,	 y: 50.5
		},
		{	 name: "Attack",	 type: "CompressorAttack",	 n: "KnobMedium",	 x: 79.5,	 y: 50.5
		},
		{	 name: "Release",	 type: "CompressorRelease",	 n: "KnobMedium",	 x: 115.5,	 y: 50.5
		},
		{	 name: "RefLevel",	 type: "CompressorRefLevel",	 n: "KnobMedium",	 x: 152.5,	 y: 50.5
		},
		{	 name: "Side Chain",	 type: "OffOn", w:50,	 n: "SwM4ed7e948",	 x: 93.5,	 y: 4.5
		},
		{	 name: "Active",	 type: "ActiveMonitor",	 n: "SwM42",	 x: 211.25,	 y: 59.5
		}
	],
	modes: [],
	ve: [
		{	 type: "path",	 d: "M246,30 L246,43 M246,53 L246,67 M241,43 L241,53 251,53 251,43z M231,30 L231,43 M231,53 L231,67 M226,43 L226,53 236,53 236,43z"
		},
		{	 type: "text",	 x: 4,	 y: 30,	 t: "Thresh"
		},
		{	 type: "text",	 x: 42,	 y: 30,	 t: "Ratio"
		},
		{	 type: "text",	 x: 74,	 y: 30,	 t: "Attack"
		},
		{	 type: "text",	 x: 108,	 y: 30,	 t: "Release"
		},
		{	 type: "text",	 x: 145,	 y: 30,	 t: "Ref Lvl"
		},
		{	 type: "text",	 x: 226,	 y: 23,	 t: "L"
		},
		{	 type: "text",	 x: 242,	 y: 23,	 t: "R"
		},
		{	 type: "led",	 x: 195,	 y: 65,	 w: 10
		},
		{	 type: "led",	 x: 195,	 y: 59,	 w: 10
		},
		{	 type: "led",	 x: 195,	 y: 29,	 w: 10
		},
		{	 type: "led",	 x: 195,	 y: 23,	 w: 10
		},
		{	 type: "led",	 x: 195,	 y: 41,	 w: 10
		},
		{	 type: "led",	 x: 195,	 y: 35,	 w: 10
		},
		{	 type: "led",	 x: 195,	 y: 47,	 w: 10
		},
		{	 type: "led",	 x: 195,	 y: 53,	 w: 10
		},
		{	 type: "led",	 x: 195,	 y: 17,	 w: 10
		},
		{	 type: "led",	 x: 195,	 y: 11,	 w: 10
		},
		{	 type: "text",	 x: 181,	 y: 69,	 t: "30"
		},
		{	 type: "text",	 x: 181,	 y: 59,	 t: "24"
		},
		{	 type: "text",	 x: 183,	 y: 49,	 t: "15"
		},
		{	 type: "text",	 x: 186,	 y: 38,	 t: "9"
		},
		{	 type: "text",	 x: 186,	 y: 28,	 t: "4"
		},
		{	 type: "text",	 x: 188,	 y: 18,	 t: "1"
		},
		{	 type: "text",	 x: 166,	 y: 9,	 t: "Gain Reduction"
		},
		{	 type: "valueDisplay",	 x: 4,	 y: 33,	 w: 32,	 ref: 0
		},
		{	 type: "valueDisplay",	 x: 39,	 y: 33,	 w: 30,	 ref: 1
		},
		{	 type: "valueDisplay",	 x: 74,	 y: 33,	 w: 32,	 ref: 2
		},
		{	 type: "valueDisplay",	 x: 109,	 y: 33,	 w: 32,	 ref: 3
		},
		{	 type: "valueDisplay",	 x: 146,	 y: 33,	 w: 32,	 ref: 4
		}
	]
},{
	id: 167,
	height: 3,
	longnm: "Pitch Shifter",
	shortnm: "PShift",
	page: {
		name: "FX",
		ord: 5
	},
	inputs: [
		{	 name: "In",	 colour: "red",	 x: 246,	 y: 9
		},
		{	 name: "Pitch",	 colour: "blue",	 x: 17,	 y: 34
		}
	],
	outputs: [
		{	 name: "Out",	 colour: "red",	 x: 246,	 y: 35
		}
	],
	params: [
		{	 name: "ShiftSemi",	 type: "PShiftCoarse",	 n: "KnobReset",	 x: 139.5,	 y: 14.5
		},
		{	 name: "ShiftFine",	 type: "PShiftFine",	 n: "KnobReset",	 x: 166.5,	 y: 14.5
		},
		{	 name: "ShiftMod",	 type: "Level_100",	 n: "KnobSmall",	 x: 25.5,	 y: 22.5
		},
		{	 name: "Delay",	 type: "ScratchDelay",	 n: "SwM54143093",	 x: 195.5,	 y: 20.5
		},
		{	 name: "Active",	 type: "ActiveMonitor",	 n: "SwM4d",	 x: 241.25,	 y: 17.5
		}
	],
	modes: [],
	ve: [
		{	 type: "path",	 d: "M16,34 L38,34 M246,11 L246,36"
		},
		{	 type: "text",	 x: 137,	 y: 11,	 t: "Semi"
		},
		{	 type: "text",	 x: 167,	 y: 11,	 t: "Fine"
		},
		{	 type: "text",	 x: 201,	 y: 17,	 t: "Delay"
		},
		{	 type: "valueDisplay",	 x: 76,	 y: 27,	 w: 60,	 ref: 0
		},
		{	 type: "text",	 x: 3,	 y: 26,	 t: "Pitch"
		},
		{	 type: "text",	 x: 82,	 y: 24,	 t: "Pitch Shift"
		}
	]
},{
	id: 192,
	height: 2,
	longnm: "Phaser",
	shortnm: "Phaser",
	page: {
		name: "FX",
		ord: 1
	},
	inputs: [
		{	 name: "In",	 colour: "red",	 x: 216,	 y: 16
		}
	],
	outputs: [
		{	 name: "Out",	 colour: "red",	 x: 246,	 y: 16
		}
	],
	params: [
		{	 name: "Type",	 type: "PhaserType",	 n: "SwM2f94dc03",	 x: 9.5,	 y: 14.5
		},
		{	 name: "Freq",	 type: "PhaserFreq",	 n: "KnobMedium",	 x: 124.5,	 y: 5.5
		},
		{	 name: "FeedBack",	 type: "Level_100",	 n: "KnobMedium",	 x: 182.5,	 y: 5.5
		},
		{	 name: "Active",	 type: "ActiveMonitor",	 n: "SwM42",	 x: 226.25,	 y: 10.5
		}
	],
	modes: [],
	ve: [
		{	 type: "path",	 d: "M213,16 L249,16"
		},
		{	 type: "text",	 x: 92,	 y: 9,	 t: "Rate"
		},
		{	 type: "text",	 x: 158,	 y: 14,	 t: "Feed"
		},
		{	 type: "valueDisplay",	 x: 81,	 y: 12,	 w: 40,	 ref: 1
		},
		{	 type: "text",	 x: 158,	 y: 22,	 t: "back"
		}
	]
}, ///end of FX
/// start of Level
{
	id: 43,
	height: 2,
	longnm: "Constant Value",
	shortnm: "Constant",
	page: {
		name: "Level",
		ord: 0
	},
	inputs: [],
	outputs: [
		{	 name: "Out",	 colour: "blue",	 x: 246,	 y: 15
		}
	],
	params: [
		{	 name: "Level",	 type: "LevBipUni",	 n: "KnobMedium",	 x: 163.5,	 y: 5.5
		},
		{	 name: "BipUni",	 type: "BipUni",	 n: "SwM5b04c56d",	 x: 54.5,	 y: 14.5
		}
	],
	modes: [],
	ve: [
		{	 type: "path",	 d: "M207,15 L247,15"
		},
		{	 type: "valueDisplay",	 x: 187,	 y: 8,	 w: 28,	 ref: 0
		}
	]
},{
	id: 44,
	height: 2,
	longnm: "Level Multiplier",
	shortnm: "LevMult",
	page: {
		name: "Level",
		ord: 6
	},
	inputs: [
		{	 name: "In",	 colour: "purple",	 x: 216,	 y: 18
		},
		{	 name: "Mod",	 colour: "purple",	 x: 186,	 y: 18
		}
	],
	outputs: [
		{	 name: "Out",	 colour: "purple",	 x: 246,	 y: 18
		}
	],
	params: [],
	modes: [],
	ve: [
		{	 type: "path",	 d: "M186,15 L186,6 232,6 232,15"
		},
		{	 type: "bmp",	 x: 220.5,	 y: 11.5,	 id: "HVCA"
		}
	]
},{
	id: 50,
	height: 2,
	longnm: "Constant Switch Toggling",
	shortnm: "ConstSwT",
	page: {
		name: "Level",
		ord: 2
	},
	inputs: [],
	outputs: [
		{	 name: "Out",	 colour: "blue",	 x: 246,	 y: 15
		}
	],
	params: [
		{	 name: "Lev",	 type: "LevBipUni",	 n: "KnobMedium",	 x: 163.5,	 y: 5.5
		},
		{	 name: "On",	 type: "OffOn",	 n: "SwM6b9f5cac",	 x: 111.5,	 y: 8.5, w:44
		},
		{	 name: "BipUni",	 type: "BipUni",	 n: "SwM5b04c56d",	 x: 54.5,	 y: 14.5
		}
	],
	modes: [],
	ve: [
		{	 type: "bmp",	 x: 215,	 y: 3,	 id: "SWcon"
		},
		{	 type: "valueDisplay",	 x: 187,	 y: 8,	 w: 28,	 ref: 0
		}
	]
},{
	id: 59,
	height: 2,
	longnm: "Compare to Level",
	shortnm: "CompLev",
	page: {
		name: "Level",
		ord: 10
	},
	inputs: [
		{	 name: "In",	 colour: "purple",	 x: 126,	 y: 16
		}
	],
	outputs: [
		{	 name: "Out",	 colour: "orange",	 x: 246,	 y: 16
		}
	],
	params: [
		{	 name: "C",	 type: "Bipolar_127",	 n: "KnobMedium",	 x: 173.5,	 y: 5.5
		}
	],
	modes: [],
	ve: [
		{	 type: "valueDisplay",	 x: 149,	 y: 8,	 w: 21,	 ref: 0
		},
		{	 type: "text",	 x: 109,	 y: 20,	 t: "A"
		},
		{	 type: "text",	 x: 213,	 y: 20,	 t: "A>=C"
		},
		{	 type: "text",	 x: 140,	 y: 20,	 t: "C"
		}
	]
},{
	id: 71,
	height: 2,
	longnm: "Envelope Follower",
	shortnm: "EnvFollow",
	page: {
		name: "Level",
		ord: 8
	},
	inputs: [
		{	 name: "In",	 colour: "purple",	 x: 216,	 y: 16
		}
	],
	outputs: [
		{	 name: "Out",	 colour: "blue",	 x: 246,	 y: 16
		}
	],
	params: [
		{	 name: "Attack",	 type: "EnvFollowAttack",	 n: "KnobMedium",	 x: 115.5,	 y: 5.5
		},
		{	 name: "Release",	 type: "EnvFollowRelease",	 n: "KnobMedium",	 x: 183.5,	 y: 5.5
		}
	],
	modes: [],
	ve: [
		{	 type: "valueDisplay",	 x: 80,	 y: 12,	 w: 32,	 ref: 0
		},
		{	 type: "valueDisplay",	 x: 148,	 y: 12,	 w: 32,	 ref: 1
		},
		{	 type: "bmp",	 x: 220.5,	 y: 9.5,	 id: "box"
		},
		{	 type: "text",	 x: 80,	 y: 9,	 t: "Attack"
		},
		{	 type: "text",	 x: 147,	 y: 9,	 t: "Release"
		}
	]
},{
	id: 81,
	height: 2,
	longnm: "Level Amplifier",
	shortnm: "LevAmp",
	page: {
		name: "Level",
		ord: 5
	},
	inputs: [
		{	 name: "In",	 colour: "purple",	 x: 216,	 y: 18
		}
	],
	outputs: [
		{	 name: "Out",	 colour: "purple",	 x: 246,	 y: 18
		}
	],
	params: [
		{	 name: "Gain",	 type: "LevAmpGain",	 n: "KnobMedium",	 x: 140.5,	 y: 5.5
		},
		{	 name: "Type",	 type: "LinDB",	 n: "SwM78555a87",	 x: 54.5,	 y: 14.5
		}
	],
	modes: [],
	ve: [
		{	 type: "path",	 d: "M181,15 L181,5 232,5 232,14"
		},
		{	 type: "bmp",	 x: 221,	 y: 11,	 id: "HVCA"
		},
		{	 type: "valueDisplay",	 x: 164,	 y: 10,	 w: 32,	 ref: 0
		}
	]
},{
	id: 112,
	height: 2,
	longnm: "Level Add",
	shortnm: "LevAdd",
	page: {
		name: "Level",
		ord: 3
	},
	inputs: [
		{	 name: "In",	 colour: "purple",	 x: 216,	 y: 18
		}
	],
	outputs: [
		{	 name: "Out",	 colour: "purple",	 x: 246,	 y: 18
		}
	],
	params: [
		{	 name: "Level",	 type: "LevBipUni",	 n: "KnobMedium",	 x: 142.5,	 y: 5.5
		},
		{	 name: "BipUni",	 type: "BipUni",	 n: "SwM5b04c56d",	 x: 54.5,	 y: 14.5
		}
	],
	modes: [],
	ve: [
		{	 type: "path",	 d: "M231,5 L181,5 181,15 M231,5 L231,12 M236,18 L246,18"
		},
		{	 type: "valueDisplay",	 x: 167,	 y: 10,	 w: 28,	 ref: 0
		},
		{	 type: "bmp",	 x: 220,	 y: 11.5,	 id: "ADD"
		}
	]
},{
	id: 117,
	height: 3,
	longnm: "Level Modulator",
	shortnm: "LevMod",
	page: {
		name: "Level",
		ord: 7
	},
	inputs: [
		{	 name: "In",	 colour: "purple",	 x: 216,	 y: 33
		},
		{	 name: "Mod",	 colour: "purple",	 x: 216,	 y: 12
		},
		{	 name: "ModDepth",	 colour: "purple",	 x: 97,	 y: 34
		}
	],
	outputs: [
		{	 name: "Out",	 colour: "purple",	 x: 246,	 y: 33
		}
	],
	params: [
		{	 name: "ModDepth",	 type: "Level_100",	 n: "KnobSmall",	 x: 105.5,	 y: 22.5
		},
		{	 name: "ModType",	 type: "LevModAmRm",	 n: "KnobReset",	 x: 144.5,	 y: 17.5
		}
	],
	modes: [],
	ve: [
		{	 type: "path",	 d: "M96,34 L118,34"
		},
		{	 type: "bmp",	 x: 220,	 y: 9,	 id: "LMOD"
		},
		{	 type: "text",	 x: 135,	 y: 40,	 t: "0"
		},
		{	 type: "text",	 x: 165,	 y: 40,	 t: "Bal."
		},
		{	 type: "text",	 x: 145,	 y: 14,	 t: "AM"
		},
		{	 type: "text",	 x: 190,	 y: 16,	 t: "Mod"
		},
		{	 type: "text",	 x: 86,	 y: 18,	 t: "Mod depth"
		}
	]
},{
	id: 128,
	height: 2,
	longnm: "Min/Max Compare",
	shortnm: "MinMax",
	page: {
		name: "Level",
		ord: 12
	},
	inputs: [
		{	 name: "A",	 colour: "purple",	 x: 126,	 y: 16
		},
		{	 name: "B",	 colour: "purple",	 x: 156,	 y: 16
		}
	],
	outputs: [
		{	 name: "Min",	 colour: "purple",	 x: 216,	 y: 16
		},
		{	 name: "Max",	 colour: "purple",	 x: 246,	 y: 16
		}
	],
	params: [],
	modes: [],
	ve: [
		{	 type: "text",	 x: 109,	 y: 20,	 t: "A"
		},
		{	 type: "text",	 x: 141,	 y: 20,	 t: "B"
		},
		{	 type: "text",	 x: 222.5,	 y: 20,	 t: "Max"
		},
		{	 type: "text",	 x: 193.5,	 y: 20,	 t: "Min"
		}
	]
},{
	id: 157,
	height: 2,
	longnm: "Level Converter",
	shortnm: "LevConv",
	page: {
		name: "Level",
		ord: 4
	},
	inputs: [
		{	 name: "In",	 colour: "purple",	 x: 216,	 y: 16
		}
	],
	outputs: [
		{	 name: "Out",	 colour: "purple",	 x: 246,	 y: 16
		}
	],
	params: [
		{	 name: "OutputType",	 type: "PosNegInvBipInv",	 n: "levelshift",	 x: 223.5,	 y: 10.5
		},
		{	 name: "InputType",	 type: "BipPosNeg",	 n: "SwM33b2d94e",	 x: 96.5,	 y: 12.5
		}
	],
	modes: [],
	ve: [
		{	 type: "path",	 d: "M216,16 L248,16"
		},
		{	 type: "text",	 x: 104,	 y: 9,	 t: "In signal type"
		}
	]
},{
	id: 159,
	height: 2,
	longnm: "Compare to Signal",
	shortnm: "CompSig",
	page: {
		name: "Level",
		ord: 11
	},
	inputs: [
		{	 name: "A",	 colour: "purple",	 x: 126,	 y: 16
		},
		{	 name: "B",	 colour: "purple",	 x: 156,	 y: 16
		}
	],
	outputs: [
		{	 name: "Out",	 colour: "orange",	 x: 246,	 y: 16
		}
	],
	params: [],
	modes: [],
	ve: [
		{	 type: "text",	 x: 109,	 y: 20,	 t: "A"
		},
		{	 type: "text",	 x: 141,	 y: 20,	 t: "B"
		},
		{	 type: "text",	 x: 213,	 y: 20,	 t: "A>=B"
		}
	]
},{
	id: 188,
	height: 2,
	longnm: "Constant Switch Momentary",
	shortnm: "ConstSwM",
	page: {
		name: "Level",
		ord: 1
	},
	inputs: [],
	outputs: [
		{	 name: "Out",	 colour: "blue",	 x: 246,	 y: 15
		}
	],
	params: [
		{	 name: "Lev",	 type: "LevBipUni",	 n: "KnobMedium",	 x: 163.5,	 y: 5.5
		},
		{	 name: "On",	 type: "OffOn",	 n: "SwM6b9f5cac",	 x: 111.5,	 y: 8.5, w:44
		},
		{	 name: "BipUni",	 type: "BipUni",	 n: "SwM5b04c56d",	 x: 54.5,	 y: 14.5
		}
	],
	modes: [],
	ve: [
		{	 type: "valueDisplay",	 x: 187,	 y: 8,	 w: 28,	 ref: 0
		},
		{	 type: "bmp",	 x: 215,	 y: 3,	 id: "SWcon"
		},
		{	 type: "bmp",	 x: 102,	 y: 8.5,	 id: "SWMcon"
		}
	]
},{
	id: 189,
	height: 3,
	longnm: "Noise Gate",
	shortnm: "NoiseGate",
	page: {
		name: "Level",
		ord: 9
	},
	inputs: [
		{	 name: "In",	 colour: "purple",	 x: 246,	 y: 9
		}
	],
	outputs: [
		{	 name: "Out",	 colour: "purple",	 x: 246,	 y: 35
		},
		{	 name: "Env",	 colour: "blue",	 x: 229,	 y: 35
		}
	],
	params: [
		{	 name: "Threshold",	 type: "Threshold_127",	 n: "KnobMedium",	 x: 187.5,	 y: 20.5
		},
		{	 name: "Attack",	 type: "NoiseGateAttack",	 n: "KnobMedium",	 x: 48.5,	 y: 20.5
		},
		{	 name: "Release",	 type: "NoiseGateRelease",	 n: "KnobMedium",	 x: 113.5,	 y: 20.5
		},
		{	 name: "Active",	 type: "ActiveMonitor",	 n: "SwM42",	 x: 241.25,	 y: 17.5
		}
	],
	modes: [],
	ve: [
		{	 type: "path",	 d: "M246,8 L246,38"
		},
		{	 type: "led",	 x: 213,	 y: 32,	 w: 6.5
		},
		{	 type: "text",	 x: 11,	 y: 24,	 t: "Attack"
		},
		{	 type: "text",	 x: 75,	 y: 24,	 t: "Release"
		},
		{	 type: "text",	 x: 141,	 y: 24,	 t: "Threshold"
		},
		{	 type: "valueDisplay",	 x: 142,	 y: 27,	 w: 42,	 ref: 0
		},
		{	 type: "valueDisplay",	 x: 10,	 y: 27,	 w: 35,	 ref: 1
		},
		{	 type: "valueDisplay",	 x: 75,	 y: 27,	 w: 35,	 ref: 2
		}
	]
},{
	id: 195,
	height: 2,
	longnm: "Modulation Amount",
	shortnm: "ModAmt",
	page: {
		name: "Level",
		ord: 13
	},
	inputs: [
		{	 name: "In",	 colour: "purple",	 x: 196,	 y: 18
		},
		{	 name: "Mod",	 colour: "purple",	 x: 216,	 y: 18
		}
	],
	outputs: [
		{	 name: "Out",	 colour: "purple",	 x: 246,	 y: 18
		}
	],
	params: [
		{	 name: "ModDepth",	 type: "Level_100",	 n: "KnobMedium",	 x: 99.5,	 y: 5.5
		},
		{	 name: "On",	 type: "OffOn",	 n: "SwM9ff",	 x: 123.5,	 y: 8.5, w:42
		},
		{	 name: "ExpLin",	 type: "ExpLin_1",	 n: "SwM1512f642",	 x: 4.5,	 y: 14.5
		},
		{	 name: "InvertMode",	 type: "ModAmtInvert",	 n: "SwM614c012",	 x: 38.5,	 y: 14.5
		}
	],
	modes: [],
	ve: [
		{	 type: "path",	 d: "M232,15 L232,7 196,7 196,15"
		},
		{	 type: "bmp",	 x: 220.5,	 y: 11.5,	 id: "HVCA"
		},
		{	 type: "text",	 x: 78,	 y: 14,	 t: "Mod"
		},
		{	 type: "text",	 x: 73,	 y: 23,	 t: "depth"
		},
		{	 type: "text",	 x: 169,	 y: 21,	 t: "Mod"
		}
	]
},///end of Level
{///start of mixer
	id: 18,
	height: 2,
	longnm: "Cross Fader",
	shortnm: "X-Fade",
	page: {
		name: "Mixer",
		ord: 13
	},
	inputs: [
		{	name: "In1",	colour: "purple",	x: 186,	y: 18
		},
		{	name: "In2",	colour: "purple",	x: 216,	y: 18
		},
		{	name: "Mod",	colour: "purple",	x: 93,	y: 19
		}
	],
	outputs: [
		{	name: "Out",	colour: "purple",	x: 246,	y: 18
		}
	],
	params: [
		{	name: "MixMod",	type: "Level_100",	n: "KnobSmall",	x: 101.5,	y: 7.5
		},
		{	name: "Mix",	type: "Bipolar_127",	n: "KnobReset",	x: 140.5,	y: 3.5
		},
		{	name: "LogLin",	type: "LogLin",	n: "SwM778423e9",	x: 42.5,	y: 14.5
		}
	],
	modes: [],
	ve: [
		{	type: "path",	d:"M246,12l0,-9 -45.5,0 1.5,3 1.5,-3 M186,12 l0,-5 30,0 0,2 -30,0 m30,0 0,3"
		},
		{	type: "line",	"x1": 92,	"y1": 19,	"x2": 114,	"y2": 19
		},
		{	type: "text",	x: 133,	y: 24,	t: "1"
		},
		{	type: "text",	x: 161,	y: 24,	t: "2"
		},
		{	type: "text",	x: 175,	y: 23,	t: "1"
		},
		{	type: "text",	x: 203,	y: 23,	t: "2"
		},
		{	type: "bmp",	x: 184,	y: 4,	id: 12
		}
	]
},{
	id: 19,
	height: 2,
	longnm: "Mixer 4-1 B",
	shortnm: "Mix4-1B",
	page: {
		name: "Mixer",
		ord: 5
	},
	inputs: [
		{	name: "In1",	colour: "purple",	x: 82,	y: 18
		},
		{	name: "In2",	colour: "purple",	x: 120,	y: 18
		},
		{	name: "In3",	colour: "purple",	x: 158,	y: 18
		},
		{	name: "In4",	colour: "purple",	x: 196,	y: 18
		},
		{	name: "Chain",	colour: "purple",	x: 10,	y: 19
		}
	],
	outputs: [
		{	name: "Out",	colour: "purple",	x: 246,	y: 18
		}
	],
	params: [
		{	name: "Lev1",	type: "MixLevel",	n: "KnobMedium",	x: 90.5,	y: 5.5
		},
		{	name: "Lev2",	type: "MixLevel",	n: "KnobMedium",	x: 128.5,	y: 5.5
		},
		{	name: "Lev3",	type: "MixLevel",	n: "KnobMedium",	x: 166.5,	y: 5.5
		},
		{	name: "Lev4",	type: "MixLevel",	n: "KnobMedium",	x: 204.5,	y: 5.5
		},
		{	name: "ExpLin",	type: "ExpLin_2",	n: "SwM699ffc08",	x: 42.5,	y: 14.5
		}
	],
	modes: [],
	ve: [
		{	type: "text",	x: 84,	y: 11,	t: "1"
		},
		{	type: "text",	x: 122,	y: 11,	t: "2"
		},
		{	type: "text",	x: 160,	y: 11,	t: "3"
		},
		{	type: "text",	x: 197,	y: 11,	t: "4"
		},
		{	type: "text",	x: 17,	y: 24,	t: "Chain"
		}
	]
},{
	id: 40,
	height: 4,
	longnm: "Mixer 8-1 B",
	shortnm: "Mix8-1B",
	page: {
		name: "Mixer",
		ord: 9
	},
	inputs: [
		{	name: "In1",	colour: "purple",	x: 51,	y: 25
		},
		{	name: "In2",	colour: "purple",	x: 76,	y: 25
		},
		{	name: "In3",	colour: "purple",	x: 101,	y: 25
		},
		{	name: "In4",	colour: "purple",	x: 126,	y: 25
		},
		{	name: "In5",	colour: "purple",	x: 151,	y: 25
		},
		{	name: "In6",	colour: "purple",	x: 176,	y: 25
		},
		{	name: "In7",	colour: "purple",	x: 201,	y: 25
		},
		{	name: "In8",	colour: "purple",	x: 226,	y: 25
		},
		{	name: "Chain",	colour: "purple",	x: 246,	y: 9
		}
	],
	outputs: [
		{	name: "Out",	colour: "purple",	x: 246,	y: 50
		}
	],
	params: [
		{	name: "Lev1",	type: "MixLevel",	n: "KnobMedium",	x: 39.5,	y: 35.5
		},
		{	name: "Lev2",	type: "MixLevel",	n: "KnobMedium",	x: 64.5,	y: 35.5
		},
		{	name: "Lev3",	type: "MixLevel",	n: "KnobMedium",	x: 89.5,	y: 35.5
		},
		{	name: "Lev4",	type: "MixLevel",	n: "KnobMedium",	x: 114.5,	y: 35.5
		},
		{	name: "Lev5",	type: "MixLevel",	n: "KnobMedium",	x: 139.5,	y: 35.5
		},
		{	name: "Lev6",	type: "MixLevel",	n: "KnobMedium",	x: 164.5,	y: 35.5
		},
		{	name: "Lev7",	type: "MixLevel",	n: "KnobMedium",	x: 189.5,	y: 35.5
		},
		{	name: "Lev8",	type: "MixLevel",	n: "KnobMedium",	x: 214.5,	y: 35.5
		},
		{	name: "ExpLin",	type: "ExpLin_2",	n: "SwM699ffc08",	x: 6.5,	y: 19.5
		},
		{	name: "Pad",	type: "Pad_3",	n: "SwMf9c81c5",	x: 6.5,	y: 43.5
		}
	],
	modes: [],
	ve: [
		{	type: "text",	x: 39,	y: 29,	t: "1"
		},
		{	type: "text",	x: 63,	y: 29,	t: "2"
		},
		{	type: "text",	x: 88,	y: 29,	t: "3"
		},
		{	type: "text",	x: 113,	y: 29,	t: "4"
		},
		{	type: "text",	x: 138,	y: 29,	t: "5"
		},
		{	type: "text",	x: 163,	y: 29,	t: "6"
		},
		{	type: "text",	x: 188,	y: 29,	t: "7"
		},
		{	type: "text",	x: 213,	y: 29,	t: "8"
		},
		{	type: "text",	x: 215,	y: 12,	t: "Chain"
		},
		{	type: "text",	x: 13,	y: 41,	t: "Pad"
		}
	]
},{
	id: 47,
	height: 2,
	longnm: "Pan",
	shortnm: "Pan",
	page: {
		name: "Mixer",
		ord: 12
	},
	inputs: [
		{	name: "In",	colour: "purple",	x: 186,	y: 18
		},
		{	name: "Mod",	colour: "purple",	x: 93,	y: 19
		}
	],
	outputs: [
		{	name: "OutL",	colour: "purple",	x: 216,	y: 18
		},
		{	name: "OutR",	colour: "purple",	x: 246,	y: 18
		}
	],
	params: [
		{	name: "PanMod",	type: "Level_100",	n: "KnobSmall",	x: 101.5,	y: 7.5
		},
		{	name: "Pan",	type: "Bipolar_127",	n: "KnobReset",	x: 140.5,	y: 3.5
		},
		{	name: "LogLin",	type: "LogLin",	n: "SwM778423e9",	x: 42.5,	y: 14.5
		}
	],
	modes: [],
	ve: [
		{	type: "path",	d:"M186,12L186,3 231.5,3 230,6 228.5,3 M216,12 l0,-5 30,0 0,2 -30,0 m30,0 0,3"
		},
		{	type: "line",	"x1": 92,	"y1": 19,	"x2": 114,	"y2": 19
		},
		{	type: "text",	x: 132,	y: 24,	t: "L"
		},
		{	type: "text",	x: 161,	y: 24,	t: "R"
		},
		{	type: "text",	x: 202,	y: 23,	t: "L"
		},
		{	type: "text",	x: 231,	y: 23,	t: "R"
		},
		{	type: "bmp",	x: 184,	y: 4,	id: 12
		}
	]
},{
	id: 48,
	height: 5,
	longnm: "Mixer Stereo",
	shortnm: "MixStereo",
	page: {
		name: "Mixer",
		ord: 11
	},
	inputs: [
		{	name: "In1",	colour: "purple",	x: 15,	y: 27
		},
		{	name: "In2",	colour: "purple",	x: 47,	y: 27
		},
		{	name: "In3",	colour: "purple",	x: 79,	y: 27
		},
		{	name: "In4",	colour: "purple",	x: 111,	y: 27
		},
		{	name: "In5",	colour: "purple",	x: 143,	y: 27
		},
		{	name: "In6",	colour: "purple",	x: 175,	y: 27
		}
	],
	outputs: [
		{	name: "OutL",	colour: "purple",	x: 222,	y: 65
		},
		{	name: "OutR",	colour: "purple",	x: 246,	y: 65
		}
	],
	params: [
		{	name: "Lev1",	type: "Level_100",	n: "KnobMedium",	x: 20.5,	y: 50.5
		},
		{	name: "Lev2",	type: "Level_100",	n: "KnobMedium",	x: 52.5,	y: 50.5
		},
		{	name: "Lev3",	type: "Level_100",	n: "KnobMedium",	x: 84.5,	y: 50.5
		},
		{	name: "Lev4",	type: "Level_100",	n: "KnobMedium",	x: 116.5,	y: 50.5
		},
		{	name: "Lev5",	type: "Level_100",	n: "KnobMedium",	x: 148.5,	y: 50.5
		},
		{	name: "Lev6",	type: "Level_100",	n: "KnobMedium",	x: 180.5,	y: 50.5
		},
		{	name: "Pan1",	type: "Bipolar_127",	n: "KnobReset",	x: 21.5,	y: 22.5
		},
		{	name: "Pan2",	type: "Bipolar_127",	n: "KnobReset",	x: 53.5,	y: 22.5
		},
		{	name: "Pan3",	type: "Bipolar_127",	n: "KnobReset",	x: 85.5,	y: 22.5
		},
		{	name: "Pan4",	type: "Bipolar_127",	n: "KnobReset",	x: 117.5,	y: 22.5
		},
		{	name: "Pan5",	type: "Bipolar_127",	n: "KnobReset",	x: 149.5,	y: 22.5
		},
		{	name: "Pan6",	type: "Bipolar_127",	n: "KnobReset",	x: 181.5,	y: 22.5
		},
		{	name: "LevMaster",	type: "Level_100",	n: "KnobBig",	x: 218.5,	y: 14.5
		}
	],
	modes: [],
	ve: [
		{	type: "text",	x: 12,	y: 21,	t: "1"
		},
		{	type: "text",	x: 43,	y: 21,	t: "2"
		},
		{	type: "text",	x: 75,	y: 21,	t: "3"
		},
		{	type: "text",	x: 107,	y: 21,	t: "4"
		},
		{	type: "text",	x: 139,	y: 21,	t: "5"
		},
		{	type: "text",	x: 171,	y: 21,	t: "6"
		},
		{	type: "text",	x: 3,	y: 44,	t: "Pan"
		},
		{	type: "text",	x: 3,	y: 69,	t: "Lvl"
		},
		{	type: "text",	x: 213,	y: 47,	t: "Master"
		},
		{	type: "text",	x: 208,	y: 11,	t: "Main Out"
		},
		{	type: "text",	x: 218,	y: 58,	t: "L"
		},
		{	type: "text",	x: 242,	y: 58,	t: "R"
		}
	]
},{
	id: 66,
	height: 2,
	longnm: "Scratch",
	shortnm: "Mix2-1B",
	page: {
		name: "Mixer",
		ord: 3
	},
	inputs: [
		{	name: "In1",	colour: "purple",	x: 76,	y: 20
		},
		{	name: "In2",	colour: "purple",	x: 161,	y: 20
		},
		{	name: "Chain",	colour: "purple",	x: 10,	y: 20
		}
	],
	outputs: [
		{	name: "Out",	colour: "purple",	x: 246,	y: 20
		}
	],
	params: [
		{	name: "Inv1",	type: "MixInvert",	n: "SwM11fd1",	x: 82.5,	y: 14.5
		},
		{	name: "Lev1",	type: "MixLevel",	n: "KnobMedium",	x: 131.5,	y: 5.5
		},
		{	name: "Inv2",	type: "MixInvert",	n: "SwM11fd1",	x: 167.5,	y: 14.5
		},
		{	name: "Lev2",	type: "MixLevel",	n: "KnobMedium",	x: 216.5,	y: 5.5
		},
		{	name: "ExpLin",	type: "ExpLin_2",	n: "SwM699ffc08",	x: 41.5,	y: 14.5
		}
	],
	modes: [],
	ve: [
		{	type: "text",	x: 16,	y: 24,	t: "Chain"
		},
		{	type: "valueDisplay",	x: 101,	y: 12,	w: 28,	ref: 1
		},
		{	type: "valueDisplay",	x: 186,	y: 12,	w: 28,	ref: 3
		}
	]
},{
	id: 113,
	height: 2,
	longnm: "Fade 1-2",
	shortnm: "Fade1-2",
	page: {
		name: "Mixer",
		ord: 14
	},
	inputs: [
		{	name: "In",	colour: "purple",	x: 186,	y: 18
		},
		{	name: "Mod",	colour: "purple",	x: 93,	y: 19
		}
	],
	outputs: [
		{	name: "Out1",	colour: "purple",	x: 216,	y: 18
		},
		{	name: "Out2",	colour: "purple",	x: 246,	y: 18
		}
	],
	params: [
		{	name: "Mix",	type: "Fade12Mix",	n: "KnobMedium",	x: 140.5,	y: 5.5
		},
		{	name: "MixMod",	type: "Level_100",	n: "KnobSmall",	x: 101.5,	y: 7.5
		}
	],
	modes: [],
	ve: [
		{	type: "path",	d:"M186,12L186,3 231.5,3 230,6 228.5,3 M216,12 l0,-5 12,0 0,2 -12,0 M246,12 l0,-5 -13.5,0 0,2 13.5,0"
		},
		{	type: "line",	"x1": 92,	"y1": 19,	"x2": 114,	"y2": 19
		},
		{	type: "text",	x: 202,	y: 23,	t: "L"
		},
		{	type: "text",	x: 232,	y: 23,	t: "R"
		},
		{	type: "text",	x: 132,	y: 24,	t: "L"
		},
		{	type: "text",	x: 162,	y: 24,	t: "R"
		},
		{	type: "bmp",	x: 184,	y: 4,	id: 12
		}
	]
},{
	id: 114,
	height: 2,
	longnm: "Fade 2-1",
	shortnm: "Fade2-1",
	page: {
		name: "Mixer",
		ord: 15
	},
	inputs: [
		{	name: "In1",	colour: "purple",	x: 186,	y: 18
		},
		{	name: "In2",	colour: "purple",	x: 216,	y: 18
		},
		{	name: "Mod",	colour: "purple",	x: 93,	y: 19
		}
	],
	outputs: [
		{	name: "Out",	colour: "purple",	x: 246,	y: 18
		}
	],
	params: [
		{	name: "Mix",	type: "Fade21Mix",	n: "KnobMedium",	x: 140.5,	y: 5.5
		},
		{	name: "MixMod",	type: "Level_100",	n: "KnobSmall",	x: 101.5,	y: 7.5
		}
	],
	modes: [],
	ve: [
		{	type: "path",	d:"M246,12l0,-9 -47,0 1.5,3 1.5,-3 M186,12 l0,-5 12,0 0,2 -12,0 M216,12 l0,-5 -13.5,0 0,2 13.5,0"
		},
		{	type: "line",	"x1": 92,	"y1": 19,	"x2": 114,	"y2": 19
		},
		{	type: "text",	x: 175,	y: 23,	t: "1"
		},
		{	type: "text",	x: 203,	y: 23,	t: "2"
		},
		{	type: "text",	x: 134,	y: 23,	t: "1"
		},
		{	type: "text",	x: 162,	y: 23,	t: "2"
		},
		{	type: "bmp",	x: 184,	y: 4,	id: 11
		}
	]
},{
	id: 116,
	height: 2,
	longnm: "Mix 8-1 A",
	shortnm: "Mix8-1A",
	page: {
		name: "Mixer",
		ord: 8
	},
	inputs: [
		{	name: "In1",	colour: "purple",	x: 82,	y: 18
		},
		{	name: "In2",	colour: "purple",	x: 101,	y: 18
		},
		{	name: "In3",	colour: "purple",	x: 120,	y: 18
		},
		{	name: "In4",	colour: "purple",	x: 139,	y: 18
		},
		{	name: "In5",	colour: "purple",	x: 158,	y: 18
		},
		{	name: "In6",	colour: "purple",	x: 177,	y: 18
		},
		{	name: "In7",	colour: "purple",	x: 196,	y: 18
		},
		{	name: "In8",	colour: "purple",	x: 215,	y: 18
		}
	],
	outputs: [
		{	name: "Out",	colour: "purple",	x: 246,	y: 18
		}
	],
	params: [
		{	name: "Pad",	type: "Pad_3",	n: "SwMf9c81c5",	x: 22.5,	y: 14.5
		}
	],
	modes: [],
	ve: [
		{	type: "text",	x: 79,	y: 10,	t: "1"
		},
		{	type: "text",	x: 98,	y: 10,	t: "2"
		},
		{	type: "text",	x: 117,	y: 10,	t: "3"
		},
		{	type: "text",	x: 135,	y: 10,	t: "4"
		},
		{	type: "text",	x: 155,	y: 10,	t: "5"
		},
		{	type: "text",	x: 174,	y: 10,	t: "6"
		},
		{	type: "text",	x: 193,	y: 10,	t: "7"
		},
		{	type: "text",	x: 212,	y: 10,	t: "8"
		},
		{	type: "text",	x: 3,	y: 23,	t: "Pad"
		}
	]
},{
	id: 123,
	height: 4,
	longnm: "Mixer 4-1 C",
	shortnm: "Mix4-1C",
	page: {
		name: "Mixer",
		ord: 6
	},
	inputs: [
		{	name: "In1",	colour: "purple",	x: 54,	y: 28
		},
		{	name: "In2",	colour: "purple",	x: 102,	y: 28
		},
		{	name: "In3",	colour: "purple",	x: 150,	y: 28
		},
		{	name: "In4",	colour: "purple",	x: 198,	y: 28
		},
		{	name: "Chain",	colour: "purple",	x: 246,	y: 9
		}
	],
	outputs: [
		{	name: "Out",	colour: "purple",	x: 246,	y: 50
		}
	],
	params: [
		{	name: "Lev1",	type: "MixLevel",	n: "KnobMedium",	x: 62.5,	y: 16.5
		},
		{	name: "Lev2",	type: "MixLevel",	n: "KnobMedium",	x: 110.5,	y: 16.5
		},
		{	name: "Lev3",	type: "MixLevel",	n: "KnobMedium",	x: 158.5,	y: 16.5
		},
		{	name: "Lev4",	type: "MixLevel",	n: "KnobMedium",	x: 206.5,	y: 16.5
		},
		{	name: "On1",	type: "OffOn",	w:42,	n: "SwM1fff56",	x: 41.5,	y: 42.5
		},
		{	name: "On2",	type: "OffOn",	w:42,	n: "SwM1fff57",	x: 89.5,	y: 42.5
		},
		{	name: "On3",	type: "OffOn",	w:42,	n: "SwM1fff58",	x: 137.5,	y: 42.5
		},
		{	name: "On4",	type: "OffOn",  w:42,	n: "SwM1fff59",	x: 185.5,	y: 42.5
		},
		{	name: "Pad",	type: "Pad_2",	n: "SwM1fd69e45",	x: 6.5,	y: 43.5
		},
		{	name: "ExpLin",	type: "ExpLin_2",	n: "SwM699ffc08",	x: 6.5,	y: 19.5
		}
	],
	modes: [],
	ve: [
		{	type: "text",	x: 42,	y: 32,	t: "1"
		},
		{	type: "text",	x: 89,	y: 32,	t: "2"
		},
		{	type: "text",	x: 137,	y: 32,	t: "3"
		},
		{	type: "text",	x: 185,	y: 32,	t: "4"
		},
		{	type: "text",	x: 215,	y: 12,	t: "Chain"
		},
		{	type: "text",	x: 13,	y: 41,	t: "Pad"
		}
	]
},{
	id: 140,
	height: 4,
	longnm: "Mixer 4-1 S",
	shortnm: "Mix4-1S",
	page: {
		name: "Mixer",
		ord: 6
	},
	inputs: [
		{	name: "In1L",	colour: "purple",	x: 10,	y: 30
		},
		{	name: "In1R",	colour: "purple",	x: 26,	y: 30
		},
		{	name: "In2L",	colour: "purple",	x: 10+56,	y: 30
		},
		{	name: "In2R",	colour: "purple",	x: 26+56,	y: 30
		},
		{	name: "In3L",	colour: "purple",	x: 10+112,	y: 30
		},
		{	name: "In3R",	colour: "purple",	x: 26+112,	y: 30
		},
		{	name: "In4L",	colour: "purple",	x: 10+168,	y: 30
		},
		{	name: "In4R",	colour: "purple",	x: 26+168,	y: 30
		},
		{	name: "ChainL",	colour: "purple",	x: 228,	y: 9
		},
		{	name: "ChainR",	colour: "purple",	x: 246,	y: 9
		}
	],
	outputs: [
		{	name: "OutL",	colour: "purple",	x: 228,	y: 50
		},
		{	name: "OutR",	colour: "purple",	x: 246,	y: 50
		}

	],
	params: [
		{	name: "Lev1",	type: "MixLevel",	n: "KnobMedium",	x: 36,	y: 16.5
		},
		{	name: "Lev2",	type: "MixLevel",	n: "KnobMedium",	x: 36+56,	y: 16.5
		},
		{	name: "Lev3",	type: "MixLevel",	n: "KnobMedium",	x: 36+112,	y: 16.5
		},
		{	name: "Lev4",	type: "MixLevel",	n: "KnobMedium",	x: 36+168,	y: 16.5
		},
		{	name: "On1",	type: "OffOn",	w:42,	n: "SwM1fff56",	x: 10,	y: 42.5
		},
		{	name: "On2",	type: "OffOn",	w:42,	n: "SwM1fff57",	x: 10+56,	y: 42.5
		},
		{	name: "On3",	type: "OffOn",	w:42,	n: "SwM1fff58",	x: 10+112,	y: 42.5
		},
		{	name: "On4",	type: "OffOn",  w:42,	n: "SwM1fff59",	x: 10+168,	y: 42.5
		},
		{	name: "ExpLin",	type: "ExpLin_2",	n: "SwM699ffc08",	x: 70,	y: 3
		}
	],
	modes: [],
	ve: [
		{	type: "text",	x: 7,	y: 23,	t: "L"
		},
		{	type: "text",	x: 23,	y: 23,	t: "R"
		},
		{	type: "text",	x: 7+56,	y: 23,	t: "L"
		},
		{	type: "text",	x: 23+56,	y: 23,	t: "R"
		},
		{	type: "text",	x: 7+112,	y: 23,	t: "L"
		},
		{	type: "text",	x: 23+112,	y: 23,	t: "R"
		},
		{	type: "text",	x: 7+168,	y: 23,	t: "L"
		},
		{	type: "text",	x: 23+168,	y: 23,	t: "R"
		},
		{	type: "text",	x: 195,	y: 12,	t: "Chain"
		}
	]
},{
	id: 161,
	height: 9,
	longnm: "Mixer 8-1 Fader",
	shortnm: "MixFader",
	page: {
		name: "Mixer",
		ord: 10
	},
	inputs: [
		{	name: "In1",	colour: "purple",	x: 18,	y: 27
		},
		{	name: "In2",	colour: "purple",	x: 47,	y: 27
		},
		{	name: "In3",	colour: "purple",	x: 76,	y: 27
		},
		{	name: "In4",	colour: "purple",	x: 105,	y: 27
		},
		{	name: "In5",	colour: "purple",	x: 134,	y: 27
		},
		{	name: "In6",	colour: "purple",	x: 163,	y: 27
		},
		{	name: "In7",	colour: "purple",	x: 192,	y: 27
		},
		{	name: "In8",	colour: "purple",	x: 221,	y: 27
		},
		{	name: "Chain",	colour: "purple",	x: 246,	y: 9
		}
	],
	outputs: [
		{	name: "Out",	colour: "purple",	x: 246,	y: 125
		}
	],
	params: [
		{	name: "Lev1",	type: "MixLevel",	n: "KnobSlider",	x: 12.5,	y: 53.5
		},
		{	name: "Lev2",	type: "MixLevel",	n: "KnobSlider",	x: 41.5,	y: 53.5
		},
		{	name: "Lev3",	type: "MixLevel",	n: "KnobSlider",	x: 70.5,	y: 53.5
		},
		{	name: "Lev4",	type: "MixLevel",	n: "KnobSlider",	x: 99.5,	y: 53.5
		},
		{	name: "Lev5",	type: "MixLevel",	n: "KnobSlider",	x: 128.5,	y: 53.5
		},
		{	name: "Lev6",	type: "MixLevel",	n: "KnobSlider",	x: 157.5,	y: 53.5
		},
		{	name: "Lev7",	type: "MixLevel",	n: "KnobSlider",	x: 186.5,	y: 53.5
		},
		{	name: "Lev8",	type: "MixLevel",	n: "KnobSlider",	x: 215.5,	y: 53.5
		},
		{	name: "On1",	type: "OffOn",	w:28,	n: "SwM1084c",	x: 4.5,	y: 117.5
		},
		{	name: "On2",	type: "OffOn",	w:28,	n: "SwM1084d",	x: 33.5,	y: 117.5
		},
		{	name: "On3",	type: "OffOn",	w:28,	n: "SwM1084e",	x: 62.5,	y: 117.5
		},
		{	name: "On4",	type: "OffOn",	w:28,	n: "SwM1084f",	x: 91.5,	y: 117.5
		},
		{	name: "On5",	type: "OffOn",	w:28,	n: "SwM10850",	x: 120.5,	y: 117.5
		},
		{	name: "On6",	type: "OffOn",	w:28,	n: "SwM10851",	x: 149.5,	y: 117.5
		},
		{	name: "On7",	type: "OffOn",	w:28,	n: "SwM10852",	x: 178.5,	y: 117.5
		},
		{	name: "On8",	type: "OffOn",	w:28,	n: "SwM10853",	x: 207.5,	y: 117.5
		},
		{	name: "ExpLin",	type: "ExpLin_2",	n: "SwM699ffc08",	x: 90.5,	y: 4.5
		},
		{	name: "Pad",	type: "Pad_3",	n: "SwMf9c81c5",	x: 177.5,	y: 4.5
		}
	],
	modes: [],
	ve: [
		{	type: "valueDisplay",	x: 4,	y: 37,	w: 28,	ref: 0
		},
		{	type: "valueDisplay",	x: 33,	y: 37,	w: 28,	ref: 1
		},
		{	type: "valueDisplay",	x: 62,	y: 37,	w: 28,	ref: 2
		},
		{	type: "valueDisplay",	x: 91,	y: 37,	w: 28,	ref: 3
		},
		{	type: "valueDisplay",	x: 120,	y: 37,	w: 28,	ref: 4
		},
		{	type: "valueDisplay",	x: 149,	y: 37,	w: 28,	ref: 5
		},
		{	type: "valueDisplay",	x: 178,	y: 37,	w: 28,	ref: 6
		},
		{	type: "valueDisplay",	x: 207,	y: 37,	w: 28,	ref: 7
		},
		{	type: "text",	x: 236,	y: 99,	t: "Out"
		},
		{	type: "text",	x: 208,	y: 31,	t: "8"
		},
		{	type: "text",	x: 179,	y: 31,	t: "7"
		},
		{	type: "text",	x: 150,	y: 31,	t: "6"
		},
		{	type: "text",	x: 121,	y: 31,	t: "5"
		},
		{	type: "text",	x: 92,	y: 31,	t: "4"
		},
		{	type: "text",	x: 63,	y: 31,	t: "3"
		},
		{	type: "text",	x: 34,	y: 31,	t: "2"
		},
		{	type: "text",	x: 6,	y: 31,	t: "1"
		},
		{	type: "text",	x: 215,	y: 12,	t: "Chain"
		},
		{	type: "text",	x: 158,	y: 13,	t: "Pad"
		}
	]
},{
	id: 184,
	height: 2,
	longnm: "Mixer 1-1 A",
	shortnm: "Mix1-1A",
	page: {
		name: "Mixer",
		ord: 0
	},
	inputs: [
		{	name: "In",	colour: "purple",	x: 216,	y: 16
		},
		{	name: "Chain",	colour: "purple",	x: 10,	y: 20
		}
	],
	outputs: [
		{	name: "Out",	colour: "purple",	x: 246,	y: 16
		}
	],
	params: [
		{	name: "Lev",	type: "MixLevel",	n: "KnobMedium",	x: 158.5,	y: 5.5
		},
		{	name: "On",	type: "OffOn",	w:40,	n: "SwM1fff56",	x: 112.5,	y: 8.5
		},
		{	name: "ExpLin",	type: "ExpLin_2",	n: "SwM699ffc08",	x: 43.5,	y: 14.5
		}
	],
	modes: [],
	ve: [
		{	type: "line",	"x1": 217,	"y1": 16,	"x2": 247,	"y2": 16
		},
		{	type: "text",	x: 17,	y: 24,	t: "Chain"
		}
	]
},{
	id: 185,
	height: 2,
	longnm: "Mixer 1-1 Stereo",
	shortnm: "Mix1-1S",
	page: {
		name: "Mixer",
		ord: 1
	},
	inputs: [
		{	name: "InL",	colour: "purple",	x: 188,	y: 18
		},
		{	name: "InR",	colour: "purple",	x: 208,	y: 18
		},
		{	name: "LChain",	colour: "purple",	x: 10,	y: 20
		},
		{	name: "RChain",	colour: "purple",	x: 30,	y: 20
		}
	],
	outputs: [
		{	name: "OutL",	colour: "purple",	x: 226,	y: 18
		},
		{	name: "OutR",	colour: "purple",	x: 246,	y: 18
		}
	],
	params: [
		{	name: "Lev",	type: "MixLevel",	n: "KnobMedium",	x: 156.5,	y: 5.5
		},
		{	name: "On",	type: "OffOn",	w:40,	n: "SwM1fff56",	x: 110.5,	y: 8.5
		},
		{	name: "ExpLin",	type: "ExpLin_2",	n: "SwM699ffc08",	x: 76.5,	y: 14.5
		}
	],
	modes: [],
	ve: [
		{	type: "text",	x: 44,	y: 24,	t: "Chain"
		},
		{	type: "text",	x: 184,	y: 10,	t: "L"
		},
		{	type: "text",	x: 204,	y: 10,	t: "R"
		},
		{	type: "text",	x: 222,	y: 10,	t: "L"
		},
		{	type: "text",	x: 242,	y: 10,	t: "R"
		},
		{	type: "text",	x: 16,	y: 24,	t: "L"
		},
		{	type: "text",	x: 36,	y: 24,	t: "R"
		}
	]
},{
	id: 193,
	height: 2,
	longnm: "Mixer 4-1 A",
	shortnm: "Mix4-1A",
	page: {
		name: "Mixer",
		ord: 4
	},
	inputs: [
		{	name: "In1",	colour: "purple",	x: 82,	y: 18
		},
		{	name: "In2",	colour: "purple",	x: 120,	y: 18
		},
		{	name: "In3",	colour: "purple",	x: 158,	y: 18
		},
		{	name: "In4",	colour: "purple",	x: 196,	y: 18
		}
	],
	outputs: [
		{	name: "Out",	colour: "purple",	x: 246,	y: 18
		}
	],
	params: [],
	modes: [],
	ve: [
		{	type: "text",	x: 79,	y: 10,	t: "1"
		},
		{	type: "text",	x: 117,	y: 10,	t: "2"
		},
		{	type: "text",	x: 154,	y: 10,	t: "3"
		},
		{	type: "text",	x: 192,	y: 10,	t: "4"
		}
	]
},{
	id: 194,
	height: 2,
	longnm: "Mixer 2-1 A",
	shortnm: "Mix2-1A",
	page: {
		name: "Mixer",
		ord: 2
	},
	inputs: [
		{	name: "In1",	colour: "purple",	x: 126,	y: 16
		},
		{	name: "In2",	colour: "purple",	x: 208,	y: 16
		},
		{	name: "Chain",	colour: "purple",	x: 10,	y: 20
		}
	],
	outputs: [
		{	name: "Out",	colour: "purple",	x: 246,	y: 16
		}
	],
	params: [
		{	name: "Lev1",	type: "MixLevel",	n: "KnobMedium",	x: 134.5,	y: 5.5
		},
		{	name: "On1",	type: "OffOn",	w:40,	n: "SwM1fff56",	x: 77.5,	y: 8.5
		},
		{	name: "Lev2",	type: "MixLevel",	n: "KnobMedium",	x: 216.5,	y: 5.5
		},
		{	name: "On2",	type: "OffOn",	w:40,	n: "SwM1fff57",	x: 159.5,	y: 8.5
		},
		{	name: "ExpLin",	type: "ExpLin_2",	n: "SwM699ffc08",	x: 43.5,	y: 14.5
		}
	],
	modes: [],
	ve: [
		{	type: "text",	x: 17,	y: 24,	t: "Chain"
		}
	]
},/// end of mixer
{/// start of midi
	id: 57,
	height: 2,
	longnm: "MIDI Control Automate",
	shortnm: "Automate",
	page: {
		name: "MIDI",
		ord: 6
	},
	inputs: [
		{	name: "In",	colour: "yellow",	x: 16,	y: 20
		}
	],
	outputs: [
		{	name: "Out",	colour: "yellow",	x: 71,	y: 20
		}
	],
	params: [
		{	name: "Ctrl",	type: "MidiData",	n: "KnobSpin",	x: 134.5,	y: 5.5
		},
		{	name: "Val",	type: "MidiData",	n: "KnobMedium",	x: 180.5,	y: 5.5
		},
		{	name: "Ch",	type: "MidiCh_20",	n: "KnobSpin",	x: 240.5,	y: 5.5
		},
		{	name: "Echo",	type: "OffOn",	n: "SwM7364bc84",	x: 81.5,	y: 14.5
		}
	],
	modes: [],
	ve: [
		{	type: "valueDisplay",	x: 208,	y: 12,	w: 29,	ref: 2
		},
		{	type: "valueDisplay",	x: 108,	y: 12,	w: 23,	ref: 0
		},
		{	type: "valueDisplay",	x: 154,	y: 12,	w: 23,	ref: 1
		},
		{	type: "text",	x: 211,	y: 9,	t: "Chan"
		},
		{	type: "text",	x: 110,	y: 9,	t: "Ctrl"
		},
		{	type: "text",	x: 153,	y: 9,	t: "Value"
		},
		{	type: "text",	x: 23,	y: 24,	t: "Send"
		},
		{	type: "bmp",	x: 46,	y: 14,	id: 16
		},
		{	type: "text",	x: 80,	y: 10,	t: "Echo"
		}
	]
},{
	id: 141,
	height: 2,
	longnm: "MIDI Control Send",
	shortnm: "CtrlSend",
	page: {
		name: "MIDI",
		ord: 0
	},
	inputs: [
		{	name: "Send",	colour: "yellow",	x: 16,	y: 20
		},
		{	name: "Value",	colour: "blue",	x: 146,	y: 20
		}
	],
	outputs: [
		{	name: "Send",	colour: "yellow",	x: 71,	y: 20
		}
	],
	params: [
		{	name: "Ctrl",	type: "MidiData",	n: "KnobSpin",	x: 121.5,	y: 5.5
		},
		{	name: "Val",	type: "MidiData",	n: "KnobMedium",	x: 180.5,	y: 5.5
		},
		{	name: "Ch",	type: "MidiCh_20",	n: "KnobSpin",	x: 240.5,	y: 5.5
		}
	],
	modes: [],
	ve: [
		{	type: "valueDisplay",	x: 208,	y: 12,	w: 29,	ref: 2
		},
		{	type: "valueDisplay",	x: 95,	y: 12,	w: 23,	ref: 0
		},
		{	type: "valueDisplay",	x: 154,	y: 12,	w: 23,	ref: 1
		},
		{	type: "text",	x: 211,	y: 9,	t: "Chan"
		},
		{	type: "text",	x: 96,	y: 9,	t: "Ctrl"
		},
		{	type: "text",	x: 153,	y: 9,	t: "Value"
		},
		{	type: "text",	x: 23,	y: 24,	t: "Send"
		},
		{	type: "bmp",	x: 46,	y: 14,	id: 16
		}
	]
},{
	id: 142,
	height: 2,
	longnm: "MIDI Program Change Send",
	shortnm: "PCSend",
	page: {
		name: "MIDI",
		ord: 1
	},
	inputs: [
		{	name: "Send",	colour: "yellow",	x: 16,	y: 20
		},
		{	name: "Program",	colour: "blue",	x: 146,	y: 20
		}
	],
	outputs: [
		{	name: "Send",	colour: "yellow",	x: 71,	y: 20
		}
	],
	params: [
		{	name: "Program",	type: "MidiData",	n: "KnobMedium",	x: 180.5,	y: 5.5
		},
		{	name: "Ch",	type: "MidiCh_16",	n: "KnobSpin",	x: 240.5,	y: 5.5
		}
	],
	modes: [],
	ve: [
		{	type: "valueDisplay",	x: 208,	y: 12,	w: 29,	ref: 1
		},
		{	type: "valueDisplay",	x: 154,	y: 12,	w: 23,	ref: 0
		},
		{	type: "text",	x: 211,	y: 9,	t: "Chan"
		},
		{	type: "text",	x: 138,	y: 9,	t: "Program"
		},
		{	type: "text",	x: 22,	y: 24,	t: "Send"
		},
		{	type: "bmp",	x: 45,	y: 14,	id: 15
		}
	]
},{
	id: 143,
	height: 2,
	longnm: "MIDI Note Send",
	shortnm: "NoteSend",
	page: {
		name: "MIDI",
		ord: 2
	},
	inputs: [
		{	name: "Gate",	colour: "yellow",	x: 16,	y: 20
		},
		{	name: "Vel",	colour: "blue",	x: 71,	y: 20
		},
		{	name: "Note",	colour: "blue",	x: 143,	y: 20
		}
	],
	outputs: [],
	params: [
		{	name: "Vel",	type: "MidiData",	n: "KnobMedium",	x: 105.5,	y: 5.5
		},
		{	name: "Note",	type: "MidiData",	n: "KnobMedium",	x: 180.5,	y: 5.5
		},
		{	name: "Ch",	type: "MidiCh_20",	n: "KnobSpin",	x: 240.5,	y: 5.5
		}
	],
	modes: [],
	ve: [
		{	type: "valueDisplay",	x: 208,	y: 12,	w: 29,	ref: 2
		},
		{	type: "valueDisplay",	x: 151,	y: 12,	w: 26,	ref: 1
		},
		{	type: "text",	x: 211,	y: 9,	t: "Chan"
		},
		{	type: "text",	x: 153,	y: 9,	t: "Note"
		},
		{	type: "valueDisplay",	x: 79,	y: 12,	w: 23,	ref: 0
		},
		{	type: "text",	x: 83,	y: 9,	t: "Vel"
		},
		{	type: "text",	x: 23,	y: 24,	t: "Gate"
		},
		{	type: "bmp",	x: 4,	y: 14,	id: 14
		}
	]
},{
	id: 147,
	height: 2,
	longnm: "MIDI Control Receive",
	shortnm: "CtrlRcv",
	page: {
		name: "MIDI",
		ord: 3
	},
	inputs: [],
	outputs: [
		{	name: "Rcv",	colour: "yellow",	x: 216,	y: 18
		},
		{	name: "Val",	colour: "blue",	x: 246,	y: 18
		}
	],
	params: [
		{	name: "Ctrl",	type: "MidiData",	n: "KnobSpin",	x: 118.5,	y: 5.5
		},
		{	name: "Ch",	type: "MidiCh_16",	n: "KnobSpin",	x: 171.5,	y: 5.5
		}
	],
	modes: [],
	ve: [
		{	type: "valueDisplay",	x: 139,	y: 12,	w: 29,	ref: 1
		},
		{	type: "valueDisplay",	x: 95,	y: 12,	w: 20,	ref: 0
		},
		{	type: "text",	x: 142,	y: 9,	t: "Chan"
		},
		{	type: "text",	x: 96,	y: 9,	t: "Ctrl"
		},
		{	type: "text",	x: 238,	y: 10,	t: "Val"
		},
		{	type: "text",	x: 206,	y: 10,	t: "Rcv"
		}
	]
},{
	id: 148,
	height: 2,
	longnm: "MIDI Note Receive",
	shortnm: "NoteRcv",
	page: {
		name: "MIDI",
		ord: 4
	},
	inputs: [],
	outputs: [
		{	name: "Gate",	colour: "yellow",	x: 194,	y: 18
		},
		{	name: "Vel",	colour: "blue",	x: 216,	y: 18
		},
		{	name: "RelVel",	colour: "blue",	x: 238,	y: 18
		}
	],
	params: [
		{	name: "Note",	type: "MidiData",	n: "KnobMedium",	x: 108.5,	y: 5.5
		},
		{	name: "Ch",	type: "MidiCh_17",	n: "KnobSpin",	x: 171.5,	y: 5.5
		}
	],
	modes: [],
	ve: [
		{	type: "valueDisplay",	x: 79,	y: 12,	w: 26,	ref: 0
		},
		{	type: "text",	x: 81,	y: 9,	t: "Note"
		},
		{	type: "text",	x: 208,	y: 10,	t: "Vel"
		},
		{	type: "text",	x: 184,	y: 10,	t: "Gate"
		},
		{	type: "valueDisplay",	x: 139,	y: 12,	w: 29,	ref: 1
		},
		{	type: "text",	x: 142,	y: 9,	t: "Chan"
		},
		{	type: "text",	x: 224,	y: 10,	t: "RelVel"
		}
	]
},{
	id: 149,
	height: 3,
	longnm: "MIDI Note Zone",
	shortnm: "NoteZone",
	page: {
		name: "MIDI",
		ord: 5
	},
	inputs: [],
	outputs: [],
	params: [
		{	name: "RcvCh",	type: "MidiCh_17",	n: "KnobSpin",	x: 53.5,	y: 20.5
		},
		{	name: "RcvMin",	type: "MidiData",	n: "KnobSpin",	x: 93.5,	y: 20.5
		},
		{	name: "RcvMax",	type: "MidiData",	n: "KnobSpin",	x: 133.5,	y: 20.5
		},
		{	name: "SendTrans",	type: "Bipolar_127",	n: "KnobSpin",	x: 196.5,	y: 20.5
		},
		{	name: "SendCh",	type: "MidiCh_20",	n: "KnobSpin",	x: 240.5,	y: 20.5
		},
		{	name: "ThruMode",	type: "NoteZoneThru",	n: "SwMad412f0",	x: 170.5,	y: 4.5
		}
	],
	modes: [],
	ve: [
		{	type: "valueDisplay",	x: 23,	y: 27,	w: 29,	ref: 0
		},
		{	type: "text",	x: 26,	y: 25,	t: "Chan"
		},
		{	type: "valueDisplay",	x: 67,	y: 27,	w: 25,	ref: 1
		},
		{	type: "text",	x: 71,	y: 25,	t: "Min"
		},
		{	type: "valueDisplay",	x: 107,	y: 27,	w: 25,	ref: 2
		},
		{	type: "text",	x: 109,	y: 25,	t: "Max"
		},
		{	type: "text",	x: 3,	y: 30,	t: "Rcv"
		},
		{	type: "valueDisplay",	x: 170,	y: 27,	w: 25,	ref: 3
		},
		{	type: "text",	x: 213,	y: 25,	t: "Chan"
		},
		{	type: "text",	x: 146,	y: 30,	t: "Send"
		},
		{	type: "valueDisplay",	x: 210,	y: 27,	w: 29,	ref: 4
		},
		{	type: "text",	x: 168,	y: 25,	t: "Trans"
		},
		{	type: "text",	x: 132,	y: 13,	t: "Let thru:"
		}
	]
},/// end of midi
{/// start of delay
	id: 172,
	height: 2,
	longnm: "Delay Static",
	shortnm: "DlySingleA",
	page: {
		name: "Delay",
		ord: 0
	},
	inputs: [
		{	name: "In",	colour: "red",	x: 216,	y: 16
		}
	],
	outputs: [
		{	name: "Out",	colour: "red",	x: 246,	y: 16
		}
	],
	params: [
		{	name: "Time",	type: "DelayTime_3",	n: "KnobMedium",	x: 182.5,	y: 5.5
		}
	],
	modes: [
		{	name: "DelayRange",	type: "DelayRange_3"
		}
	],
	ve: [
		{	type: "text",	x: 11,	y: 22,	t: "Range"
		},
		{	type: "valueDisplay",	x: 139,	y: 12,	w: 40,	ref: 0
		},
		{	type: "text",	x: 147,	y: 9,	t: "Time"
		}
	]
},{
	id: 173,
	height: 2,
	longnm: "Delay Single",
	shortnm: "DlySingleB",
	page: {
		name: "Delay",
		ord: 1
	},
	inputs: [
		{	name: "In",	colour: "red",	x: 216,	y: 16
		},
		{	name: "Time",	colour: "red",	x: 107,	y: 19
		}
	],
	outputs: [
		{	name: "Out",	colour: "red",	x: 246,	y: 16
		}
	],
	params: [
		{	name: "Time",	type: "DelayTime_3",	n: "KnobMedium",	x: 182.5,	y: 5.5
		},
		{	name: "TimeMod",	type: "Level_100",	n: "KnobSmall",	x: 115.5,	y: 7.5
		}
	],
	modes: [
		{	name: "DelayRange",	type: "DelayRange_3"
		}
	],
	ve: [
		{	type: "line",	"x1": 104,	"y1": 20,	"x2": 126,	"y2": 20
		},
		{	type: "text",	x: 11,	y: 22,	t: "Range"
		},
		{	type: "valueDisplay",	x: 139,	y: 12,	w: 40,	ref: 0
		},
		{	type: "text",	x: 147,	y: 9,	t: "Time"
		}
	]
},{
	id: 174,
	height: 3,
	longnm: "Delay Dual",
	shortnm: "DelayDual",
	page: {
		name: "Delay",
		ord: 2
	},
	inputs: [
		{	name: "In",	colour: "red",	x: 246,	y: 9
		},
		{	name: "Time1",	colour: "red",	x: 99,	y: 34
		},
		{	name: "Time2",	colour: "red",	x: 174,	y: 34
		}
	],
	outputs: [
		{	name: "Out1",	colour: "red",	x: 144,	y: 34
		},
		{	name: "Out2",	colour: "red",	x: 219,	y: 34
		}
	],
	params: [
		{	name: "Time1",	type: "DelayTime_3",	n: "KnobMedium",	x: 133.5,	y: 4.5
		},
		{	name: "Time1Mod",	type: "Level_100",	n: "KnobSmall",	x: 107.5,	y: 22.5
		},
		{	name: "Time2",	type: "DelayTime_3",	n: "KnobMedium",	x: 208.5,	y: 4.5
		},
		{	name: "Time2Mod",	type: "Level_100",	n: "KnobSmall",	x: 182.5,	y: 22.5
		}
	],
	modes: [
		{	name: "DelayRange",	type: "DelayRange_3"
		}
	],
	ve: [
		{	type: "line",	"x1": 96,	"y1": 34,	"x2": 118,	"y2": 34
		},
		{	type: "line",	"x1": 171,	"y1": 34,	"x2": 193,	"y2": 34
		},
		{	type: "text",	x: 4,	y: 24,	t: "Range"
		},
		{	type: "valueDisplay",	x: 90,	y: 6,	w: 40,	ref: 0
		},
		{	type: "valueDisplay",	x: 165,	y: 6,	w: 40,	ref: 2
		},
		{	type: "text",	x: 231,	y: 11,	t: "In"
		}
	]
},{
	id: 175,
	height: 5,
	longnm: "Delay Quad",
	shortnm: "DelayQuad",
	page: {
		name: "Delay",
		ord: 3
	},
	inputs: [
		{	name: "In",	colour: "red",	x: 246,	y: 9
		},
		{	name: "Time1",	colour: "red",	x: 61,	y: 64
		},
		{	name: "Time2",	colour: "red",	x: 107,	y: 64
		},
		{	name: "Time3",	colour: "red",	x: 155,	y: 64
		},
		{	name: "Time4",	colour: "red",	x: 202,	y: 64
		}
	],
	outputs: [
		{	name: "OutMain",	colour: "red",	x: 246,	y: 65
		},
		{	name: "Out1",	colour: "red",	x: 80,	y: 41
		},
		{	name: "Out2",	colour: "red",	x: 128,	y: 41
		},
		{	name: "Out3",	colour: "red",	x: 175,	y: 41
		},
		{	name: "Out4",	colour: "red",	x: 222,	y: 40
		}
	],
	params: [
		{	name: "Time1",	type: "DelayTime_3",	n: "KnobMedium",	x: 48.5,	y: 31.5
		},
		{	name: "Time1Mod",	type: "Level_100",	n: "KnobSmall",	x: 69.5,	y: 52.5
		},
		{	name: "Time2",	type: "DelayTime_3",	n: "KnobMedium",	x: 95.5,	y: 31.5
		},
		{	name: "Time2Mod",	type: "Level_100",	n: "KnobSmall",	x: 115.5,	y: 52.5
		},
		{	name: "Time3",	type: "DelayTime_3",	n: "KnobMedium",	x: 142.5,	y: 31.5
		},
		{	name: "Time3Mod",	type: "Level_100",	n: "KnobSmall",	x: 163.5,	y: 52.5
		},
		{	name: "Time4",	type: "DelayTime_3",	n: "KnobMedium",	x: 189.5,	y: 31.5
		},
		{	name: "Time4Mod",	type: "Level_100",	n: "KnobSmall",	x: 210.5,	y: 52.5
		},
		{	name: "TimeClk",	type: "TimeClk",	n: "SwM780a6e3d",	x: 4.5,	y: 17.5
		}
	],
	modes: [
		{	name: "DelayRange",	type: "DelayRange_3"
		}
	],
	ve: [
		{	type: "line",	"x1": 58,	"y1": 64,	"x2": 80,	"y2": 64
		},
		{	type: "line",	"x1": 104,	"y1": 64,	"x2": 126,	"y2": 64
		},
		{	type: "line",	"x1": 152,	"y1": 64,	"x2": 174,	"y2": 64
		},
		{	type: "line",	"x1": 199,	"y1": 64,	"x2": 221,	"y2": 64
		},
		{	type: "valueDisplay",	x: 48,	y: 15,	w: 40,	ref: 0
		},
		{	type: "valueDisplay",	x: 95,	y: 15,	w: 40,	ref: 2
		},
		{	type: "valueDisplay",	x: 142,	y: 15,	w: 40,	ref: 4
		},
		{	type: "valueDisplay",	x: 189,	y: 15,	w: 40,	ref: 6
		},
		{	type: "text",	x: 4,	y: 54,	t: "Range"
		},
		{	type: "text",	x: 230,	y: 12,	t: "In"
		}
	]
},{
	id: 176,
	height: 3,
	longnm: "Delay A",
	shortnm: "DelayA",
	page: {
		name: "Delay",
		ord: 7
	},
	inputs: [
		{	name: "In",	colour: "red",	x: 246,	y: 9
		}
	],
	outputs: [
		{	name: "Out",	colour: "red",	x: 246,	y: 38
		}
	],
	params: [
		{	name: "Time",	type: "DelayTime_2",	n: "KnobMedium",	x: 95.5,	y: 20.5
		},
		{	name: "FB",	type: "Level_100",	n: "KnobMedium",	x: 126.5,	y: 20.5
		},
		{	name: "Filter",	type: "Level_100",	n: "KnobMedium",	x: 164.5,	y: 20.5
		},
		{	name: "DryWet",	type: "Level_100",	n: "KnobMedium",	x: 203.5,	y: 20.5
		},
		{	name: "Active",	type: "ActiveMonitor",	n: "SwM42",	x: 241.25,	y: 17.5
		},
		{	name: "TimeClk",	type: "TimeClk",	n: "SwM780a6e3d",	x: 58.5,	y: 13.5
		}
	],
	modes: [
		{	name: "DelayRange",	type: "DelayRange_2"
		}
	],
	ve: [
		{	type: "line",	"x1": 246,	"y1": 9,	"x2": 246,	"y2": 36
		},
		{	type: "text",	x: 4,	y: 24,	t: "Range"
		},
		{	type: "text",	x: 130,	y: 17,	t: "FB"
		},
		{	type: "text",	x: 162,	y: 17,	t: "Filter"
		},
		{	type: "text",	x: 193,	y: 17,	t: "Dry/Wet"
		},
		{	type: "valueDisplay",	x: 52,	y: 27,	w: 40,	ref: 0
		}
	]
},{
	id: 177,
	height: 4,
	longnm: "Delay B",
	shortnm: "DelayB",
	page: {
		name: "Delay",
		ord: 8
	},
	inputs: [
		{	name: "In",	colour: "red",	x: 246,	y: 9
		},
		{	name: "FBMod",	colour: "purple",	x: 126,	y: 49
		},
		{	name: "DryWetMod",	colour: "purple",	x: 203,	y: 49
		}
	],
	outputs: [
		{	name: "Out",	colour: "red",	x: 246,	y: 50
		}
	],
	params: [
		{	name: "Time",	type: "DelayTime_2",	n: "KnobMedium",	x: 95.5,	y: 21.5
		},
		{	name: "FB",	type: "Level_100",	n: "KnobMedium",	x: 126.5,	y: 12.5
		},
		{	name: "LP",	type: "Level_100",	n: "KnobSmall",	x: 170.5,	y: 37.5
		},
		{	name: "DryWet",	type: "Level_100",	n: "KnobMedium",	x: 203.5,	y: 12.5
		},
		{	name: "TimeClk",	type: "TimeClk",	n: "SwM780a6e3d",	x: 58.5,	y: 14.5
		},
		{	name: "FBMod",	type: "Level_100",	n: "KnobSmall",	x: 134.5,	y: 37.5
		},
		{	name: "DryWetMod",	type: "Level_100",	n: "KnobSmall",	x: 211.5,	y: 37.5
		},
		{	name: "Active",	type: "ActiveMonitor",	n: "SwM42",	x: 241.25,	y: 24.5
		},
		{	name: "HP",	type: "Level_100",	n: "KnobSmall",	x: 170.5,	y: 14.5
		}
	],
	modes: [
		{	name: "DelayRange",	type: "DelayRange_2"
		}
	],
	ve: [
		{	type: "line",	"x1": 125,	"y1": 49,	"x2": 147,	"y2": 49
		},
		{	type: "line",	"x1": 201,	"y1": 49,	"x2": 223,	"y2": 49
		},
		{	type: "line",	"x1": 246,	"y1": 11,	"x2": 246,	"y2": 51
		},
		{	type: "text",	x: 4,	y: 25,	t: "Range"
		},
		{	type: "text",	x: 193,	y: 11,	t: "Dry/Wet"
		},
		{	type: "text",	x: 130,	y: 11,	t: "FB"
		},
		{	type: "valueDisplay",	x: 52,	y: 28,	w: 40,	ref: 0
		},
		{	type: "text",	x: 162,	y: 11,	t: "Filter"
		},
		{	type: "text",	x: 157,	y: 21,	t: "HP"
		},
		{	type: "text",	x: 157,	y: 46,	t: "LP"
		}
	]
},{
	id: 178,
	height: 2,
	longnm: "Delay Clocked",
	shortnm: "DlyClock",
	page: {
		name: "Delay",
		ord: 6
	},
	inputs: [
		{	name: "In",	colour: "purple",	x: 216,	y: 16
		},
		{	name: "Clk",	colour: "orange",	x: 10,	y: 20
		}
	],
	outputs: [
		{	name: "Out",	colour: "purple",	x: 246,	y: 16
		}
	],
	params: [
		{	name: "Delay",	type: "Range_128",	n: "KnobMedium",	x: 182.5,	y: 5.5
		}
	],
	modes: [],
	ve: [
		{	type: "text",	x: 17,	y: 24,	t: "Clk"
		},
		{	type: "text",	x: 105,	y: 13,	t: "Sample"
		},
		{	type: "text",	x: 108,	y: 22,	t: "Delay"
		},
		{	 type: "bmp",	 x: 220.5,	 y: 9.5,	 id: "box"
		},
		{	type: "valueDisplay",	x: 139,	y: 8,	w: 40,	ref: 0
		}
	]
},{
	id: 179,
	height: 2,
	longnm: "Shift Register",
	shortnm: "DlyShiftReg",
	page: {
		name: "Delay",
		ord: 5
	},
	inputs: [
		{	name: "In",	colour: "purple",	x: 86,	y: 18
		},
		{	name: "Clk",	colour: "orange",	x: 10,	y: 20
		}
	],
	outputs: [
		{	name: "Out1",	colour: "purple",	x: 106,	y: 18
		},
		{	name: "Out2",	colour: "purple",	x: 126,	y: 18
		},
		{	name: "Out3",	colour: "purple",	x: 146,	y: 18
		},
		{	name: "Out4",	colour: "purple",	x: 166,	y: 18
		},
		{	name: "Out5",	colour: "purple",	x: 186,	y: 18
		},
		{	name: "Out6",	colour: "purple",	x: 206,	y: 18
		},
		{	name: "Out7",	colour: "purple",	x: 226,	y: 18
		},
		{	name: "Out8",	colour: "purple",	x: 246,	y: 18
		}
	],
	params: [],
	modes: [],
	ve: [
		{	type: "line",	"x1": 84,	"y1": 18,	"x2": 248,	"y2": 18
		},
		{	type: "text",	x: 17,	y: 24,	t: "Clk"
		},
		{	type: "text",	x: 102,	y: 10,	t: "1"
		},
		{	type: "text",	x: 122,	y: 10,	t: "2"
		},
		{	type: "text",	x: 142,	y: 10,	t: "3"
		},
		{	type: "text",	x: 161,	y: 10,	t: "4"
		},
		{	type: "text",	x: 182,	y: 10,	t: "5"
		},
		{	type: "text",	x: 202,	y: 10,	t: "6"
		},
		{	type: "text",	x: 222,	y: 10,	t: "7"
		},
		{	type: "text",	x: 242,	y: 10,	t: "8"
		}
	]
},{
	id: 181,
	height: 3,
	longnm: "Delay 8 Tap",
	shortnm: "DlyEight",
	page: {
		name: "Delay",
		ord: 4
	},
	inputs: [
		{	name: "In",	colour: "red",	x: 246,	y: 9
		}
	],
	outputs: [
		{	name: "Out1",	colour: "red",	x: 106,	y: 35
		},
		{	name: "Out2",	colour: "red",	x: 126,	y: 35
		},
		{	name: "Out3",	colour: "red",	x: 146,	y: 35
		},
		{	name: "Out4",	colour: "red",	x: 166,	y: 35
		},
		{	name: "Out5",	colour: "red",	x: 186,	y: 35
		},
		{	name: "Out6",	colour: "red",	x: 206,	y: 35
		},
		{	name: "Out7",	colour: "red",	x: 226,	y: 35
		},
		{	name: "Out8",	colour: "red",	x: 246,	y: 35
		}
	],
	params: [
		{	name: "Time",	type: "DelayTime_3",	n: "KnobMedium",	x: 152.5,	y: 4.5
		}
	],
	modes: [
		{	name: "DelayRange",	type: "DelayRange_3"
		}
	],
	ve: [
		{	type: "line",	"x1": 103,	"y1": 35,	"x2": 248,	"y2": 35
		},
		{	type: "valueDisplay",	x: 109,	y: 11,	w: 40,	ref: 0
		},
		{	type: "text",	x: 11,	y: 29,	t: "Range"
		},
		{	type: "text",	x: 232,	y: 12,	t: "In"
		},
		{	type: "text",	x: 117,	y: 9,	t: "Time"
		}
	]
},{
	id: 182,
	height: 5,
	longnm: "Delay Stereo",
	shortnm: "DlyStereo",
	page: {
		name: "Delay",
		ord: 9
	},
	inputs: [
		{	name: "In",	colour: "red",	x: 246,	y: 9
		}
	],
	outputs: [
		{	name: "OutL",	colour: "red",	x: 226,	y: 65
		},
		{	name: "OutR",	colour: "red",	x: 246,	y: 65
		}
	],
	params: [
		{	name: "TimeLeft",	type: "DelayTime_1",	n: "KnobMedium",	x: 69.5,	y: 23.5
		},
		{	name: "TimeRight",	type: "DelayTime_1",	n: "KnobMedium",	x: 69.5,	y: 50.5
		},
		{	name: "FBLeft",	type: "Level_100",	n: "KnobMedium",	x: 97.5,	y: 23.5
		},
		{	name: "FBRight",	type: "Level_100",	n: "KnobMedium",	x: 97.5,	y: 50.5
		},
		{	name: "XFBLeft",	type: "Level_100",	n: "KnobMedium",	x: 125.5,	y: 23.5
		},
		{	name: "XFBRight",	type: "Level_100",	n: "KnobMedium",	x: 125.5,	y: 50.5
		},
		{	name: "TimeClk",	type: "TimeClk",	n: "SwM780a6e3d",	x: 32.5,	y: 15.5
		},
		{	name: "LP",	type: "Level_100",	n: "KnobMedium",	x: 153.5,	y: 25.5
		},
		{	name: "DryWet",	type: "Level_100",	n: "KnobMedium",	x: 210.5,	y: 25.5
		},
		{	name: "Active",	type: "ActiveMonitor",	n: "SwM42",	x: 241.25,	y: 31.5
		},
		{	name: "HP",	type: "Level_100",	n: "KnobMedium",	x: 179.5,	y: 25.5
		}
	],
	modes: [
		{	name: "DelayRange",	type: "DelayRange_1"
		}
	],
	ve: [
		{	type: "line",	"x1": 246,	"y1": 9,	"x2": 246,	"y2": 67
		},
		{	type: "line",	"x1": 226,	"y1": 51,	"x2": 226,	"y2": 66
		},
		{	type: "line",	"x1": 226,	"y1": 51,	"x2": 247,	"y2": 51
		},
		{	type: "text",	x: 101,	y: 20,	t: "FB"
		},
		{	type: "valueDisplay",	x: 27,	y: 29,	w: 40,	ref: 0
		},
		{	type: "text",	x: 6,	y: 38,	t: "Left"
		},
		{	type: "text",	x: 124,	y: 20,	t: "X-FB"
		},
		{	type: "valueDisplay",	x: 27,	y: 53,	w: 40,	ref: 0
		},
		{	type: "text",	x: 3,	y: 63,	t: "Right"
		},
		{	type: "text",	x: 200,	y: 22,	t: "Dry/Wet"
		},
		{	type: "text",	x: 164,	y: 13,	t: "Filter"
		},
		{	type: "text",	x: 233,	y: 69,	t: "R"
		},
		{	type: "text",	x: 213,	y: 69,	t: "L"
		},
		{	type: "text",	x: 158,	y: 22,	t: "LP"
		},
		{	type: "text",	x: 183,	y: 22,	t: "HP"
		},
		{	type: "text",	x: 158,	y: 54,	t: "Range"
		}
	]
},/// end of delay
{/// start of env
	id: 20,
	height: 4,
	longnm: "Envelop ADSR",
	shortnm: "EnvADSR",
	page: {
		name: "Env",
		ord: 0
	},
	inputs: [
		{	name: "In",	colour: "purple",	x: 246,	y: 9
		},
		{	name: "Gate",	colour: "yellow",	x: 10,	y: 35
		},
		{	name: "AM",	colour: "blue",	x: 10,	y: 50
		}
	],
	outputs: [
		{	name: "Env",	colour: "blue",	x: 229,	y: 50
		},
		{	name: "Out",	colour: "purple",	x: 246,	y: 50
		}
	],
	params: [
		{	name: "Shape",	type: "EnvShape_3",	n: "SwM0",	x: 178.5,	y: 44.5, isgraph:1
		},
		{	name: "Attack",	type: "EnvTime",	n: "KnobMedium",	x: 53.5,	y: 35.5, isgraph:1
		},
		{	name: "Decay",	type: "EnvTime",	n: "KnobMedium",	x: 87.5,	y: 35.5, isgraph:1
		},
		{	name: "Sustain",	type: "EnvLevel",	n: "KnobMedium",	x: 117.5,	y: 35.5, isgraph:1
		},
		{	name: "Release",	type: "EnvTime",	n: "KnobMedium",	x: 150.5,	y: 35.5, isgraph:1
		},
		{	name: "OutputType",	type: "PosNegInvBipInv",	n: "levelshift",	x: 204.5,	y: 44.5, isgraph:1
		},
		{	name: "KB",	type: "OffOn",	n: "SwM957",	x: 16.5,	y: 16.5
		},
		{	name: "NR",	type: "EnvNR",	n: "SwM0",	x: 35.5,	y: 44.5
		}
	],
	modes: [],
	ve: [
		{	type: "graphenv",	x: 173,	y: 4,	w: 61,	h: 28, f:"adsrGraph"
		},
		{	type: "line",	"x1": 246,	"y1": 10,	"x2": 246,	"y2": 25
		},
		{	type: "line",	"x1": 246,	"y1": 37,	"x2": 246,	"y2": 52
		},
		{	type: "valueDisplay",	x: 42,	y: 17,	w: 32,	ref: 1,	func: "adsrT"
		},
		{	type: "valueDisplay",	x: 139,	y: 17,	w: 32,	ref: 4,	func: "adsrT"
		},
		{	type: "text",	x: 42,	y: 40,	t: "A"
		},
		{	type: "text",	x: 142,	y: 40,	t: "R"
		},
		{	type: "valueDisplay",	x: 76,	y: 17,	w: 32,	ref: 2,	func: "adsrT"
		},
		{	type: "text",	x: 79,	y: 40,	t: "D"
		},
		{	type: "led",	x: 6,	y: 17,	w: 6.5
		},
		{	type: "text",	x: 16,	y: 39,	t: "Gate"
		},
		{	type: "text",	x: 16,	y: 54,	t: "AM"
		},
		{	type: "valueDisplay",	x: 110,	y: 17,	w: 27,	ref: 3,	func: "adsrL"
		},
		{	type: "text",	x: 110,	y: 40,	t: "S"
		},
		{	type: "bmp",	x: 240,	y: 20,	id: "VVCA"
		},
		{	type: "text",	x: 222,	y: 42,	t: "Env"
		},
		{	type: "text",	x: 175,	y: 42,	t: "Shape"
		}
	]
},{
	id: 23,
	height: 5,
	longnm: "Envelope Modulation ADSR",
	shortnm: "ModADSR",
	page: {
		name: "Env",
		ord: 8
	},
	inputs: [
		{	name: "Gate",	colour: "yellow",	x: 10,	y: 50
		},
		{	name: "AttackMod",	colour: "blue",	x: 49,	y: 64
		},
		{	name: "DecayMod",	colour: "blue",	x: 85,	y: 64
		},
		{	name: "SustainMod",	colour: "blue",	x: 121,	y: 64
		},
		{	name: "ReleaseMod",	colour: "blue",	x: 157,	y: 64
		},
		{	name: "In",	colour: "purple",	x: 246,	y: 9
		},
		{	name: "AM",	colour: "blue",	x: 10,	y: 65
		}
	],
	outputs: [
		{	name: "Env",	colour: "blue",	x: 229,	y: 65
		},
		{	name: "Out",	colour: "purple",	x: 246,	y: 65
		}
	],
	params: [
		{	name: "Attack",	type: "EnvTime",	n: "KnobMedium",	x: 38.5,	y: 31.5, isgraph:1
		},
		{	name: "Decay",	type: "EnvTime",	n: "KnobMedium",	x: 74.5,	y: 31.5, isgraph:1
		},
		{	name: "Sustain",	type: "EnvLevel",	n: "KnobMedium",	x: 110.5,	y: 31.5, isgraph:1
		},
		{	name: "Release",	type: "EnvTime",	n: "KnobMedium",	x: 146.5,	y: 31.5, isgraph:1
		},
		{	name: "AttackMod",	type: "Level_100",	n: "KnobSmall",	x: 57.5,	y: 52.5
		},
		{	name: "DecayMod",	type: "Level_100",	n: "KnobSmall",	x: 93.5,	y: 52.5
		},
		{	name: "SustainMod",	type: "Level_100",	n: "KnobSmall",	x: 129.5,	y: 52.5
		},
		{	name: "ReleaseMod",	type: "Level_100",	n: "KnobSmall",	x: 165.5,	y: 52.5
		},
		{	name: "OutputType",	type: "PosNegInvBipInv",	n: "levelshift",	x: 200.5,	y: 59.5, isgraph:1
		},
		{	name: "KB",	type: "OffOn",	n: "SwM957",	x: 4.5,	y: 17.5
		}
	],
	modes: [],
	ve: [
		{	type: "graphenv",	x: 173,	y: 4,	w: 61,	h: 28, f:"adsrMGraph"
		},
		{	type: "line",	"x1": 48,	"y1": 64,	"x2": 70,	"y2": 64
		},
		{	type: "line",	"x1": 84,	"y1": 64,	"x2": 106,	"y2": 64
		},
		{	type: "line",	"x1": 120,	"y1": 64,	"x2": 142,	"y2": 64
		},
		{	type: "line",	"x1": 156,	"y1": 64,	"x2": 178,	"y2": 64
		},
		{	type: "line",	"x1": 246,	"y1": 9,	"x2": 246,	"y2": 31
		},
		{	type: "line",	"x1": 246,	"y1": 43,	"x2": 246,	"y2": 65
		},
		{	type: "valueDisplay",	x: 30,	y: 14,	w: 35,	ref: 0,	func: "adsrT"
		},
		{	type: "valueDisplay",	x: 136,	y: 14,	w: 35,	ref: 3,	func: "adsrT"
		},
		{	type: "text",	x: 29,	y: 37,	t: "A"
		},
		{	type: "text",	x: 139,	y: 37,	t: "R"
		},
		{	type: "valueDisplay",	x: 68,	y: 14,	w: 35,	ref: 1,	func: "adsrT"
		},
		{	type: "text",	x: 67,	y: 37,	t: "D"
		},
		{	type: "valueDisplay",	x: 106,	y: 14,	w: 27,	ref: 2,	func: "adsrL"
		},
		{	type: "text",	x: 103,	y: 37,	t: "S"
		},
		{	type: "led",	x: 6,	y: 33,	w: 6.5
		},
		{	type: "text",	x: 16,	y: 54,	t: "Gate"
		},
		{	type: "text",	x: 16,	y: 69,	t: "AM"
		},
		{	type: "bmp",	x: 240,	y: 27,	id: "VVCA"
		},
		{	type: "text",	x: 219,	y: 57,	t: "Env"
		}
	]
},{
	id: 41,
	height: 2,
	longnm: "Envelope Hold",
	shortnm: "EnvH",
	page: {
		name: "Env",
		ord: 1
	},
	inputs: [
		{	name: "Trig",	colour: "yellow",	x: 10,	y: 20
		},
		{	name: "AM",	colour: "blue",	x: 55,	y: 20
		},
		{	name: "In",	colour: "purple",	x: 216,	y: 16
		}
	],
	outputs: [
		{	name: "Env",	colour: "blue",	x: 200,	y: 18
		},
		{	name: "Out",	colour: "purple",	x: 246,	y: 16
		}
	],
	params: [
		{	name: "Hold",	type: "EnvTime",	n: "KnobMedium",	x: 119.5,	y: 5.5, isgraph:1
		},
		{	name: "OutputType",	type: "PosNegInv",	n: "levelshift",	x: 176.5,	y: 14.5, isgraph:1
		}
	],
	modes: [],
	ve: [
		{	type: "graphenv",	x: 142,	y: 4,	w: 31,	h: 22, f:"henvGraph"
		},
		{	type: "text",	x: 21,	y: 24,	t: "Trig"
		},
		{	type: "led",	x: 40,	y: 18,	w: 6.5
		},
		{	type: "text",	x: 61,	y: 24,	t: "AM"
		},
		{	type: "valueDisplay",	x: 81,	y: 12,	w: 35,	ref: 0
		},
		{	type: "bmp",	x: 221,	y: 10,	id: "HVCA"
		},
		{	type: "text",	x: 190,	y: 10,	t: "Env"
		}
	]
},{
	id: 46,
	height: 4,
	longnm: "Envelope AHD",
	shortnm: "EnvAHD",
	page: {
		name: "Env",
		ord: 4
	},
	inputs: [
		{	name: "Trig",	colour: "yellow",	x: 10,	y: 35
		},
		{	name: "AM",	colour: "blue",	x: 10,	y: 50
		},
		{	name: "In",	colour: "purple",	x: 246,	y: 9
		}
	],
	outputs: [
		{	name: "Env",	colour: "blue",	x: 229,	y: 50
		},
		{	name: "Out",	colour: "purple",	x: 246,	y: 50
		}
	],
	params: [
		{	name: "Shape",	type: "EnvShape_3",	n: "SwM0",	x: 178.5,	y: 44.5, isgraph:1
		},
		{	name: "Attack",	type: "EnvTime",	n: "KnobMedium",	x: 64.5,	y: 35.5, isgraph:1
		},
		{	name: "Hold",	type: "EnvTime",	n: "KnobMedium",	x: 107.5,	y: 35.5, isgraph:1
		},
		{	name: "NR",	type: "EnvNR",	n: "SwM0",	x: 46.5,	y: 44.5
		},
		{	name: "Decay",	type: "EnvTime",	n: "KnobMedium",	x: 150.5,	y: 35.5, isgraph:1
		},
		{	name: "OutputType",	type: "PosNegInv",	n: "levelshift",	x: 203.5,	y: 44.5, isgraph:1
		},
		{	name: "KB",	type: "OffOn",	n: "SwM957",	x: 16.5,	y: 16.5
		}
	],
	modes: [],
	ve: [
		{	type: "graphenv",	x: 176,	y: 4,	w: 58,	h: 28, f:"ahdGraph"
		},
		{	type: "line",	"x1": 246,	"y1": 9,	"x2": 246,	"y2": 25
		},
		{	type: "line",	"x1": 246,	"y1": 37,	"x2": 246,	"y2": 53
		},
		{	type: "text",	x: 22,	y: 39,	t: "Trig"
		},
		{	type: "led",	x: 6,	y: 18,	w: 6.5
		},
		{	type: "text",	x: 17,	y: 54,	t: "AM"
		},
		{	type: "valueDisplay",	x: 51,	y: 18,	w: 35,	ref: 1
		},
		{	type: "valueDisplay",	x: 137,	y: 18,	w: 35,	ref: 4
		},
		{	type: "text",	x: 51,	y: 41,	t: "A"
		},
		{	type: "text",	x: 137,	y: 41,	t: "D"
		},
		{	type: "valueDisplay",	x: 94,	y: 18,	w: 35,	ref: 2
		},
		{	type: "text",	x: 95,	y: 42,	t: "H"
		},
		{	type: "bmp",	x: 240,	y: 20,	id: "VVCA"
		},
		{	type: "text",	x: 219,	y: 42,	t: "Env"
		},
		{	type: "text",	x: 176,	y: 41,	t: "Shape"
		}
	]
},{
	id: 52,
	height: 6,
	longnm: "Envelope Multi",
	shortnm: "EnvMulti",
	page: {
		name: "Env",
		ord: 6
	},
	inputs: [
		{	name: "Gate",	colour: "yellow",	x: 10,	y: 33
		},
		{	name: "In",	colour: "purple",	x: 216,	y: 9
		},
		{	name: "AM",	colour: "blue",	x: 48,	y: 33
		}
	],
	outputs: [
		{	name: "Env",	colour: "blue",	x: 246,	y: 26
		},
		{	name: "Out",	colour: "purple",	x: 246,	y: 9
		}
	],
	params: [
		{	name: "Level1",	type: "EnvLevel",	n: "KnobMedium",	x: 49.5,	y: 65.5, isgraph:1
		},
		{	name: "Level2",	type: "EnvLevel",	n: "KnobMedium",	x: 109.5,	y: 65.5, isgraph:1
		},
		{	name: "Level3",	type: "EnvLevel",	n: "KnobMedium",	x: 169.5,	y: 65.5, isgraph:1
		},
		{	name: "Level4",	type: "EnvLevel",	n: "KnobMedium",	x: 229.5,	y: 65.5, isgraph:1
		},
		{	name: "Time1",	type: "EnvTime",	n: "KnobMedium",	x: 22.5,	y: 65.5, isgraph:1
		},
		{	name: "Time2",	type: "EnvTime",	n: "KnobMedium",	x: 80.5,	y: 65.5, isgraph:1
		},
		{	name: "Time3",	type: "EnvTime",	n: "KnobMedium",	x: 140.5,	y: 65.5, isgraph:1
		},
		{	name: "Time4",	type: "EnvTime",	n: "KnobMedium",	x: 200.5,	y: 65.5, isgraph:1
		},
		{	name: "NR",	type: "EnvNR",	n: "SwM0",	x: 4.5,	y: 74.5
		},
		{	name: "SustainMode",	type: "SustainMode_2",	n: "SwM506b10bd",	x: 68.5,	y: 24.5, isgraph:1
		},
		{	name: "OutputType",	type: "PosNegInvBip",	n: "levelshift",	x: 205.5,	y: 20.5, isgraph:1
		},
		{	name: "KB",	type: "OffOn",	n: "SwM957",	x: 16.5,	y: 16.5
		},
		{	name: "Shape",	type: "EnvShape_3",	n: "SwM0",	x: 179.5,	y: 20.5, isgraph:1
		}
	],
	modes: [],
	ve: [
		{	type: "graphenv",	x: 92,	y: 4,	w: 84,	h: 28, f:"multiEnvGraph"
		},
		{	type: "line",	"x1": 40,	"y1": 44,	"x2": 52,	"y2": 44
		},
		{	type: "line",	"x1": 100,	"y1": 44,	"x2": 112,	"y2": 44
		},
		{	type: "line",	"x1": 159,	"y1": 44,	"x2": 171,	"y2": 44
		},
		{	type: "line",	"x1": 218,	"y1": 44,	"x2": 230,	"y2": 44
		},
		{	type: "led",	x: 6,	y: 18,	w: 6.5
		},
		{	type: "text",	x: 16,	y: 37,	t: "Gate"
		},
		{	type: "text",	x: 39,	y: 26,	t: "AM"
		},
		{	type: "valueDisplay",	x: 47,	y: 49,	w: 24,	ref: 0,	func: "adsrL"
		},
		{	type: "text",	x: 54,	y: 47,	t: "L1"
		},
		{	type: "valueDisplay",	x: 107,	y: 49,	w: 24,	ref: 1,	func: "adsrL"
		},
		{	type: "text",	x: 114,	y: 47,	t: "L2"
		},
		{	type: "valueDisplay",	x: 167,	y: 49,	w: 24,	ref: 2,	func: "adsrL"
		},
		{	type: "text",	x: 172,	y: 47,	t: "L3"
		},
		{	type: "valueDisplay",	x: 227,	y: 49,	w: 24,	ref: 3,	func: "adsrL"
		},
		{	type: "text",	x: 231,	y: 47,	t: "L4"
		},
		{	type: "valueDisplay",	x: 13,	y: 49,	w: 32,	ref: 4,	func: "adsrT"
		},
		{	type: "text",	x: 26,	y: 47,	t: "T1"
		},
		{	type: "valueDisplay",	x: 73,	y: 49,	w: 32,	ref: 5,	func: "adsrT"
		},
		{	type: "text",	x: 84,	y: 47,	t: "T2"
		},
		{	type: "valueDisplay",	x: 133,	y: 49,	w: 32,	ref: 6,	func: "adsrT"
		},
		{	type: "text",	x: 144,	y: 47,	t: "T3"
		},
		{	type: "valueDisplay",	x: 193,	y: 49,	w: 32,	ref: 7,	func: "adsrT"
		},
		{	type: "text",	x: 203,	y: 47,	t: "T4"
		},
		{	type: "text",	x: 58,	y: 22,	t: "Sustain"
		},
		{	type: "text",	x: 177,	y: 17,	t: "Shape"
		},
		{	type: "bmp",	x: 220,	y: 3,	id: "HVCA"
		},
		{	type: "text",	x: 222,	y: 29,	t: "Env"
		}
	]
},{
	id: 55,
	height: 2,
	longnm: "Envelope Decay",
	shortnm: "EnvD",
	page: {
		name: "Env",
		ord: 2
	},
	inputs: [
		{	name: "Trig",	colour: "yellow",	x: 10,	y: 20
		},
		{	name: "AM",	colour: "blue",	x: 55,	y: 20
		},
		{	name: "In",	colour: "purple",	x: 216,	y: 16
		}
	],
	outputs: [
		{	name: "Env",	colour: "blue",	x: 200,	y: 18
		},
		{	name: "Out",	colour: "purple",	x: 246,	y: 16
		}
	],
	params: [
		{	name: "Decay",	type: "EnvTime",	n: "KnobMedium",	x: 119.5,	y: 5.5, isgraph:1
		},
		{	name: "OutputType",	type: "PosNegInv",	n: "levelshift",	x: 176.5,	y: 14.5, isgraph:1
		}
	],
	modes: [],
	ve: [
		{	type: "graphenv",	x: 142,	y: 4,	w: 31,	h: 22, f:"denvGraph"
		},
		{	type: "text",	x: 21,	y: 24,	t: "Trig"
		},
		{	type: "led",	x: 40,	y: 18,	w: 6.5
		},
		{	type: "text",	x: 61,	y: 24,	t: "AM"
		},
		{	type: "valueDisplay",	x: 81,	y: 12,	w: 35,	ref: 0
		},
		{	type: "bmp",	x: 221,	y: 10,	id: "HVCA"
		},
		{	type: "text",	x: 190,	y: 10,	t: "Env"
		}
	]
},{
	id: 84,
	height: 3,
	longnm: "Envelope ADR",
	shortnm: "EnvADR",
	page: {
		name: "Env",
		ord: 3
	},
	inputs: [
		{	name: "Gate",	colour: "yellow",	x: 10,	y: 35
		},
		{	name: "In",	colour: "purple",	x: 246,	y: 9
		},
		{	name: "AM",	colour: "blue",	x: 58,	y: 35
		}
	],
	outputs: [
		{	name: "Env",	colour: "blue",	x: 229,	y: 35
		},
		{	name: "Out",	colour: "purple",	x: 246,	y: 35
		},
		{	name: "End",	colour: "yellow",	x: 211,	y: 35
		}
	],
	params: [
		{	name: "Shape",	type: "EnvShape_3",	n: "SwM0",	x: 165.5,	y: 14.5, isgraph:1
		},
		{	name: "Attack",	type: "EnvTime",	n: "KnobMedium",	x: 93.5,	y: 20.5, isgraph:1
		},
		{	name: "NR",	type: "EnvNR",	n: "SwM0",	x: 76.5,	y: 29.5
		},
		{	name: "Release",	type: "EnvTime",	n: "KnobMedium",	x: 142.5,	y: 20.5, isgraph:1
		},
		{	name: "TG",	type: "TrigGate",	n: "SwM4d79a85b",	x: 18.5,	y: 29.5
		},
		{	name: "OutputType",	type: "PosNegInv",	n: "levelshift",	x: 167.5,	y: 29.5, isgraph:1
		},
		{	name: "KB",	type: "OffOn",	n: "SwM957",	x: 18.5,	y: 16.5
		},
		{	name: "DcyRel",	type: "AdAr",	n: "SwM432a2079",	x: 119.5,	y: 29.5, isgraph:1
		}
	],
	modes: [],
	ve: [
		{	type: "graphenv",	x: 189,	y: 3,	w: 45,	h: 24, f:"adrGraph"
		},
		{	type: "led",	x: 6,	y: 18,	w: 6.5
		},
		{	type: "text",	x: 49,	y: 27,	t: "AM"
		},
		{	type: "text",	x: 184,	y: 39,	t: "End"
		},
		{	type: "valueDisplay",	x: 79,	y: 4,	w: 35,	ref: 1
		},
		{	type: "valueDisplay",	x: 123,	y: 4,	w: 35,	ref: 3
		},
		{	type: "text",	x: 80,	y: 27,	t: "A"
		},
		{	type: "bmp",	x: 240,	y: 12,	id: "VVCA"
		},
		{	type: "text",	x: 161,	y: 11,	t: "Shape"
		}
	]
},{
	id: 119,
	height: 5,
	longnm: "Envelope ADDSR",
	shortnm: "EnvADDSR",
	page: {
		name: "Env",
		ord: 5
	},
	inputs: [
		{	name: "Gate",	colour: "yellow",	x: 10,	y: 41
		},
		{	name: "AM",	colour: "blue",	x: 10,	y: 65
		},
		{	name: "In",	colour: "purple",	x: 216,	y: 9
		}
	],
	outputs: [
		{	name: "Env",	colour: "blue",	x: 246,	y: 26
		},
		{	name: "Out",	colour: "purple",	x: 246,	y: 9
		}
	],
	params: [
		{	name: "KB",	type: "OffOn",	n: "SwM957",	x: 16.5,	y: 17.5
		},
		{	name: "Shape",	type: "EnvShape_3",	n: "SwM0",	x: 179.5,	y: 20.5, isgraph:1
		},
		{	name: "Attack",	type: "EnvTime",	n: "KnobMedium",	x: 55.5,	y: 50.5, isgraph:2
		},
		{	name: "Decay1",	type: "EnvTime",	n: "KnobMedium",	x: 91.5,	y: 50.5, isgraph:3
		},
		{	name: "Level1",	type: "EnvLevel",	n: "KnobMedium",	x: 126.5,	y: 50.5, isgraph:4
		},
		{	name: "Decay2",	type: "EnvTime",	n: "KnobMedium",	x: 159.5,	y: 50.5, isgraph:5
		},
		{	name: "Level2",	type: "EnvLevel",	n: "KnobMedium",	x: 193.5,	y: 50.5, isgraph:6
		},
		{	name: "Release",	type: "EnvTime",	n: "KnobMedium",	x: 227.5,	y: 50.5, isgraph:7
		},
		{	name: "SustainMode",	type: "SustainMode_1",	n: "SwM445ef0d",	x: 70.5,	y: 17.5, isgraph:8
		},
		{	name: "OutputType",	type: "PosNegInvBipInv",	n: "levelshift",	x: 205.5,	y: 20.5, isgraph:9
		},
		{	name: "NR",	type: "EnvNR",	n: "SwM0",	x: 37.5,	y: 59.5
		}
	],
	modes: [],
	ve: [
		{	type: "graphenv",	x: 92,	y: 4,	w: 84,	h: 28, f:"addsrGraph"
		},
		{	type: "text",	x: 16,	y: 69,	t: "AM"
		},
		{	type: "led",	x: 6,	y: 19,	w: 6.5
		},
		{	type: "text",	x: 16,	y: 45,	t: "Gate"
		},
		{	type: "valueDisplay",	x: 42,	y: 34,	w: 35,	ref: 2
		},
		{	type: "valueDisplay",	x: 148,	y: 34,	w: 35,	ref: 5
		},
		{	type: "text",	x: 44,	y: 56,	t: "A"
		},
		{	type: "text",	x: 147,	y: 56,	t: "D2"
		},
		{	type: "valueDisplay",	x: 80,	y: 34,	w: 35,	ref: 3
		},
		{	type: "text",	x: 80,	y: 56,	t: "D1"
		},
		{	type: "valueDisplay",	x: 118,	y: 34,	w: 27,	ref: 4
		},
		{	type: "text",	x: 115,	y: 56,	t: "L1"
		},
		{	type: "valueDisplay",	x: 186,	y: 34,	w: 27,	ref: 6
		},
		{	type: "text",	x: 181,	y: 56,	t: "L2"
		},
		{	type: "valueDisplay",	x: 216,	y: 34,	w: 35,	ref: 7
		},
		{	type: "text",	x: 218,	y: 56,	t: "R"
		},
		{	type: "text",	x: 36,	y: 26,	t: "Sustain"
		},
		{	type: "bmp",	x: 221,	y: 3,	id: "HVCA"
		},
		{	type: "text",	x: 222,	y: 29,	t: "Env"
		},
		{	type: "text",	x: 177,	y: 16,	t: "Shape"
		}
	]
},{
	id: 169,
	height: 5,
	longnm: "Envelope Modulation AHD",
	shortnm: "ModAHD",
	page: {
		name: "Env",
		ord: 7
	},
	inputs: [
		{	name: "Trig",	colour: "yellow",	x: 10,	y: 36
		},
		{	name: "AttackMod",	colour: "blue",	x: 72,	y: 64
		},
		{	name: "HoldMod",	colour: "blue",	x: 116,	y: 64
		},
		{	name: "DecayMod",	colour: "blue",	x: 159,	y: 64
		},
		{	name: "In",	colour: "purple",	x: 246,	y: 9
		},
		{	name: "AM",	colour: "blue",	x: 10,	y: 65
		}
	],
	outputs: [
		{	name: "Env",	colour: "blue",	x: 229,	y: 65
		},
		{	name: "Out",	colour: "purple",	x: 246,	y: 65
		}
	],
	params: [
		{	name: "Attack",	type: "EnvTime",	n: "KnobMedium",	x: 60.5,	y: 31.5, isgraph:1
		},
		{	name: "Hold",	type: "EnvTime",	n: "KnobMedium",	x: 103.5,	y: 31.5, isgraph:1
		},
		{	name: "Decay",	type: "EnvTime",	n: "KnobMedium",	x: 146.5,	y: 31.5, isgraph:1
		},
		{	name: "AttackMod",	type: "Level_100",	n: "KnobSmall",	x: 80.5,	y: 52.5
		},
		{	name: "HoldMod",	type: "Level_100",	n: "KnobSmall",	x: 124.5,	y: 52.5
		},
		{	name: "DecayMod",	type: "Level_100",	n: "KnobSmall",	x: 167.5,	y: 52.5
		},
		{	name: "OutputType",	type: "PosNegInv",	n: "levelshift",	x: 200.5,	y: 59.5, isgraph:1
		},
		{	name: "KB",	type: "OffOn",	n: "SwM957",	x: 16.5,	y: 17.5
		}
	],
	modes: [],
	ve: [
		{	type: "graphenv",	x: 176,	y: 4,	w: 58,	h: 28, f:"ahdMGraph"
		},
		{	type: "line",	"x1": 71,	"y1": 64,	"x2": 93,	"y2": 64
		},
		{	type: "line",	"x1": 113,	"y1": 64,	"x2": 135,	"y2": 64
		},
		{	type: "line",	"x1": 156,	"y1": 64,	"x2": 178,	"y2": 64
		},
		{	type: "line",	"x1": 246,	"y1": 8,	"x2": 246,	"y2": 31
		},
		{	type: "line",	"x1": 246,	"y1": 44,	"x2": 246,	"y2": 67
		},
		{	type: "text",	x: 22,	y: 41,	t: "Trig"
		},
		{	type: "led",	x: 6,	y: 19,	w: 6.5
		},
		{	type: "text",	x: 17,	y: 69,	t: "AM"
		},
		{	type: "valueDisplay",	x: 51,	y: 14,	w: 35,	ref: 0
		},
		{	type: "valueDisplay",	x: 137,	y: 14,	w: 35,	ref: 2
		},
		{	type: "text",	x: 50,	y: 39,	t: "A"
		},
		{	type: "text",	x: 137,	y: 39,	t: "D"
		},
		{	type: "valueDisplay",	x: 94,	y: 14,	w: 35,	ref: 1
		},
		{	type: "text",	x: 93,	y: 39,	t: "H"
		},
		{	type: "bmp",	x: 240,	y: 27,	id: "VVCA"
		},
		{	type: "text",	x: 219,	y: 57,	t: "Env"
		}
	]
},/// end of env
{/// start of switch
	id: 15,
	height: 4,
	longnm: "Switch 8-1",
	shortnm: "Sw8-1",
	page: {
		name: "Switch",
		ord: 5
	},
	inputs: [
		{	name: "In1",	colour: "purple",	x: 88,	y: 9
		},
		{	name: "In2",	colour: "purple",	x: 130,	y: 9
		},
		{	name: "In3",	colour: "purple",	x: 172,	y: 9
		},
		{	name: "In4",	colour: "purple",	x: 214,	y: 9
		},
		{	name: "In5",	colour: "purple",	x: 105,	y: 20
		},
		{	name: "In6",	colour: "purple",	x: 147,	y: 20
		},
		{	name: "In7",	colour: "purple",	x: 189,	y: 20
		},
		{	name: "In8",	colour: "purple",	x: 231,	y: 20
		}
	],
	outputs: [
		{	name: "Out",	colour: "purple",	x: 246,	y: 50
		},
		{	name: "Control",	colour: "blue",	x: 10,	y: 50
		}
	],
	params: [
		{	name: "Sel",	type: "sw_3",	n: "SwM322bb710",	x: 67.5,	y: 29.5
		}
	],
	modes: [],
	ve: [
		{	type: "text",	x: 60,	y: 38.5,	t: "1"
		},
		{	type: "text",	x: 59,	y: 50,	t: "5"
		},
		{	type: "valueDisplay",	x: 19,	y: 42,	w: 17,	ref: 0
		},
		{	type: "text",	x: 3,	y: 41,	t: "Control"
		},
		{	type: "text",	x: 77,	y: 13,	t: "1"
		},
		{	type: "text",	x: 117,	y: 13,	t: "2"
		},
		{	type: "text",	x: 200,	y: 13,	t: "4"
		},
		{	type: "text",	x: 159,	y: 13,	t: "3"
		},
		{	type: "text",	x: 93,	y: 25,	t: "5"
		},
		{	type: "text",	x: 135,	y: 25,	t: "6"
		},
		{	type: "text",	x: 218,	y: 25,	t: "8"
		},
		{	type: "text",	x: 177,	y: 25,	t: "7"
		}
	]
},{
	id: 17,
	height: 2,
	longnm: "Value Switch 1-2",
	shortnm: "ValSw1-2",
	page: {
		name: "Switch",
		ord: 11
	},
	inputs: [
		{	name: "Input",	colour: "purple",	x: 186,	y: 18
		},
		{	name: "Ctrl",	colour: "purple",	x: 10,	y: 20
		}
	],
	outputs: [
		{	name: "OutOn",	colour: "purple",	x: 246,	y: 18
		},
		{	name: "OutOff",	colour: "purple",	x: 216,	y: 18
		}
	],
	params: [
		{	name: "Val",	type: "ValSwVal",	n: "KnobSpinH",	x: 82.5,	y: 15.5
		}
	],
	modes: [],
	ve: [
		{	type: "line",	"x1": 186,	"y1": 6,	"x2": 232,	"y2": 6
		},
		{	type: "line",	"x1": 186,	"y1": 6,	"x2": 186,	"y2": 13
		},
		{	type: "line",	"x1": 122,	"y1": 20,	"x2": 151,	"y2": 20
		},
		{	type: "bmp",	x: 218,	y: 6,	id: "SW12"
		},
		{	type: "text",	x: 240,	y: 10,	t: "On"
		},
		{	type: "text",	x: 17,	y: 24,	t: "Ctrl"
		},
		{	type: "text",	x: 17,	y: 24,	t: "Ctrl"
		},
		{	type: "valueDisplay",	x: 106,	y: 13,	w: 17,	ref: 0
		},
		{	type: "text",	x: 83,	y: 10,	t: "Ctrl Value"
		},
		{	type: "led",	x: 146,	y: 17,	w: 6.5
		},
		{	type: "text",	x: 144,	y: 14,	t: "On"
		}
	]
},{
	id: 21,
	height: 2,
	longnm: "Multiplexer 1-8",
	shortnm: "Mux1-8",
	page: {
		name: "Switch",
		ord: 14
	},
	inputs: [
		{	name: "In",	colour: "purple",	x: 86,	y: 18
		},
		{	name: "Ctrl",	colour: "blue",	x: 10,	y: 20
		}
	],
	outputs: [
		{	name: "Out1",	colour: "purple",	x: 106,	y: 18
		},
		{	name: "Out2",	colour: "purple",	x: 126,	y: 18
		},
		{	name: "Out3",	colour: "purple",	x: 146,	y: 18
		},
		{	name: "Out4",	colour: "purple",	x: 166,	y: 18
		},
		{	name: "Out5",	colour: "purple",	x: 186,	y: 18
		},
		{	name: "Out6",	colour: "purple",	x: 206,	y: 18
		},
		{	name: "Out7",	colour: "purple",	x: 226,	y: 18
		},
		{	name: "Out8",	colour: "purple",	x: 246,	y: 18
		}
	],
	params: [],
	modes: [],
	ve: [
		{	type: "text",	x: 97,	y: 10,	t: "1"
		},
		{	type: "text",	x: 116,	y: 10,	t: "2"
		},
		{	type: "text",	x: 136,	y: 10,	t: "3"
		},
		{	type: "text",	x: 155,	y: 10,	t: "4"
		},
		{	type: "text",	x: 176,	y: 10,	t: "5"
		},
		{	type: "text",	x: 196,	y: 10,	t: "6"
		},
		{	type: "text",	x: 216,	y: 10,	t: "7"
		},
		{	type: "text",	x: 236,	y: 10,	t: "8"
		},
		{	type: "ledArray",	x: 102,	y: 3,	w: 6.5,	xo:20,	cnt:8
		},
		{	type: "text",	x: 17,	y: 24,	t: "Ctrl"
		}
	]
},{
	id: 36,
	height: 2,
	longnm: "Switch On/Off Momentary",
	shortnm: "SwOnOffM",
	page: {
		name: "Switch",
		ord: 0
	},
	inputs: [
		{	name: "In",	colour: "purple",	x: 216,	y: 18
		}
	],
	outputs: [
		{	name: "Out",	colour: "purple",	x: 246,	y: 18
		},
		{	name: "Ctrl",	colour: "blue",	x: 10,	y: 20
		}
	],
	params: [
		{	name: "On",	type: "OffOn",	n: "SwM9ff",	x: 152.5,	y: 10.5, w:44
		}
	],
	modes: [],
	ve: [
		{	type: "path",	d:"M174,12L174,6 230,6 230,12"
		},
		{	type: "bmp",	x: 218,	y: 6,	id: "SWcon"
		},
		{	type: "valueDisplay",	x: 18,	y: 13,	w: 17,	ref: 0
		},
		{	type: "text",	x: 37,	y: 23,	t: "Ctrl"
		},
		{	type: "bmp",	x: 143,	y: 11,	id: "SWMcon"
		}
	]
},{
	id: 53,
	height: 2,
	longnm: "Sample & Hold",
	shortnm: "S&H",
	page: {
		name: "Switch",
		ord: 16
	},
	inputs: [
		{	name: "In",	colour: "purple",	x: 198,	y: 18
		},
		{	name: "Ctrl",	colour: "orange",	x: 168,	y: 18
		}
	],
	outputs: [
		{	name: "Out",	colour: "purple",	x: 246,	y: 18
		}
	],
	params: [],
	modes: [],
	ve: [
		{	type: "line",	"x1": 168,	"y1": 6,	"x2": 215,	"y2": 6
		},
		{	type: "line",	"x1": 168,	"y1": 6,	"x2": 168,	"y2": 16
		},
		{	type: "line",	"x1": 236,	"y1": 18,	"x2": 251,	"y2": 18
		},
		{	type: "bmp",	x: 203,	y: 6,	id: "SH"
		},
		{	type: "text",	x: 77,	y: 10,	t: "Sample and Hold"
		},
		{	type: "bmp",	x: 225,	y: 13,	id: 7
		},
		{	type: "text",	x: 143,	y: 22,	t: "Ctrl"
		}
	]
},{
	id: 60,
	height: 3,
	longnm: "Multiplexer 8-1 with variable X-Fade",
	shortnm: "Mux8-1X",
	page: {
		name: "Switch",
		ord: 15
	},
	inputs: [
		{	name: "In1",	colour: "purple",	x: 38,	y: 35
		},
		{	name: "In2",	colour: "purple",	x: 58,	y: 35
		},
		{	name: "In3",	colour: "purple",	x: 78,	y: 35
		},
		{	name: "In4",	colour: "purple",	x: 98,	y: 35
		},
		{	name: "In5",	colour: "purple",	x: 118,	y: 35
		},
		{	name: "In6",	colour: "purple",	x: 138,	y: 35
		},
		{	name: "In7",	colour: "purple",	x: 158,	y: 35
		},
		{	name: "In8",	colour: "purple",	x: 178,	y: 35
		},
		{	name: "Ctrl",	colour: "blue",	x: 10,	y: 35
		}
	],
	outputs: [
		{	name: "Out",	colour: "purple",	x: 246,	y: 35
		}
	],
	params: [
		{	name: "XFade",	type: "Level_100",	n: "KnobMedium",	x: 190.5,	y: 20.5
		}
	],
	modes: [],
	ve: [
		{	type: "graph",	x: 217,	y: 4,	w: 34,	h: 22
		},
		{	type: "text",	x: 29,	y: 28,	t: "1"
		},
		{	type: "text",	x: 48,	y: 28,	t: "2"
		},
		{	type: "text",	x: 68,	y: 28,	t: "3"
		},
		{	type: "text",	x: 87,	y: 28,	t: "4"
		},
		{	type: "text",	x: 108,	y: 28,	t: "5"
		},
		{	type: "text",	x: 128,	y: 28,	t: "6"
		},
		{	type: "text",	x: 148,	y: 28,	t: "7"
		},
		{	type: "text",	x: 168,	y: 28,	t: "8"
		},
		{	type: "ledArray",	x: 34,	y: 21,	w: 6.5,	xo:20,	cnt:8
		},
		{	type: "text",	x: 3,	y: 28,	t: "Ctrl"
		},
		{	type: "text",	x: 182,	y: 17,	t: "X-Fade"
		}
	]
},{
	id: 76,
	height: 2,
	longnm: "Switch On/Off Toggle",
	shortnm: "SwOnOffT",
	page: {
		name: "Switch",
		ord: 1
	},
	inputs: [
		{	name: "In",	colour: "purple",	x: 216,	y: 18
		}
	],
	outputs: [
		{	name: "Out",	colour: "purple",	x: 246,	y: 18
		},
		{	name: "Ctrl",	colour: "blue",	x: 10,	y: 20
		}
	],
	params: [
		{	name: "On",	type: "OffOn",	n: "SwM9ff",	x: 152.5,	y: 10.5, w:44
		}
	],
	modes: [],
	ve: [
		{	type: "path",	d:"M174,12L174,6 230,6 230,12"
		},
		{	type: "bmp",	x: 218,	y: 6,	id: "SWcon"
		},
		{	type: "valueDisplay",	x: 18,	y: 13,	w: 17,	ref: 0
		},
		{	type: "text",	x: 37,	y: 23,	t: "Ctrl"
		}
	]
},{
	id: 78,
	height: 4,
	longnm: "Switch 1-8",
	shortnm: "Sw1-8",
	page: {
		name: "Switch",
		ord: 9
	},
	inputs: [
		{	name: "In",	colour: "purple",	x: 56,	y: 50
		}
	],
	outputs: [
		{	name: "Out1",	colour: "purple",	x: 94,	y: 38
		},
		{	name: "Out2",	colour: "purple",	x: 137,	y: 38
		},
		{	name: "Out3",	colour: "purple",	x: 180,	y: 38
		},
		{	name: "Out4",	colour: "purple",	x: 223,	y: 38
		},
		{	name: "Out5",	colour: "purple",	x: 117,	y: 50
		},
		{	name: "Out6",	colour: "purple",	x: 160,	y: 50
		},
		{	name: "Out7",	colour: "purple",	x: 203,	y: 50
		},
		{	name: "Out8",	colour: "purple",	x: 246,	y: 50
		},
		{	name: "Ctrl",	colour: "blue",	x: 10,	y: 50
		}
	],
	params: [
		{	name: "Sel",	type: "sw_3",	n: "SwM322bb710",	x: 82.5,	y: 4.5
		}
	],
	modes: [],
	ve: [
		{	type: "text",	x: 75,	y: 13.5,	t: "1"
		},
		{	type: "text",	x: 74,	y: 25,	t: "5"
		},
		{	type: "valueDisplay",	x: 19,	y: 42,	w: 17,	ref: 0
		},
		{	type: "text",	x: 3,	y: 41,	t: "Control"
		},
		{	type: "text",	x: 82,	y: 42,	t: "1"
		},
		{	type: "text",	x: 124,	y: 42,	t: "2"
		},
		{	type: "text",	x: 209,	y: 42,	t: "4"
		},
		{	type: "text",	x: 167,	y: 42,	t: "3"
		},
		{	type: "text",	x: 104,	y: 55,	t: "5"
		},
		{	type: "text",	x: 147,	y: 55,	t: "6"
		},
		{	type: "text",	x: 233,	y: 55,	t: "8"
		},
		{	type: "text",	x: 190,	y: 55,	t: "7"
		},
		{	type: "text",	x: 52,	y: 43,	t: "In"
		}
	]
},{
	id: 79,
	height: 3,
	longnm: "Switch 4-1",
	shortnm: "Sw4-1",
	page: {
		name: "Switch",
		ord: 4
	},
	inputs: [
		{	name: "In1",	colour: "purple",	x: 88,	y: 16
		},
		{	name: "In2",	colour: "purple",	x: 132,	y: 16
		},
		{	name: "In3",	colour: "purple",	x: 175,	y: 16
		},
		{	name: "In4",	colour: "purple",	x: 218,	y: 16
		}
	],
	outputs: [
		{	name: "Out",	colour: "purple",	x: 246,	y: 35
		},
		{	name: "Ctrl",	colour: "blue",	x: 10,	y: 35
		}
	],
	params: [
		{	name: "Sel",	type: "sw_2",	n: "SwM6330d1d2",	x: 67.5,	y: 27.5
		}
	],
	modes: [],
	ve: [
		{	type: "valueDisplay",	x: 19,	y: 27,	w: 17,	ref: 0
		},
		{	type: "text",	x: 3,	y: 26,	t: "Control"
		},
		{	type: "text",	x: 77,	y: 20,	t: "1"
		},
		{	type: "text",	x: 119,	y: 20,	t: "2"
		},
		{	type: "text",	x: 204,	y: 20,	t: "4"
		},
		{	type: "text",	x: 162,	y: 20,	t: "3"
		}
	]
},{
	id: 85,
	height: 2,
	longnm: "Window Switch",
	shortnm: "WindSw",
	page: {
		name: "Switch",
		ord: 12
	},
	inputs: [
		{	name: "In",	colour: "purple",	x: 216,	y: 18
		},
		{	name: "Ctrl",	colour: "purple",	x: 10,	y: 20
		}
	],
	outputs: [
		{	name: "Out",	colour: "purple",	x: 246,	y: 18
		},
		{	name: "Gate",	colour: "orange",	x: 187,	y: 18
		}
	],
	params: [
		{	name: "ValFrom",	type: "Range_64",	n: "KnobMedium",	x: 105.5,	y: 5.5
		},
		{	name: "ValTo",	type: "Range_64",	n: "KnobMedium",	x: 157.5,	y: 5.5
		}
	],
	modes: [],
	ve: [
		{	type: "path",	d:"M187,12L187,6 230,6 230,12"
		},
		{	type: "bmp",	x: 218,	y: 6,	id: "SWcon"
		},
		{	type: "text",	x: 17,	y: 24,	t: "Ctrl"
		},
		{	type: "valueDisplay",	x: 77,	y: 12,	w: 25,	ref: 0
		},
		{	type: "text",	x: 78,	y: 9,	t: "From"
		},
		{	type: "valueDisplay",	x: 129,	y: 12,	w: 25,	ref: 1
		},
		{	type: "text",	x: 135,	y: 9,	t: "To"
		},
		{	type: "bmp",	x: 218,	y: 6,	id: 10
		},
		{	type: "led",	x: 198,	y: 15,	w: 6.5
		}
	]
},{
	id: 88,
	height: 3,
	longnm: "Switch 1-4",
	shortnm: "Sw1-4",
	page: {
		name: "Switch",
		ord: 8
	},
	inputs: [
		{	name: "In",	colour: "purple",	x: 56,	y: 35
		}
	],
	outputs: [
		{	name: "Out1",	colour: "purple",	x: 94,	y: 35
		},
		{	name: "Out2",	colour: "purple",	x: 137,	y: 35
		},
		{	name: "Out3",	colour: "purple",	x: 180,	y: 35
		},
		{	name: "Out4",	colour: "purple",	x: 223,	y: 35
		},
		{	name: "Ctrl",	colour: "blue",	x: 10,	y: 35
		}
	],
	params: [
		{	name: "Sel",	type: "sw_2",	n: "SwM5b2fe282",	x: 72.5,	y: 10.5
		}
	],
	modes: [],
	ve: [
		{	type: "valueDisplay",	x: 19,	y: 27,	w: 17,	ref: 0
		},
		{	type: "text",	x: 3,	y: 26,	t: "Control"
		},
		{	type: "text",	x: 83,	y: 39,	t: "1"
		},
		{	type: "text",	x: 124,	y: 39,	t: "2"
		},
		{	type: "text",	x: 209,	y: 39,	t: "4"
		},
		{	type: "text",	x: 167,	y: 39,	t: "3"
		},
		{	type: "text",	x: 52,	y: 28,	t: "In"
		}
	]
},{
	id: 90,
	height: 2,
	longnm: "Switch 1-2",
	shortnm: "Sw1-2",
	page: {
		name: "Switch",
		ord: 7
	},
	inputs: [
		{	name: "In",	colour: "purple",	x: 186,	y: 18
		}
	],
	outputs: [
		{	name: "Out2",	colour: "purple",	x: 246,	y: 18
		},
		{	name: "Out1",	colour: "purple",	x: 216,	y: 18
		},
		{	name: "Ctrl",	colour: "blue",	x: 10,	y: 20
		}
	],
	params: [
		{	name: "Out",	type: "Sw_1",	n: "SwM33027f93",	x: 83.5,	y: 8.5, w:44
		}
	],
	modes: [],
	ve: [
		{	type: "line",	"x1": 186,	"y1": 6,	"x2": 232,	"y2": 6
		},
		{	type: "line",	"x1": 186,	"y1": 6,	"x2": 186,	"y2": 13
		},
		{	type: "valueDisplay",	x: 18,	y: 13,	w: 17,	ref: 0
		},
		{	type: "text",	x: 37,	y: 23,	t: "Ctrl"
		},
		{	type: "bmp",	x: 218,	y: 6,	id: "SW12"
		},
		{	type: "text",	x: 205,	y: 22,	t: "1"
		},
		{	type: "text",	x: 242,	y: 11.5,	t: "2"
		}
	]
},{
	id: 100,
	height: 2,
	longnm: "Switch 2-1",
	shortnm: "Sw2-1",
	page: {
		name: "Switch",
		ord: 3
	},
	inputs: [
		{	name: "In1",	colour: "purple",	x: 186,	y: 18
		},
		{	name: "In2",	colour: "purple",	x: 216,	y: 18
		}
	],
	outputs: [
		{	name: "Out",	colour: "purple",	x: 246,	y: 18
		},
		{	name: "Ctrl",	colour: "blue",	x: 10,	y: 20
		}
	],
	params: [
		{	name: "Sel",	type: "Sw_1",	n: "SwM22c75813",	x: 83.5,	y: 8.5
		}
	],
	modes: [],
	ve: [
		{	type: "line",	"x1": 200,	"y1": 6,	"x2": 248,	"y2": 6
		},
		{	type: "line",	"x1": 247,	"y1": 6,	"x2": 247,	"y2": 13
		},
		{	type: "valueDisplay",	x: 18,	y: 13,	w: 17,	ref: 0
		},
		{	type: "text",	x: 37,	y: 23,	t: "Ctrl"
		},
		{	type: "bmp",	x: 187,	y: 6,	id: "SW12"
		},
		{	type: "text",	x: 175,	y: 22,	t: "1"
		},
		{	type: "text",	x: 222,	y: 22,	t: "2"
		}
	]
},{
	id: 105,
	height: 2,
	longnm: "Value Switch 2-1",
	shortnm: "ValSw2-1",
	page: {
		name: "Switch",
		ord: 10
	},
	inputs: [
		{	name: "In1",	colour: "purple",	x: 186,	y: 18
		},
		{	name: "In2",	colour: "purple",	x: 216,	y: 18
		},
		{	name: "Ctrl",	colour: "purple",	x: 10,	y: 20
		}
	],
	outputs: [
		{	name: "Out",	colour: "purple",	x: 246,	y: 18
		}
	],
	params: [
		{	name: "Val",	type: "ValSwVal",	n: "KnobSpinH",	x: 82.5,	y: 15.5
		}
	],
	modes: [],
	ve: [
		{	type: "line",	"x1": 122,	"y1": 20,	"x2": 151,	"y2": 20
		},
		{	type: "line",	"x1": 201,	"y1": 6,	"x2": 248,	"y2": 6
		},
		{	type: "line",	"x1": 247,	"y1": 6,	"x2": 247,	"y2": 13
		},
		{	type: "text",	x: 17,	y: 24,	t: "Ctrl"
		},
		{	type: "text",	x: 17,	y: 24,	t: "Ctrl"
		},
		{	type: "valueDisplay",	x: 106,	y: 13,	w: 17,	ref: 0
		},
		{	type: "text",	x: 83,	y: 10,	t: "Ctrl Value"
		},
		{	type: "led",	x: 146,	y: 17,	w: 6.5
		},
		{	type: "text",	x: 144,	y: 14,	t: "On"
		},
		{	type: "bmp",	x: 188,	y: 6,	id: "SW12"
		},
		{	type: "text",	x: 222,	y: 22,	t: "On"
		}
	]
},{
	id: 124,
	height: 2,
	longnm: "Multiplexer 8-1",
	shortnm: "Mux8-1",
	page: {
		name: "Switch",
		ord: 13
	},
	inputs: [
		{	name: "In1",	colour: "purple",	x: 86,	y: 18
		},
		{	name: "In2",	colour: "purple",	x: 106,	y: 18
		},
		{	name: "In3",	colour: "purple",	x: 126,	y: 18
		},
		{	name: "In4",	colour: "purple",	x: 146,	y: 18
		},
		{	name: "In5",	colour: "purple",	x: 166,	y: 18
		},
		{	name: "In6",	colour: "purple",	x: 186,	y: 18
		},
		{	name: "In7",	colour: "purple",	x: 206,	y: 18
		},
		{	name: "In8",	colour: "purple",	x: 226,	y: 18
		},
		{	name: "Ctrl",	colour: "blue",	x: 10,	y: 20
		}
	],
	outputs: [
		{	name: "Out",	colour: "purple",	x: 246,	y: 18
		}
	],
	params: [],
	modes: [],
	ve: [
		{	type: "text",	x: 77,	y: 10,	t: "1"
		},
		{	type: "text",	x: 96,	y: 10,	t: "2"
		},
		{	type: "text",	x: 116,	y: 10,	t: "3"
		},
		{	type: "text",	x: 135,	y: 10,	t: "4"
		},
		{	type: "text",	x: 156,	y: 10,	t: "5"
		},
		{	type: "text",	x: 176,	y: 10,	t: "6"
		},
		{	type: "text",	x: 196,	y: 10,	t: "7"
		},
		{	type: "text",	x: 216,	y: 10,	t: "8"
		},
		{	type: "ledArray",	x: 82,	y: 3,	w: 6.5,	xo:20,	cnt:8
		},
		{	type: "text",	x: 17,	y: 24,	t: "Ctrl"
		}
	]
},{
	id: 139,
	height: 2,
	longnm: "Track & Hold",
	shortnm: "T&H",
	page: {
		name: "Switch",
		ord: 17
	},
	inputs: [
		{	name: "In",	colour: "purple",	x: 198,	y: 18
		},
		{	name: "Ctrl",	colour: "orange",	x: 168,	y: 18
		}
	],
	outputs: [
		{	name: "Out",	colour: "purple",	x: 246,	y: 18
		}
	],
	params: [],
	modes: [],
	ve: [
		{	type: "line",	"x1": 168,	"y1": 6,	"x2": 215,	"y2": 6
		},
		{	type: "line",	"x1": 168,	"y1": 6,	"x2": 168,	"y2": 16
		},
		{	type: "line",	"x1": 236,	"y1": 18,	"x2": 251,	"y2": 18
		},
		{	type: "bmp",	x: 203,	y: 6,	id: "SH"
		},
		{	type: "text",	x: 83,	y: 14,	t: "High = Track"
		},
		{	type: "bmp",	x: 225,	y: 13,	id: 6
		},
		{	type: "text",	x: 143,	y: 22,	t: "Ctrl"
		},
		{	type: "text",	x: 84,	y: 23,	t: "Low = Hold"
		}
	]
},{
	id: 186,
	height: 2,
	longnm: "Switch 1-2 Momentary",
	shortnm: "Sw1-2M",
	page: {
		name: "Switch",
		ord: 6
	},
	inputs: [
		{	name: "In",	colour: "purple",	x: 186,	y: 18
		}
	],
	outputs: [
		{	name: "OutOn",	colour: "purple",	x: 246,	y: 18
		},
		{	name: "OutOff",	colour: "purple",	x: 216,	y: 18
		},
		{	name: "Ctrl",	colour: "blue",	x: 10,	y: 20
		}
	],
	params: [
		{	name: "Sel",	type: "OffOn",	n: "SwM6b9f5cac",	x: 111.5,	y: 8.5, w:44
		}
	],
	modes: [],
	ve: [
		{	type: "path",	d:"M186,13L186,6 232,6"
		},
		{	type: "valueDisplay",	x: 18,	y: 13,	w: 17,	ref: 0
		},
		{	type: "text",	x: 37,	y: 23,	t: "Ctrl"
		},
		{	type: "bmp",	x: 218,	y: 6,	id: "SW12"
		},
		{	type: "text",	x: 240,	y: 10,	t: "On"
		},
		{	type: "bmp",	x: 102,	y: 8.5,	id: "SWMcon"
		}
	]
},{
	id: 187,
	height: 2,
	longnm: "Switch 2-1 Momentary",
	shortnm: "Sw2-1M",
	page: {
		name: "Switch",
		ord: 2
	},
	inputs: [
		{	name: "InOff",	colour: "purple",	x: 186,	y: 18
		},
		{	name: "InOn",	colour: "purple",	x: 216,	y: 18
		}
	],
	outputs: [
		{	name: "Out",	colour: "purple",	x: 246,	y: 18
		},
		{	name: "Ctrl",	colour: "blue",	x: 10,	y: 20
		}
	],
	params: [
		{	name: "Sel",	type: "OffOn",	n: "SwM6b9f5cac",	x: 111.5,	y: 8.5, w:44
		}
	],
	modes: [],
	ve: [
		{	type: "line",	"x1": 201,	"y1": 6,	"x2": 248,	"y2": 6
		},
		{	type: "line",	"x1": 247,	"y1": 6,	"x2": 247,	"y2": 13
		},
		{	type: "valueDisplay",	x: 18,	y: 13,	w: 17,	ref: 0
		},
		{	type: "text",	x: 37,	y: 23,	t: "Ctrl"
		},
		{	type: "bmp",	x: 188,	y: 6,	id: "SW12"
		},
		{	type: "text",	x: 222,	y: 22,	t: "On"
		},
		{	type: "bmp",	x: 102,	y: 8.5,	id: "SWMcon"
		}
	]
},/// end of switch
{/// start of rnd
	id: 200,
	height: 2,
	longnm: "Random A",
	shortnm: "RandomA",
	page: {
		name: "Rnd",
		ord: 0
	},
	inputs: [
		{	name: "Rate",	colour: "blue",	x: 10,	y: 20
		}
	],
	outputs: [
		{	name: "Out",	colour: "blue",	x: 245,	y: 20
		}
	],
	params: [
		{	name: "Rate",	type: "LfoRate_3",	n: "KnobMedium",	x: 143.5,	y: 5.5
		},
		{	name: "PolyMono",	type: "PolyMono",	n: "SwM7dcebf3d",	x: 42.5,	y: 14.5
		},
		{	name: "OutputType",	type: "BipPosNeg",	n: "levelshift",	x: 222.5,	y: 14.5
		},
		{	name: "Range",	type: "LfoRange_3",	n: "SwM3d4bccd9",	x: 74.5,	y: 14.5
		},
		{	name: "Active",	type: "ActiveMonitor",	n: "SwM4d",	x: 240.25,	y: 2.5
		},
		{	name: "Edge",	type: "RndEdge",	n: "SwM98dcda4",	x: 194.5,	y: 14.5
		},
		{	name: "StepProb",	type: "RandomAStepProb",	n: "SwM20380785",	x: 167.5,	y: 14.5
		}
	],
	modes: [],
	ve: [
		{	type: "text",	x: 17,	y: 24,	t: "Rate"
		},
		{	type: "valueDisplay",	x: 101,	y: 8,	w: 40,	ref: [0,3]
		},
		{	type: "led",	x: 226,	y: 4,	w: 6.5
		},
		{	type: "text",	x: 196,	y: 11,	t: "Edge"
		},
		{	type: "text",	x: 76,	y: 11,	t: "Rate"
		},
		{	type: "text",	x: 169,	y: 11,	t: "Step"
		}
	]
},{
	id: 202,
	height: 3,
	longnm: "Random B",
	shortnm: "RandomB",
	page: {
		name: "Rnd",
		ord: 1
	},
	inputs: [
		{	name: "Rate",	colour: "blue",	x: 10,	y: 18
		},
		{	name: "RateVar",	colour: "blue",	x: 10,	y: 34
		}
	],
	outputs: [
		{	name: "Out",	colour: "blue",	x: 246,	y: 35
		}
	],
	params: [
		{	name: "Rate",	type: "LfoRate_3",	n: "KnobMedium",	x: 125.5,	y: 20.5
		},
		{	name: "PolyMono",	type: "PolyMono",	n: "SwM7dcebf3d",	x: 46.5,	y: 21.5
		},
		{	name: "Kbt",	type: "Kbt_4",	n: "SwM43a19dbe",	x: 151.5,	y: 20.5
		},
		{	name: "RateMod",	type: "Level_100",	n: "KnobSmall",	x: 18.5,	y: 22.5
		},
		{	name: "StepProb",	type: "Level_100",	n: "KnobMedium",	x: 181.5,	y: 20.5
		},
		{	name: "Active",	type: "ActiveMonitor",	n: "SwM4d",	x: 226.25,	y: 29.5
		},
		{	name: "OutputType",	type: "BipPosNeg",	n: "levelshift",	x: 206.5,	y: 29.5
		},
		{	name: "Range",	type: "LfoRange_3",	n: "SwM1d0ee86b",	x: 81.5,	y: 8.5
		},
		{	name: "Edge",	type: "RndEdge",	n: "SwM98dcda4",	x: 211.5,	y: 14.5
		}
	],
	modes: [],
	ve: [
		{	type: "line",	"x1": 9,	"y1": 34,	"x2": 31,	"y2": 34
		},
		{	type: "valueDisplay",	x: 82,	y: 23,	w: 40,	ref: [0,7]
		},
		{	type: "text",	x: 16,	y: 20,	t: "Rate"
		},
		{	type: "text",	x: 153,	y: 17,	t: "KBT"
		},
		{	type: "text",	x: 180,	y: 17,	t: "Step"
		},
		{	type: "text",	x: 212,	y: 11,	t: "Edge"
		},
		{	type: "led",	x: 242,	y: 21,	w: 6.5
		}
	]
},{
	id: 204,
	height: 2,
	longnm: "Random Clock A",
	shortnm: "RndClkA",
	page: {
		name: "Rnd",
		ord: 2
	},
	inputs: [
		{	name: "Clk",	colour: "orange",	x: 10,	y: 20
		},
		{	name: "Rst",	colour: "orange",	x: 74,	y: 20
		},
		{	name: "Seed",	colour: "purple",	x: 109,	y: 19
		}
	],
	outputs: [
		{	name: "Out",	colour: "purple",	x: 246,	y: 20
		}
	],
	params: [
		{	name: "StepProb",	type: "Level_100",	n: "KnobMedium",	x: 198.5,	y: 5.5
		},
		{	name: "PolyMono",	type: "PolyMono",	n: "SwM7dcebf3d",	x: 36.5,	y: 14.5
		},
		{	name: "Dice",	type: "OffOn",	n: "SwM207fc7",	x: 122.5,	y: 8.5
		},
		{	name: "OutputType",	type: "BipPosNeg",	n: "levelshift",	x: 222.5,	y: 14.5
		},
		{	name: "Active",	type: "ActiveMonitor",	n: "SwM4d",	x: 241.25,	y: 2.5
		}
	],
	modes: [],
	ve: [
		{	type: "text",	x: 21,	y: 24,	t: "Clk"
		},
		{	type: "text",	x: 169,	y: 9,	t: "Step"
		},
		{	type: "valueDisplay",	x: 163,	y: 12,	w: 32,	ref: 0
		},
		{	type: "text",	x: 85,	y: 24,	t: "Rst"
		},
		{	type: "text",	x: 97,	y: 11,	t: "Seed"
		}
	]
},{
	id: 205,
	height: 2,
	longnm: "Random Trig",
	shortnm: "RndTrig",
	page: {
		name: "Rnd",
		ord: 4
	},
	inputs: [
		{	name: "Clk",	colour: "orange",	x: 10,	y: 20
		},
		{	name: "Rst",	colour: "orange",	x: 74,	y: 20
		},
		{	name: "Seed",	colour: "purple",	x: 109,	y: 19
		},
		{	name: "Prob",	colour: "purple",	x: 124,	y: 19
		}
	],
	outputs: [
		{	name: "Out",	colour: "orange",	x: 245,	y: 20
		}
	],
	params: [
		{	name: "StepProb",	type: "Level_100",	n: "KnobMedium",	x: 190.5,	y: 5.5
		},
		{	name: "StepProbMod",	type: "Level_100",	n: "KnobSmall",	x: 132.5,	y: 7.5
		},
		{	name: "Active",	type: "ActiveMonitor",	n: "SwM4d",	x: 240.25,	y: 2.5
		},
		{	name: "PolyMono",	type: "PolyMono",	n: "SwM7dcebf3d",	x: 36.5,	y: 14.5
		}
	],
	modes: [],
	ve: [
		{	type: "line",	"x1": 121,	"y1": 19,	"x2": 143,	"y2": 19
		},
		{	type: "graph",	x: 214,	y: 4,	w: 21,	h: 22
		},
		{	type: "text",	x: 21,	y: 24,	t: "Clk"
		},
		{	type: "text",	x: 160,	y: 9,	t: "Prob"
		},
		{	type: "text",	x: 85,	y: 24,	t: "Rst"
		},
		{	type: "text",	x: 97,	y: 11,	t: "Seed"
		},
		{	type: "valueDisplay",	x: 155,	y: 12,	w: 32,	ref: 0
		}
	]
},{
	id: 206,
	height: 3,
	longnm: "Random Clock B",
	shortnm: "RndClkB",
	page: {
		name: "Rnd",
		ord: 3
	},
	inputs: [
		{	name: "Clk",	colour: "orange",	x: 10,	y: 20
		},
		{	name: "Rst",	colour: "orange",	x: 10,	y: 34
		},
		{	name: "Seed",	colour: "purple",	x: 58,	y: 34
		},
		{	name: "Step",	colour: "blue",	x: 156,	y: 34
		}
	],
	outputs: [
		{	name: "Out",	colour: "purple",	x: 246,	y: 35
		}
	],
	params: [
		{	name: "StepProb",	type: "Level_100",	n: "KnobMedium",	x: 192.5,	y: 20.5
		},
		{	name: "OutputType",	type: "BipPosNeg",	n: "levelshift",	x: 222.5,	y: 29.5
		},
		{	name: "Active",	type: "ActiveMonitor",	n: "SwM4d",	x: 241.25,	y: 15.5
		},
		{	name: "PolyMono",	type: "PolyMono",	n: "SwM7dcebf3d",	x: 125.5,	y: 8.5
		},
		{	name: "StepProbMod",	type: "Level_100",	n: "KnobSmall",	x: 165.5,	y: 22.5
		}
	],
	modes: [
		{	name: "Character",	type: "Rnd_1"
		}
	],
	ve: [
		{	type: "line",	"x1": 154,	"y1": 34,	"x2": 176,	"y2": 34
		},
		{	type: "text",	x: 22,	y: 24,	t: "Clk"
		},
		{	type: "text",	x: 164,	y: 14,	t: "Step"
		},
		{	type: "text",	x: 76,	y: 23,	t: "Character"
		},
		{	type: "text",	x: 22,	y: 38,	t: "Rst"
		},
		{	type: "text",	x: 47,	y: 25,	t: "Seed"
		},
		{	type: "valueDisplay",	x: 186,	y: 4,	w: 32,	ref: 0
		}
	]
},{
	id: 208,
	height: 3,
	longnm: "Random Pattern",
	shortnm: "RndPattern",
	page: {
		name: "Rnd",
		ord: 5
	},
	inputs: [
		{	name: "Clk",	colour: "orange",	x: 10,	y: 20
		},
		{	name: "Rst",	colour: "orange",	x: 10,	y: 35
		},
		{	name: "A",	colour: "blue",	x: 57,	y: 20
		},
		{	name: "B",	colour: "blue",	x: 57,	y: 35
		},
		{	name: "StepProb",	colour: "blue",	x: 123,	y: 34
		}
	],
	outputs: [
		{	name: "Out",	colour: "purple",	x: 246,	y: 35
		}
	],
	params: [
		{	name: "PatternA",	type: "RangeBip_128",	n: "KnobSpinH",	x: 89.5,	y: 15.5
		},
		{	name: "PatternB",	type: "Level_100",	n: "KnobSpinH",	x: 89.5,	y: 30.5
		},
		{	name: "StepProb",	type: "RangeBip_128",	n: "KnobMedium",	x: 155.5,	y: 20.5
		},
		{	name: "LoopCount",	type: "Range_128",	n: "KnobSpinH",	x: 183.5,	y: 30.5
		},
		{	name: "StepProbMod",	type: "Level_100",	n: "KnobSmall",	x: 131.5,	y: 22.5
		},
		{	name: "OutputType",	type: "BipPosNeg",	n: "levelshift",	x: 206.5,	y: 29.5
		},
		{	name: "Active",	type: "ActiveMonitor",	n: "SwM4d",	x: 226.25,	y: 29.5
		}
	],
	modes: [
		{	name: "Waveform",	type: "RndStepPulse"
		}
	],
	ve: [
		{	type: "line",	"x1": 121,	"y1": 34,	"x2": 143,	"y2": 34
		},
		{	type: "text",	x: 21,	y: 25,	t: "Clk"
		},
		{	type: "text",	x: 21,	y: 39,	t: "Rst"
		},
		{	type: "text",	x: 79,	y: 10,	t: "pattern"
		},
		{	type: "text",	x: 120,	y: 10,	t: "Step/"
		},
		{	type: "valueDisplay",	x: 183,	y: 13,	w: 21,	ref: 3
		},
		{	type: "text",	x: 182,	y: 10,	t: "Loop"
		},
		{	type: "valueDisplay",	x: 65,	y: 13,	w: 22,	ref: 0
		},
		{	type: "valueDisplay",	x: 65,	y: 28,	w: 22,	ref: 1
		},
		{	type: "valueDisplay",	x: 147,	y: 4,	w: 32,	ref: 2
		},
		{	type: "text",	x: 42,	y: 24,	t: "A"
		},
		{	type: "text",	x: 43,	y: 39,	t: "B"
		},
		{	type: "text",	x: 120,	y: 19,	t: "Prob"
		}
	]
},/// end of rnd
{/// start of seq
	id: 121,
	height: 9,
	longnm: "Sequencer Note",
	shortnm: "SeqNote",
	page: {
		name: "Seq",
		ord: 3
	},
	inputs: [
		{	name: "Clk",	colour: "orange",	x: 10,	y: 48
		},
		{	name: "Rst",	colour: "orange",	x: 10,	y: 71
		},
		{	name: "Loop",	colour: "orange",	x: 10,	y: 93
		},
		{	name: "Park",	colour: "orange",	x: 210,	y: 9
		},
		{	name: "Note",	colour: "purple",	x: 10,	y: 109
		},
		{	name: "Trig",	colour: "orange",	x: 10,	y: 125
		},
		{	name: "RecVal",	colour: "purple",	x: 104,	y: 9
		},
		{	name: "RecEnable",	colour: "orange",	x: 117,	y: 9
		}
	],
	outputs: [
		{	name: "Link",	colour: "orange",	x: 246,	y: 31
		},
		{	name: "Note",	colour: "purple",	x: 246,	y: 109
		},
		{	name: "Trig",	colour: "orange",	x: 246,	y: 125
		}
	],
	params: [
		{	name: "Seq1Step1",	type: "FreqCoarse",	n: "KnobSeqSlider",	x: 25.5,	y: 40.5
		},
		{	name: "Seq1Step2",	type: "FreqCoarse",	n: "KnobSeqSlider",	x: 37.5,	y: 40.5
		},
		{	name: "Seq1Step3",	type: "FreqCoarse",	n: "KnobSeqSlider",	x: 49.5,	y: 40.5
		},
		{	name: "Seq1Step4",	type: "FreqCoarse",	n: "KnobSeqSlider",	x: 61.5,	y: 40.5
		},
		{	name: "Seq1Step5",	type: "FreqCoarse",	n: "KnobSeqSlider",	x: 73.5,	y: 40.5
		},
		{	name: "Seq1Step6",	type: "FreqCoarse",	n: "KnobSeqSlider",	x: 85.5,	y: 40.5
		},
		{	name: "Seq1Step7",	type: "FreqCoarse",	n: "KnobSeqSlider",	x: 97.5,	y: 40.5
		},
		{	name: "Seq1Step8",	type: "FreqCoarse",	n: "KnobSeqSlider",	x: 109.5,	y: 40.5
		},
		{	name: "Seq1Step9",	type: "FreqCoarse",	n: "KnobSeqSlider",	x: 121.5,	y: 40.5
		},
		{	name: "Seq1Step10",	type: "FreqCoarse",	n: "KnobSeqSlider",	x: 133.5,	y: 40.5
		},
		{	name: "Seq1Step11",	type: "FreqCoarse",	n: "KnobSeqSlider",	x: 145.5,	y: 40.5
		},
		{	name: "Seq1Step12",	type: "FreqCoarse",	n: "KnobSeqSlider",	x: 157.5,	y: 40.5
		},
		{	name: "Seq1Step13",	type: "FreqCoarse",	n: "KnobSeqSlider",	x: 169.5,	y: 40.5
		},
		{	name: "Seq1Step14",	type: "FreqCoarse",	n: "KnobSeqSlider",	x: 181.5,	y: 40.5
		},
		{	name: "Seq1Step15",	type: "FreqCoarse",	n: "KnobSeqSlider",	x: 193.5,	y: 40.5
		},
		{	name: "Seq1Step16",	type: "FreqCoarse",	n: "KnobSeqSlider",	x: 205.5,	y: 40.5
		},
		{	name: "Seq2Step1",	type: "OffOnBlank",	n: "SwM0",	x: 25.5,	y: 119.5
		},
		{	name: "Seq2Step2",	type: "OffOnBlank",	n: "SwM0",	x: 37.5,	y: 119.5
		},
		{	name: "Seq2Step3",	type: "OffOnBlank",	n: "SwM0",	x: 49.5,	y: 119.5
		},
		{	name: "Seq2Step4",	type: "OffOnBlank",	n: "SwM0",	x: 61.5,	y: 119.5
		},
		{	name: "Seq2Step5",	type: "OffOnBlank",	n: "SwM0",	x: 73.5,	y: 119.5
		},
		{	name: "Seq2Step6",	type: "OffOnBlank",	n: "SwM0",	x: 85.5,	y: 119.5
		},
		{	name: "Seq2Step7",	type: "OffOnBlank",	n: "SwM0",	x: 97.5,	y: 119.5
		},
		{	name: "Seq2Step8",	type: "OffOnBlank",	n: "SwM0",	x: 109.5,	y: 119.5
		},
		{	name: "Seq2Step9",	type: "OffOnBlank",	n: "SwM0",	x: 121.5,	y: 119.5
		},
		{	name: "Seq2Step10",	type: "OffOnBlank",	n: "SwM0",	x: 133.5,	y: 119.5
		},
		{	name: "Seq2Step11",	type: "OffOnBlank",	n: "SwM0",	x: 145.5,	y: 119.5
		},
		{	name: "Seq2Step12",	type: "OffOnBlank",	n: "SwM0",	x: 157.5,	y: 119.5
		},
		{	name: "Seq2Step13",	type: "OffOnBlank",	n: "SwM0",	x: 169.5,	y: 119.5
		},
		{	name: "Seq2Step14",	type: "OffOnBlank",	n: "SwM0",	x: 181.5,	y: 119.5
		},
		{	name: "Seq2Step15",	type: "OffOnBlank",	n: "SwM0",	x: 193.5,	y: 119.5
		},
		{	name: "Seq2Step16",	type: "OffOnBlank",	n: "SwM0",	x: 205.5,	y: 119.5
		},
		{	name: "Loop",	type: "LoopOnce",	n: "SwM0",	x: 4.5,	y: 18.5
		},
		{	name: "Length",	type: "SeqLen",	n: "KnobSpinH",	x: 158.5,	y: 4.5
		},
		{	name: "TG",	type: "TrigGate",	n: "SwM140ef",	x: 221.5,	y: 119.5
		},
		{	name: "Clr",	type: "OffOn",	n: "SwM10909",	x: 231.5,	y: 71.5
		},
		{	name: "Rnd",	type: "OffOn",	n: "SwM14188",	x: 231.5,	y: 86.5
		}
	],
	modes: [],
	ve: [
		{	type: "line",	"x1": 216,	"y1": 125,	"x2": 247,	"y2": 125
		},
		{	type: "line",	"x1": 12,	"y1": 125,	"x2": 26,	"y2": 125
		},
		{	type: "line",	"x1": 10,	"y1": 109,	"x2": 26,	"y2": 109
		},
		{	type: "line",	"x1": 226,	"y1": 109,	"x2": 241,	"y2": 109
		},
		{	type: "line",	"x1": 198,	"y1": 44,	"x2": 238,	"y2": 44
		},
		{	type: "line",	"x1": 127,	"y1": 3,	"x2": 127,	"y2": 16
		},
		{	type: "line",	"x1": 25,	"y1": 39,	"x2": 218,	"y2": 39
		},
		{	type: "line",	"x1": 25,	"y1": 115,	"x2": 230,	"y2": 115
		},
		{	type: "line",	"x1": 25,	"y1": 39,	"x2": 25,	"y2": 115
		},
		{	type: "line",	"x1": 229,	"y1": 23,	"x2": 229,	"y2": 115
		},
		{	type: "graph",	x: 217,	y: 24,	w: 11,	h: 91
		},
		{	type: "line",	"x1": 217,	"y1": 23,	"x2": 230,	"y2": 23
		},
		{	type: "line",	"x1": 217,	"y1": 23,	"x2": 217,	"y2": 63
		},
		{	type: "graph",	x: 231,	y: 40,	w: 21,	h: 25
		},
		{	type: "led",	x: 242,	y: 7,	w: 6.5
		},
		{	type: "ledArray",	x: 25,	y: 31,	w: 10,	xo:12,	cnt:16
		},
		{	type: "text",	x: 3,	y: 41,	t: "Clk"
		},
		{	type: "text",	x: 3,	y: 64,	t: "Rst"
		},
		{	type: "text",	x: 217,	y: 13,	t: "Park"
		},
		{	type: "text",	x: 233,	y: 24,	t: "Link"
		},
		{	type: "text",	x: 28,	y: 29,	t: "1"
		},
		{	type: "text",	x: 39,	y: 29,	t: "2"
		},
		{	type: "text",	x: 51,	y: 29,	t: "3"
		},
		{	type: "text",	x: 63,	y: 29,	t: "4"
		},
		{	type: "text",	x: 75,	y: 29,	t: "5"
		},
		{	type: "text",	x: 87,	y: 29,	t: "6"
		},
		{	type: "text",	x: 99,	y: 29,	t: "7"
		},
		{	type: "text",	x: 111,	y: 29,	t: "8"
		},
		{	type: "text",	x: 123,	y: 29,	t: "9"
		},
		{	type: "text",	x: 134,	y: 29,	t: "10"
		},
		{	type: "text",	x: 147,	y: 29,	t: "11"
		},
		{	type: "text",	x: 158,	y: 29,	t: "12"
		},
		{	type: "text",	x: 170,	y: 29,	t: "13"
		},
		{	type: "text",	x: 182,	y: 29,	t: "14"
		},
		{	type: "text",	x: 194,	y: 29,	t: "15"
		},
		{	type: "text",	x: 206,	y: 29,	t: "16"
		},
		{	type: "valueDisplay",	x: 179,	y: 4,	w: 16,	ref: 33
		},
		{	type: "text",	x: 128,	y: 12,	t: "Length"
		},
		{	type: "text",	x: 3,	y: 86,	t: "Loop"
		},
		{	type: "text",	x: 81,	y: 12,	t: "Rec"
		}
	]
},{
	id: 144,
	height: 5,
	longnm: "Seq Event",
	shortnm: "SeqEvent",
	page: {
		name: "Seq",
		ord: 0
	},
	inputs: [
		{	name: "Clk",	colour: "orange",	x: 10,	y: 20
		},
		{	name: "Rst",	colour: "yellow",	x: 10,	y: 42
		},
		{	name: "Loop",	colour: "yellow",	x: 10,	y: 65
		},
		{	name: "Park",	colour: "yellow",	x: 27,	y: 49
		},
		{	name: "Trig1",	colour: "yellow",	x: 27,	y: 49
		},
		{	name: "Trig2",	colour: "yellow",	x: 27,	y: 65
		}
	],
	outputs: [
		{	name: "Link",	colour: "yellow",	x: 246,	y: 32
		},
		{	name: "Trig1",	colour: "orange",	x: 246,	y: 49
		},
		{	name: "Trig2",	colour: "orange",	x: 246,	y: 65
		}
	],
	params: [
		{	name: "Seq1Step1",	type: "OffOnBlank",	n: "SwM0",	x: 34.5,	y: 44.5
		},
		{	name: "Seq1Step2",	type: "OffOnBlank",	n: "SwM0",	x: 46.5,	y: 44.5
		},
		{	name: "Seq1Step3",	type: "OffOnBlank",	n: "SwM0",	x: 58.5,	y: 44.5
		},
		{	name: "Seq1Step4",	type: "OffOnBlank",	n: "SwM0",	x: 70.5,	y: 44.5
		},
		{	name: "Seq1Step5",	type: "OffOnBlank",	n: "SwM0",	x: 82.5,	y: 44.5
		},
		{	name: "Seq1Step6",	type: "OffOnBlank",	n: "SwM0",	x: 94.5,	y: 44.5
		},
		{	name: "Seq1Step7",	type: "OffOnBlank",	n: "SwM0",	x: 106.5,	y: 44.5
		},
		{	name: "Seq1Step8",	type: "OffOnBlank",	n: "SwM0",	x: 118.5,	y: 44.5
		},
		{	name: "Seq1Step9",	type: "OffOnBlank",	n: "SwM0",	x: 130.5,	y: 44.5
		},
		{	name: "Seq1Step10",	type: "OffOnBlank",	n: "SwM0",	x: 142.5,	y: 44.5
		},
		{	name: "Seq1Step11",	type: "OffOnBlank",	n: "SwM0",	x: 154.5,	y: 44.5
		},
		{	name: "Seq1Step12",	type: "OffOnBlank",	n: "SwM0",	x: 166.5,	y: 44.5
		},
		{	name: "Seq1Step13",	type: "OffOnBlank",	n: "SwM0",	x: 178.5,	y: 44.5
		},
		{	name: "Seq1Step14",	type: "OffOnBlank",	n: "SwM0",	x: 190.5,	y: 44.5
		},
		{	name: "Seq1Step15",	type: "OffOnBlank",	n: "SwM0",	x: 202.5,	y: 44.5
		},
		{	name: "Seq1Step16",	type: "OffOnBlank",	n: "SwM0",	x: 214.5,	y: 44.5
		},
		{	name: "Seq2Step1",	type: "OffOnBlank",	n: "SwM0",	x: 34.5,	y: 59.5
		},
		{	name: "Seq2Step2",	type: "OffOnBlank",	n: "SwM0",	x: 46.5,	y: 59.5
		},
		{	name: "Seq2Step3",	type: "OffOnBlank",	n: "SwM0",	x: 58.5,	y: 59.5
		},
		{	name: "Seq2Step4",	type: "OffOnBlank",	n: "SwM0",	x: 70.5,	y: 59.5
		},
		{	name: "Seq2Step5",	type: "OffOnBlank",	n: "SwM0",	x: 82.5,	y: 59.5
		},
		{	name: "Seq2Step6",	type: "OffOnBlank",	n: "SwM0",	x: 94.5,	y: 59.5
		},
		{	name: "Seq2Step7",	type: "OffOnBlank",	n: "SwM0",	x: 106.5,	y: 59.5
		},
		{	name: "Seq2Step8",	type: "OffOnBlank",	n: "SwM0",	x: 118.5,	y: 59.5
		},
		{	name: "Seq2Step9",	type: "OffOnBlank",	n: "SwM0",	x: 130.5,	y: 59.5
		},
		{	name: "Seq2Step10",	type: "OffOnBlank",	n: "SwM0",	x: 142.5,	y: 59.5
		},
		{	name: "Seq2Step11",	type: "OffOnBlank",	n: "SwM0",	x: 154.5,	y: 59.5
		},
		{	name: "Seq2Step12",	type: "OffOnBlank",	n: "SwM0",	x: 166.5,	y: 59.5
		},
		{	name: "Seq2Step13",	type: "OffOnBlank",	n: "SwM0",	x: 178.5,	y: 59.5
		},
		{	name: "Seq2Step14",	type: "OffOnBlank",	n: "SwM0",	x: 190.5,	y: 59.5
		},
		{	name: "Seq2Step15",	type: "OffOnBlank",	n: "SwM0",	x: 202.5,	y: 59.5
		},
		{	name: "Seq2Step16",	type: "OffOnBlank",	n: "SwM0",	x: 214.5,	y: 59.5
		},
		{	name: "Loop",	type: "LoopOnce",	n: "SwM0",	x: 87.5,	y: 4.5
		},
		{	name: "Length",	type: "SeqLen",	n: "KnobSpinH",	x: 145.5,	y: 4.5
		},
		{	name: "TG1",	type: "TrigGate",	n: "SwM140ef",	x: 227.5,	y: 44.5
		},
		{	name: "TG2",	type: "TrigGate",	n: "SwM140ef",	x: 227.5,	y: 59.5
		}
	],
	modes: [],
	ve: [
		{	type: "line",	"x1": 218,	"y1": 49,	"x2": 247,	"y2": 49
		},
		{	type: "line",	"x1": 219,	"y1": 65,	"x2": 248,	"y2": 65
		},
		{	type: "line",	"x1": 26,	"y1": 49,	"x2": 47,	"y2": 49
		},
		{	type: "line",	"x1": 25,	"y1": 65,	"x2": 46,	"y2": 65
		},
		{	type: "text",	x: 20,	y: 24,	t: "Clk"
		},
		{	type: "text",	x: 3,	y: 35,	t: "Rst"
		},
		{	type: "led",	x: 242,	y: 7,	w: 6.5
		},
		{	type: "text",	x: 217,	y: 13,	t: "Park"
		},
		{	type: "text",	x: 234,	y: 24,	t: "Link"
		},
		{	type: "ledArray",	x: 34,	y: 36,	w: 10,	xo:12,	cnt:16
		},
		{	type: "text",	x: 37,	y: 33,	t: "1"
		},
		{	type: "text",	x: 48,	y: 33,	t: "2"
		},
		{	type: "text",	x: 60,	y: 33,	t: "3"
		},
		{	type: "text",	x: 72,	y: 33,	t: "4"
		},
		{	type: "text",	x: 84,	y: 33,	t: "5"
		},
		{	type: "text",	x: 96,	y: 33,	t: "6"
		},
		{	type: "text",	x: 108,	y: 33,	t: "7"
		},
		{	type: "text",	x: 120,	y: 33,	t: "8"
		},
		{	type: "text",	x: 132,	y: 33,	t: "9"
		},
		{	type: "text",	x: 143,	y: 33,	t: "10"
		},
		{	type: "text",	x: 156,	y: 33,	t: "11"
		},
		{	type: "text",	x: 167,	y: 33,	t: "12"
		},
		{	type: "text",	x: 179,	y: 33,	t: "13"
		},
		{	type: "text",	x: 191,	y: 33,	t: "14"
		},
		{	type: "text",	x: 203,	y: 33,	t: "15"
		},
		{	type: "text",	x: 215,	y: 33,	t: "16"
		},
		{	type: "valueDisplay",	x: 167,	y: 4,	w: 16,	ref: 33
		},
		{	type: "text",	x: 114,	y: 13,	t: "Length"
		},
		{	type: "text",	x: 4,	y: 57,	t: "Lp"
		}
	]
},{
	id: 145,
	height: 8,
	longnm: "Sequencer Values",
	shortnm: "SeqVal",
	page: {
		name: "Seq",
		ord: 1
	},
	inputs: [
		{	name: "Clk",	colour: "orange",	x: 10,	y: 30
		},
		{	name: "Rst",	colour: "yellow",	x: 10,	y: 52
		},
		{	name: "Loop",	colour: "yellow",	x: 10,	y: 74
		},
		{	name: "Park",	colour: "yellow",	x: 210,	y: 9
		},
		{	name: "Val",	colour: "purple",	x: 10,	y: 89
		},
		{	name: "Trig",	colour: "yellow",	x: 10,	y: 110
		}
	],
	outputs: [
		{	name: "Link",	colour: "yellow",	x: 246,	y: 31
		},
		{	name: "Val",	colour: "purple",	x: 246,	y: 89
		},
		{	name: "Trig",	colour: "orange",	x: 246,	y: 110
		}
	],
	params: [
		{	name: "Seq1Step1",	type: "LevBipUni",	n: "KnobSpin",	x: 29.5,	y: 79.5
		},
		{	name: "Seq1Step2",	type: "LevBipUni",	n: "KnobSpin",	x: 41.5,	y: 79.5
		},
		{	name: "Seq1Step3",	type: "LevBipUni",	n: "KnobSpin",	x: 53.5,	y: 79.5
		},
		{	name: "Seq1Step4",	type: "LevBipUni",	n: "KnobSpin",	x: 65.5,	y: 79.5
		},
		{	name: "Seq1Step5",	type: "LevBipUni",	n: "KnobSpin",	x: 77.5,	y: 79.5
		},
		{	name: "Seq1Step6",	type: "LevBipUni",	n: "KnobSpin",	x: 89.5,	y: 79.5
		},
		{	name: "Seq1Step7",	type: "LevBipUni",	n: "KnobSpin",	x: 101.5,	y: 79.5
		},
		{	name: "Seq1Step8",	type: "LevBipUni",	n: "KnobSpin",	x: 113.5,	y: 79.5
		},
		{	name: "Seq1Step9",	type: "LevBipUni",	n: "KnobSpin",	x: 125.5,	y: 79.5
		},
		{	name: "Seq1Step10",	type: "LevBipUni",	n: "KnobSpin",	x: 137.5,	y: 79.5
		},
		{	name: "Seq1Step11",	type: "LevBipUni",	n: "KnobSpin",	x: 149.5,	y: 79.5
		},
		{	name: "Seq1Step12",	type: "LevBipUni",	n: "KnobSpin",	x: 161.5,	y: 79.5
		},
		{	name: "Seq1Step13",	type: "LevBipUni",	n: "KnobSpin",	x: 173.5,	y: 79.5
		},
		{	name: "Seq1Step14",	type: "LevBipUni",	n: "KnobSpin",	x: 185.5,	y: 79.5
		},
		{	name: "Seq1Step15",	type: "LevBipUni",	n: "KnobSpin",	x: 197.5,	y: 79.5
		},
		{	name: "Seq1Step16",	type: "LevBipUni",	n: "KnobSpin",	x: 209.5,	y: 79.5
		},
		{	name: "Seq2Step1",	type: "OffOnBlank",	n: "SwM0",	x: 29.5,	y: 104.5
		},
		{	name: "Seq2Step2",	type: "OffOnBlank",	n: "SwM0",	x: 41.5,	y: 104.5
		},
		{	name: "Seq2Step3",	type: "OffOnBlank",	n: "SwM0",	x: 53.5,	y: 104.5
		},
		{	name: "Seq2Step4",	type: "OffOnBlank",	n: "SwM0",	x: 65.5,	y: 104.5
		},
		{	name: "Seq2Step5",	type: "OffOnBlank",	n: "SwM0",	x: 77.5,	y: 104.5
		},
		{	name: "Seq2Step6",	type: "OffOnBlank",	n: "SwM0",	x: 89.5,	y: 104.5
		},
		{	name: "Seq2Step7",	type: "OffOnBlank",	n: "SwM0",	x: 101.5,	y: 104.5
		},
		{	name: "Seq2Step8",	type: "OffOnBlank",	n: "SwM0",	x: 113.5,	y: 104.5
		},
		{	name: "Seq2Step9",	type: "OffOnBlank",	n: "SwM0",	x: 125.5,	y: 104.5
		},
		{	name: "Seq2Step10",	type: "OffOnBlank",	n: "SwM0",	x: 137.5,	y: 104.5
		},
		{	name: "Seq2Step11",	type: "OffOnBlank",	n: "SwM0",	x: 149.5,	y: 104.5
		},
		{	name: "Seq2Step12",	type: "OffOnBlank",	n: "SwM0",	x: 161.5,	y: 104.5
		},
		{	name: "Seq2Step13",	type: "OffOnBlank",	n: "SwM0",	x: 173.5,	y: 104.5
		},
		{	name: "Seq2Step14",	type: "OffOnBlank",	n: "SwM0",	x: 185.5,	y: 104.5
		},
		{	name: "Seq2Step15",	type: "OffOnBlank",	n: "SwM0",	x: 197.5,	y: 104.5
		},
		{	name: "Seq2Step16",	type: "OffOnBlank",	n: "SwM0",	x: 210,	y: 104.5
		},
		{	name: "Loop",	type: "LoopOnce",	n: "SwM0",	x: 87.5,	y: 4.5
		},
		{	name: "Length",	type: "SeqLen",	n: "KnobSpinH",	x: 145.5,	y: 4.5
		},
		{	name: "BipUni",	type: "BipUni",	n: "SwM5b04c56d",	x: 231.5,	y: 69.5
		},
		{	name: "TG",	type: "TrigGate",	n: "SwM140ef",	x: 223.5,	y: 104.5
		},
		{	name: "Clr",	type: "OffOn",	n: "SwM10909",	x: 231.5,	y: 41.5
		},
		{	name: "Rnd",	type: "OffOn",	n: "SwM14188",	x: 231.5,	y: 55.5
		}
	],
	modes: [],
	ve: [
		{	type: "line",	"x1": 219,	"y1": 110,	"x2": 245,	"y2": 110
		},
		{	type: "line",	"x1": 10,	"y1": 110,	"x2": 36,	"y2": 110
		},
		{	type: "line",	"x1": 59,	"y1": 38,	"x2": 59,	"y2": 88
		},
		{	type: "line",	"x1": 47,	"y1": 38,	"x2": 47,	"y2": 88
		},
		{	type: "line",	"x1": 35,	"y1": 38,	"x2": 35,	"y2": 88
		},
		{	type: "line",	"x1": 83,	"y1": 38,	"x2": 83,	"y2": 88
		},
		{	type: "line",	"x1": 71,	"y1": 38,	"x2": 71,	"y2": 88
		},
		{	type: "line",	"x1": 107,	"y1": 39,	"x2": 107,	"y2": 89
		},
		{	type: "line",	"x1": 95,	"y1": 39,	"x2": 95,	"y2": 89
		},
		{	type: "line",	"x1": 131,	"y1": 39,	"x2": 131,	"y2": 89
		},
		{	type: "line",	"x1": 119,	"y1": 39,	"x2": 119,	"y2": 89
		},
		{	type: "line",	"x1": 155,	"y1": 39,	"x2": 155,	"y2": 89
		},
		{	type: "line",	"x1": 143,	"y1": 39,	"x2": 143,	"y2": 89
		},
		{	type: "line",	"x1": 179,	"y1": 39,	"x2": 179,	"y2": 89
		},
		{	type: "line",	"x1": 167,	"y1": 39,	"x2": 167,	"y2": 89
		},
		{	type: "line",	"x1": 203,	"y1": 39,	"x2": 203,	"y2": 89
		},
		{	type: "line",	"x1": 191,	"y1": 39,	"x2": 191,	"y2": 89
		},
		{	type: "line",	"x1": 215,	"y1": 39,	"x2": 215,	"y2": 89
		},
		{	type: "line",	"x1": 9,	"y1": 89,	"x2": 37,	"y2": 89
		},
		{	type: "line",	"x1": 221,	"y1": 89,	"x2": 242,	"y2": 89
		},
		{	type: "text",	x: 3,	y: 23,	t: "Clk"
		},
		{	type: "text",	x: 3,	y: 45,	t: "Rst"
		},
		{	type: "led",	x: 242,	y: 7,	w: 6.5
		},
		{	type: "text",	x: 217,	y: 13,	t: "Park"
		},
		{	type: "text",	x: 233,	y: 24,	t: "Link"
		},
		{	type: "ledArray",	x: 29,	y: 35,	w: 10,	xo:12,	cnt:16
		},
		{	type: "text",	x: 32,	y: 32,	t: "1"
		},
		{	type: "text",	x: 43,	y: 32,	t: "2"
		},
		{	type: "text",	x: 55,	y: 32,	t: "3"
		},
		{	type: "text",	x: 67,	y: 32,	t: "4"
		},
		{	type: "text",	x: 79,	y: 32,	t: "5"
		},
		{	type: "text",	x: 91,	y: 32,	t: "6"
		},
		{	type: "text",	x: 103,	y: 32,	t: "7"
		},
		{	type: "text",	x: 115,	y: 32,	t: "8"
		},
		{	type: "text",	x: 127,	y: 32,	t: "9"
		},
		{	type: "text",	x: 138,	y: 32,	t: "10"
		},
		{	type: "text",	x: 151,	y: 32,	t: "11"
		},
		{	type: "text",	x: 162,	y: 32,	t: "12"
		},
		{	type: "text",	x: 174,	y: 32,	t: "13"
		},
		{	type: "text",	x: 186,	y: 32,	t: "14"
		},
		{	type: "text",	x: 198,	y: 32,	t: "15"
		},
		{	type: "text",	x: 210,	y: 32,	t: "16"
		},
		{	type: "valueDisplay",	x: 167,	y: 4,	w: 16,	ref: 33
		},
		{	type: "text",	x: 113,	y: 13,	t: "Length"
		},
		{	type: "valueDisplay",	x: 24,	y: 45,	w: 21,	ref: 0
		},
		{	type: "valueDisplay",	x: 36,	y: 62,	w: 21,	ref: 1
		},
		{	type: "valueDisplay",	x: 48,	y: 45,	w: 21,	ref: 2
		},
		{	type: "valueDisplay",	x: 60,	y: 62,	w: 21,	ref: 3
		},
		{	type: "valueDisplay",	x: 72,	y: 45,	w: 21,	ref: 4
		},
		{	type: "valueDisplay",	x: 84,	y: 62,	w: 21,	ref: 5
		},
		{	type: "valueDisplay",	x: 96,	y: 45,	w: 21,	ref: 6
		},
		{	type: "valueDisplay",	x: 108,	y: 62,	w: 21,	ref: 7
		},
		{	type: "valueDisplay",	x: 120,	y: 45,	w: 21,	ref: 8
		},
		{	type: "valueDisplay",	x: 132,	y: 62,	w: 21,	ref: 9
		},
		{	type: "valueDisplay",	x: 144,	y: 45,	w: 21,	ref: 10
		},
		{	type: "valueDisplay",	x: 156,	y: 62,	w: 21,	ref: 11
		},
		{	type: "valueDisplay",	x: 168,	y: 45,	w: 21,	ref: 12
		},
		{	type: "valueDisplay",	x: 180,	y: 62,	w: 21,	ref: 13
		},
		{	type: "valueDisplay",	x: 192,	y: 45,	w: 21,	ref: 14
		},
		{	type: "valueDisplay",	x: 204,	y: 62,	w: 21,	ref: 15
		},
		{	type: "text",	x: 3,	y: 67,	t: "Loop"
		}
	]
},{
	id: 146,
	height: 8,
	longnm: "Sequencer Level",
	shortnm: "SeqLev",
	page: {
		name: "Seq",
		ord: 2
	},
	inputs: [
		{	name: "Clk",	colour: "orange",	x: 10,	y: 29
		},
		{	name: "Rst",	colour: "orange",	x: 10,	y: 52
		},
		{	name: "Loop",	colour: "orange",	x: 10,	y: 74
		},
		{	name: "Park",	colour: "orange",	x: 210,	y: 9
		},
		{	name: "Val",	colour: "purple",	x: 10,	y: 93
		},
		{	name: "Trig",	colour: "orange",	x: 10,	y: 110
		}
	],
	outputs: [
		{	name: "Link",	colour: "orange",	x: 246,	y: 31
		},
		{	name: "Val",	colour: "purple",	x: 246,	y: 92
		},
		{	name: "Trig",	colour: "orange",	x: 246,	y: 110
		}
	],
	params: [
		{	name: "Seq1Step1",	type: "LevBipUni",	n: "KnobSlider",	x: 28.5,	y: 40.5
		},
		{	name: "Seq1Step2",	type: "LevBipUni",	n: "KnobSlider",	x: 40.5,	y: 40.5
		},
		{	name: "Seq1Step3",	type: "LevBipUni",	n: "KnobSlider",	x: 52.5,	y: 40.5
		},
		{	name: "Seq1Step4",	type: "LevBipUni",	n: "KnobSlider",	x: 64.5,	y: 40.5
		},
		{	name: "Seq1Step5",	type: "LevBipUni",	n: "KnobSlider",	x: 76.5,	y: 40.5
		},
		{	name: "Seq1Step6",	type: "LevBipUni",	n: "KnobSlider",	x: 88.5,	y: 40.5
		},
		{	name: "Seq1Step7",	type: "LevBipUni",	n: "KnobSlider",	x: 100.5,	y: 40.5
		},
		{	name: "Seq1Step8",	type: "LevBipUni",	n: "KnobSlider",	x: 112.5,	y: 40.5
		},
		{	name: "Seq1Step9",	type: "LevBipUni",	n: "KnobSlider",	x: 124.5,	y: 40.5
		},
		{	name: "Seq1Step10",	type: "LevBipUni",	n: "KnobSlider",	x: 136.5,	y: 40.5
		},
		{	name: "Seq1Step11",	type: "LevBipUni",	n: "KnobSlider",	x: 148.5,	y: 40.5
		},
		{	name: "Seq1Step12",	type: "LevBipUni",	n: "KnobSlider",	x: 160.5,	y: 40.5
		},
		{	name: "Seq1Step13",	type: "LevBipUni",	n: "KnobSlider",	x: 172.5,	y: 40.5
		},
		{	name: "Seq1Step14",	type: "LevBipUni",	n: "KnobSlider",	x: 184.5,	y: 40.5
		},
		{	name: "Seq1Step15",	type: "LevBipUni",	n: "KnobSlider",	x: 196.5,	y: 40.5
		},
		{	name: "Seq1Step16",	type: "LevBipUni",	n: "KnobSlider",	x: 208.5,	y: 40.5
		},
		{	name: "Seq2Step1",	type: "OffOnBlank",	n: "SwM0",	x: 28.5,	y: 104.5
		},
		{	name: "Seq2Step2",	type: "OffOnBlank",	n: "SwM0",	x: 40.5,	y: 104.5
		},
		{	name: "Seq2Step3",	type: "OffOnBlank",	n: "SwM0",	x: 52.5,	y: 104.5
		},
		{	name: "Seq2Step4",	type: "OffOnBlank",	n: "SwM0",	x: 64.5,	y: 104.5
		},
		{	name: "Seq2Step5",	type: "OffOnBlank",	n: "SwM0",	x: 76.5,	y: 104.5
		},
		{	name: "Seq2Step6",	type: "OffOnBlank",	n: "SwM0",	x: 88.5,	y: 104.5
		},
		{	name: "Seq2Step7",	type: "OffOnBlank",	n: "SwM0",	x: 100.5,	y: 104.5
		},
		{	name: "Seq2Step8",	type: "OffOnBlank",	n: "SwM0",	x: 112.5,	y: 104.5
		},
		{	name: "Seq2Step9",	type: "OffOnBlank",	n: "SwM0",	x: 124.5,	y: 104.5
		},
		{	name: "Seq2Step10",	type: "OffOnBlank",	n: "SwM0",	x: 136.5,	y: 104.5
		},
		{	name: "Seq2Step11",	type: "OffOnBlank",	n: "SwM0",	x: 148.5,	y: 104.5
		},
		{	name: "Seq2Step12",	type: "OffOnBlank",	n: "SwM0",	x: 160.5,	y: 104.5
		},
		{	name: "Seq2Step13",	type: "OffOnBlank",	n: "SwM0",	x: 172.5,	y: 104.5
		},
		{	name: "Seq2Step14",	type: "OffOnBlank",	n: "SwM0",	x: 184.5,	y: 104.5
		},
		{	name: "Seq2Step15",	type: "OffOnBlank",	n: "SwM0",	x: 196.5,	y: 104.5
		},
		{	name: "Seq2Step16",	type: "OffOnBlank",	n: "SwM0",	x: 208.5,	y: 104.5
		},
		{	name: "Loop",	type: "LoopOnce",	n: "SwM0",	x: 87.5,	y: 4.5
		},
		{	name: "Length",	type: "SeqLen",	n: "KnobSpinH",	x: 145.5,	y: 4.5
		},
		{	name: "BipUni",	type: "BipUni",	n: "SwM5b04c56d",	x: 231.5,	y: 71.5
		},
		{	name: "TG",	type: "TrigGate",	n: "SwM140ef",	x: 222.5,	y: 104.5
		},
		{	name: "Clr",	type: "OffOn",	n: "SwM10909",	x: 231.5,	y: 41.5
		},
		{	name: "Rnd",	type: "OffOn",	n: "SwM14188",	x: 231.5,	y: 56.5
		}
	],
	modes: [],
	ve: [
		{	type: "line",	"x1": 217,	"y1": 110,	"x2": 245,	"y2": 110
		},
		{	type: "line",	"x1": 10,	"y1": 110,	"x2": 35,	"y2": 110
		},
		{	type: "line",	"x1": 24,	"y1": 86,	"x2": 45,	"y2": 86
		},
		{	type: "line",	"x1": 205,	"y1": 86,	"x2": 226,	"y2": 86
		},
		{	type: "line",	"x1": 12,	"y1": 93,	"x2": 25,	"y2": 93
		},
		{	type: "line",	"x1": 24,	"y1": 86,	"x2": 24,	"y2": 93
		},
		{	type: "line",	"x1": 226,	"y1": 92,	"x2": 245,	"y2": 92
		},
		{	type: "line",	"x1": 226,	"y1": 86,	"x2": 226,	"y2": 93
		},
		{	type: "led",	x: 242,	y: 7,	w: 6.5
		},
		{	type: "ledArray",	x: 28,	y: 32,	w: 10,	xo:12,	cnt:16
		},
		{	type: "text",	x: 3,	y: 22,	t: "Clk"
		},
		{	type: "text",	x: 3,	y: 45,	t: "Rst"
		},
		{	type: "text",	x: 217,	y: 13,	t: "Park"
		},
		{	type: "text",	x: 233,	y: 24,	t: "Link"
		},
		{	type: "text",	x: 31,	y: 30,	t: "1"
		},
		{	type: "text",	x: 42,	y: 30,	t: "2"
		},
		{	type: "text",	x: 54,	y: 30,	t: "3"
		},
		{	type: "text",	x: 66,	y: 30,	t: "4"
		},
		{	type: "text",	x: 78,	y: 30,	t: "5"
		},
		{	type: "text",	x: 90,	y: 30,	t: "6"
		},
		{	type: "text",	x: 102,	y: 30,	t: "7"
		},
		{	type: "text",	x: 114,	y: 30,	t: "8"
		},
		{	type: "text",	x: 126,	y: 30,	t: "9"
		},
		{	type: "text",	x: 137,	y: 30,	t: "10"
		},
		{	type: "text",	x: 150,	y: 30,	t: "11"
		},
		{	type: "text",	x: 161,	y: 30,	t: "12"
		},
		{	type: "text",	x: 173,	y: 30,	t: "13"
		},
		{	type: "text",	x: 185,	y: 30,	t: "14"
		},
		{	type: "text",	x: 197,	y: 30,	t: "15"
		},
		{	type: "text",	x: 209,	y: 30,	t: "16"
		},
		{	type: "valueDisplay",	x: 167,	y: 4,	w: 16,	ref: 33
		},
		{	type: "text",	x: 114,	y: 13,	t: "Length"
		},
		{	type: "text",	x: 3,	y: 67,	t: "Loop"
		}
	]
},{
	id: 154,
	height: 8,
	longnm: "Sequencer Controlled",
	shortnm: "SeqCtr",
	page: {
		name: "Seq",
		ord: 4
	},
	inputs: [
		{	name: "Ctrl",	colour: "purple",	x: 10,	y: 29
		},
		{	name: "Val",	colour: "purple",	x: 10,	y: 92
		},
		{	name: "Trig",	colour: "orange",	x: 10,	y: 110
		}
	],
	outputs: [
		{	name: "Val",	colour: "purple",	x: 246,	y: 91
		},
		{	name: "Trig",	colour: "orange",	x: 246,	y: 110
		}
	],
	params: [
		{	name: "Seq1Step1",	type: "LevBipUni",	n: "KnobSlider",	x: 28.5,	y: 39.5
		},
		{	name: "Seq1Step2",	type: "LevBipUni",	n: "KnobSlider",	x: 40.5,	y: 39.5
		},
		{	name: "Seq1Step3",	type: "LevBipUni",	n: "KnobSlider",	x: 52.5,	y: 39.5
		},
		{	name: "Seq1Step4",	type: "LevBipUni",	n: "KnobSlider",	x: 64.5,	y: 39.5
		},
		{	name: "Seq1Step5",	type: "LevBipUni",	n: "KnobSlider",	x: 76.5,	y: 39.5
		},
		{	name: "Seq1Step6",	type: "LevBipUni",	n: "KnobSlider",	x: 88.5,	y: 39.5
		},
		{	name: "Seq1Step7",	type: "LevBipUni",	n: "KnobSlider",	x: 100.5,	y: 39.5
		},
		{	name: "Seq1Step8",	type: "LevBipUni",	n: "KnobSlider",	x: 112.5,	y: 39.5
		},
		{	name: "Seq1Step9",	type: "LevBipUni",	n: "KnobSlider",	x: 124.5,	y: 39.5
		},
		{	name: "Seq1Step10",	type: "LevBipUni",	n: "KnobSlider",	x: 136.5,	y: 39.5
		},
		{	name: "Seq1Step11",	type: "LevBipUni",	n: "KnobSlider",	x: 148.5,	y: 39.5
		},
		{	name: "Seq1Step12",	type: "LevBipUni",	n: "KnobSlider",	x: 160.5,	y: 39.5
		},
		{	name: "Seq1Step13",	type: "LevBipUni",	n: "KnobSlider",	x: 172.5,	y: 39.5
		},
		{	name: "Seq1Step14",	type: "LevBipUni",	n: "KnobSlider",	x: 184.5,	y: 39.5
		},
		{	name: "Seq1Step15",	type: "LevBipUni",	n: "KnobSlider",	x: 196.5,	y: 39.5
		},
		{	name: "Seq1Step16",	type: "LevBipUni",	n: "KnobSlider",	x: 208.5,	y: 39.5
		},
		{	name: "Seq2Step1",	type: "OffOnBlank",	n: "SwM0",	x: 28.5,	y: 104.5
		},
		{	name: "Seq2Step2",	type: "OffOnBlank",	n: "SwM0",	x: 40.5,	y: 104.5
		},
		{	name: "Seq2Step3",	type: "OffOnBlank",	n: "SwM0",	x: 52.5,	y: 104.5
		},
		{	name: "Seq2Step4",	type: "OffOnBlank",	n: "SwM0",	x: 64.5,	y: 104.5
		},
		{	name: "Seq2Step5",	type: "OffOnBlank",	n: "SwM0",	x: 76.5,	y: 104.5
		},
		{	name: "Seq2Step6",	type: "OffOnBlank",	n: "SwM0",	x: 88.5,	y: 104.5
		},
		{	name: "Seq2Step7",	type: "OffOnBlank",	n: "SwM0",	x: 100.5,	y: 104.5
		},
		{	name: "Seq2Step8",	type: "OffOnBlank",	n: "SwM0",	x: 112.5,	y: 104.5
		},
		{	name: "Seq2Step9",	type: "OffOnBlank",	n: "SwM0",	x: 124.5,	y: 104.5
		},
		{	name: "Seq2Step10",	type: "OffOnBlank",	n: "SwM0",	x: 136.5,	y: 104.5
		},
		{	name: "Seq2Step11",	type: "OffOnBlank",	n: "SwM0",	x: 148.5,	y: 104.5
		},
		{	name: "Seq2Step12",	type: "OffOnBlank",	n: "SwM0",	x: 160.5,	y: 104.5
		},
		{	name: "Seq2Step13",	type: "OffOnBlank",	n: "SwM0",	x: 172.5,	y: 104.5
		},
		{	name: "Seq2Step14",	type: "OffOnBlank",	n: "SwM0",	x: 184.5,	y: 104.5
		},
		{	name: "Seq2Step15",	type: "OffOnBlank",	n: "SwM0",	x: 196.5,	y: 104.5
		},
		{	name: "Seq2Step16",	type: "OffOnBlank",	n: "SwM0",	x: 208.5,	y: 104.5
		},
		{	name: "TG",	type: "TrigGate",	n: "SwM140ef",	x: 222.5,	y: 104.5
		},
		{	name: "BipUni",	type: "BipUni",	n: "SwM5b04c56d",	x: 231.5,	y: 66.5
		},
		{	name: "XFade",	type: "SeqCtrlXFade",	n: "SwM332ebd3d",	x: 141.5,	y: 4.5
		},
		{	name: "Clr",	type: "OffOn",	n: "SwM10909",	x: 231.5,	y: 36.5
		},
		{	name: "Rnd",	type: "OffOn",	n: "SwM14188",	x: 231.5,	y: 51.5
		}
	],
	modes: [],
	ve: [
		{	type: "line",	"x1": 217,	"y1": 110,	"x2": 248,	"y2": 110
		},
		{	type: "line",	"x1": 11,	"y1": 110,	"x2": 36,	"y2": 110
		},
		{	type: "line",	"x1": 24,	"y1": 85,	"x2": 45,	"y2": 85
		},
		{	type: "line",	"x1": 205,	"y1": 85,	"x2": 226,	"y2": 85
		},
		{	type: "line",	"x1": 13,	"y1": 92,	"x2": 25,	"y2": 92
		},
		{	type: "line",	"x1": 24,	"y1": 85,	"x2": 24,	"y2": 92
		},
		{	type: "line",	"x1": 226,	"y1": 91,	"x2": 241,	"y2": 91
		},
		{	type: "line",	"x1": 226,	"y1": 85,	"x2": 226,	"y2": 92
		},
		{	type: "ledArray",	x: 28,	y: 31,	w: 10,	xo:12,	cnt:16
		},
		{	type: "text",	x: 31,	y: 29,	t: "1"
		},
		{	type: "text",	x: 42,	y: 29,	t: "2"
		},
		{	type: "text",	x: 54,	y: 29,	t: "3"
		},
		{	type: "text",	x: 66,	y: 29,	t: "4"
		},
		{	type: "text",	x: 78,	y: 29,	t: "5"
		},
		{	type: "text",	x: 90,	y: 29,	t: "6"
		},
		{	type: "text",	x: 102,	y: 29,	t: "7"
		},
		{	type: "text",	x: 114,	y: 29,	t: "8"
		},
		{	type: "text",	x: 126,	y: 29,	t: "9"
		},
		{	type: "text",	x: 137,	y: 29,	t: "10"
		},
		{	type: "text",	x: 150,	y: 29,	t: "11"
		},
		{	type: "text",	x: 161,	y: 29,	t: "12"
		},
		{	type: "text",	x: 173,	y: 29,	t: "13"
		},
		{	type: "text",	x: 185,	y: 29,	t: "14"
		},
		{	type: "text",	x: 197,	y: 29,	t: "15"
		},
		{	type: "text",	x: 209,	y: 29,	t: "16"
		},
		{	type: "text",	x: 3,	y: 22,	t: "Ctr"
		},
		{	type: "led",	x: 242,	y: 7,	w: 6.5
		},
		{	type: "text",	x: 218,	y: 13,	t: "Park"
		},
		{	type: "text",	x: 111,	y: 14,	t: "XFade"
		}
	]
},/// end of seq
{/// start of hidden
	id: 35,
	height: 2,
	longnm: "Driver",
	shortnm: "Driver",
	page: {
		name: "Hidden",
		ord: 1
	},
	inputs: [
		{	name: "Ex",	colour: "purple",	x: 8,	y: 19
		},
		{	name: "In",	colour: "purple",	x: 231,	y: 19
		}
	],
	outputs: [
		{	name: "Out",	colour: "purple",	x: 246,	y: 50
		}
	],
	params: [
		{	name: "Sel",	type: "sw_3",	n: "SwM322bb710",	x: 67.5,	y: 29.5
		}
	],
	modes: [],
	ve: [
		{	type: "text",	x: 3,	y: 20,	t: "Excitation"
		}
	]
},{
	id: 56,
	height: 5,
	longnm: "Resonator",
	shortnm: "Res",
	page: {
		name: "Hidden",
		ord: 2
	},
	inputs: [
		{	name: "Pitch",	colour: "blue",	x: 8,	y: 20
		},
		{	name: "PitchMod",	colour: "blue",	x: 8,	y: 20
		},
		{	name: "In",	colour: "red",	x: 246,	y: 8
		}
	],
	outputs: [
		{	name: "Out",	colour: "red",	x: 246,	y: 50
		},
		{	name: "Drv",	colour: "red",	x: 236,	y: 8
		}
	],
	params: [
		{	name: "Sel",	type: "sw_3",	n: "SwM322bb710",	x: 67.5,	y: 29.5
		}
	],
	modes: [],
	ve: [
		{	type: "text",	x: 3,	y: 38.5,	t: "Pitch"
		},
		{	type: "text",	x: 159,	y: 50,	t: "Algorithm"
		}
	]
}
];

////////////// helper
Array.prototype.getById = function(id) {
	var rv;
	for (var i=0; rv=this[i]; i++)
		if (rv.id==id)	break;
	return rv;
};
