#!/usr/bin/env python

import os,string,sys,math
from array import array
sys.path.append('.')
from nord import units
from nord.g2.file import Pch2File, MorphMap
from nord.g2.colors import g2modulecolors, g2cablecolors, g2conncolors
from nord.convert.version import version as g2oolsversion
import dxtable

class SCLConverter: 
  def __init__(self):
    self.pch2 = Pch2File('G2SCL.PCH2')
    self.fine = [self.modulebyname('Fine%d'%i) for i in range(0,6)]
    self.coarse = [self.modulebyname('Coarse%d'%i) for i in range(0,6)]

  def modulebyname(self, name):
    for module in self.pch2.patch.voice.modules:
      if module.name == name:
        return module
    return None

class Struct:
  def __init__(self, **kw):
    self.__dict__ = kw

global lookingforhead, lookingforcount, gettingcents, state

lookingforhead = 1
lookingforcount = 2
gettingcents = 3

def parseScalaFile(f):
  print(f)
  state = lookingforhead
  for line in file(f):
    if line[:1] == "!":
      continue # ignore all comment lines
    if state == lookingforhead:
      head = line
      state = lookingforcount
    elif state == lookingforcount:
      count = int(line)
      cents = []
      state = gettingcents
    elif state == gettingcents:
      txt = line[:-1]
      # check for word 'cents' and remove
      ix = txt.find("cents")
      if ix > 0:
        txt = txt[:ix-1]
      if txt.find(".") < 0:
        # not cents so must be a ratio, convert to cents
        ratio = txt.split('/')
        if len(ratio) == 1:
          ratio.append("1")
        txt = 1200.0*math.log(float(ratio[0])/float(ratio[1]))/math.log(2)
      else:
        txt = float(txt)
      cents.append(txt)
  print head
  # now set values for 6 sets of 16 fine and coarse
  SCLcon = SCLConverter()
  #raw_input("press Enter")
  outname = f[:-4]
  st = 0 # add cents value each time
  for i in range(96):
    et = i * 100 # == number of cents for note in Equal Temp
    diff = st - et
    f = math.fmod(diff,100.0)
    if f<0.0:
      f = 100 + f
    h = int((diff - f) / 100)
    # print i, f, int((f+0.5)*1.28)
    SCLcon.fine[int(i/16)].params[i % 16].variations[0] = int((f+0.5)*1.28)
    SCLcon.coarse[int(i/16)].params[i % 16].variations[0] = abs(h)
    if (h>0): # sign bit for coarse control
      SCLcon.coarse[int(i/16)].params[16+(i % 16)].variations[0] = True
    st = cents[i % count] + (int(i/count)*cents[count-1])
  SCLcon.pch2.write(outname+'.pch2')
  return()

#parseScalaFile('C:\\python25\\scl\\temp12fo1o.scl')
for fname in sys.argv[1:]:
  parseScalaFile(fname)
